//-----------------------------------------------------------------------------
//  Copyright (C) 2017 Thomas S. Ullrich
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//
//  Author: Thomas S. Ullrich
//  Last update: December 5, 2017
//-----------------------------------------------------------------------------
#ifndef xyscanDataTable_h
#define xyscanDataTable_h
#include <QTableWidget>
#include <QTextDocument>

class QImage;
class QFile;

class xyscanDataTable : public QTableWidget
{
    Q_OBJECT
    
public:
    xyscanDataTable(QWidget *);
    
    void addPoint(double, double, double, double, double, double);

    bool dataSaved() const;
    void setDataSaved(bool);
    
    QString userComment() const;
    void setUserComment(const QString&);

    void writePrinterDocument(QTextDocument&, const QString&, const QImage* = nullptr);
    void writeRootMacro(QFile&, const QString&, bool, bool, double mc[4]);
    void writeTextFile(QFile&, const QString&);

    double x(int) const;
    double y(int) const;
    double dx_lower(int) const;
    double dx_upper(int) const;
    double dy_lower(int) const;
    double dy_upper(int) const;

public slots:
    void deleteLast();
    void deleteAll();
    
private:
    QString mUserComment;
    bool mDataSaved;
};

inline bool xyscanDataTable::dataSaved() const {return mDataSaved;}
inline void xyscanDataTable::setDataSaved(bool val) {mDataSaved = val;}
inline QString xyscanDataTable::userComment() const {return mUserComment;}
inline void xyscanDataTable::setUserComment(const QString& str) {mUserComment = str;}
inline double xyscanDataTable::x(int i) const {return item(i, 0)->text().toDouble();}
inline double xyscanDataTable::y(int i) const {return item(i, 1)->text().toDouble();}
inline double xyscanDataTable::dx_lower(int i) const {return item(i, 2)->text().toDouble();}
inline double xyscanDataTable::dx_upper(int i) const {return item(i, 3)->text().toDouble();}
inline double xyscanDataTable::dy_lower(int i) const {return item(i, 4)->text().toDouble();}
inline double xyscanDataTable::dy_upper(int i) const {return item(i, 5)->text().toDouble();}

#endif
