/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: DSCCommentLanguageLevel.java 1681108 2015-05-22 13:26:12Z ssteiner $ */

package org.apache.xmlgraphics.ps.dsc.events;

import java.io.IOException;

import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSGenerator;

/**
 * Represents a %%LanguageLevel DSC comment
 */
public class DSCCommentLanguageLevel extends AbstractDSCComment {

    private int level;

    /**
     * Creates a new instance.
     */
    public DSCCommentLanguageLevel() {
    }

    /**
     * Creates a new instance
     * @param level the PostScript language level (usually 2 or 3)
     */
    public DSCCommentLanguageLevel(int level) {
        this.level = level;
    }

    /**
     * Returns the PostScript language level (usually 2 or 3).
     * @return the language level
     */
    public int getLanguageLevel() {
        return this.level;
    }

    /**
     * @see org.apache.xmlgraphics.ps.dsc.events.DSCComment#getName()
     */
    public String getName() {
        return DSCConstants.LANGUAGE_LEVEL;
    }

    /**
     * @see org.apache.xmlgraphics.ps.dsc.events.DSCComment#hasValues()
     */
    public boolean hasValues() {
        return true;
    }

    /**
     * @see org.apache.xmlgraphics.ps.dsc.events.DSCComment#parseValue(java.lang.String)
     */
    public void parseValue(String value) {
        this.level = Integer.parseInt(value);
    }

    /**
     * @see org.apache.xmlgraphics.ps.dsc.events.DSCEvent#generate(org.apache.xmlgraphics.ps.PSGenerator)
     */
    public void generate(PSGenerator gen) throws IOException {
        if (level <= 0) {
            throw new IllegalStateException("Language Level was not properly set");
        }
        gen.writeDSCComment(getName(), getLanguageLevel());
    }

}
