.TH xjig 1 "July-23-1996" "X Version 11"
.SH NAME
xjig \- the jigsaw puzzle
.SH SYNOPSIS
.B xjig
<options>
.SH DESCRIPTION
.I XJig
is a puzzle, that tries to replicate a jigsaw puzzle on the screen as
close as possible. As in every jigsaw puzzle, the goal is to set all the
pieces together. If you like, you can watch the time that you spent
for it.
.PP
Any image-file in gif-format can be used as the source for the puzzle, which
is then randomly created regarding the sizes selected by the options. 
.PP
The control should be as intuitive as possible in the way that you will usually
pull the freely rotatable pieces at one edge, drag them to the desired
destination
and drop them so they will snap together easily when close to an neighboured
tile.

.SH SPECIAL EFFECTS

Tiles are freely formed and rotatable with texture mapping
routines to give the appearance of a real mess on the screen.

Tiles snap together very easy if they are dropped somewhere close to another
matching tile, when turned in the correct direction.

Puzzles can be doubled sided so you might have to flip
the tiles to the correct side to let them snap together.

If the Xserver supports the Shape-Extension, the tiles can be opened directly
on the desktop, which is a pretty showcase, but you need a very fast machine
for really getting this playable. (Any ideas on how to add double buffering to
the shaped-window approach of the jigsaw are warmly welcome!)

.SH CONTROLS
The usual way to move the pieces on the screen should be to drag the piece
with the left mouse button to their destination by pulling them at on edge.
The piece will automatically rotate like if you pull or push them with your
fingertip on a table.

In addition, the following movements are possible:

.ta 19
.nf
.in +2
click left:	rotate 90 degrees left
click right:	rotate 90 degrees right
click middle:	flip tile to backside
drag left:	rotator drag (as mentionned above)
   +middle:	pause rotator drag for a straight drag
drag middle:	straight drag
   +left:	pause drag for a static rotation
   +click left:	rotate 90 degrees left during drag
   +click right:	rotate 90 degrees right during drag
CTRL+click left:	same as click middle
.in -2
.fi
.PP
The right button has actually the same functionality as the middle button
so that 2 button systems shouldn't have problems. Only the "drag middle+click right"
move will not work in that mode, and the flipping has to be done with the help
of the CTRL-key.

.SH OPTIONS
.SS "Tile Selection"
.TP 12
.B -file \fIname\fP
use the specified file as the source image for the puzzle
.TP 12
.B -side \fIp\fP
select the side of the image to be on top, if you don't like the mess
with the double sided tiles.
.SS "Size Selection"
.B
.TP 12
.B -w \fIx\fP
Select number of tiles in horizontal direction. The Images are automatically
rotated in portrait orientation before they are sliced. Therefore \fIx\fP
usually should be smaller than \fIy\fP of the next option.
.TP 12
.B -h \fIy\fP
Select number of tiles in vertical direction respectively.
.TP 12
.B -ts \fIn\fP
Select average tile width. Instead of explicitly specifying the number of tiles
by using the previous options -w and -h, the average tile width in pixels can be
selected and the values for \fIx\fP and \fIy\fP above are computed according to
to the selected size.
.SS "Image Options"
.TP 12
.B -ww \fIx\fP
Select width of image in pixels. This can be used to scale the image before
playing for the case that a very large image is the source.
.TP 12
.B -wh \fIh\fP
Select height of image in pixels. If only one of -ww and -wh, the aspect ratio
is kept constant.
.TP 12
.B -no_crop
The image is usually automatically cropped, since many images are surrounded by
frames or textual comments. The cropping stops at a reasonable amount of colors
per line or row. If this is not desired of if you want to puzzle with painted
images with few color, you should disable this feature.
.TP 12
.B -no_flip
Before tiling takes place, a landscape image is rotated to portrait mode, which
effects successive options like -w or -ww. If this is not desired, you can
switch this feature off.

.SS "X-Window options"
.TP 12
.B -display \fIname\fP
Select the display to connect to.
.TP 12
.B -shapes
If the SHAPE-extension is supported by your display, you can use this option to
let each puzzle tile appear in its own shaped window. The results might depend
on the behaviour of the window-manager. The manager is actually advised by the
override redirect attribute flag of the puzzle shapes not to do anything with
them. But who knows ...
.TP 12
.B -no_shm
When the program was build with support of the MIT-SHM extension, it might crash
when started to display on a remote machine or X-terminal. You can deselect the
usage of the extension with this option.

.SS "Miscellaneous"
.TP 12
.B -no_anim
Turns off animation of rotation and flipping, for the case the machine isn't
fast enough to make it look nice.

.SH ZOOMING & PANNING
For not losing tiles at the window border and for getting more workspace,
the game has some zooming
and panning features to control the view on your desk. They are controlled via
the keyboard with the following functionality:

.ta 19
.nf
.in +2
Cursor Keys:	Pan View
Page-Up or Add:	Zoom in
Page-Down or Sub:	Zoom out
Home:	Reset to original size
End:	Set maximum zooming to view all tiles
.in -2
.fi

The image quality usually suffers from zooming, since gif-images
are usually dithered to be viewed best in their original size.
This also applies to the size options -ww and -wh.

.SH "Color Allocation"
The program was tested on PseudoColor- and TrueColor-displays.
On PseudoColor-displays
the program might run out of colors, since colors are very limited and it
has to share its colors
with other clients. It tries to share similar colors with other clients.
But if too may color consuming clients are running, the image-quality
will suffer. You should stop other clients in that case or you might
quantize the image to a fewer number of colors with packages like
ImageMagick, xv or netpbm.
.SH "SEE ALSO"
X(1), convert(1), xv(1), ppmquant(1)

.SH COPYRIGHT
Copyright 1996, Helmut Hoenig, Heiligenhaus
.nf
.TP 8
email (for any comments):
Helmut.Hoenig@hub.de
.TP 5
smail (for gifts):
   Helmut Hoenig
   Hopfenstrasse 8a
   65520 Bad Camberg
   GERMANY
.PP
.ce 8
********************************************************

By the way, I am collecting banknotes! If you want 
to join into my collection, get any bill of your
country, sign it on the backside and send it to me
so I will pin it on my world map.
(Don't forget the exact location for the pin :-)
But you can also just send me a picture postcard ...

********************************************************
.fi
.PP
Permission to use, copy, modify, and distribute this
software for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies.

.SS "other fancy things from the author"
.ta 15
.nf
xcol (1990)	- color selector for editing text-files
flying (94/95)	- pool billard simulation
xdefmap (1995)	- enhanced tool for setting up standard colormaps
xmemory (95/96)	- memory with simultaneous multiplayer action

available at ftp.x.org and its mirrors
.fi
