/*
 * Copyright (C) 2000-2021 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */

#ifndef CONTROL_H
#define CONTROL_H

xui_vctrl_t *control_init (gGui_t *gui);
void control_deinit (xui_vctrl_t *vctrl);

/* supports XUI_W_* */
void control_toggle_window (xitk_widget_t *w, void *vctrl);

/* off (0), keyboard only (1), hidden window (2), visible window (3= */
/* int control_status (xui_vctrl_t *vctrl); */

void control_reset (xui_vctrl_t *vctrl);

void control_toggle_visibility (xui_vctrl_t *vctrl);
void control_change_skins (xui_vctrl_t *vctrl, int);
void control_raise_window (xui_vctrl_t *vctrl);
/* void control_update_tips_timeout (xui_vctrl_t *vctrl, unsigned long timeout); */
void control_action (xui_vctrl_t *vctrl, action_id_t action);

#endif
