/*
 *      A.1  Standard #include Files
 */
#include        <stdio.h>
#include        <stddef.h>

/*
 *      A.2  Data Types in Compilation Order
 */

/*
 *      A.2.1  Basic Types
 */
/* --- Gfloat -- floating point number --- */
   typedef float   Gfloat;
/* --- Gint -- integer --- */
   typedef int             Gint;
/* --- Gstore  store --- */
   typedef void *Gstore;
/* --- Gtran_matrix3  transformation matrix 3 --- */
   typedef Gfloat Gtran_matrix3[3][4];
/* --- Gtran_matrix  transformation matrix --- */
   typedef Gfloat Gtran_matrix[2][3];
/* --- Gmatrix3  4*4 [view] matrix --- */
   typedef Gfloat Gmatrix3[4][4];
/* --- Gdata  data --- */
   typedef struct {
       size_t   size;    /* size of data      */
       void     *data;   /* pointer to data   */
   } Gdata;

/*
 *      A.2.2  Enumeration Types
 */
/* --- Gasf  aspect source flag --- */
   typedef enum {
     GASF_BUNDLED, GASF_INDIV
   } Gasf;
/* --- Gattrs  attributes [used] --- */
   typedef enum {
     GATTR_LINE,   GATTR_MARKER,   GATTR_TEXT,   GATTR_FILL,
     GATTR_EDGE
   } Gattrs;
/* --- Gattr_ctrl_flag  attribute control flag --- */
   typedef enum {
     GFLAG_CUR, GFLAG_SPECIF
   } Gattr_ctrl_flag;
/* --- Gclip_ind  clipping indicator --- */
   typedef enum {
     GIND_NO_CLIP, GIND_CLIP
   } Gclip_ind;
/* --- Gcolr_avail  colour available --- */
   typedef enum {
     GAVAIL_MONOCHR, GAVAIL_COLR
   } Gcolr_avail;
/* --- Gcoord_switch  coordinate switch --- */
   typedef enum {
     GCOORD_WC, GCOORD_NDC
   } Gcoord_switch;
/* --- Gctrl_flag  control flag --- */
   typedef enum {
     GFLAG_COND, GFLAG_ALWAYS
   } Gctrl_flag;
/* --- Gdc_units  device coordinate units --- */
   typedef enum {
     GDC_METRES, GDC_OTHER
   } Gdc_units;
/* --- Gdefer_mode  deferral mode --- */
   typedef enum {
     GDEFER_ASAP, GDEFER_BNIG, GDEFER_BNIL, GDEFER_ASTI
   } Gdefer_mode;
/* --- Gdet  detectability --- */
   typedef enum {
     GSEG_UNDET, GSEG_DET
   } Gdet;
/* --- Gdisp_surf_empty  display surface empty --- */
   typedef enum {
     GSURF_NOT_EMPTY, GSURF_EMPTY
   } Gdisp_surf_empty;
/* --- Gdyn_mod  dynamic modification [accepted] --- */
   typedef enum {
     GDYN_IRG, GDYN_IMM
   } Gdyn_mod;
/* --- Gecho_switch  echo switch --- */
   typedef enum {
     GSWITCH_NO_ECHO, GSWITCH_ECHO
   } Gecho_switch;
/* --- Gedge_flag  edge flag --- */
   typedef enum {
     GEDGE_OFF, GEDGE_ON
   } Gedge_flag;
/* --- Gfill_int_style  fill area interior style --- */
   typedef enum {
     GSTYLE_HOLLOW, GSTYLE_SOLID, GSTYLE_PAT, GSTYLE_HATCH
   } Gfill_int_style;
/* --- Ghighl  highlighting --- */
   typedef enum {
     GSEG_NORM, GSEG_HIGHL
   } Ghighl;
/* --- Ghor_text_align  horizontal text alignment --- */
   typedef enum {
     GHOR_NORM, GHOR_LEFT, GHOR_CTR, GHOR_RIGHT
   } Ghor_text_align;
/* --- Gin_class  input class --- */
   typedef enum {
     GIN_NONE,  GIN_LOC,  GIN_STROKE,  GIN_VAL,  GIN_CHOICE,
     GIN_PICK, GIN_STRING
   } Gin_class;
/* --- Ginq_type  inquire type --- */
   typedef enum {
     GINQ_SET, GINQ_REALIZED
   } Ginq_type;
/* --- Girg_mode  implicit regeneration mode --- */
   typedef enum {
     GIRG_SUPPR, GIRG_ALLOWED
   } Girg_mode;
/* --- Glevel  GKS-3D level --- */
   typedef enum {
     GLEVEL_0A, GLEVEL_0B, GLEVEL_0C, GLEVEL_1A,  GLEVEL_1B,
     GLEVEL_1C, GLEVEL_2A, GLEVEL_2B, GLEVEL_2C
   } Glevel;
/* --- Gline_fill_ctrl_flag  polyline/fill area control flag
         --- */
   typedef enum {
     GFLAG_LINE, GFLAG_FILL
   } Gline_fill_ctrl_flag;
/* --- Gnew_frame_nec_upd  new frame [action] necessary [at]
         update --- */
   typedef enum {
     GNEW_NO, GNEW_YES
   } Gnew_frame_nec_upd;
/* --- Gop_mode  operating mode --- */
   typedef enum {
     GOP_REQ, GOP_SAMPLE, GOP_EVENT
   } Gop_mode;
/* --- Gop_st  operating state --- */
   typedef enum {
     GST_GKCL, GST_GKOP, GST_WSOP, GST_WSAC, GST_SGOP
   } Gop_st;
/* --- Gpr_flag  prompt flag --- */
   typedef enum {
     GPR_OFF, GPR_ON
   } Gpr_flag;
/* --- Gpres_inval  presence [of] invalid [values] --- */
   typedef enum {
     GINVAL_ABSENT, GINVAL_PRESENT
   } Gpres_inval;
/* --- Gproj_type  projection type --- */
   typedef enum {
     GPROJ_PARAL, GPROJ_PERSPECT
   } Gproj_type;
/* --- Grel_pri  relative priority --- */
   typedef enum {
     GPRI_HIGHER, GPRI_LOWER
   } Grel_pri;
/* --- Gmore_simult_events  more simultaneous events --- */
   typedef enum {
     GSIMULT_NO_MORE, GSIMULT_MORE
   } Gmore_simult_events;
/* --- Gin_status  [input] status --- */
   typedef enum {
     GIN_STATUS_NONE, GIN_STATUS_OK, GIN_STATUS_NO_IN
   } Gin_status;
/* --- Gtext_path  text path --- */
   typedef enum {
     GPATH_RIGHT, GPATH_LEFT, GPATH_UP, GPATH_DOWN
   } Gtext_path;
/* --- Gtext_prec  text precision --- */
   typedef enum {
     GPREC_STRING, GPREC_CHAR, GPREC_STROKE
   } Gtext_prec;
/* --- Gupd_regen_flag  update regeneration flag --- */
   typedef enum {
     GFLAG_POSTPONE, GFLAG_PERFORM
   } Gupd_regen_flag;
/* --- Gupd_st  update state --- */
   typedef enum {
     GUPD_NOT_PEND, GUPD_PEND
   } Gupd_st;
/* --- Gvert_text_align  vertical text alignment --- */
   typedef enum {
     GVERT_NORM,    GVERT_TOP,    GVERT_CAP,     GVERT_HALF,
     GVERT_BASE, GVERT_BOTTOM
   } Gvert_text_align;
/* --- Gvis  visibility --- */
   typedef enum {
     GSEG_INVIS, GSEG_VIS
   } Gvis;
/* --- Gws_cat  workstation category --- */
   typedef enum {
     GCAT_OUT,  GCAT_IN,  GCAT_OUTIN,  GCAT_WISS,   GCAT_MO,
     GCAT_MI
   } Gws_cat;
/* --- Gws_class  workstation classification --- */
   typedef enum {
     GCLASS_VEC, GCLASS_RASTER, GCLASS_OTHER
   } Gws_class;
/* --- Gws_st  workstation state --- */
   typedef enum {
     GWS_INACTIVE, GWS_ACTIVE
   } Gws_st;

/*
 *      A.2.3  Simple Structures
 */
/* --- Gasfs  aspect source flags --- */
   typedef struct {
       Gasf   linetype;          /* linetype ASF                      */
       Gasf   linewidth;         /* linewidth scale factor ASF        */
       Gasf   line_colr_ind;     /* polyline colour index ASF         */
       Gasf   marker_type;       /* marker type ASF                   */
       Gasf   marker_size;       /* marker size scale factor ASF      */
       Gasf   marker_colr_ind;   /* polymarker colour index ASF       */
       Gasf   text_font_prec;    /* text font and precision ASF       */
       Gasf   char_expan;        /* character expansion factor ASF    */
       Gasf   char_space;        /* character spacing ASF             */
       Gasf   text_colr_ind;     /* text colour index ASF             */
       Gasf   fill_int_style;    /* fill area interior style ASF      */
       Gasf   fill_style_ind;    /* fill area style index ASF         */
       Gasf   fill_colr_ind;     /* fill area colour index ASF        */
   } Gasfs;
/* --- Gasfs3  aspect source flags 3 --- */
   typedef struct {
       Gasf   linetype;          /* linetype ASF                      */
       Gasf   linewidth;         /* linewidth scale factor ASF        */
       Gasf   line_colr_ind;     /* polyline colour index ASF         */
       Gasf   marker_type;       /* marker type ASF                   */
       Gasf   marker_size;       /* marker size scale factor ASF      */
       Gasf   marker_colr_ind;   /* polymarker colour index ASF       */
       Gasf   text_font_prec;    /* text font and precision ASF       */
       Gasf   char_expan;        /* character expansion factor ASF    */
       Gasf   char_space;        /* character spacing ASF             */
       Gasf   text_colr_ind;     /* text colour index ASF             */
       Gasf   fill_int_style;    /* fill area interior style ASF      */
       Gasf   fill_style_ind;    /* fill area style index ASF         */
       Gasf   fill_colr_ind;     /* fill area colour index ASF        */
       Gasf   edge_flag;         /* edge flag ASF                     */
       Gasf   edgetype;          /* edgetype ASF                      */
       Gasf   edgewidth;         /* edgewidth scale factor ASF        */
       Gasf   edge_colr_ind;     /* edge colour index ASF             */
   } Gasfs3;
/* --- Gcieluv  CIE L*u*v* [colour specification] --- */
   typedef struct {
       Gfloat   cieluv_x;       /* x coefficient   */
       Gfloat   cieluv_y;       /* y coefficient   */
       Gfloat   cieluv_y_lum;   /* y luminance     */
   } Gcieluv;
/* --- Gcolr_facs  colour facilities --- */
   typedef struct {
       Gint          num_colrs;       /* num. of colours                  */
       Gcolr_avail   colr_avail;      /* colour availability              */
       Gint          num_pred_inds;   /* num. of predef. colour indices   */
   } Gcolr_facs;
/* --- Gdyn_mod_seg_attrs  dynamic modification [of] segment
         attributes --- */
   typedef struct {
                               /* changeability of:                      */
       Gdyn_mod   tran;        /* segment transformation                 */
       Gdyn_mod   invis_vis;   /* appearing (invisible -> visible)       */
       Gdyn_mod   vis_invis;   /* disappearing (visible -> invisible)    */
       Gdyn_mod   highl;       /* highlighting                           */
       Gdyn_mod   pri;         /* priority                               */
       Gdyn_mod   add_prims;   /* addition of primitives to segment      */
       Gdyn_mod   del;         /* deletion of segment                    */
   } Gdyn_mod_seg_attrs;
/* --- Gdyn_mod_ws_attrs  dynamic modification [of] worksta-
         tion attributes  --- */
   typedef struct {
                                   /* changeability of:             */
       Gdyn_mod   line_bundle;     /* polyline representation       */
       Gdyn_mod   marker_bundle;   /* polymarker representation     */
       Gdyn_mod   text_bundle;     /* text representation           */
       Gdyn_mod   fill_bundle;     /* fill area representation      */
       Gdyn_mod   pat_rep;         /* pattern representation        */
       Gdyn_mod   colr_rep;        /* colour representation         */
       Gdyn_mod   ws_tran;         /* workstation transformation    */
   } Gdyn_mod_ws_attrs;
/* --- Gdyn_mod_ws_attrs3  dynamic modification [of]  works-
         tation attributes 3 --- */
   typedef struct {
                                   /* changeability of:            */
       Gdyn_mod   line_bundle;     /* polyline representation      */
       Gdyn_mod   marker_bundle;   /* polymarker representation    */
       Gdyn_mod   text_bundle;     /* text representation          */
       Gdyn_mod   fill_bundle;     /* fill area representation     */
       Gdyn_mod   edge_bundle;     /* edge representation          */
       Gdyn_mod   pat_rep;         /* pattern representation       */
       Gdyn_mod   colr_rep;        /* colour representation        */
       Gdyn_mod   view_rep;        /* view representation          */
       Gdyn_mod   ws_tran;         /* workstation transform        */
       Gdyn_mod   hlhsr_mode;      /* HLHSR mode                   */
   } Gdyn_mod_ws_attrs3;
/* --- Gedge_bundle  edge bundle --- */
   typedef struct {
       Gedge_flag   flag;       /* edge flag                */
       Gint         type;       /* edgetype                 */
       Gfloat       width;      /* edgewidth scale factor   */
       Gint         colr_ind;   /* edge colour index        */
   } Gedge_bundle;
/* --- Gfill_bundle  fill area bundle --- */
   typedef struct {
       Gfill_int_style   int_style;   /* fill area interior style   */
       Gint              style_ind;   /* fill area style index      */
       Gint              colr_ind;    /* fill area colour index     */
   } Gfill_bundle;
/* --- Gfloat_size  float size --- */
   typedef struct {
       Gfloat   size_x;   /* x size   */
       Gfloat   size_y;   /* y size   */
   } Gfloat_size;
/* --- Gfloat_size3  float size 3 --- */
   typedef struct {
       Gfloat   size_x;   /* x size   */
       Gfloat   size_y;   /* y size   */
       Gfloat   size_z;   /* z size   */
   } Gfloat_size3;
/* --- Ghls  Hue Luminance Saturation [colour specification]
         --- */
   typedef struct {
       Gfloat   hue;         /* hue          */
       Gfloat   lightness;   /* lightness    */
       Gfloat   satur;       /* saturation   */
   } Ghls;
/* --- Ghsv  Hue Saturation Value [colour specification] ---
         */
   typedef struct {
       Gfloat   hue;     /* hue          */
       Gfloat   satur;   /* saturation   */
       Gfloat   value;   /* value        */
   } Ghsv;
/* --- Gint_list  integer list --- */
   typedef struct {
       Gint   num_ints;   /* num. of integers in list   */
       Gint   *ints;      /* list of integers           */
   } Gint_list;
/* --- Gint_size  integer size --- */
   typedef struct {
       Gint   size_x;   /* x size   */
       Gint   size_y;   /* y size   */
   } Gint_size;
/* --- Gint_size3  integer size 3 --- */
   typedef struct {
       Gint   size_x;   /* x size   */
       Gint   size_y;   /* y size   */
       Gint   size_z;   /* z size   */
   } Gint_size3;
/* --- Glimit  limit --- */
   typedef struct {
       Gfloat   x_min;   /* x min   */
       Gfloat   x_max;   /* x max   */
       Gfloat   y_min;   /* y min   */
       Gfloat   y_max;   /* y max   */
   } Glimit;
/* --- Glimit3  limit 3 --- */
   typedef struct {
       Gfloat   x_min;   /* x min   */
       Gfloat   x_max;   /* x max   */
       Gfloat   y_min;   /* y min   */
       Gfloat   y_max;   /* y max   */
       Gfloat   z_min;   /* z min   */
       Gfloat   z_max;   /* z max   */
   } Glimit3;
/* --- Gline_bundle  polyline bundle --- */
   typedef struct {
       Gint     type;       /* linetype                 */
       Gfloat   width;      /* linewidth scale factor   */
       Gint     colr_ind;   /* polyline colour index    */
   } Gline_bundle;
/* --- Gmarker_bundle  polymarker bundle --- */
   typedef struct {
       Gint     type;       /* marker type                */
       Gfloat   size;       /* marker size scale factor   */
       Gint     colr_ind;   /* polymarker colour index    */
   } Gmarker_bundle;
/* --- Gmax_ws_st_tables  max. [length of] workstation state
         tables  --- */
   typedef struct {
                                /* max. num. of :                    */
       Gint   line_bundles;     /* polyline bundle table entries     */
       Gint   marker_bundles;   /* polymarker bundle table entries   */
       Gint   text_bundles;     /* text bundle table entries         */
       Gint   fill_bundles;     /* fill area bundle table entries    */
       Gint   pat_reps;         /* pattern table entries             */
       Gint   colr_reps;        /* colour table entries              */
   } Gmax_ws_st_tables;
/* ---  Gmax_ws_st_tables3   max.  [length  of]  workstation
         state tables 3 --- */
   typedef struct {
                                /* max. num. of :                    */
       Gint   line_bundles;     /* polyline bundle table entries     */
       Gint   marker_bundles;   /* polymarker bundle table entries   */
       Gint   text_bundles;     /* text bundle table entries         */
       Gint   fill_bundles;     /* fill area bundle table entries    */
       Gint   pat_reps;         /* pattern table entries             */
       Gint   edge_bundles;     /* edge bundle table entries         */
       Gint   colr_reps;        /* colour table entries              */
       Gint   view_reps;        /* view table entries                */
   } Gmax_ws_st_tables3;
/* --- Gnum_in  number [of] input [devices] --- */
   typedef struct {
       Gint   loc;      /* num. of locator devices    */
       Gint   stroke;   /* num. of stroke devices     */
       Gint   val;      /* num. of valuator devices   */
       Gint   choice;   /* num. of choice devices     */
       Gint   pick;     /* num. of pick devices       */
       Gint   string;   /* num. of string devices     */
   } Gnum_in;
/* --- Gpick  pick [value] --- */
   typedef struct {
       Gint   seg_name;   /* segment name      */
       Gint   pick_id;    /* pick identifier   */
   } Gpick;
/* --- Gpoint  point --- */
   typedef struct {
       Gfloat   x;   /* x coordinate   */
       Gfloat   y;   /* y coordinate   */
   } Gpoint;
/* --- Gpoint3  point 3 --- */
   typedef struct {
       Gfloat   x;   /* x coordinate   */
       Gfloat   y;   /* y coordinate   */
       Gfloat   z;   /* z coordinate   */
   } Gpoint3;
/* --- Grgb  Red Green Blue [colour specification] --- */
   typedef struct {
       Gfloat   red;     /* red intensity     */
       Gfloat   green;   /* green intensity   */
       Gfloat   blue;    /* blue intensity    */
   } Grgb;
/* --- Gseg_attrs  segment attributes --- */
   typedef struct {
       Gtran_matrix   tran_matrix;   /* transformation matrix   */
       Gvis           vis;           /* visibility              */
       Ghighl         highl;         /* hightlighting           */
       Gfloat         pri;           /* segment priority        */
       Gdet           det;           /* detectability           */
   } Gseg_attrs;
/* --- Gseg_attrs3  segment attributes 3 --- */
   typedef struct {
       Gtran_matrix3   tran_matrix;   /* transformation matrix   */
       Gvis            vis;           /* visibility              */
       Ghighl          highl;         /* hightlighting           */
       Gfloat          pri;           /* segment priority        */
       Gdet            det;           /* detectability           */
   } Gseg_attrs3;
/* --- Gtext_align  text alignment --- */
   typedef struct {
       Ghor_text_align    hor;    /* horizontal component   */
       Gvert_text_align   vert;   /* vertical component     */
   } Gtext_align;
/* --- Gtext_font_prec  text font [and] precision --- */
   typedef struct {
       Gint         font;   /* text font        */
       Gtext_prec   prec;   /* text precision   */
   } Gtext_font_prec;
/* --- Gvec  vector --- */
   typedef struct {
       Gfloat   delta_x;   /* x coordinate   */
       Gfloat   delta_y;   /* y coordinate   */
   } Gvec;
/* --- Gvec3  vector 3 --- */
   typedef struct {
       Gfloat   delta_x;   /* x coordinate   */
       Gfloat   delta_y;   /* y coordinate   */
       Gfloat   delta_z;   /* z coordinate   */
   } Gvec3;
/* --- Gws_max_nums  workstation max. numbers --- */
   typedef struct {
       Gint   simult_open;     /* max. num. of simult. open wss               */
       Gint   simult_active;   /* max. num. of simult. active wss             */
       Gint   assoc_seg;       /* max. num. of wss associated with segment    */
   } Gws_max_nums;

/*
 *      A.2.4  Nested Structures
 */
/* --- Gclip  clipping --- */
   typedef struct {
       Gclip_ind   clip_ind;    /* clipping indicator   */
       Glimit      clip_rect;   /* clipping rectangle   */
   } Gclip;
/* --- Gclip3  clipping 3 --- */
   typedef struct {
       Gclip_ind   clip_ind;   /* clipping indicator   */
       Glimit3     clip_vol;   /* clipping volume      */
   } Gclip3;
/* --- Gdisp_space_size  display space size --- */
   typedef struct {
       Gdc_units     dc_units;      /* device coordinate units                  */
       Gfloat_size   size_dc;       /* display space size [in] dc [units]       */
       Gint_size     size_raster;   /* display space size [in] raster [units]   */
   } Gdisp_space_size;
/* --- Gdisp_space_size3  display space size 3 --- */
   typedef struct {
       Gdc_units      dc_units;      /* device coordinate units                  */
       Gfloat_size3   size_dc;       /* display space size [in] dc [units]       */
       Gint_size3     size_raster;   /* display space size [in] raster [units]   */
   } Gdisp_space_size3;
/* --- Gedge_facs  edge facilities --- */
   typedef struct {
       Gint_list   types;           /* list of edgetypes              */
       Gint        num_widths;      /* num. of available edgewidths   */
       Gfloat      nom_width;       /* nominal edgewidth              */
       Gfloat      min_width;       /* min. edgewidth                 */
       Gfloat      max_width;       /* max. edgewidth                 */
       Gint        num_pred_inds;   /* num. of predef. edge indices   */
   } Gedge_facs;
/* --- Gfill_attrs  fill area attributes --- */
   typedef struct {
       Gasf           int_style_asf;   /* fill area interior style asf   */
       Gasf           style_ind_asf;   /* fill area style index asf      */
       Gasf           colr_ind_asf;    /* fill area colour index asf     */
       Gint           ind;             /* fill area index                */
       Gfill_bundle   bundle;          /* fill area bundle               */
   } Gfill_attrs;
/* --- Gfill_facs  fill area facilities --- */
   typedef struct {
       Gint              num_int_styles;   /* num. of interior styles             */
       Gfill_int_style   int_styles[4];    /* list of available interior styles   */
       Gint_list         hatch_styles;     /* list of available hatch styles      */
       Gint              num_pred_inds;    /* num. of predef. fill area indices   */
   } Gfill_facs;
/* --- Gindiv_attrs  individual attributes --- */
   typedef struct {
       Gint              linetype;          /* linetype                     */
       Gfloat            linewidth;         /* linewidth scale factor       */
       Gint              line_colr_ind;     /* polyline colour index        */
       Gint              marker_type;       /* marker type                  */
       Gfloat            marker_size;       /* marker size scale factor     */
       Gint              marker_colr_ind;   /* polymarker colour index      */
       Gtext_font_prec   text_font_prec;    /* text font and precision      */
       Gfloat            char_expan;        /* character expansion factor   */
       Gfloat            char_space;        /* character spacing            */
       Gint              text_colr_ind;     /* text colour index            */
       Gfill_int_style   fill_int_style;    /* fill area interior style     */
       Gint              fill_style_ind;    /* fill area style index        */
       Gint              fill_colr_ind;     /* fill area colour index       */
       Gasfs             asfs;              /* aspect source flags          */
   } Gindiv_attrs;
/* --- Gindiv_attrs3  individual attributes 3 --- */
   typedef struct {
       Gint              linetype;          /* linetype                     */
       Gfloat            linewidth;         /* linewidth scale factor       */
       Gint              line_colr_ind;     /* polyline colour index        */
       Gint              marker_type;       /* marker type                  */
       Gfloat            marker_size;       /* marker size scale factor     */
       Gint              marker_colr_ind;   /* polymarker colour index      */
       Gtext_font_prec   text_font_prec;    /* text font and precision      */
       Gfloat            char_expan;        /* character expansion factor   */
       Gfloat            char_space;        /* character spacing            */
       Gint              text_colr_ind;     /* text colour index            */
       Gfill_int_style   fill_int_style;    /* fill area interior style     */
       Gint              fill_style_ind;    /* fill area style index        */
       Gint              fill_colr_ind;     /* fill area colour index       */
       Gedge_flag        edge_flag;         /* edge flag                    */
       Gint              edgetype;          /* edgetype                     */
       Gfloat            edgewidth;         /* edgewidth scale factor       */
       Gint              edge_colr_ind;     /* edge colour index            */
       Gasfs3            asfs;              /* aspect source flags 3        */
   } Gindiv_attrs3;
/* --- Gline_attrs  polyline attributes --- */
   typedef struct {
       Gasf           type_asf;       /* linetype asf                */
       Gasf           width_asf;      /* linewidth asf               */
       Gasf           colr_ind_asf;   /* polyline colour index asf   */
       Gint           ind;            /* polyline index              */
       Gline_bundle   bundle;         /* polyline bundle             */
   } Gline_attrs;
/* --- Gline_facs  polyline facilities --- */
   typedef struct {
       Gint_list   types;           /* list of linetypes                  */
       Gint        num_widths;      /* num. of available linewidths       */
       Gfloat      nom_width;       /* nominal linewidth                  */
       Gfloat      min_width;       /* min. linewidth                     */
       Gfloat      max_width;       /* max. linewidth                     */
       Gint        num_pred_inds;   /* num. of predef. polyline indices   */
   } Gline_facs;
/* --- Gmarker_attrs  polymarker attributes --- */
   typedef struct {
       Gasf             type_asf;       /* marker type asf                */
       Gasf             size_asf;       /* marker size scale factor asf   */
       Gasf             colr_ind_asf;   /* marker colour index asf        */
       Gint             ind;            /* polymarker index               */
       Gmarker_bundle   bundle;         /* polymarker bundle              */
   } Gmarker_attrs;
/* --- Gmarker_facs  polymarker facilities --- */
   typedef struct {
       Gint_list   types;           /* list of marker types                 */
       Gint        num_sizes;       /* num. of available marker sizes       */
       Gfloat      nom_size;        /* nominal marker size                  */
       Gfloat      min_size;        /* min. marker size                     */
       Gfloat      max_size;        /* max. marker size                     */
       Gint        num_pred_inds;   /* num. of predef. polymarker indices   */
   } Gmarker_facs;
/* --- Gparal  parallelogram --- */
   typedef struct {
       Gpoint3   p;   /* point p   */
       Gpoint3   q;   /* point q   */
       Gpoint3   r;   /* point r   */
   } Gparal;
/* --- Gpat_rep  pattern representation --- */
   typedef struct {
       Gint_size   dims;          /* colour array's dimensions   */
       Gint        *colr_array;   /* colour array                */
   } Gpat_rep;
/* --- Gprim_attrs  primitive attributes --- */
   typedef struct {
       Gint          line_ind;        /* polyline index            */
       Gint          marker_ind;      /* polymarker index          */
       Gint          text_ind;        /* text index                */
       Gfloat        char_ht;         /* character height          */
       Gvec          char_up_vec;     /* character up vector       */
       Gfloat        char_width;      /* character width           */
       Gvec          char_base_vec;   /* character base vector     */
       Gtext_path    text_path;       /* text path                 */
       Gtext_align   text_align;      /* text alignment            */
       Gint          fill_ind;        /* fill area index           */
       Gvec          pat_width_vec;   /* pattern width vector      */
       Gvec          pat_ht_vec;      /* pattern height vector     */
       Gpoint        pat_ref_point;   /* pattern reference point   */
   } Gprim_attrs;
/* --- Gprim_attrs3  primitive attributes 3 --- */
   typedef struct {
       Gint          line_ind;         /* polyline index              */
       Gint          marker_ind;       /* polymarker index            */
       Gint          text_ind;         /* text index                  */
       Gfloat        char_ht;          /* character height            */
       Gvec          char_up_vec;      /* character up vector         */
       Gfloat        char_width;       /* character width             */
       Gvec          char_base_vec;    /* character base vector       */
       Gtext_path    text_path;        /* text path                   */
       Gtext_align   text_align;       /* text alignment              */
       Gint          fill_ind;         /* fill area index             */
       Gvec          pat_width_vec;    /* pattern width vector        */
       Gvec          pat_ht_vec;       /* pattern height vector       */
       Gpoint3       pat_ref_point;    /* pattern reference point     */
       Gvec3         pat_ref_vec[2];   /* pattern reference vectors   */
       Gint          edge_ind;         /* edge index                  */
       Gint          view_ind;         /* view index                  */
   } Gprim_attrs3;
/* --- Gpoint_list  point list --- */
   typedef struct {
       Gint     num_points;   /* num. of points in the list   */
       Gpoint   *points;      /* list of points               */
   } Gpoint_list;
/* --- Gpoint_list3  point list 3 --- */
   typedef struct {
       Gint      num_points;   /* num. of points in the list   */
       Gpoint3   *points;      /* list of points               */
   } Gpoint_list3;
/* --- Gpoint_list_list  list of point lists --- */
   typedef struct {
       Gint          num_point_lists;   /* num. of point lists in the list   */
       Gpoint_list   *point_lists;      /* list of point lists               */
   } Gpoint_list_list;
/* --- Gpoint_list_list3  list of point lists 3 --- */
   typedef struct {
       Gint           num_point_lists;   /* num. of point lists in the list   */
       Gpoint_list3   *point_lists;      /* list of point lists               */
   } Gpoint_list_list3;
/* --- Grect  rectangle --- */
   typedef struct {
       Gpoint   p;   /* point p   */
       Gpoint   q;   /* point q   */
   } Grect;
/* --- Gtext_extent  text extent --- */
   typedef struct {
       Gpoint   concat_point;   /* concatenation point         */
       Gpoint   paral[4];       /* text extent parallelogram   */
   } Gtext_extent;
/* --- Gtext_extent3  text extent 3 --- */
   typedef struct {
       Gpoint3   concat_point;   /* concatenation point         */
       Gpoint3   paral[4];       /* text extent parallelogram   */
   } Gtext_extent3;
/* --- Gtext_bundle  text bundle --- */
   typedef struct {
       Gtext_font_prec   text_font_prec;   /* text font and precision      */
       Gfloat            char_expan;       /* character expansion factor   */
       Gfloat            char_space;       /* character spacing            */
       Gint              colr_ind;         /* text colour index            */
   } Gtext_bundle;
/* --- Gtext_facs  text facilities --- */
   typedef struct {
       Gint              num_font_precs;    /* num. of fonts and precisions      */
       Gtext_font_prec   *font_precs;       /* list of fonts and precisions      */
       Gint              num_char_hts;      /* num. of character heights         */
       Gfloat            min_char_ht;       /* min. character height             */
       Gfloat            max_char_ht;       /* max. character height             */
       Gint              num_char_expans;   /* num. of char. expansion factors   */
       Gfloat            min_char_expan;    /* min. expansion factor             */
       Gfloat            max_char_expan;    /* max. expansion factor             */
       Gint              num_pred_inds;     /* num. of predef. text indices      */
   } Gtext_facs;
/* --- Gtran  transformation --- */
   typedef struct {
       Glimit   win;   /* window     */
       Glimit   vp;    /* viewport   */
   } Gtran;
/* --- Gtran3  transformation 3 --- */
   typedef struct {
       Glimit3   win;   /* window     */
       Glimit3   vp;    /* viewport   */
   } Gtran3;
/* --- Gview_map3  view mapping 3 --- */
   typedef struct {
       Glimit       win;              /* window limits                */
       Glimit3      proj_vp;          /* projection viewport limits   */
       Gproj_type   proj_type;        /* projection type              */
       Gpoint3      proj_ref_point;   /* projection reference point   */
       Gfloat       view_plane;       /* view plane distance          */
       Gfloat       front_plane;      /* front plane distance         */
       Gfloat       back_plane;       /* back plane distance          */
   } Gview_map3;
/* --- Gview_rep3  view representation 3 --- */
   typedef struct {
       Gmatrix3    ori_matrix;   /* orientation matrix           */
       Gmatrix3    map_matrix;   /* mapping matrix               */
       Glimit3     clip_limit;   /* clipping limits              */
       Gclip_ind   xy_clip;      /* X-Y clipping [indicator]     */
       Gclip_ind   back_clip;    /* back clipping [indicator]    */
       Gclip_ind   front_clip;   /* front clipping [indicator]   */
   } Gview_rep3;

/*
 *      A.2.5  Implementation Dependent Types
 */
/* --- Gchoice_data  choice data record   --- */
   typedef struct {
        union Gchoice_pets {
            struct Gchoice_pet_r1 {
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r1;   /* pet 1 data */
            struct Gchoice_pet_r2 {
                        Gint       num_prs;        /* number of prompts */
                        Gpr_flag   *prs;           /* prompt array */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r2;   /* pet 2 data */
            struct Gchoice_pet_r3 {
                        Gint       num_strings;    /* number of choice strings */
                        char       **strings;      /* array of choice strings */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r3;   /* pet 3 data */
            struct Gchoice_pet_r4 {
                        Gint       num_strings;    /* number of choice strings */
                        char       **strings;      /* array of choice strings */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r4;   /* pet 4 data */
            struct Gchoice_pet_r5 {
                        Gint       seg_name;       /* segment name */
                        Gint       num_pick_ids;   /* number of pick identifiers */
                        Gint       *pick_ids;      /* array of pick identifiers */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r5;   /* pet 5 data */
            struct Gchoice_pet_u1 {
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_u1;   /* pet -1 data */
            /*. . . impl. defined PET's */
         } pets;
   } Gchoice_data;
/* --- Gchoice_data3  choice data record 3 --- */
   typedef struct {
        union Gchoice3_pets {
            struct Gchoice3_pet_r1 {
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r1;   /* pet 1 data */
            struct Gchoice3_pet_r2 {
                        Gint       num_prs;        /* number of prompts */
                        Gpr_flag   *prs;           /* prompt array */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r2;   /* pet 2 data */
            struct Gchoice3_pet_r3 {
                        Gint       num_strings;    /* number of choice strings */
                        char       **strings;      /* array of choice strings */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r3;   /* pet 3 data */
            struct Gchoice3_pet_r4 {
                        Gint       num_strings;    /* number of choice strings */
                        char       **strings;      /* array of choice strings */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r4;   /* pet 4 data */
            struct Gchoice3_pet_r5 {
                        Gint       seg_name;       /* segment name */
                        Gint       num_pick_ids;   /* number of pick identifiers */
                        Gint       *pick_ids;      /* array of pick identifiers */
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_r5;   /* pet 5 data */
            struct Gchoice3_pet_u1 {
                        Gdata      impl_dep;       /* impl. dep. */
            } pet_u1;   /* pet -1 data */
            /*. . . impl. defined PET's */
         } pets;
   } Gchoice_data3;
/* --- Gcolr_rep  colour representation --- */
   typedef union {
       Grgb      rgb;      /* Red Green Blue colour specification */
       Gcieluv   cieluv;   /* CIE L*u*v* 1976 colour specification */
       Ghls      hls;      /* Hue Luminance Saturation colour specification */
       Ghsv      hsv;      /* Hue Saturation Value colour specification */
       Gdata     unsupp;   /* impl. dep. colour specification */
                           /* etc. */
   } Gcolr_rep;
/* --- Gescape_in_data  escape input data record --- */
   typedef union {
       struct Gescape_in_r1 {
                      Gdata   reg_dep;    /* reg. dep. */
       } escape_r1;   /* escape 1 data */
       struct Gescape_in_u1 {
                      Gdata   impl_dep;   /* impl. dep. */
       } escape_u1;   /* escape -1 data */
       /* etc. */
   } Gescape_in_data;
/* --- Gescape_out_data  escape output data record --- */
   typedef union {
       struct Gescape_out_r1 {
                      Gdata   reg_dep;    /* reg. dep. */
       } escape_r1;   /* escape 1 data */
       struct Gescape_out_u1 {
                      Gdata   impl_dep;   /* impl. dep. */
       } escape_u1;   /* escape -1 data */
       /* etc. */
   } Gescape_out_data;
/* --- Ggdp_data  gdp data record --- */
   typedef union {
       struct Ggdp_r1 {
                    Gdata   reg_dep;    /* reg. dep. */
       } gdp_r1;    /* gdp 1 data */
       struct Ggdp_u1 {
                    Gdata   impl_dep;   /* impl. dep. */
       } gdp_u1;    /* gdp -1 data */
       /* etc. */
   } Ggdp_data;
/* --- Ggdp_data3  gdp data record 3 --- */
   typedef union {
       struct Ggdp3_r1 {
                    Gdata   reg_dep;    /* reg. dep. */
       } gdp3_r1;   /* gdp 1 data */
       struct Ggdp3_u1 {
                    Gdata   impl_dep;   /* impl. dep. */
       } gdp3_u1;   /* gdp -1 data */
       /* etc. */
   } Ggdp_data3;
/* --- Gitem_data  item data record --- */
   typedef struct {
       Gint                 type;         /* item type                          */
       Gint                 length;       /* item data record length            */
       union {
          Gctrl_flag        clear_ws;     /* control flag                  */
          Gupd_regen_flag   upd_ws;       /* regen. flag                   */
          struct Gdefer_st {
                            Gdefer_mode   defer_mode;
                                          /* deferral mode                 */
                            Girg_mode     irg_mode;
                                          /* irg mode                      */
          } defer_st;                     /* deferrral state               */
          /* etc. */
          Gdata             gdp_unsupp;   /* GDPs not supported by impl.   */
          Gdata             impl_dep;     /* impl. dependent               */
       } data;
   } Gitem_data;
/* --- Gloc_data  locator  data record --- */
   typedef struct {
       union Gloc_pets {
           struct Gloc_pet_r1 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r1;   /* pet 1 data */
           struct Gloc_pet_r2 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r2;   /* pet 2 data */
           struct Gloc_pet_r3 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r3;   /* pet 3 data */
           struct Gloc_pet_r4 {
                       Gattr_ctrl_flag          attr_ctrl_flag;
                       /* attribute             control flag */
                       Gline_attrs              line_attrs;
                       /* polyline              attributes */
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r4;   /* pet 4 data */
           struct Gloc_pet_r5 {
                       Gattr_ctrl_flag          attr_ctrl_flag;
                       /* attribute             control flag */
                       Gline_fill_ctrl_flag     line_fill_ctrl_flag;
                       /* polyline/fill area    control flag */
                       union Gloc_attrs {
                                                Gline_attrs    line_attrs;
                                                /* polyline    attrs. */
                                                Gfill_attrs    fill_attrs;
                                                /* fill area   attrs. */
                       } attrs;
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r5;   /* pet 5 data */
           struct Gloc_pet_r6 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r6;   /* pet 6 data */
           struct Gloc_pet_u1 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_u1;   /* pet -1 data */
           /*. . . impl. defined PET's */
       } pets;
   } Gloc_data;
/* --- Gloc_data3  locator data record 3 --- */
   typedef struct {
       union Gloc3_pets {
           struct Gloc3_pet_r1 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r1;   /* pet 1 data */
           struct Gloc3_pet_r2 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r2;   /* pet 2 data */
           struct Gloc3_pet_r3 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r3;   /* pet 3 data */
           struct Gloc3_pet_r4 {
                       Gattr_ctrl_flag          attr_ctrl_flag;
                       /* attribute             control flag */
                       Gline_attrs              line_attrs;
                       /* polyline              attributes */
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r4;   /* pet 4 data */
           struct Gloc3_pet_r5 {
                       Gattr_ctrl_flag          attr_ctrl_flag;
                       /* attribute             control flag */
                       Gline_fill_ctrl_flag     line_fill_ctrl_flag;
                       /* polyline/fill area    control flag */
                       union Gloc3_attrs {
                                                Gline_attrs    line_attrs;
                                                /* polyline    attrs. */
                                                Gfill_attrs    fill_attrs;
                                                /* fill area   attrs. */
                       } attrs;
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r5;   /* pet 5 data */
           struct Gloc3_pet_r6 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_r6;   /* pet 6 data */
           struct Gloc3_pet_u1 {
                       Gdata                    impl_dep;      /* impl. dep. */
           } pet_u1;   /* pet -1 data */
           /*. . . impl. defined PET's */
       } pets;
   } Gloc_data3;
/* --- Gpick_data  pick data record  --- */
   typedef struct {
       union Gpick_pets {
           struct Gpick_pet_r1 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_r1;   /* pet 1 data */
           struct Gpick_pet_r2 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_r2;   /* pet 2 data */
           struct Gpick_pet_r3 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_r3;   /* pet 3 data */
           struct Gpick_pet_u1 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_u1;   /* pet -1 data */
           /* etc. */
        } pets;
   } Gpick_data;
/* --- Gpick_data3  pick data record 3 --- */
   typedef struct {
       union Gpick3_pets {
           struct Gpick3_pet_r1 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_r1;   /* pet 1 data */
           struct Gpick3_pet_r2 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_r2;   /* pet 2 data */
           struct Gpick3_pet_r3 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_r3;   /* pet 3 data */
           struct Gpick3_pet_u1 {
                       Gdata   impl_dep;   /* impl. dep. */
           } pet_u1;   /* pet -1 data */
           /* etc. */
        } pets;
   } Gpick_data3;
/* --- Gstring_data  string data record --- */
   typedef struct {
       Gint   in_buf_size;   /* input buffer size (nr. of bytes) */
       Gint   init_pos;      /* initial [editing] position */
       union string_pets {
              struct Gstring_pet_r1 {
                             Gdata    impl_dep;    /* impl. dep. */
              } pet_r1;      /* pet 1 data */
              struct Gstring_pet_u1 {
                             Gdata    impl_dep;    /* impl. dep. */
              } pet_u1;      /* pet -1 data */
              /* etc. */
        } pets;
   } Gstring_data;
/* --- Gstring_data3  string data record 3 --- */
   typedef struct {
       Gint   in_buf_size;   /* input buffer size (nr. of bytes) */
       Gint   init_pos;      /* initial [editing] position */
       union string3_pets {
              struct Gstring3_pet_r1 {
                             Gdata    impl_dep;    /* impl. dep. */
              } pet_r1;      /* pet 1 data */
              struct Gstring3_pet_u1 {
                             Gdata    impl_dep;    /* impl. dep. */
              } pet_u1;      /* pet -1 data */
              /* etc. */
        } pets;
   } Gstring_data3;
/* --- Gstroke_data  stroke data record  --- */
   typedef struct {
       Gint     in_buf_size;     /* input buffer size (nr. of points) */
       Gint     init_pos;        /* initial [editing] position */
       Gfloat   x_interval;      /* X interval */
       Gfloat   y_interval;      /* Y interval */
       Gfloat   time_interval;   /* time interval */
       union Gstroke_pets {
                struct Gstroke_pet_r1 {
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r1;        /* pet 1 data */
                struct Gstroke_pet_r2 {
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r2;        /* pet 2 data */
                struct Gstroke_pet_r3 {
                                 Gattr_ctrl_flag   attr_ctrl_flag;
                                 /* attribute      control flag */
                                 Gmarker_attrs     marker_attrs;
                                 /* polymarker     attrs. */
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r3;        /* pet 3 data */
                struct Gstroke_pet_r4 {
                                 Gattr_ctrl_flag   attr_ctrl_flag;
                                 /* attribute      control flag */
                                 Gline_attrs       line_attrs;
                                 /* polyline       attrs. */
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r4;        /* pet 4 data */
                struct Gstroke_pet_u1 {
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_u1;        /* pet -1 data */
                /* etc. */
       } pets;
   } Gstroke_data;
/* --- Gstroke_data3  stroke data record 3 --- */
   typedef struct {
       Gint     in_buf_size;     /* input buffer size (nr. of points) */
       Gint     init_pos;        /* initial [editing] position */
       Gfloat   x_interval;      /* X interval */
       Gfloat   y_interval;      /* Y interval */
       Gfloat   z_interval;      /* Z interval */
       Gfloat   time_interval;   /* time interval */
       union Gstroke3_pets {
                struct Gstroke3_pet_r1 {
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r1;        /* pet 1 data */
                struct Gstroke3_pet_r2 {
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r2;        /* pet 2 data */
                struct Gstroke3_pet_r3 {
                                 Gattr_ctrl_flag   attr_ctrl_flag;
                                 /* attribute      control flag */
                                 Gmarker_attrs     marker_attrs;
                                 /* polymarker     attrs. */
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_r3;        /* pet 3 data */
                struct Gstroke3_pet_r4 {
                                 Gattr_ctrl_flag   attr_ctrl_flag;
                                 /* attribute      control flag */
                                 Gline_attrs       line_attrs;
                                 /* polyline       attrs. */
                                 Gdata             impl_dep;
                } pet_r4;        /* pet 4 data */
                struct Gstroke3_pet_u1 {
                                 Gdata             impl_dep;   /* impl. dep. */
                } pet_u1;        /* pet -1 data */
                /* etc. */
       } pets;
   } Gstroke_data3;
/* --- Gval_data  valuator data record --- */
   typedef struct {
       Gfloat   low_value;    /* low value */
       Gfloat   high_value;   /* high value */
       union Gval_pets {
                struct Gval_pet_r1 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_r1;     /* pet 1 data */
                struct Gval_pet_r2 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_r2;     /* pet 2 data */
                struct Gval_pet_r3 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_r3;     /* pet 3 data */
                struct Gval_pet_u1 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_u1;     /* pet -1 data */
                /* etc. */
        } pets;
   } Gval_data;
/* --- Gval_data3  valuator data record 3 --- */
   typedef struct {
       Gfloat   low_value;    /* low value */
       Gfloat   high_value;   /* high value */
       union Gval3_pets {
                struct Gval3_pet_r1 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_r1;     /* pet 1 data */
                struct Gval3_pet_r2 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_r2;     /* pet 2 data */
                struct Gval3_pet_r3 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_r3;     /* pet 3 data */
                struct Gval3_pet_u1 {
                              Gdata   impl_dep;   /* impl. dep. */
                } pet_u1;     /* pet -1 data */
                /* etc. */
        } pets;
   } Gval_data3;

/*
 *      A.3  Macros
 */

/*
 *      A.3.1  Error Macros
 */
#define GE_NO_ERR              (0)/* No Errors */
/*
 * operating state errors
 */
#define GE_NOT_GKCL            (1)/* GKS-3D not in proper state: GKS-3D shall be
                                   in the state GKCL */
#define GE_NOT_GKOP            (2)/* GKS-3D not in proper state: GKS-3D shall be
                                   in the state GKOP */
#define GE_NOT_WSAC            (3)/* GKS-3D not in proper state: GKS-3D shall be
                                   in the state WSAC */
#define GE_NOT_SGOP            (4)/* GKS-3D not in proper state: GKS-3D shall be
                                   in the state SGOP */
#define GE_NOT_WSAC_SGOP       (5)/* GKS-3D not in proper state: GKS-3D shall be
                                   either in the state WSAC or in the state SGOP
                                   */
#define GE_NOT_WSOP_WSAC       (6)/* GKS-3D not in proper state: GKS-3D shall be
                                   either in the state WSOP or in the state WSAC
                                   */
#define GE_GKCL_GKOP           (7)/* GKS-3D not in proper state: GKS-3D shall be
                                   in one of the states WSOP, WSAC or SGOP */
#define GE_GKCL                (8)/* GKS-3D not in proper state: GKS-3D shall be
                                   in one of the states GKOP, WSOP, WSAC or SGOP
                                   */
/*
 * workstation errors
 */
#define GE_WS_ID_INVAL         (20)/* Specified workstation identifier is
                                   invalid */
#define GE_CONN_ID_INVAL       (21)/* Specified connection identifier is invalid
                                   */
#define GE_WS_TYPE_INVAL       (22)/* Specified workstation type is invalid */
#define GE_NO_WS_TYPE          (23)/* Specified workstation type does not exist
                                   */
#define GE_WS_OPEN             (24)/* Specified workstation is open */
#define GE_WS_NOT_OPEN         (25)/* Specified workstation is not open */
#define GE_WS_CANT_OPEN        (26)/* Specified workstation cannot be opened */
#define GE_WISS_NOT_OPEN       (27)/* Workstation Independent Segment Storage is
                                   not open */
#define GE_WISS_OPEN           (28)/* Workstation Independent Segment Storage is
                                   already open */
#define GE_WS_ACTIVE           (29)/* Specified workstation is active */
#define GE_WS_INACTIVE         (30)/* Specified workstation is not active */
#define GE_WS_MO               (31)/* Specified workstation is of category MO */
#define GE_WS_NOT_MO           (32)/* Specified workstation is not of category
                                   MO */
#define GE_WS_MI               (33)/* Specified workstation is of category MI */
#define GE_WS_NOT_MI           (34)/* Specified workstation is not of category
                                   MI */
#define GE_WS_IN               (35)/* Specified workstation is of category INPUT
                                   */
#define GE_WS_WISS             (36)/* Specified workstation is Workstation
                                   Independent Segment Storage */
#define GE_WS_NOT_OUTIN        (37)/* Specified workstation is not of category
                                   OUTIN */
#define GE_WS_NOT_IN_OUTIN     (38)/* Specified workstation is neither of
                                   category INPUT nor of category OUTIN */
#define GE_WS_NOT_OUT_OUTIN    (39)/* Specified workstation is neither of
                                   category OUTPUT nor of category OUTIN */
#define GE_WS_NO_PIXEL         (40)/* Specified workstation has no pixel store
                                   readback capability */
#define GE_WS_TYPE_NO_GDP      (41)/* Specified workstation type is not able to
                                   generate the specified generalized drawing
                                   primitive */
#define GE_WS_MAX_OPEN         (42)/* Maximum number of simultaneously open
                                   workstations would be exceeded */
#define GE_WS_MAX_ACTIVE       (43)/* Maximum number of simultaneously active
                                   workstations would be exceeded */
/*
 * transformation errors
 */
#define GE_TRAN_NUM_INVAL      (50)/* Transformation number is invalid */
#define GE_RECT_INVAL          (51)/* Rectangle definition is invalid */
#define GE_VP_INVAL            (52)/* Viewport is not within the Normalized Dev-
                                   ice Coordinate unit square */
#define GE_WIN_INVAL           (53)/* Workstation window is not within the Nor-
                                   malized Device Coordinate unit square */
#define GE_WS_VP_INVAL         (54)/* Workstation viewport is not within the
                                   display space */
/*
 * output attribute errors
 */
#define GE_LINE_IND_INVAL      (60)/* Polyline index is invalid */
#define GE_LINE_REP_UNDEF      (61)/* A representation for the specified poly-
                                   line index has not been defined on this
                                   workstation */
#define GE_LINE_REP_NOT_PRED   (62)/* A representation for the specified poly-
                                   line index has not been predefined on this
                                   workstation */
#define GE_LINETYPE_ZERO       (63)/* Linetype is equal to zero */
#define GE_LINETYPE_NOT_WS     (64)/* Specified linetype is not supported on
                                   this workstation */
#define GE_LINEWIDTH_LT_ZERO   (65)/* Linewidth scale factor is less than zero
                                   */
#define GE_MARKER_IND_INVAL    (66)/* Polymarker index is invalid */
#define GE_MARKER_REP_UNDEF    (67)/* A representation for the specified poly-
                                   marker index has not been defined on this
                                   workstation */
#define GE_MARKER_REP_NOT_PRED (68)/* A representation for the specified poly-
                                   marker index has not been predefined on this
                                   workstation */
#define GE_MARKER_TYPE_ZERO    (69)/* Marker type is equal to zero */
#define GE_MARKER_TYPE_NOT_WS  (70)/* Specified marker type is not supported on
                                   this workstation */
#define GE_MARKER_SIZE_LT_ZERO (71)/* Marker size scale factor is less than zero
                                   */
#define GE_TEXT_IND_INVAL      (72)/* Text index is invalid */
#define GE_TEXT_REP_UNDEF      (73)/* A representation for the specified text
                                   index has not been defined on this worksta-
                                   tion */
#define GE_TEXT_REP_NOT_PRED   (74)/* A representation for the specified text
                                   index has not been predefined on this works-
                                   tation */
#define GE_FONT_ZERO           (75)/* Text font is equal to zero */
#define GE_FONT_NOT_WS         (76)/* Requested text font is not supported for
                                   the specified precision on this workstation
                                   */
#define GE_EXPAN_LE_ZERO       (77)/* Character expansion factor is less than or
                                   equal to zero */
#define GE_HT_LE_ZERO          (78)/* Character height is less than or equal to
                                   zero */
#define GE_UP_VEC_ZERO         (79)/* Length of character up vector is zero */
#define GE_FILL_IND_INVAL      (80)/* Fill area index is invalid */
#define GE_FILL_REP_UNDEF      (81)/* A representation for the specified fill
                                   area index has not been defined on this
                                   workstation */
#define GE_FILL_REP_NOT_PRED   (82)/* A representation for the specified fill
                                   area index has not been predefined on this
                                   workstation */
#define GE_INT_STYLE_NOT_WS    (83)/* Specified fill area interior style is not
                                   supported on this workstation */
#define GE_STYLE_IND_ZERO      (84)/* Style (pattern or hatch) index is equal to
                                   zero */
#define GE_PAT_IND_INVAL       (85)/* Specified pattern index is invalid */
#define GE_HATCH_STYLE_NOT_WS  (86)/* Specified hatch style is not supported on
                                   this workstation */
#define GE_PAT_SIZE_LE_ZERO    (87)/* Pattern size value is not positive */
#define GE_PAT_REP_UNDEF       (88)/* A representation for the specified pattern
                                   index has not been defined on this worksta-
                                   tion */
#define GE_PAT_REP_NOT_PRED    (89)/* A representation for the specified pattern
                                   index has not been predefined on this works-
                                   tation */
#define GE_PAT_NOT_WS          (90)/* Interior style PATTERN is not supported on
                                   this workstation */
#define GE_DIM_INVAL           (91)/* Dimensions of colour array are invalid */
#define GE_COLR_IND_LT_ZERO    (92)/* Colour index is less than zero */
#define GE_COLR_IND_INVAL      (93)/* Colour index is invalid */
#define GE_COLR_REP_UNDEF      (94)/* A representation for the specified colour
                                   index has not been defined on this worksta-
                                   tion */
#define GE_COLR_REP_NOT_PRED   (95)/* A representation for the specified colour
                                   index has not been predefined on this works-
                                   tation */
#define GE_COLR_INVAL          (96)/* Colour component is outside valid range
                                   for colour model */
#define GE_PICK_ID_INVAL       (97)/* Pick identifier is invalid */
#define GE_COLR_MODEL_UNAVAIL  (98)/* Specified colour model is not available on
                                   the workstation */
/*
 * output errors
 */
#define GE_NUM_POINT_INVAL     (100)/* Number of points is invalid */
#define GE_INVAL_CODE          (101)/* Invalid code in string */
#define GE_GDP_ID_INVAL        (102)/* Generalized drawing primitive identifier
                                   is invalid */
#define GE_GDP_DATA_INVAL      (103)/* Content of generalized drawing primitive
                                   data record is invalid */
#define GE_CANT_GEN_GDP        (104)/* At least one active workstation is not
                                   able to generate the specified generalized
                                   drawing primitive */
#define GE_CANT_GEN_GDP_CLIP   (105)/* At least one active workstation is not
                                   able to generate the specified generalized
                                   drawing primitive under the current transfor-
                                   mations and clipping conditions */
/*
 * segment errors
 */
#define GE_SEG_NAME_INVAL      (120)/* Specified segment name is invalid */
#define GE_SEG_NAME_USED       (121)/* Specified segment name is already in use
                                   */
#define GE_SEG_ABSENT          (122)/* Specified segment does not exist */
#define GE_SEG_NOT_WS          (123)/* Specified segment does not exist on
                                   specified workstation */
#define GE_SEG_NOT_WISS        (124)/* Specified segment does not exist on
                                   Workstation Independent Segment Storage */
#define GE_SEG_OPEN            (125)/* Specified segment is open */
#define GE_SEG_PRI_INVAL       (126)/* Segment priority is outside the range
                                   [0,1] */
/*
 * input errors
 */
#define GE_IN_DEV_NOT_WS       (140)/* Specified input device is not present on
                                   workstation */
#define GE_IN_DEV_NOT_REQ      (141)/* Input device is not in REQUEST mode */
#define GE_IN_DEV_NOT_SAMPLE   (142)/* Input device is not in SAMPLE mode */
#define GE_EV_SAMPLE_UNAVAIL   (143)/* EVENT and SAMPLE input mode are not
                                   available at this level of GKS-3D */
#define GE_PET_NOT_WS          (144)/* Specified prompt and echo type is not
                                   supported on this workstation */
#define GE_ECHO_INVAL          (145)/* Echo area is outside display space */
#define GE_IN_DATA_INVAL       (146)/* Contents of input data record are invalid
                                   */
#define GE_QUE_OVERF           (147)/* Input queue has overflowed */
#define GE_NO_QUE_OVERF        (148)/* Input queue has not overflowed since
                                   GKS-3D was opened or the last invocation of
                                   INQUIRE INPUT QUEUE OVERFLOW */
#define GE_ASSOC_WS_CLOSED     (149)/* Input queue has overflowed, but associ-
                                   ated workstation has been closed */
#define GE_NO_CUR_EV           (150)/* No input value of the correct class is in
                                   the current event report */
#define GE_TIMEOUT_INVAL       (151)/* Timeout is invalid */
#define GE_INIT_INVAL          (152)/* Initial value is invalid */
#define GE_INIT_STROKE_INVAL   (153)/* Number of points in the initial stroke is
                                   greater than the buffer size */
#define GE_INIT_STRING_INVAL   (154)/* Length of the initial string is greater
                                   than the buffer size */
/*
 * GKSM errors
 */
#define GE_ITEM_RESERVED       (160)/* Item type is not allowed for user items
                                   */
#define GE_ITEM_LENGTH_INVAL   (161)/* Item length is invalid */
#define GE_NO_ITEM_MI          (162)/* No item is left in GKS-3D Metafile input
                                   */
#define GE_ITEM_INVAL          (163)/* Metafile item is invalid */
#define GE_ITEM_GKS_INVAL      (164)/* Item type is not a valid GKS-3D item */
#define GE_ITEM_DATA_INVAL     (165)/* Content of item data record is invalid
                                   for the specified item type */
#define GE_MAX_ITEM_DATA_INVAL (166)/* Maximum item data record length is
                                   invalid */
#define GE_USER_ITEM           (167)/* User item cannot be interpreted */
#define GE_FUNC_UNAVAIL        (168)/* Specified function is not supported in
                                   this level of GKS-3D */
/*
 * escape errors
 */
#define GE_ESCAPE_FUNC_UNAVAIL (180)/* Specified escape function is not sup-
                                   ported */
#define GE_ESCAPE_ID_INVAL     (181)/* Specified escape function identification
                                   is invalid */
#define GE_ESCAPE_DATA_INVAL   (182)/* Contents of escape data record are
                                   invalid */
/*
 * error file errors
 */
#define GE_ERR_FILE_INVAL      (200)/* Specified error file is invalid */
/*
 * I/O errors
 */
#define GE_MEM_OVERF           (300)/* Storage overflow has occurred in GKS-3D
                                   */
#define GE_SEG_MEM_OVERF       (301)/* Storage overflow has occurred in segment
                                   storage */
#define GE_IO_ERR_READ         (302)/* Input/Output error has occurred while
                                   reading */
#define GE_IO_ERR_WRITE        (303)/* Input/Output error has occurred while
                                   writing */
#define GE_IO_ERR_WRITE_WS     (304)/* Input/Output error has occurred while
                                   sending data to a workstation */
#define GE_IO_ERR_READ_WS      (305)/* Input/Output error has occurred while
                                   receiving data from a workstation */
#define GE_IO_ERR_LIB          (306)/* Input/Output error has occurred during
                                   program library management */
#define GE_IO_ERR_WS_TABLE     (307)/* Input/Output error has occurred while
                                   reading workstation description table */
#define GE_ARITH_ERR           (308)/* Arithmetic error has occurred */
/*
 * 3-D Transformation errors
 */
#define GE_UP_VEC_PLANE_NORM_COLL (400)/* View up vector and view plane normal
                                   are collinear */
#define GE_PLANE_NORM_NULL     (401)/* View plane normal is a null vector */
#define GE_UP_VEC_NULL         (402)/* View up vector is a null vector */
#define GE_CLIP_LIM_INVAL      (403)/* View clipping limits are not within NPC
                                   range */
#define GE_PROJ_REF_POINT_INVAL   (404)/* Projection reference point is between
                                   the front and back clipping planes */
#define GE_PROJ_REF_POINT_PLANE   (405)/* Projection reference point is on the
                                   view plane */
#define GE_BOX_DEF_INVAL       (406)/* Box definition is invalid */
#define GE_VP3_INVAL           (407)/* Viewport is not within NDC unit cube */
#define GE_VIEW_IND_INVAL      (408)/* Specified view index is invalid */
#define GE_VIEW_REP_UNDEF      (409)/* A representation for the specified view
                                   index has not been defined on this worksta-
                                   tion. */
#define GE_VIEW_REP_NOT_PRED   (410)/* A representation for the specified view
                                   index has not been predefined on this works-
                                   tation */
#define GE_WS_WIN_LIM_INVAL    (411)/* Workstation window limits are not within
                                   the NPC unit cube */
#define GE_BACK_CLIP_INVAL     (412)/* Back clipping plane is in front of the
                                   front clipping plane */
#define GE_CLIP_PLANE_EQ       (413)/* Front and back clipping planes are the
                                   same */
/*
 * 3-D output attribute errors
 */
#define GE_EDGE_IND_INVAL      (420)/* Edge index is invalid */
#define GE_EDGE_REP_UNDEF      (421)/* A representation for the specified edge
                                   index has not been defined on this worksta-
                                   tion */
#define GE_EDGE_REP_NOT_PRED   (422)/* A representation for the specified edge
                                   index has not been predefined on this works-
                                   tation */
#define GE_EDGETYPE_ZERO       (423)/* Edgetype is equal to zero */
#define GE_EDGETYPE_NOT_WS     (424)/* Specified edgetype is not supported on
                                   this workstation */
#define GE_EDGEWIDTH_LT_ZERO   (425)/* Edgewidth scale factor is less than zero
                                   */
#define GE_PAT_REF_VEC_COLL    (426)/* Pattern reference vectors are collinear
                                   */
#define GE_HLHSR_NOT_WS        (427)/* Specified HLHSR mode not supported on
                                   workstation */
#define GE_HLHSR_ID_INVAL      (428)/* Specified HLHSR identifier is invalid */
#define GE_HLHSR_MODE_INVAL    (429)/* Specified HLHSR mode is invalid */
/*
 * 3-D output errors
 */
#define GE_TEXT_VEC_COLL       (430)/* The text direction vectors are collinear
                                   */
#define GE_LIST_POINT_LIST_INVAL  (431)/* List of point lists is invalid */
/*
 * binding specific errors
 */
#define GE_START_IND_INVAL     (2200)/* Start index out of range*/
#define GE_APPL_LIST_LENGTH_LT_ZERO (2201)/* Length of application list is nega-
                                   tive */
#define GE_ENUM_TYPE_INVAL     (2202)/* Enumeration type out of range*/
#define GE_ALLOC_STORE         (2203)/* Error while allocating Store */
#define GE_ALLOC_MEM_STORE     (2204)/* Error while allocating memory for Store
                                   */
/*
 *      A.3.2  Function Macros
 */
#define Gfn_open_gks                (0)
#define Gfn_close_gks               (1)
#define Gfn_open_ws                 (2)
#define Gfn_close_ws                (3)
#define Gfn_activate_ws             (4)
#define Gfn_deactivate_ws           (5)
#define Gfn_clear_ws                (6)
#define Gfn_redraw_all_segs_ws      (7)
#define Gfn_upd_ws                  (8)
#define Gfn_set_defer_st            (9)
#define Gfn_message                 (10)
#define Gfn_escape                  (11)
#define Gfn_polyline3               (109)
#define Gfn_polyline                (12)
#define Gfn_polymarker3             (110)
#define Gfn_polymarker              (13)
#define Gfn_text3                   (111)
#define Gfn_text                    (14)
#define Gfn_fill_area3              (112)
#define Gfn_fill_area               (15)
#define Gfn_fill_area_set3          (114)
#define Gfn_fill_area_set           (113)
#define Gfn_cell_array3             (115)
#define Gfn_cell_array              (16)
#define Gfn_gdp3                    (116)
#define Gfn_gdp                     (17)
#define Gfn_set_line_ind            (18)
#define Gfn_set_linetype            (19)
#define Gfn_set_linewidth           (20)
#define Gfn_set_line_colr_ind       (21)
#define Gfn_set_marker_ind          (22)
#define Gfn_set_marker_type         (23)
#define Gfn_set_marker_size         (24)
#define Gfn_set_marker_colr_ind     (25)
#define Gfn_set_text_ind            (26)
#define Gfn_set_text_font_prec      (27)
#define Gfn_set_char_expan          (28)
#define Gfn_set_char_space          (29)
#define Gfn_set_text_colr_ind       (30)
#define Gfn_set_char_ht             (31)
#define Gfn_set_char_up_vec         (32)
#define Gfn_set_text_path           (33)
#define Gfn_set_text_align          (34)
#define Gfn_set_fill_ind            (35)
#define Gfn_set_fill_int_style      (36)
#define Gfn_set_fill_style_ind      (37)
#define Gfn_set_fill_colr_ind       (38)
#define Gfn_set_pat_size            (39)
#define Gfn_set_pat_ref_point_vecs  (117)
#define Gfn_set_pat_ref_point       (40)
#define Gfn_set_edge_ind            (118)
#define Gfn_set_edge_flag           (119)
#define Gfn_set_edgetype            (120)
#define Gfn_set_edgewidth           (121)
#define Gfn_set_edge_colr_ind       (122)
#define Gfn_set_asfs3               (123)
#define Gfn_set_asfs                (41)
#define Gfn_set_pick_id             (42)
#define Gfn_set_line_rep            (43)
#define Gfn_set_marker_rep          (44)
#define Gfn_set_text_rep            (45)
#define Gfn_set_fill_rep            (46)
#define Gfn_set_pat_rep             (47)
#define Gfn_set_edge_rep            (124)
#define Gfn_set_colr_model          (125)
#define Gfn_set_colr_rep            (48)
#define Gfn_set_colr_rep_ext        (153)
#define Gfn_set_win3                (126)
#define Gfn_set_win                 (49)
#define Gfn_set_vp3                 (127)
#define Gfn_set_vp                  (50)
#define Gfn_set_vp_in_pri           (51)
#define Gfn_sel_norm_tran           (52)
#define Gfn_set_clip_ind            (53)
#define Gfn_set_view_ind            (128)
#define Gfn_set_view_rep3           (129)
#define Gfn_set_view_tran_in_pri    (130)
#define Gfn_set_hlhsr_id            (131)
#define Gfn_set_hlhsr_mode          (132)
#define Gfn_set_ws_win3             (133)
#define Gfn_set_ws_win              (54)
#define Gfn_set_ws_vp3              (134)
#define Gfn_set_ws_vp               (55)
#define Gfn_create_seg              (56)
#define Gfn_close_seg               (57)
#define Gfn_rename_seg              (58)
#define Gfn_del_seg                 (59)
#define Gfn_del_seg_ws              (60)
#define Gfn_assoc_seg_ws            (61)
#define Gfn_copy_seg_ws             (62)
#define Gfn_insert_seg3             (135)
#define Gfn_insert_seg              (63)
#define Gfn_set_seg_tran3           (136)
#define Gfn_set_seg_tran            (64)
#define Gfn_set_vis                 (65)
#define Gfn_set_highl               (66)
#define Gfn_set_seg_pri             (67)
#define Gfn_set_det                 (68)
#define Gfn_init_loc3               (137)
#define Gfn_init_loc                (69)
#define Gfn_init_stroke3            (138)
#define Gfn_init_stroke             (70)
#define Gfn_init_val3               (139)
#define Gfn_init_val                (71)
#define Gfn_init_choice3            (140)
#define Gfn_init_choice             (72)
#define Gfn_init_pick3              (141)
#define Gfn_init_pick               (73)
#define Gfn_init_string3            (142)
#define Gfn_init_string             (74)
#define Gfn_set_loc_mode            (75)
#define Gfn_set_stroke_mode         (76)
#define Gfn_set_val_mode            (77)
#define Gfn_set_choice_mode         (78)
#define Gfn_set_pick_mode           (79)
#define Gfn_set_string_mode         (80)
#define Gfn_req_loc3                (143)
#define Gfn_req_loc                 (81)
#define Gfn_req_stroke3             (144)
#define Gfn_req_stroke              (82)
#define Gfn_req_val                 (83)
#define Gfn_req_choice              (84)
#define Gfn_req_pick                (85)
#define Gfn_req_string              (86)
#define Gfn_sample_loc3             (145)
#define Gfn_sample_loc              (87)
#define Gfn_sample_stroke3          (146)
#define Gfn_sample_stroke           (88)
#define Gfn_sample_val              (89)
#define Gfn_sample_choice           (90)
#define Gfn_sample_pick             (91)
#define Gfn_sample_string           (92)
#define Gfn_await_event             (93)
#define Gfn_flush_events            (94)
#define Gfn_get_loc3                (147)
#define Gfn_get_loc                 (95)
#define Gfn_get_stroke3             (148)
#define Gfn_get_stroke              (96)
#define Gfn_get_val                 (97)
#define Gfn_get_choice              (98)
#define Gfn_get_pick                (99)
#define Gfn_get_string              (100)
#define Gfn_write_item              (101)
#define Gfn_get_item_type           (102)
#define Gfn_read_item               (103)
#define Gfn_interpret_item          (104)
#define Gfn_eval_view_ori_matrix3   (149)
#define Gfn_eval_view_map_matrix3   (150)
#define Gfn_eval_tran_matrix3       (151)
#define Gfn_eval_tran_matrix        (105)
#define Gfn_accum_tran_matrix3      (152)
#define Gfn_accum_tran_matrix       (106)
#define Gfn_emergency_close_gks     (153)
#define Gfn_err_hand                (154)
#define Gfn_err_log                 (155)
#define Gfn_set_err_hand            (156)

/*
 *      A.3.3  Miscellaneous Macros
 */
#define GLINE_SOLID    (1)  /* Solid linetype */
#define GLINE_DASH     (2)  /* Dashed linetype */
#define GLINE_DOT      (3)  /* Dotted linetype */
#define GLINE_DASH_DOT (4)  /* Dashed-dotted linetype */
#define GLINE_DASH_DOT_DOT  (5)/* Dashed-dotted-dotted line-
type */
#define GMARKER_DOT    (1)  /* Dotted marker type */
#define GMARKER_PLUS   (2)  /* Plus (+) marker type */
#define GMARKER_ASTERISK    (3)/* Asterisk (*) marker type
*/
#define GMARKER_CIRCLE (4)  /* Circle (o) marker type */
#define GMARKER_CROSS  (5)  /* Cross (X) marker type */
#define GMODEL_RGB     (1)  /* Red-Green-Blue */
#define GMODEL_CIELUV  (2)  /* CIE Luv 1976 */
#define GMODEL_HSV     (3)  /* Hue-Saturation-Value */
#define GMODEL_HLS     (4)  /* Hue-Lightness-Saturation */
#define GLOC_DEF       (1)  /* Locator default */
#define GLOC_CROSS_HAIR     (2)/* Locator cross-hair */
#define GLOC_TRACK_CROSS    (3)/* Locator tracking cross*/
#define GLOC_RUB_BAND  (4)  /* Locator rubber band */
#define GLOC_RECT      (5)  /* Locator rectangle */
#define GLOC_DIGIT     (6)  /* Locator digital */
#define GSTROKE_DEF    (1)  /* Stroke default */
#define GSTROKE_DIGIT  (2)  /* Stroke digit */
#define GSTROKE_MARKER (3)  /* Stroke polymarker */
#define GSTROKE_LINE   (4)  /* Stroke polyline */
#define GVAL_DEF       (1)  /* Valuator default */
#define GVAL_GRAPH     (2)  /* Valuator graphical */
#define GVAL_DIGIT     (3)  /* Valuator digital */
#define GCHOICE_DEF    (1)  /* Choice default */
#define GCHOICE_PR_ECHO     (2)/* Choice prompt and echo */
#define GCHOICE_STRING_PR   (3)/* Choice string and prompt
*/
#define GCHOICE_STRING_IN   (4)/* Choice string input*/
#define GCHOICE_SEG    (5)  /* Choice segment */
#define GPICK_DEF      (1)  /* Pick default */
#define GPICK_GROUP_HIGHL   (2)/* Pick group highlighting */
#define GPICK_SEG_HIGHL     (3)/* Pick segment highlighting
*/
#define GSTRING_DEF    (1)  /* String default */
#define GDEF_MEM_SIZE  ((size_t) (-1))/* Default memory size
*/
#define GDEF_ERR_FILE  ((char *) (""))/* Default error file
name*/

/*
 *      A.3.4  GKSM Item Macros
 */

/*
 * control items
 */
#define Gksm_end_item            ( 0) /*  end item */
#define Gksm_clear_ws            ( 1) /*  clear workstation */
#define Gksm_redraw_all_segs_ws  ( 2) /*  redraw all segments */
#define Gksm_upd_ws              ( 3) /*  update workstation */
#define Gksm_defer_st            ( 4) /*  deferral state */
#define Gksm_message             ( 5) /*  message */
#define Gksm_escape              ( 6) /*  escape */
/*
 * output items
 */
#define Gksm_polyline            (11) /*  polyline */
#define Gksm_polymarker          (12) /*  polymarker */
#define Gksm_text                (13) /*  text */
#define Gksm_fill_area           (14) /*  fill area */
#define Gksm_fill_area_set       (15) /*  fill area set */
#define Gksm_cell_array          (16) /*  cell array */
#define Gksm_gdp                 (17) /*  gdp */
/*
 * output attribute items
 */
#define Gksm_line_ind            (21) /*  polyline index */
#define Gksm_linetype            (22) /*  linetype */
#define Gksm_linewidth           (23) /*  linewidth scale
#define Gksm_line_colr_ind       (24) /*  polyline colour index */
#define Gksm_marker_ind          (25) /*  polymarker index */
#define Gksm_marker_type         (26) /*  marker type */
#define Gksm_marker_size         (27) /*  marker size scale
#define Gksm_marker_colr_ind     (28) /*  polymarker colour
#define Gksm_text_ind            (29) /*  text index */
#define Gksm_text_font_prec      (30) /*  text font
#define Gksm_char_expan          (31) /*  character expansion
#define Gksm_char_space          (32) /*  character spacing */
#define Gksm_text_colr_ind       (33) /*  text colour index */
#define Gksm_char_vec            (34) /*  character vectors */
#define Gksm_text_path           (35) /*  text path */
#define Gksm_text_align          (36) /*  text alignment */
#define Gksm_fill_ind            (37) /*  fill area index */
#define Gksm_fill_int_style      (38) /*  fill area interior style */
#define Gksm_fill_style_ind      (39) /*  fill area style index */
#define Gksm_fill_colr_ind       (40) /*  fill area colour index */
#define Gksm_pat_ref_point_vecs  (41) /*  pattern reference point and vectors */
#define Gksm_edge_ind            (42) /*  edge index */
#define Gksm_edge_flag           (43) /*  edge flag */
#define Gksm_edgetype            (44) /*  edgetype */
#define Gksm_edgewidth           (45) /*  edgewidth scale factor */
#define Gksm_edge_colr_ind       (46) /*  edge colour index */
#define Gksm_asf                 (47) /*  aspect source flags */
#define Gksm_pick_id             (48) /*  pick identifier */
/*
 * workstation attribute items
 */
#define Gksm_line_rep            (51) /*  polyline repr. */
#define Gksm_marker_rep          (52) /*  polymarker repr. */
#define Gksm_text_rep            (53) /*  text repr. */
#define Gksm_fill_rep            (54) /*  fill area repr. */
#define Gksm_pat_rep             (55) /*  pattern repr. */
#define Gksm_edge_rep            (56) /*  edge repr. */
#define Gksm_colr_model          (57) /*  colour model */
#define Gksm_colr_rep            (58) /*  colour repr. */
/*
 * transformation items
 */
#define Gksm_clip_vol            (61) /*  clipping volume */
#define Gksm_clip_ind            (62) /*  clipping indicator */
#define Gksm_view_ind            (63) /*  view index */
#define Gksm_view_rep            (64) /*  view repr.  */
#define Gksm_hlhsr_id            (65) /*  HLHSR identifier */
#define Gksm_hlhsr_mode          (66) /*  HLHSR mode */
#define Gksm_ws_win              (71) /*  workstation window */
#define Gksm_ws_vp               (72) /*  workstation viewport */
/*
 * segment items
 */
#define Gksm_create_seg          (81) /*  create segment */
#define Gksm_close_seg           (82) /*  close segment */
#define Gksm_rename_seg          (83) /*  rename segment */
#define Gksm_del_seg             (84) /*  delete segment */
#define Gksm_set_seg_tran        (91) /*  segment transformation */
#define Gksm_set_vis             (92) /*  visibility  */
#define Gksm_set_highl           (93) /*  highlighting */
#define Gksm_set_seg_pri         (94) /*  segment priiority */
#define Gksm_set_det             (95) /*  detectability */

/*
 *      A.4  GKS-3D/C Function Specification
 */

/*
 *      A.4.1  Control Functions
 */
extern void gopen_gks(
     const char   *err_file,   /* name of error file                    */
     size_t       mem_units    /* number of units of memory available
                                  for buffer space                      */);
extern void gclose_gks(
      void);
extern void gopen_ws(
     Gint         ws_id,      /* workstation identifier   */
     const void   *conn_id,   /* connection identifier    */
     Gint         ws_type     /* workstation type         */);
extern void gclose_ws(
     Gint   ws_id   /* workstation identifier   */);
extern void gactivate_ws(
     Gint   ws_id   /* workstation identifier   */);
extern void gdeactivate_ws(
     Gint   ws_id   /* workstation identifier   */);
extern void gclear_ws(
     Gint         ws_id,      /* workstation identifier   */
     Gctrl_flag   ctrl_flag   /* control flag             */);
extern void gredraw_all_segs_ws(
     Gint   ws_id   /* workstation identifier   */);
extern void gupd_ws(
     Gint              ws_id,           /* workstation identifier     */
     Gupd_regen_flag   upd_regen_flag   /* update regeneration flag   */);
extern void gset_defer_st(
     Gint          ws_id,        /* workstation identifier       */
     Gdefer_mode   defer_mode,   /* deferral mode                */
     Girg_mode     irg_mode      /* implicit regeneration mode   */);
extern void gmessage(
     Gint         ws_id,     /* workstation identifier   */
     const char   *message   /* message string           */);
extern void gescape(
     Gint                    func_id,     /* escape function identifier       */
     const Gescape_in_data   *in_data,    /* escape input data record         */
     Gstore                  store,       /* handle to Store object           */
     Gescape_out_data        **out_data   /* OUT  escape output data record   */);

/*
 *      A.4.2  Output Functions
 */
extern void gpolyline3(
     const Gpoint_list3   *point_list   /* list of points   */);
#define gpolyline	gpolyline_iso
extern void gpolyline(
     const Gpoint_list   *point_list   /* list of points   */);
extern void gpolymarker3(
     const Gpoint_list3   *point_list   /* list of points   */);
#define gpolymarker	gpolymarker_iso
extern void gpolymarker(
     const Gpoint_list   *point_list   /* list of points   */);
extern void gtext3(
     const Gpoint3   *text_pos,     /* text position            */
     const Gvec3     text_dir[2],   /* text direction vectors   */
     const char      *char_string   /* character string         */);
extern void gtext(
     const Gpoint   *text_pos,     /* text position      */
     const char     *char_string   /* character string   */);
extern void gfill_area3(
     const Gpoint_list3   *point_list   /* list of points   */);
extern void gfill_area(
     const Gpoint_list   *point_list   /* list of points   */);
extern void gfill_area_set3(
     const Gpoint_list_list3   *point_list_list   /* list of point lists   */);
extern void gfill_area_set(
     const Gpoint_list_list   *point_list_list   /* list of point lists   */);
extern void gcell_array3(
     const Gparal     *paral,       /* cell parallelogram   */
     const Gpat_rep   *colr_array   /* colour array         */);
extern void gcell_array(
     const Grect      *rect,        /* cell rectangle   */
     const Gpat_rep   *colr_array   /* colour array     */);
extern void ggdp3(
     const Gpoint_list3   *point_list,   /* list of points     */
     Gint                 gdp3_id,       /* gdp 3 identifier   */
     const Ggdp_data3     *gdp_data      /* gdp data record    */);
extern void ggdp(
     const Gpoint_list   *point_list,   /* list of points    */
     Gint                gdp_id,        /* gdp identifier    */
     const Ggdp_data     *gdp_data      /* gdp data record   */);

/*
 *      A.4.3  Output Attribute Functions
 */
extern void gset_line_ind(
     Gint   line_ind   /* polyline index   */);
extern void gset_linetype(
     Gint   linetype   /* linetype   */);
extern void gset_linewidth(
     Gfloat   linewidth   /* linewidth scale factor   */);
extern void gset_line_colr_ind(
     Gint   line_colr_ind   /* polyline colour index   */);
extern void gset_marker_ind(
     Gint   marker_ind   /* polymarker index   */);
extern void gset_marker_type(
     Gint   marker_type   /* marker type   */);
extern void gset_marker_size(
     Gfloat   marker_size   /* marker size scale factor   */);
extern void gset_marker_colr_ind(
     Gint   marker_colr_ind   /* polymarker colour index   */);
extern void gset_text_ind(
     Gint   text_ind   /* text index   */);
extern void gset_text_font_prec(
     const Gtext_font_prec   *text_font_prec   /* text font and precision    */);
extern void gset_char_expan(
     Gfloat   char_expan   /* character expansion factor   */);
extern void gset_char_space(
     Gfloat   char_space   /* character spacing   */);
extern void gset_text_colr_ind(
     Gint   text_colr_ind   /* text colour index   */);
extern void gset_char_ht(
     Gfloat   char_ht   /* character height   */);
extern void gset_char_up_vec(
     const Gvec   *char_up_vec   /* character up vector   */);
extern void gset_text_path(
     Gtext_path   text_path   /* text path   */);
extern void gset_text_align(
     const Gtext_align   *text_align   /* text alignment   */);
extern void gset_fill_ind(
     Gint   fill_ind   /* fill area index   */);
extern void gset_fill_int_style(
     Gfill_int_style   fill_int_style   /* fill area interior style   */);
extern void gset_fill_style_ind(
     Gint   fill_style_ind   /* fill area style index   */);
extern void gset_fill_colr_ind(
     Gint   fill_colr_ind   /* fill area colour index   */);
extern void gset_pat_size(
     const Gfloat_size   *pat_size   /* pattern size   */);
extern void gset_pat_ref_point_vecs(
     const Gpoint3   *pat_ref_point,   /* pattern reference point              */
     const Gvec3     pat_ref_vec[2]    /* 1st ref. vector: X axis of pattern   */
                                       /* 2nd ref. vector: Y axis of pattern   */);
extern void gset_pat_ref_point(
     const Gpoint   *pat_ref_point   /* pattern reference point   */);
extern void gset_edge_ind(
     Gint   edge_ind   /* edge index   */);
extern void gset_edge_flag(
     Gedge_flag   edge_flag   /* edge flag   */);
extern void gset_edgetype(
     Gint   edgetype   /* edgetype   */);
extern void gset_edgewidth(
     Gfloat   edgewidth   /* edgewidth scale factor   */);
extern void gset_edge_colr_ind(
     Gint   edge_colr_ind   /* edge colour index   */);
extern void gset_asfs3(
     const Gasfs3   *list_asf   /* list of aspect source flags    */);
extern void gset_asfs(
     const Gasfs   *list_asf   /* list of aspect source flags    */);
extern void gset_pick_id(
     Gint   pick_id   /* pick identifier   */);
extern void gset_line_rep(
     Gint                 ws_id,         /* workstation identifier     */
     Gint                 line_ind,      /* polyline index             */
     const Gline_bundle   *line_bundle   /* polyline representation    */);
extern void gset_marker_rep(
     Gint                   ws_id,           /* workstation identifier       */
     Gint                   marker_ind,      /* polymarker index             */
     const Gmarker_bundle   *marker_bundle   /* polymarker representation    */);
extern void gset_text_rep(
     Gint                 ws_id,         /* workstation identifier   */
     Gint                 text_ind,      /* text index               */
     const Gtext_bundle   *text_bundle   /* text representation      */);
extern void gset_fill_rep(
     Gint                 ws_id,         /* workstation identifier      */
     Gint                 fill_ind,      /* fill area index             */
     const Gfill_bundle   *fill_bundle   /* fill area representation    */);
extern void gset_pat_rep(
     Gint             ws_id,     /* workstation identifier    */
     Gint             pat_ind,   /* pattern index             */
     const Gpat_rep   *pat_rep   /* pattern representation    */);
extern void gset_edge_rep(
     Gint                 ws_id,         /* workstation identifier   */
     Gint                 edge_ind,      /* edge index               */
     const Gedge_bundle   *edge_bundle   /* edge representation      */);
extern void gset_colr_model(
     Gint   ws_id,       /* workstation identifier   */
     Gint   colr_model   /* colour model             */);
extern void gset_colr_rep(
     Gint              ws_id,      /* workstation identifier   */
     Gint              colr_ind,   /* colour index             */
     const Gcolr_rep   *colr_rep   /* colour representation    */);

/*
 *      A.4.4  Transformation Functions
 */
extern void gset_win3(
     Gint            tran_num,     /* transformation number   */
     const Glimit3   *win_limits   /* window limits           */);
extern void gset_win(
     Gint           tran_num,     /* transformation number   */
     const Glimit   *win_limits   /* window limits           */);
extern void gset_vp3(
     Gint            tran_num,    /* transformation number   */
     const Glimit3   *vp_limits   /* viewport limits         */);
extern void gset_vp(
     Gint           tran_num,    /* transformation number   */
     const Glimit   *vp_limits   /* viewport limits         */);
extern void gset_vp_in_pri(
     Gint       tran_num,       /* transformation number             */
     Gint       ref_tran_num,   /* reference transformation number   */
     Grel_pri   rel_pri         /* relative priority                 */);
extern void gsel_norm_tran(
     Gint   tran_num   /* transformation number   */);
extern void gset_clip_ind(
     Gclip_ind   clip_ind   /* clipping indicator   */);
extern void gset_view_ind(
     Gint   view_ind   /* view index   */);
extern void gset_view_rep3(
     Gint               ws_id,      /* workstation identifier   */
     Gint               view_ind,   /* view index               */
     const Gview_rep3   *view_rep   /* view representation      */);
extern void gset_view_tran_in_pri(
     Gint       ws_id,      /* workstation identifier   */
     Gint       view_ind,   /* view index               */
     Gint       ref_ind,    /* reference view index     */
     Grel_pri   pri         /* relative priority        */);
extern void gset_hlhsr_id(
     Gint   hlhsr_id   /* HLHSR identifier   */);
extern void gset_hlhsr_mode(
     Gint   ws_id,       /* workstation identifier   */
     Gint   hlhsr_mode   /* HLHSR mode               */);
extern void gset_ws_win3(
     Gint            ws_id,           /* workstation identifier      */
     const Glimit3   *ws_win_limits   /* workstation window limits   */);
extern void gset_ws_win(
     Gint           ws_id,           /* workstation identifier      */
     const Glimit   *ws_win_limits   /* workstation window limits   */);
extern void gset_ws_vp3(
     Gint            ws_id,          /* workstation identifier        */
     const Glimit3   *ws_vp_limits   /* workstation viewport limits   */);
extern void gset_ws_vp(
     Gint           ws_id,          /* workstation identifier        */
     const Glimit   *ws_vp_limits   /* workstation viewport limits   */);

/*
 *      A.4.5  Segment Functions
 */
extern void gcreate_seg(
     Gint   seg_name   /* segment name   */);
extern void gclose_seg(
      void);
extern void grename_seg(
     Gint   old_seg_name,   /* old segment name   */
     Gint   new_seg_name    /* new segment name   */);
extern void gdel_seg(
     Gint   seg_name   /* segment name   */);
extern void gdel_seg_ws(
     Gint   ws_id,     /* workstation identifier   */
     Gint   seg_name   /* segment name             */);
extern void gassoc_seg_ws(
     Gint   ws_id,     /* workstation identifier   */
     Gint   seg_name   /* segment name             */);
extern void gcopy_seg_ws(
     Gint   ws_id,     /* workstation identifier   */
     Gint   seg_name   /* segment name             */);
extern void ginsert_seg3(
     Gint            seg_name,     /* segment name            */
     Gtran_matrix3   tran_matrix   /* transformation matrix   */);
extern void ginsert_seg(
     Gint           seg_name,     /* segment name            */
     Gtran_matrix   tran_matrix   /* transformation matrix   */);
extern void gset_seg_tran3(
     Gint            seg_name,     /* segment name            */
     Gtran_matrix3   tran_matrix   /* transformation matrix   */);
extern void gset_seg_tran(
     Gint           seg_name,     /* segment name            */
     Gtran_matrix   tran_matrix   /* transformation matrix   */);
extern void gset_vis(
     Gint   seg_name,   /* segment name   */
     Gvis   vis         /* visibility     */);
extern void gset_highl(
     Gint     seg_name,   /* segment name   */
     Ghighl   highl       /* highlighting   */);
extern void gset_seg_pri(
     Gint     seg_name,   /* segment name       */
     Gfloat   seg_pri     /* segment priority   */);
extern void gset_det(
     Gint   seg_name,   /* segment name    */
     Gdet   det         /* detectability   */);

/*
 *      A.4.6  Input Functions
 */
extern void ginit_loc3(
     Gint               ws_id,                /* workstation identifier     */
     Gint               loc_num,              /* locator device number      */
     Gint               init_norm_tran_num,   /* initial normalization
                                                 transformation number      */
     Gint               init_view_ind,        /* initial view index         */
     const Gpoint3      *init_loc_pos,        /* initial locator position   */
     Gint               pet,                  /* prompt and echo type       */
     const Glimit3      *echo_vol,            /* echo volume                */
     const Gloc_data3   *loc_data             /* locator data record        */);
extern void ginit_loc(
     Gint              ws_id,                /* workstation identifier     */
     Gint              loc_num,              /* locator device number      */
     Gint              init_norm_tran_num,   /* initial normalization
                                                transformation number      */
     const Gpoint      *init_loc_pos,        /* initial locator position   */
     Gint              pet,                  /* prompt and echo type       */
     const Glimit      *echo_area,           /* echo area                  */
     const Gloc_data   *loc_data             /* locator data record        */);
extern void ginit_stroke3(
     Gint                  ws_id,                /* workstation identifier   */
     Gint                  stroke_num,           /* stroke device number     */
     Gint                  init_norm_tran_num,   /* initial normalization
                                                    transformation number    */
     Gint                  init_view_ind,        /* initial view index       */
     const Gpoint_list3    *init_stroke,         /* initial stroke           */
     Gint                  pet,                  /* prompt and echo type     */
     const Glimit3         *echo_vol,            /* echo volume              */
     const Gstroke_data3   *stroke_data          /* stroke data record       */);
extern void ginit_stroke(
     Gint                 ws_id,                /* workstation identifier   */
     Gint                 stroke_num,           /* stroke device number     */
     Gint                 init_norm_tran_num,   /* initial normalization
                                                   transformation number    */
     const Gpoint_list    *init_stroke,         /* initial stroke           */
     Gint                 pet,                  /* prompt and echo type     */
     const Glimit         *echo_area,           /* echo area                */
     const Gstroke_data   *stroke_data          /* stroke data record       */);
extern void ginit_val3(
     Gint               ws_id,        /* workstation identifier   */
     Gint               val_num,      /* valuator device number   */
     Gfloat             init_value,   /* initial value            */
     Gint               pet,          /* prompt and echo type     */
     const Glimit3      *echo_vol,    /* echo volume              */
     const Gval_data3   *val_data     /* valuator data record     */);
extern void ginit_val(
     Gint              ws_id,        /* workstation identifier   */
     Gint              val_num,      /* valuator device number   */
     Gfloat            init_value,   /* initial value            */
     Gint              pet,          /* prompt and echo type     */
     const Glimit      *echo_area,   /* echo area                */
     const Gval_data   *val_data     /* valuator data record     */);
extern void ginit_choice3(
     Gint                  ws_id,         /* workstation identifier   */
     Gint                  choice_num,    /* choice device number     */
     Gin_status            init_status,   /* initial status           */
     Gint                  init_choice,   /* initial choice           */
     Gint                  pet,           /* prompt and echo type     */
     const Glimit3         *echo_vol,     /* echo volume              */
     const Gchoice_data3   *choice_data   /* choice data record       */);
extern void ginit_choice(
     Gint                 ws_id,         /* workstation identifier   */
     Gint                 choice_num,    /* choice device number     */
     Gin_status           init_status,   /* initial status           */
     Gint                 init_choice,   /* initial choice           */
     Gint                 pet,           /* prompt and echo type     */
     const Glimit         *echo_area,    /* echo area                */
     const Gchoice_data   *choice_data   /* choice data record       */);
extern void ginit_pick3(
     Gint                ws_id,         /* workstation identifier   */
     Gint                pick_num,      /* pick device number       */
     Gin_status          init_status,   /* initial status           */
     const Gpick         *init_pick,    /* initial pick value       */
     Gint                pet,           /* prompt and echo type     */
     const Glimit3       *echo_vol,     /* echo volume              */
     const Gpick_data3   *pick_data     /* pick data record         */);
extern void ginit_pick(
     Gint               ws_id,         /* workstation identifier   */
     Gint               pick_num,      /* pick device number       */
     Gin_status         init_status,   /* initial status           */
     const Gpick        *init_pick,    /* initial pick value       */
     Gint               pet,           /* prompt and echo type     */
     const Glimit       *echo_area,    /* echo area                */
     const Gpick_data   *pick_data     /* pick data record         */);
extern void ginit_string3(
     Gint                  ws_id,          /* workstation identifier   */
     Gint                  string_num,     /* string device number     */
     const char            *init_string,   /* initial string           */
     Gint                  pet,            /* prompt and echo type     */
     const Glimit3         *echo_vol,      /* echo volume              */
     const Gstring_data3   *string_data    /* string data record       */);
extern void ginit_string(
     Gint                 ws_id,          /* workstation identifier   */
     Gint                 string_num,     /* string device number     */
     const char           *init_string,   /* initial string           */
     Gint                 pet,            /* prompt and echo type     */
     const Glimit         *echo_area,     /* echo area                */
     const Gstring_data   *string_data    /* string data record       */);
extern void gset_loc_mode(
     Gint           ws_id,        /* workstation identifier   */
     Gint           loc_num,      /* locator device number    */
     Gop_mode       op_mode,      /* operating mode           */
     Gecho_switch   echo_switch   /* echo switch              */);
extern void gset_stroke_mode(
     Gint           ws_id,        /* workstation identifier   */
     Gint           stroke_num,   /* stroke device number     */
     Gop_mode       op_mode,      /* operating mode           */
     Gecho_switch   echo_switch   /* echo switch              */);
extern void gset_val_mode(
     Gint           ws_id,        /* workstation identifier   */
     Gint           val_num,      /* valuator device number   */
     Gop_mode       op_mode,      /* operating mode           */
     Gecho_switch   echo_switch   /* echo switch              */);
extern void gset_choice_mode(
     Gint           ws_id,        /* workstation identifier   */
     Gint           choice_num,   /* choice device number     */
     Gop_mode       op_mode,      /* operating mode           */
     Gecho_switch   echo_switch   /* echo switch              */);
extern void gset_pick_mode(
     Gint           ws_id,        /* workstation identifier   */
     Gint           pick_num,     /* pick device number       */
     Gop_mode       op_mode,      /* operating mode           */
     Gecho_switch   echo_switch   /* echo switch              */);
extern void gset_string_mode(
     Gint           ws_id,        /* workstation identifier   */
     Gint           string_num,   /* string device number     */
     Gop_mode       op_mode,      /* operating mode           */
     Gecho_switch   echo_switch   /* echo switch              */);
extern void greq_loc3(
     Gint         ws_id,            /* workstation identifier   */
     Gint         loc_num,          /* locator device number    */
     Gin_status   *in_status,       /* OUT input status         */
     Gint         *norm_tran_num,   /* OUT normalization
                                       transformation number    */
     Gint         *view_ind,        /* OUT view index           */
     Gpoint3      *loc_pos          /* OUT locator position     */);
extern void greq_loc(
     Gint         ws_id,            /* workstation identifier   */
     Gint         loc_num,          /* locator device number    */
     Gin_status   *in_status,       /* OUT input status         */
     Gint         *norm_tran_num,   /* OUT normalization
                                       transformation number    */
     Gpoint       *loc_pos          /* OUT locator position     */);
extern void greq_stroke3(
     Gint           ws_id,            /* workstation identifier   */
     Gint           stroke_num,       /* stroke device number     */
     Gin_status     *in_status,       /* OUT input status         */
     Gint           *norm_tran_num,   /* OUT normalization
                                         transformation number    */
     Gint           *view_ind,        /* OUT view index           */
     Gpoint_list3   *stroke           /* OUT stroke               */);
extern void greq_stroke(
     Gint          ws_id,            /* workstation identifier   */
     Gint          stroke_num,       /* stroke device number     */
     Gin_status    *in_status,       /* OUT input status         */
     Gint          *norm_tran_num,   /* OUT normalization
                                        transformation number    */
     Gpoint_list   *stroke           /* OUT stroke               */);
extern void greq_val(
     Gint         ws_id,        /* workstation identifier   */
     Gint         val_num,      /* valuator device number   */
     Gin_status   *in_status,   /* OUT input status         */
     Gfloat       *value        /* OUT value                */);
extern void greq_choice(
     Gint         ws_id,        /* workstation identifier   */
     Gint         choice_num,   /* choice device number     */
     Gin_status   *in_status,   /* OUT input status         */
     Gint         *choice       /* OUT requested choice     */);
extern void greq_pick(
     Gint         ws_id,        /* workstation identifier     */
     Gint         pick_num,     /* pick device number         */
     Gin_status   *in_status,   /* OUT input status           */
     Gpick        *pick         /* OUT requested pick value   */);
extern void greq_string(
     Gint         ws_id,        /* workstation identifier   */
     Gint         string_num,   /* string device number     */
     Gin_status   *in_status,   /* OUT input status         */
     char         *string       /* OUT requested string     */);
extern void gsample_loc3(
     Gint      ws_id,            /* workstation identifier   */
     Gint      loc_num,          /* locator device number    */
     Gint      *norm_tran_num,   /* OUT normalization
                                    transformation number    */
     Gint      *view_ind,        /* OUT view index           */
     Gpoint3   *loc_pos          /* OUT locator position     */);
extern void gsample_loc(
     Gint     ws_id,            /* workstation identifier   */
     Gint     loc_num,          /* locator device number    */
     Gint     *norm_tran_num,   /* OUT normalization
                                   transformation number    */
     Gpoint   *loc_pos          /* OUT locator position     */);
extern void gsample_stroke3(
     Gint           ws_id,            /* workstation identifier   */
     Gint           stroke_num,       /* stroke device number     */
     Gint           *norm_tran_num,   /* OUT normalization
                                         transformation number    */
     Gint           *view_ind,        /* OUT view index           */
     Gpoint_list3   *stroke           /* OUT stroke               */);
extern void gsample_stroke(
     Gint          ws_id,            /* workstation identifier   */
     Gint          stroke_num,       /* stroke device number     */
     Gint          *norm_tran_num,   /* OUT normalization
                                        transformation number    */
     Gpoint_list   *stroke           /* OUT stroke               */);
extern void gsample_val(
     Gint     ws_id,     /* workstation identifier   */
     Gint     val_num,   /* valuator device number   */
     Gfloat   *value     /* OUT value                */);
extern void gsample_choice(
     Gint         ws_id,        /* workstation identifier   */
     Gint         choice_num,   /* choice device number     */
     Gin_status   *in_status,   /* OUT input status         */
     Gint         *choice       /* OUT choice               */);
extern void gsample_pick(
     Gint         ws_id,        /* workstation identifier   */
     Gint         pick_num,     /* pick device number       */
     Gin_status   *in_status,   /* OUT input status         */
     Gpick        *pick         /* OUT pick value           */);
extern void gsample_string(
     Gint   ws_id,        /* workstation identifier   */
     Gint   string_num,   /* string device number     */
     char   *string       /* OUT string               */);
extern void gawait_event(
     Gfloat      timeout,   /* timeout (seconds)                 */
     Gint        *ws_id,    /* OUT workstation identifier        */
     Gin_class   *class,    /* OUT device class                  */
     Gint        *in_num    /* OUT logical input device number   */);
extern void gflush_events(
     Gint        ws_id,   /* workstation identifier        */
     Gin_class   class,   /* device class                  */
     Gint        in_num   /* logical input device number   */);
extern void gget_loc3(
     Gint      *norm_tran_num,   /* OUT normalization
                                    transformation number   */
     Gint      *view_ind,        /* OUT view index          */
     Gpoint3   *loc_pos          /* OUT locator position    */);
extern void gget_loc(
     Gint     *norm_tran_num,   /* OUT normalization
                                   transformation number   */
     Gpoint   *loc_pos          /* OUT locator position    */);
extern void gget_stroke3(
     Gint           *norm_tran_num,   /* OUT normalization
                                         transformation number   */
     Gint           *view_ind,        /* OUT view index          */
     Gpoint_list3   *stroke           /* OUT stroke              */);
extern void gget_stroke(
     Gint          *norm_tran_num,   /* OUT normalization
                                        transformation number   */
     Gpoint_list   *stroke           /* OUT stroke              */);
extern void gget_val(
     Gfloat   *value   /* OUT value   */);
extern void gget_choice(
     Gin_status   *in_status,   /* OUT input status   */
     Gint         *choice       /* OUT choice         */);
extern void gget_pick(
     Gin_status   *in_status,   /* OUT input status   */
     Gpick        *pick         /* OUT pick value     */);
extern void gget_string(
     char   *string   /* OUT string   */);

/*
 *      A.4.7  GKSM Functions
 */
extern void gwrite_item(
     Gint               ws_id,              /* workstation identifier    */
     Gint               item_type,          /* item type                 */
     Gint               item_data_length,   /* item data record length   */
     const Gitem_data   *item_data          /* item data record          */);
extern void gget_item_type(
     Gint   ws_id,              /* workstation identifier        */
     Gint   *item_type,         /* OUT item type                 */
     Gint   *item_data_length   /* OUT item data record length   */);
extern void gread_item(
     Gint         ws_id,                  /* workstation identifier         */
     Gint         max_item_data_length,   /* max. item data record length   */
     Gitem_data   *item_data              /* OUT item data record           */);
extern void ginterpret_item(
     Gint               type,               /* item type                 */
     Gint               item_data_length,   /* item data record length   */
     const Gitem_data   *item_data          /* item data record          */);

/*
 *      A.4.8  Inquire Functions
 */
extern void ginq_op_st(
     Gop_st   *op_st   /* OUT operating state value   */);
extern void ginq_level_gks(
     Gint     *err_ind,   /* OUT error indicator    */
     Glevel   *level      /* OUT level of GKS-3D    */);
extern void ginq_list_avail_ws_types(
     Gint        num_elems_appl_list,   /* length of application list         */
     Gint        start_ind,             /* starting index                     */
     Gint        *err_ind,              /* OUT error indicator                */
     Gint_list   *ws_type,              /* OUT list of avalailable ws types   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list           */);
extern void ginq_ws_max_nums(
     Gint           *err_ind,     /* OUT error indicator                */
     Gws_max_nums   *ws_max_num   /* OUT workstation maximum numbers    */);
extern void ginq_max_norm_tran_num(
     Gint   *err_ind,            /* OUT error indicator         */
     Gint   *max_norm_tran_num   /* OUT maximum normalization
                                    transformation number       */);
extern void ginq_set_open_wss(
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *open_ws,              /* OUT list of open ws ids      */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_set_active_wss(
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *active_ws,            /* OUT list of active ws ids    */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_cur_prim_attrs3(
     Gint           *err_ind,      /* OUT error indicator     */
     Gprim_attrs3   *prim_attrs3   /* OUT current primitive
                                      attribute 3 structure   */);
extern void ginq_cur_prim_attrs(
     Gint          *err_ind,     /* OUT error indicator     */
     Gprim_attrs   *prim_attrs   /* OUT current primitive
                                    attribute structure     */);
extern void ginq_line_ind(
     Gint   *err_ind,   /* OUT error indicator          */
     Gint   *line_ind   /* OUT current polyline index   */);
extern void ginq_marker_ind(
     Gint   *err_ind,     /* OUT error indicator            */
     Gint   *marker_ind   /* OUT current polymarker index   */);
extern void ginq_text_ind(
     Gint   *err_ind,   /* OUT error indicator      */
     Gint   *text_ind   /* OUT current text index   */);
extern void ginq_char_ht(
     Gint     *err_ind,   /* OUT error indicator            */
     Gfloat   *char_ht    /* OUT current character height   */);
extern void ginq_char_up_vec(
     Gint   *err_ind,      /* OUT error indicator               */
     Gvec   *char_up_vec   /* OUT current character up vector   */);
extern void ginq_char_width(
     Gint     *err_ind,     /* OUT error indicator           */
     Gfloat   *char_width   /* OUT current character width   */);
extern void ginq_char_base_vec(
     Gint   *err_ind,        /* OUT error indicator                 */
     Gvec   *char_base_vec   /* OUT current character base vector   */);
extern void ginq_text_path(
     Gint         *err_ind,    /* OUT error indicator     */
     Gtext_path   *text_path   /* OUT current text path   */);
extern void ginq_text_align(
     Gint          *err_ind,     /* OUT error indicator          */
     Gtext_align   *text_align   /* OUT current text alignment   */);
extern void ginq_fill_ind(
     Gint   *err_ind,   /* OUT error indicator           */
     Gint   *fill_ind   /* OUT current fill area index   */);
extern void ginq_pat_width_vec(
     Gint   *err_ind,        /* OUT error indicator                */
     Gvec   *pat_width_vec   /* OUT current pattern width vector   */);
extern void ginq_pat_ht_vec(
     Gint   *err_ind,     /* OUT error indicator                 */
     Gvec   *pat_ht_vec   /* OUT current pattern height vector   */);
extern void ginq_pat_ref_point_vecs(
     Gint      *err_ind,         /* OUT error indicator                   */
     Gpoint3   *pat_ref_point,   /* OUT current pattern reference point   */
     Gvec3     pat_ref_vec[2]    /* OUT current reference vectors;
                                    1st ref. vector: X axis of pattern
                                    2nd ref. vector: Y axis of pattern    */);
extern void ginq_pat_ref_point(
     Gint     *err_ind,        /* OUT error indicator                   */
     Gpoint   *pat_ref_point   /* OUT current pattern reference point   */);
extern void ginq_edge_ind(
     Gint   *err_ind,   /* OUT error indicator      */
     Gint   *edge_ind   /* OUT current edge index   */);
extern void ginq_view_ind(
     Gint   *err_ind,   /* OUT error indicator      */
     Gint   *view_ind   /* OUT current view index   */);
extern void ginq_cur_pick_id(
     Gint   *err_ind,   /* OUT error indicator           */
     Gint   *pick_id    /* OUT current pick identifier   */);
extern void ginq_cur_hlhsr_id(
     Gint   *err_ind,   /* OUT error indicator            */
     Gint   *hlhsr_id   /* OUT current HLHSR identifier   */);
extern void ginq_cur_indiv_attrs3(
     Gint            *err_ind,      /* OUT error indicator      */
     Gindiv_attrs3   *indiv_attr3   /* OUT current individual
                                       attribute 3 structure    */);
extern void ginq_cur_indiv_attrs(
     Gint           *err_ind,     /* OUT error indicator      */
     Gindiv_attrs   *indiv_attr   /* OUT current individual
                                     attribute  structure     */);
extern void ginq_linetype(
     Gint   *err_ind,   /* OUT error indicator    */
     Gint   *linetype   /* OUT current linetype   */);
extern void ginq_linewidth(
     Gint     *err_ind,    /* OUT error indicator                  */
     Gfloat   *linewidth   /* OUT current linewidth scale factor   */);
extern void ginq_line_colr_ind(
     Gint   *err_ind,        /* OUT error indicator                 */
     Gint   *line_colr_ind   /* OUT current polyline colour index   */);
extern void ginq_marker_type(
     Gint   *err_ind,      /* OUT error indicator       */
     Gint   *marker_type   /* OUT current marker type   */);
extern void ginq_marker_size(
     Gint     *err_ind,      /* OUT error indicator                    */
     Gfloat   *marker_size   /* OUT current marker size scale factor   */);
extern void ginq_marker_colr_ind(
     Gint   *err_ind,          /* OUT error indicator                   */
     Gint   *marker_colr_ind   /* OUT current polymarker colour index   */);
extern void ginq_text_font_prec(
     Gint              *err_ind,    /* OUT error indicator                    */
     Gtext_font_prec   *font_prec   /* OUT current text font and precision    */);
extern void ginq_char_expan(
     Gint     *err_ind,     /* OUT error indicator                      */
     Gfloat   *char_expan   /* OUT current character expansion factor   */);
extern void ginq_char_space(
     Gint     *err_ind,     /* OUT error indicator             */
     Gfloat   *char_space   /* OUT current character spacing   */);
extern void ginq_text_colr_ind(
     Gint   *err_ind,        /* OUT error indicator             */
     Gint   *text_colr_ind   /* OUT current text colour index   */);
extern void ginq_fill_int_style(
     Gint              *err_ind,         /* OUT error indicator     */
     Gfill_int_style   *fill_int_style   /* OUT current fill area
                                            interior style          */);
extern void ginq_fill_style_ind(
     Gint   *err_ind,         /* OUT error indicator                 */
     Gint   *fill_style_ind   /* OUT current fill area style index   */);
extern void ginq_fill_colr_ind(
     Gint   *err_ind,        /* OUT error indicator                  */
     Gint   *fill_colr_ind   /* OUT current fill area colour index   */);
extern void ginq_edge_flag(
     Gint         *err_ind,    /* OUT error indicator     */
     Gedge_flag   *edge_flag   /* OUT current edge flag   */);
extern void ginq_edgetype(
     Gint   *err_ind,   /* OUT error indicator    */
     Gint   *edgetype   /* OUT current edgetype   */);
extern void ginq_edgewidth(
     Gint     *err_ind,    /* OUT error indicator                  */
     Gfloat   *edgewidth   /* OUT current edgewidth scale factor   */);
extern void ginq_edge_colr_ind(
     Gint   *err_ind,        /* OUT error indicator             */
     Gint   *edge_colr_ind   /* OUT current edge colour index   */);
extern void ginq_asfs3(
     Gint     *err_ind,   /* OUT error indicator                */
     Gasfs3   *list_asf   /* OUT current aspect source flags    */);
extern void ginq_asfs(
     Gint    *err_ind,   /* OUT error indicator                */
     Gasfs   *list_asf   /* OUT current aspect source flags    */);
extern void ginq_cur_norm_tran_num(
     Gint   *err_ind,        /* OUT error indicator         */
     Gint   *norm_tran_num   /* OUT current normalization
                                transformation number       */);
extern void ginq_list_norm_tran_nums(
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *norm_tran_num,        /* OUT list of normalization
                                           transformation numbers       */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_norm_tran3(
     Gint     num,          /* normalization transformation number   */
     Gint     *err_ind,     /* OUT error indicator                   */
     Gtran3   *norm_tran3   /* OUT normalization transformation      */);
extern void ginq_norm_tran(
     Gint    num,         /* normalization transformation number   */
     Gint    *err_ind,    /* OUT error indicator                   */
     Gtran   *norm_tran   /* OUT normalization transformation      */);
extern void ginq_clip3(
     Gint     *err_ind,       /* OUT error indicator              */
     Gclip3   *clip_ind_vol   /* OUT current clipping indicator
                                 and volume                       */);
extern void ginq_clip(
     Gint    *err_ind,        /* OUT error indicator              */
     Gclip   *clip_ind_rect   /* OUT current clipping indicator
                                 and rectangle                    */);
extern void ginq_name_open_seg(
     Gint   *err_ind,        /* OUT  error indicator       */
     Gint   *name_open_seg   /* OUT name of open segment   */);
extern void ginq_set_seg_names(
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *seg_names,            /* OUT list of segment names    */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_more_simult_events(
     Gint                  *err_ind,        /* OUT error indicator              */
     Gmore_simult_events   *simult_events   /* OUT [more] simultaneous events   */);
extern void ginq_ws_conn_type(
     Gint     ws_id,       /* workstation identifier      */
     Gstore   store,       /* handle to Store object      */
     Gint     *err_ind,    /* OUT error indicator         */
     void     **conn_id,   /* OUT connection identifier   */
     Gint     *ws_type     /* OUT workstation type        */);
extern void ginq_ws_st(
     Gint     ws_id,      /* workstation identifier   */
     Gint     *err_ind,   /* OUT error indicator      */
     Gws_st   *ws_st      /* OUT workstation state    */);
extern void ginq_ws_defer_upd_sts(
     Gint                 ws_id,              /* workstation identifier           */
     Gint                 *err_ind,           /* OUT error indicator              */
     Gdefer_mode          *defer_mode,        /* OUT deferral mode                */
     Girg_mode            *irg_mode,          /* OUT implicit regeneration mode   */
     Gdisp_surf_empty     *disp_surf_empty,   /* OUT display surface empty        */
     Gnew_frame_nec_upd   *new_frame          /* OUT new frame action
                                                 necessary at update              */);
extern void ginq_list_line_inds(
     Gint        ws_id,                 /* workstation identifier                 */
     Gint        num_elems_appl_list,   /* length of application list             */
     Gint        start_ind,             /* starting index                         */
     Gint        *err_ind,              /* OUT error indicator                    */
     Gint_list   *def_line_inds,        /* OUT list of defined polyline indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list               */);
extern void ginq_line_rep(
     Gint           ws_id,      /* workstation identifier        */
     Gint           line_ind,   /* polyline index                */
     Ginq_type      type,       /* type of returned values       */
     Gint           *err_ind,   /* OUT error indicator           */
     Gline_bundle   *line_rep   /* OUT polyline representation   */);
extern void ginq_list_marker_inds(
     Gint        ws_id,                 /* workstation identifier                   */
     Gint        num_elems_appl_list,   /* length of application list               */
     Gint        start_ind,             /* starting index                           */
     Gint        *err_ind,              /* OUT error indicator                      */
     Gint_list   *def_marker_inds,      /* OUT list of defined polymarker indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list                 */);
extern void ginq_marker_rep(
     Gint             ws_id,        /* workstation identifier          */
     Gint             marker_ind,   /* polymarker index                */
     Ginq_type        type,         /* type of returned values         */
     Gint             *err_ind,     /* OUT error indicator             */
     Gmarker_bundle   *marker_rep   /* OUT polymarker representation   */);
extern void ginq_list_text_inds(
     Gint        ws_id,                 /* workstation identifier             */
     Gint        num_elems_appl_list,   /* length of application list         */
     Gint        start_ind,             /* starting index                     */
     Gint        *err_ind,              /* OUT error indicator                */
     Gint_list   *def_text_inds,        /* OUT list of defined text indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list           */);
extern void ginq_text_rep(
     Gint           ws_id,      /* workstation identifier    */
     Gint           text_ind,   /* text index                */
     Ginq_type      type,       /* type of returned values   */
     Gint           *err_ind,   /* OUT error indicator       */
     Gtext_bundle   *text_rep   /* OUT text representation   */);
extern void ginq_text_extent3(
     Gint            ws_id,         /* workstation identifier        */
     const Gpoint3   *pos,          /* text position                 */
     const Gvec3     text_dir[2],   /* text direction vectors        */
     const char      *str,          /* text string                   */
     Gint            *err_ind,      /* OUT error indicator           */
     Gtext_extent3   *extent        /* OUT concatenation point and
                                       text extent parallelogram     */);
extern void ginq_text_extent(
     Gint           ws_id,      /* workstation identifier        */
     const Gpoint   *pos,       /* text position                 */
     const char     *str,       /* text string                   */
     Gint           *err_ind,   /* OUT error indicator           */
     Gtext_extent   *extent     /* OUT concatenation point and
                                   text extent parallelogram     */);
extern void ginq_list_fill_inds(
     Gint        ws_id,                 /* workstation identifier                  */
     Gint        num_elems_appl_list,   /* length of application list              */
     Gint        start_ind,             /* starting index                          */
     Gint        *err_ind,              /* OUT error indicator                     */
     Gint_list   *def_fill_inds,        /* OUT list of defined fill area indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list                */);
extern void ginq_fill_rep(
     Gint           ws_id,      /* workstation identifier         */
     Gint           fill_ind,   /* fill area index                */
     Ginq_type      type,       /* type of returned values        */
     Gint           *err_ind,   /* OUT error indicator            */
     Gfill_bundle   *fill_rep   /* OUT fill area representation   */);
extern void ginq_list_pat_inds(
     Gint        ws_id,                 /* workstation identifier                */
     Gint        num_elems_appl_list,   /* length of application list            */
     Gint        start_ind,             /* starting index                        */
     Gint        *err_ind,              /* OUT error indicator                   */
     Gint_list   *def_pat_inds,         /* OUT list of defined pattern indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list              */);
extern void ginq_pat_rep(
     Gint        ws_id,      /* workstation identifier       */
     Gint        pat_ind,    /* pattern index                */
     Ginq_type   type,       /* type of returned values      */
     Gstore      store,      /* handle to Store object       */
     Gint        *err_ind,   /* OUT error indicator          */
     Gpat_rep    **pat_rep   /* OUT pattern representation   */);
extern void ginq_list_edge_inds(
     Gint        ws_id,                 /* workstation identifier             */
     Gint        num_elems_appl_list,   /* length of application list         */
     Gint        start_ind,             /* starting index                     */
     Gint        *err_ind,              /* OUT error indicator                */
     Gint_list   *def_edge_inds,        /* OUT list of defined edge indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list           */);
extern void ginq_edge_rep(
     Gint           ws_id,      /* workstation identifier    */
     Gint           edge_ind,   /* edge index                */
     Ginq_type      type,       /* type of returned values   */
     Gint           *err_ind,   /* OUT error indicator       */
     Gedge_bundle   *edge_rep   /* OUT edge representation   */);
extern void ginq_colr_model(
     Gint   ws_id,      /* workstation identifier     */
     Gint   *err_ind,   /* OUT error indicator        */
     Gint   *model      /* OUT current colour model   */);
extern void ginq_list_colr_inds(
     Gint        ws_id,                 /* workstation identifier               */
     Gint        num_elems_appl_list,   /* length of application list           */
     Gint        start_ind,             /* starting index                       */
     Gint        *err_ind,              /* OUT error indicator                  */
     Gint_list   *def_colr_inds,        /* OUT list of defined colour indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list             */);
extern void ginq_colr_rep(
     Gint        ws_id,      /* workstation identifier      */
     Gint        colr_ind,   /* colour index                */
     Ginq_type   type,       /* type of returned values     */
     Gint        *err_ind,   /* OUT error indicator         */
     Gcolr_rep   *colr_rep   /* OUT colour representation   */);
extern void ginq_list_view_inds(
     Gint        ws_id,                 /* workstation identifier             */
     Gint        num_elems_appl_list,   /* length of application list         */
     Gint        start_ind,             /* starting index                     */
     Gint        *err_ind,              /* OUT error indicator                */
     Gint_list   *def_view_inds,        /* OUT list of defined view indices   */
     Gint        *num_elems_impl_list   /* OUT length of impl. list           */);
extern void ginq_view_rep3(
     Gint         ws_id,          /* workstation identifier                    */
     Gint         view_ind,       /* view index                                */
     Gint         *err_ind,       /* OUT error indicator                       */
     Gupd_st      *view_upd_st,   /* OUT viewing transformation update state   */
     Gview_rep3   *req_view,      /* OUT requested view representation         */
     Gview_rep3   *cur_view       /* OUT current view representation           */);
extern void ginq_hlhsr_mode(
     Gint      ws_id,           /* workstation identifier     */
     Gint      *err_ind,        /* OUT error indicator        */
     Gupd_st   *hlhsr_upd_st,   /* OUT HLHSR update state     */
     Gint      *req_mode,       /* OUT requested HLHSR mode   */
     Gint      *cur_mode        /* OUT current HLHSR mode     */);
extern void ginq_ws_tran3(
     Gint      ws_id,             /* workstation identifier               */
     Gint      *err_ind,          /* OUT error indicator                  */
     Gupd_st   *ws_tran_upd_st,   /* OUT workstation transformation
                                     update state                         */
     Glimit3   *req_ws_win,       /* OUT requested workstation window     */
     Glimit3   *cur_ws_win,       /* OUT current workstation window       */
     Glimit3   *req_ws_vp,        /* OUT requested workstation viewport   */
     Glimit3   *cur_ws_vp         /* OUT current workstation viewport     */);
extern void ginq_ws_tran(
     Gint      ws_id,             /* workstation identifier               */
     Gint      *err_ind,          /* OUT error indicator                  */
     Gupd_st   *ws_tran_upd_st,   /* OUT workstation transformation
                                     update state                         */
     Glimit    *req_ws_win,       /* OUT requested workstation window     */
     Glimit    *cur_ws_win,       /* OUT current workstation window       */
     Glimit    *req_ws_vp,        /* OUT requested workstation viewport   */
     Glimit    *cur_ws_vp         /* OUT current workstation viewport     */);
extern void ginq_set_seg_names_ws(
     Gint        ws_id,                 /* workstation identifier       */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *seg_names,            /* OUT list of segment names    */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_loc_st3(
     Gint           ws_id,                 /* workstation identifier         */
     Gint           loc_num,               /* locator device number          */
     Ginq_type      type,                  /* type of returned values        */
     Gstore         store,                 /* handle to Store object         */
     Gint           *err_ind,              /* OUT error indicator            */
     Gop_mode       *mode,                 /* OUT operating mode             */
     Gecho_switch   *esw,                  /* OUT echo switch                */
     Gint           *init_norm_tran_num,   /* OUT initial normalization
                                              transformation number          */
     Gint           *init_view_ind,        /* OUT initial view index         */
     Gpoint3        *init_loc_pos,         /* OUT initial locator position   */
     Gint           *pet,                  /* OUT prompt/echo type           */
     Glimit3        *echo_vol,             /* OUT echo volume                */
     Gloc_data3     **loc_data             /* OUT locator data record        */);
extern void ginq_loc_st(
     Gint           ws_id,                 /* workstation identifier         */
     Gint           loc_num,               /* locator device number          */
     Ginq_type      type,                  /* type of returned values        */
     Gstore         store,                 /* handle to Store object         */
     Gint           *err_ind,              /* OUT error indicator            */
     Gop_mode       *mode,                 /* OUT operating mode             */
     Gecho_switch   *esw,                  /* OUT echo switch                */
     Gint           *init_norm_tran_num,   /* OUT initial normalization
                                              transformation number          */
     Gpoint         *init_loc_pos,         /* OUT initial locator position   */
     Gint           *pet,                  /* OUT prompt/echo type           */
     Glimit         *echo_area,            /* OUT echo area                  */
     Gloc_data      **loc_data             /* OUT locator data record        */);
extern void ginq_stroke_st3(
     Gint            ws_id,                 /* workstation identifier       */
     Gint            stroke_num,            /* stroke device number         */
     Ginq_type       type,                  /* type of returned values      */
     Gstore          store,                 /* handle to Store object       */
     Gint            *err_ind,              /* OUT error indicator          */
     Gop_mode        *mode,                 /* OUT operating mode           */
     Gecho_switch    *esw,                  /* OUT echo switch              */
     Gint            *init_norm_tran_num,   /* OUT initial normalization
                                               transformation number        */
     Gint            *init_view_ind,        /* OUT initial view index       */
     Gpoint_list3    **init_stroke,         /* OUT initial stroke           */
     Gint            *pet,                  /* OUT prompt/echo type         */
     Glimit3         *echo_vol,             /* OUT echo volume              */
     Gstroke_data3   **stroke_data          /* OUT stroke data record       */);
extern void ginq_stroke_st(
     Gint           ws_id,                 /* workstation identifier       */
     Gint           stroke_num,            /* stroke device number         */
     Ginq_type      type,                  /* type of returned values      */
     Gstore         store,                 /* handle to Store object       */
     Gint           *err_ind,              /* OUT error indicator          */
     Gop_mode       *mode,                 /* OUT operating mode           */
     Gecho_switch   *esw,                  /* OUT echo switch              */
     Gint           *init_norm_tran_num,   /* OUT initial normalization
                                              transformation number        */
     Gpoint_list    **init_stroke,         /* OUT initial stroke           */
     Gint           *pet,                  /* OUT prompt/echo type         */
     Glimit         *echo_area,            /* OUT echo area                */
     Gstroke_data   **stroke_data          /* OUT stroke data record       */);
extern void ginq_val_st3(
     Gint           ws_id,         /* workstation identifier     */
     Gint           val_num,       /* valuator device number     */
     Gstore         store,         /* handle to Store object     */
     Gint           *err_ind,      /* OUT error indicator        */
     Gop_mode       *mode,         /* OUT operating mode         */
     Gecho_switch   *esw,          /* OUT echo switch            */
     Gfloat         *init_value,   /* OUT initial value          */
     Gint           *pet,          /* OUT prompt/echo type       */
     Glimit3        *echo_vol,     /* OUT echo volume            */
     Gval_data3     **val_data     /* OUT valuator data record   */);
extern void ginq_val_st(
     Gint           ws_id,         /* workstation identifier     */
     Gint           val_num,       /* valuator device number     */
     Gstore         store,         /* handle to Store object     */
     Gint           *err_ind,      /* OUT error indicator        */
     Gop_mode       *mode,         /* OUT operating mode         */
     Gecho_switch   *esw,          /* OUT echo switch            */
     Gfloat         *init_value,   /* OUT initial value          */
     Gint           *pet,          /* OUT prompt/echo type       */
     Glimit         *echo_area,    /* OUT echo area              */
     Gval_data      **val_data     /* OUT valuator data record   */);
extern void ginq_choice_st3(
     Gint            ws_id,          /* workstation identifier      */
     Gint            choice_num,     /* choice device number        */
     Gstore          store,          /* handle to Store object      */
     Gint            *err_ind,       /* OUT error indicator         */
     Gop_mode        *mode,          /* OUT operating mode          */
     Gecho_switch    *esw,           /* OUT echo switch             */
     Gin_status      *init_status,   /* OUT initial choice status   */
     Gint            *init_choice,   /* OUT initial choice          */
     Gint            *pet,           /* OUT prompt/echo type        */
     Glimit3         *echo_vol,      /* OUT echo volume             */
     Gchoice_data3   **choice_data   /* OUT choice data record      */);
extern void ginq_choice_st(
     Gint           ws_id,          /* workstation identifier      */
     Gint           choice_num,     /* choice device number        */
     Gstore         store,          /* handle to Store object      */
     Gint           *err_ind,       /* OUT error indicator         */
     Gop_mode       *mode,          /* OUT operating mode          */
     Gecho_switch   *esw,           /* OUT echo switch             */
     Gin_status     *init_status,   /* OUT initial choice status   */
     Gint           *init_choice,   /* OUT initial choice          */
     Gint           *pet,           /* OUT prompt/echo type        */
     Glimit         *echo_area,     /* OUT echo area               */
     Gchoice_data   **choice_data   /* OUT choice data record      */);
extern void ginq_pick_st3(
     Gint           ws_id,          /* workstation identifier    */
     Gint           pick_num,       /* pick device number        */
     Ginq_type      type,           /* type of returned values   */
     Gstore         store,          /* handle to Store object    */
     Gint           *err_ind,       /* OUT error indicator       */
     Gop_mode       *mode,          /* OUT operating mode        */
     Gecho_switch   *esw,           /* OUT echo switch           */
     Gin_status     *init_status,   /* OUT initial pick status   */
     Gpick          *init_pick,     /* OUT initial pick value    */
     Gint           *pet,           /* OUT prompt/echo type      */
     Glimit3        *echo_vol,      /* OUT echo volume           */
     Gpick_data3    **pick_data     /* OUT pick data record      */);
extern void ginq_pick_st(
     Gint           ws_id,          /* workstation identifier    */
     Gint           pick_num,       /* pick device number        */
     Ginq_type      type,           /* type of returned values   */
     Gstore         store,          /* handle to Store object    */
     Gint           *err_ind,       /* OUT error indicator       */
     Gop_mode       *mode,          /* OUT operating mode        */
     Gecho_switch   *esw,           /* OUT echo switch           */
     Gin_status     *init_status,   /* OUT initial pick status   */
     Gpick          *init_pick,     /* OUT initial pick value    */
     Gint           *pet,           /* OUT prompt/echo type      */
     Glimit         *echo_area,     /* OUT echo area             */
     Gpick_data     **pick_data     /* OUT pick data record      */);
extern void ginq_string_st3(
     Gint            ws_id,           /* workstation identifier   */
     Gint            string_num,      /* string device number     */
     Gstore          store,           /* handle to Store object   */
     Gint            *err_ind,        /* OUT error indicator      */
     Gop_mode        *mode,           /* OUT operating mode       */
     Gecho_switch    *esw,            /* OUT echo switch          */
     char            **init_string,   /* OUT initial string       */
     Gint            *pet,            /* OUT prompt/echo type     */
     Glimit3         *echo_vol,       /* OUT echo volume          */
     Gstring_data3   **string_data    /* OUT string data record   */);
extern void ginq_string_st(
     Gint           ws_id,           /* workstation identifier   */
     Gint           string_num,      /* string device number     */
     Gstore         store,           /* handle to Store object   */
     Gint           *err_ind,        /* OUT error indicator      */
     Gop_mode       *mode,           /* OUT operating mode       */
     Gecho_switch   *esw,            /* OUT echo switch          */
     char           **init_string,   /* OUT intial string        */
     Gint           *pet,            /* OUT prompt/echo type     */
     Glimit         *echo_area,      /* OUT echo area            */
     Gstring_data   **string_data    /* OUT string data record   */);
extern void ginq_ws_cat(
     Gint      ws_type,    /* workstation type           */
     Gint      *err_ind,   /* OUT error indicator        */
     Gws_cat   *cat        /* OUT workstation category   */);
extern void ginq_ws_class(
     Gint        ws_type,    /* workstation type        */
     Gint        *err_ind,   /* OUT error indicator     */
     Gws_class   *class      /* OUT workstation class   */);
extern void ginq_disp_space_size3(
     Gint                ws_type,     /* workstation type           */
     Gint                *err_ind,    /* OUT error indicator        */
     Gdisp_space_size3   *disp_size   /* OUT display [space] size   */);
extern void ginq_disp_space_size(
     Gint               ws_type,     /* workstation type           */
     Gint               *err_ind,    /* OUT error indicator        */
     Gdisp_space_size   *disp_size   /* OUT display [space] size   */);
extern void ginq_dyn_mod_ws_attrs3(
     Gint                 ws_type,    /* workstation type               */
     Gint                 *err_ind,   /* OUT error indicator            */
     Gdyn_mod_ws_attrs3   *dyn_mod    /* OUT dynamic modification of
                                         workstation attributes         */);
extern void ginq_dyn_mod_ws_attrs(
     Gint                ws_type,    /* workstation type               */
     Gint                *err_ind,   /* OUT error indicator            */
     Gdyn_mod_ws_attrs   *dyn_mod    /* OUT dynamic modification of
                                        workstation attributes         */);
extern void ginq_def_defer_sts(
     Gint          ws_type,       /* workstation type               */
     Gint          *err_ind,      /* OUT error indicator            */
     Gdefer_mode   *defer_mode,   /* OUT default deferral mode      */
     Girg_mode     *irg_mode      /* OUT default impl. reg. mode    */);
extern void ginq_line_facs(
     Gint         ws_type,               /* workstation type             */
     Gint         num_elems_appl_list,   /* length of application list   */
     Gint         start_ind,             /* starting index               */
     Gint         *err_ind,              /* OUT error indicator          */
     Gline_facs   *line_facs,            /* OUT polyline facilities      */
     Gint         *num_elems_impl_list   /* OUT length of linetype
                                            list in impl.                */);
extern void ginq_pred_line_rep(
     Gint           ws_type,    /* workstation type               */
     Gint           ind,        /* predefined index               */
     Gint           *err_ind,   /* OUT error indicator            */
     Gline_bundle   *line_rep   /* OUT predefined polyline rep.   */);
extern void ginq_marker_facs(
     Gint           ws_type,               /* workstation type             */
     Gint           num_elems_appl_list,   /* length of application list   */
     Gint           start_ind,             /* starting index               */
     Gint           *err_ind,              /* OUT error indicator          */
     Gmarker_facs   *marker_facs,          /* OUT polymarker facilities    */
     Gint           *num_elems_impl_list   /* OUT length of marker type
                                              list in impl.                */);
extern void ginq_pred_marker_rep(
     Gint             ws_type,      /* workstation type                 */
     Gint             ind,          /* predefined index                 */
     Gint             *err_ind,     /* OUT error indicator              */
     Gmarker_bundle   *marker_rep   /* OUT predefined polymarker rep.   */);
extern void ginq_text_facs(
     Gint         ws_type,               /* workstation type              */
     Gint         num_elems_appl_list,   /* length of application list    */
     Gint         start_ind,             /* starting index                */
     Gint         *err_ind,              /* OUT error indicator           */
     Gtext_facs   *text_facs,            /* OUT text facilities           */
     Gint         *num_elems_impl_list   /* OUT length of text font
                                            and precision list in impl.   */);
extern void ginq_pred_text_rep(
     Gint           ws_type,    /* workstation type           */
     Gint           ind,        /* predefined index           */
     Gint           *err_ind,   /* OUT error indicator        */
     Gtext_bundle   *text_rep   /* OUT predefined text rep.   */);
extern void ginq_fill_facs(
     Gint         ws_type,               /* workstation type             */
     Gint         num_elems_appl_list,   /* length of application list   */
     Gint         start_ind,             /* starting index               */
     Gint         *err_ind,              /* OUT error indicator          */
     Gfill_facs   *fill_facs,            /* OUT fill area facilities     */
     Gint         *num_elems_impl_list   /* OUT length of hatch list     */);
extern void ginq_pred_fill_rep(
     Gint           ws_type,    /* workstation type                */
     Gint           ind,        /* predefined index                */
     Gint           *err_ind,   /* OUT error indicator             */
     Gfill_bundle   *fill_rep   /* OUT predefined fill area rep.   */);
extern void ginq_pat_facs(
     Gint   ws_type,         /* workstation type                      */
     Gint   *err_ind,        /* OUT error indicator                   */
     Gint   *num_pred_inds   /* OUT num. of predef. pattern indices   */);
extern void ginq_pred_pat_rep(
     Gint       ws_type,    /* workstation type              */
     Gint       ind,        /* predefined index              */
     Gstore     store,      /* handle to Store object        */
     Gint       *err_ind,   /* OUT error indicator           */
     Gpat_rep   **pat_rep   /* OUT predefined pattern rep.   */);
extern void ginq_edge_facs(
     Gint         ws_type,               /* workstation type             */
     Gint         num_elems_appl_list,   /* length of application list   */
     Gint         start_ind,             /* starting index               */
     Gint         *err_ind,              /* OUT error indicator          */
     Gedge_facs   *edge_facs,            /* OUT edge facilities          */
     Gint         *num_elems_impl_list   /* OUT length of edgetype
                                            list in impl.                */);
extern void ginq_pred_edge_rep(
     Gint           ws_type,    /* workstation type           */
     Gint           ind,        /* predefined index           */
     Gint           *err_ind,   /* OUT error indicator        */
     Gedge_bundle   *edge_rep   /* OUT predefined edge rep.   */);
extern void ginq_colr_model_facs(
     Gint        ws_type,               /* workstation type             */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *models,               /* OUT list of colour models    */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_colr_facs(
     Gint         ws_type,     /* workstation type        */
     Gint         *err_ind,    /* OUT error indicator     */
     Gcolr_facs   *colr_facs   /* OUT colour facilities   */);
extern void ginq_pred_colr_rep(
     Gint        ws_type,    /* workstation type             */
     Gint        ind,        /* predefined index             */
     Gint        *err_ind,   /* OUT error indicator          */
     Gcolr_rep   *colr_rep   /* OUT predefined colour rep.   */);
extern void ginq_view_facs(
     Gint   ws_type,         /* workstation type                   */
     Gint   *err_ind,        /* OUT error indicator                */
     Gint   *num_pred_inds   /* OUT num. of predef. view indices   */);
extern void ginq_pred_view_rep(
     Gint         ws_type,    /* workstation type           */
     Gint         view_ind,   /* predefined view index      */
     Gint         *err_ind,   /* OUT error indicator        */
     Gview_rep3   *view_rep   /* OUT predefined view rep.   */);
extern void ginq_hlhsr_id_facs(
     Gint        ws_type,               /* workstation type             */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *hlhsr_id,             /* OUT list of HLHSR ids        */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_hlhsr_mode_facs(
     Gint        ws_type,               /* workstation type             */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *hlhsr_mode,           /* OUT list of HLHSR modes      */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_list_avail_gdps3(
     Gint        ws_type,               /* workstation type             */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *gdp3,                 /* OUT list of GDP3s            */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_list_avail_gdps(
     Gint        ws_type,               /* workstation type             */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *gdp,                  /* OUT list of GDPs             */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_gdp3(
     Gint     ws_type,     /* workstation type              */
     Gint     gdp,         /* GDP function number           */
     Gint     *err_ind,    /* OUT error indicator           */
     Gint     *num_attr,   /* OUT num. of attributes used   */
     Gattrs   attr[5]      /* OUT list of attributes used   */);
extern void ginq_gdp(
     Gint     ws_type,     /* workstation type              */
     Gint     gdp,         /* GDP function number           */
     Gint     *err_ind,    /* OUT error indicator           */
     Gint     *num_attr,   /* OUT num. of attributes used   */
     Gattrs   attr[4]      /* OUT list of attributes used   */);
extern void ginq_max_ws_st_tables3(
     Gint                 ws_type,    /* workstation type                    */
     Gint                 *err_ind,   /* OUT error indicator                 */
     Gmax_ws_st_tables3   *lengths    /* OUT lengths of workstation tables   */);
extern void ginq_max_ws_st_tables(
     Gint                ws_type,    /* workstation type                    */
     Gint                *err_ind,   /* OUT error indicator                 */
     Gmax_ws_st_tables   *lengths    /* OUT lengths of workstation tables   */);
extern void ginq_num_seg_pris(
     Gint   ws_type,        /* workstation type                 */
     Gint   *err_ind,       /* OUT error indicator              */
     Gint   *num_seg_pris   /* OUT num. of segment priorities   */);
extern void ginq_dyn_mod_seg_attrs(
     Gint                 ws_type,    /* workstation type              */
     Gint                 *err_ind,   /* OUT error indicator           */
     Gdyn_mod_seg_attrs   *dyn_mod    /* OUT dynamic modification of
                                         segment attributess           */);
extern void ginq_num_avail_in(
     Gint      ws_type,    /* workstation type            */
     Gint      *err_ind,   /* OUT error indicator         */
     Gnum_in   *num_in     /* OUT num. of input devices   */);
extern void ginq_def_loc_data3(
     Gint         ws_type,      /* workstation type                    */
     Gint         loc_num,      /* logical input device number         */
     Gstore       store,        /* handle to Store object              */
     Gint         *err_ind,     /* OUT error indicator                 */
     Gpoint3      *loc_pos,     /* OUT default initial position        */
     Gint_list    **pet_list,   /* OUT list of prompt and echo types   */
     Glimit3      *echo_vol,    /* OUT default echo volume             */
     Gloc_data3   **loc_data    /* OUT default data record             */);
extern void ginq_def_loc_data(
     Gint        ws_type,      /* workstation type                    */
     Gint        loc_num,      /* logical input device number         */
     Gstore      store,        /* handle to Store object              */
     Gint        *err_ind,     /* OUT error indicator                 */
     Gpoint      *loc_pos,     /* OUT default locator position        */
     Gint_list   **pet_list,   /* OUT list of prompt and echo types   */
     Glimit      *echo_area,   /* OUT default echo area               */
     Gloc_data   **loc_data    /* OUT default data record             */);
extern void ginq_def_stroke_data3(
     Gint            ws_type,         /* workstation type                    */
     Gint            stroke_num,      /* logical input device number         */
     Gstore          store,           /* handle to Store object              */
     Gint            *err_ind,        /* OUT error indicator                 */
     Gint            *max_buf_size,   /* OUT max. input buffer size
                                            (nr. of points)                  */
     Gint_list       **pet_list,      /* OUT list of prompt and echo types   */
     Glimit3         *echo_vol,       /* OUT default echo volume             */
     Gstroke_data3   **stroke_data    /* OUT default data record             */);
extern void ginq_def_stroke_data(
     Gint           ws_type,         /* workstation type                    */
     Gint           stroke_num,      /* logical input device number         */
     Gstore         store,           /* handle to Store object              */
     Gint           *err_ind,        /* OUT error indicator                 */
     Gint           *max_buf_size,   /* OUT max. input buffer size
                                           (nr. of points)                  */
     Gint_list      **pet_list,      /* OUT list of prompt and echo types   */
     Glimit         *echo_area,      /* OUT default echo area               */
     Gstroke_data   **stroke_data    /* OUT default data record             */);
extern void ginq_def_val_data3(
     Gint         ws_type,      /* workstation type                    */
     Gint         val_num,      /* logical input device number         */
     Gstore       store,        /* handle to Store object              */
     Gint         *err_ind,     /* OUT error indicator                 */
     Gfloat       *def_val,     /* OUT default initial value           */
     Gint_list    **pet_list,   /* OUT list of prompt and echo types   */
     Glimit3      *echo_vol,    /* OUT default echo volume             */
     Gval_data3   **val_data    /* OUT default data record             */);
extern void ginq_def_val_data(
     Gint        ws_type,      /* workstation type                    */
     Gint        val_num,      /* logical input device number         */
     Gstore      store,        /* handle to Store object              */
     Gint        *err_ind,     /* OUT error indicator                 */
     Gfloat      *def_val,     /* OUT default initial value           */
     Gint_list   **pet_list,   /* OUT list of prompt and echo types   */
     Glimit      *echo_area,   /* OUT default echo area               */
     Gval_data   **val_data    /* OUT default data record             */);
extern void ginq_def_choice_data3(
     Gint            ws_type,            /* workstation type                    */
     Gint            choice_num,         /* logical input device number         */
     Gstore          store,              /* handle to Store object              */
     Gint            *err_ind,           /* OUT error indicator                 */
     Gint            *max_num_choices,   /* OUT max. num. of choices            */
     Gint_list       **pet_list,         /* OUT list of prompt and echo types   */
     Glimit3         *echo_vol,          /* OUT default echo volume             */
     Gchoice_data3   **choice_data       /* OUT default data record             */);
extern void ginq_def_choice_data(
     Gint           ws_type,            /* workstation type                    */
     Gint           choice_num,         /* logical input device number         */
     Gstore         store,              /* handle to Store object              */
     Gint           *err_ind,           /* OUT error indicator                 */
     Gint           *max_num_choices,   /* OUT max. num. of choices            */
     Gint_list      **pet_list,         /* OUT list of prompt and echo types   */
     Glimit         *echo_area,         /* OUT default echo area               */
     Gchoice_data   **choice_data       /* OUT default data record             */);
extern void ginq_def_pick_data3(
     Gint          ws_type,      /* workstation type                    */
     Gint          pick_num,     /* logical input device number         */
     Gstore        store,        /* handle to Store object              */
     Gint          *err_ind,     /* OUT error indicator                 */
     Gint_list     **pet_list,   /* OUT list of prompt and echo types   */
     Glimit3       *echo_vol,    /* OUT default echo volume             */
     Gpick_data3   **pick_data   /* OUT default data record             */);
extern void ginq_def_pick_data(
     Gint         ws_type,      /* workstation type                    */
     Gint         pick_num,     /* logical input device number         */
     Gstore       store,        /* handle to Store object              */
     Gint         *err_ind,     /* OUT error indicator                 */
     Gint_list    **pet_list,   /* OUT list of prompt and echo types   */
     Glimit       *echo_area,   /* OUT default echo area               */
     Gpick_data   **pick_data   /* OUT default data record             */);
extern void ginq_def_string_data3(
     Gint            ws_type,         /* workstation type                    */
     Gint            string_num,      /* logical input device number         */
     Gstore          store,           /* handle to Store object              */
     Gint            *err_ind,        /* OUT error indicator                 */
     Gint            *max_buf_size,   /* OUT max. input buffer size
                                            (nr. of bytes)                   */
     Gint_list       **pet_list,      /* OUT list of prompt and echo types   */
     Glimit3         *echo_vol,       /* OUT default echo volume             */
     Gstring_data3   **string_data    /* OUT default data record             */);
extern void ginq_def_string_data(
     Gint           ws_type,         /* workstation type                    */
     Gint           string_num,      /* logical input device number         */
     Gstore         store,           /* handle to Store object              */
     Gint           *err_ind,        /* OUT error indicator                 */
     Gint           *max_buf_size,   /* OUT max. input buffer size
                                           (nr. of bytes)                   */
     Gint_list      **pet_list,      /* OUT list of prompt and echo types   */
     Glimit         *echo_area,      /* OUT default echo area               */
     Gstring_data   **string_data    /* OUT default data record             */);
extern void ginq_set_assoc_wss(
     Gint        seg_name,              /* segment name                 */
     Gint        num_elems_appl_list,   /* length of application list   */
     Gint        start_ind,             /* starting index               */
     Gint        *err_ind,              /* OUT error indicator          */
     Gint_list   *ws,                   /* OUT list of workstations     */
     Gint        *num_elems_impl_list   /* OUT length of impl. list     */);
extern void ginq_seg_attrs3(
     Gint          seg_name,   /* segment name                      */
     Gint          *err_ind,   /* OUT error indicator               */
     Gseg_attrs3   *seg_attr   /* OUT segment attribute structure   */);
extern void ginq_seg_attrs(
     Gint         seg_name,   /* segment name                      */
     Gint         *err_ind,   /* OUT error indicator               */
     Gseg_attrs   *seg_attr   /* OUT segment attribute structure   */);
extern void ginq_pixel_array_dims(
     Gint          ws_id,      /* workstation identifier        */
     const Grect   *rect,      /* rectangle                     */
     Gint          *err_ind,   /* OUT error indicator           */
     Gint_size     *dims       /* OUT pixel array dimensions    */);
extern void ginq_pixel_array(
     Gint              ws_id,         /* workstation identifier           */
     const Gpoint      *pixel_loc,    /* pixel location                   */
     const Gint_size   *dims,         /* pixel array dimensions           */
     Gint              *err_ind,      /* OUT error indicator              */
     Gpres_inval       *pres_inval,   /* OUT presence of invalid values   */
     Gint              *pixel_array   /* OUT colour index array           */);
extern void ginq_pixel(
     Gint           ws_id,        /* workstation identifier   */
     const Gpoint   *pixel_loc,   /* pixel location           */
     Gint           *err_ind,     /* OUT error indicator      */
     Gint           *colr_ind     /* OUT colour index         */);
extern void ginq_in_overf(
     Gint        *err_ind,    /* OUT error indicator               */
     Gint        *ws_id,      /* OUT workstation identifier        */
     Gin_class   *in_class,   /* OUT input class                   */
     Gint        *in_num      /* OUT logical input device number   */);

/*
 *      A.4.9  Utility Functions
 */
extern void geval_view_ori_matrix3(
     const Gpoint3   *view_ref_point,   /* view reference point          */
     const Gvec3     *view_norm,        /* view plane normal             */
     const Gvec3     *view_up_vec,      /* view up vector                */
     Gcoord_switch   coord_switch,      /* coordinate switch             */
     Gint            *err_ind,          /* OUT error indicator           */
     Gmatrix3        view_ori_matrix    /* OUT view orientation matrix   */);
extern void geval_view_map_matrix3(
     const Gview_map3   *map,             /* view mapping              */
     Gint               *err_ind,         /* OUT error indicator       */
     Gmatrix3           view_map_matrix   /* OUT view mapping matrix   */);
extern void geval_tran_matrix3(
     const Gpoint3   *point,         /* fixed point                 */
     const Gvec3     *shift,         /* shift vector                */
     Gfloat          x_angle,        /* rotation angle X            */
     Gfloat          y_angle,        /* rotation angle Y            */
     Gfloat          z_angle,        /* rotation angle Z            */
     const Gvec3     *scale,         /* scale factors               */
     Gcoord_switch   coord_switch,   /* coordinate switch           */
     Gtran_matrix3   tran_matrix     /* OUT transformation matrix   */);
extern void geval_tran_matrix(
     const Gpoint    *point,         /* fixed point                 */
     const Gvec      *shift,         /* shift vector                */
     Gfloat          angle,          /* rotation angle              */
     const Gvec      *scale,         /* scale factors               */
     Gcoord_switch   coord_switch,   /* coordinate switch           */
     Gtran_matrix    tran_matrix     /* OUT transformation matrix   */);
extern void gaccum_tran_matrix3(
     Gtran_matrix3   matrix,         /* transformation matrix       */
     const Gpoint3   *point,         /* fixed point                 */
     const Gvec3     *shift,         /* shift vector                */
     Gfloat          x_angle,        /* rotation angle X            */
     Gfloat          y_angle,        /* rotation angle Y            */
     Gfloat          z_angle,        /* rotation angle Z            */
     const Gvec3     *scale,         /* scale factors               */
     Gcoord_switch   coord_switch,   /* coordinate switch           */
     Gtran_matrix3   tran_matrix     /* OUT transformation matrix   */);
extern void gaccum_tran_matrix(
     Gtran_matrix    matrix,         /* transformation matrix       */
     const Gpoint    *point,         /* fixed point                 */
     const Gvec      *shift,         /* shift vector                */
     Gfloat          angle,          /* rotation angle              */
     const Gvec      *scale,         /* scale factors               */
     Gcoord_switch   coord_switch,   /* coordinate switch           */
     Gtran_matrix    tran_matrix     /* OUT transformation matrix   */);
extern void gset_err_hand(
     void         (*new_hand)(Gint , Gint , const char *),
                  /* the application's error handling address */
     void         (**old_hand)(Gint , Gint , const char *)
                  /* OUT address of the error handling replaced */);
extern void gcreate_store(
     Gint     *err_ind,   /* OUT error indicator                */
     Gstore   *store      /* OUT pointer to allocated storage   */);
extern void gdel_store(
     Gint     *err_ind,   /* OUT error indicator            */
     Gstore   *store      /* IN/OUT storage to be deleted   */);

/*
 *      A.4.10  Error Handling Functions
 */
extern void gemergency_close_gks(
         void);
extern void gerr_hand(
     Gint         err_num,    /* error number                                 */
     Gint         func_num,   /* number of function that detected the error   */
     const char   *err_file   /* name of error file                           */);
extern void gerr_log(
     Gint         err_num,    /* error number                                 */
     Gint         func_num,   /* number of function that detected the error   */
     const char   *err_file   /* name of error file                           */);
