/*  detect.h
 *
 *  Header file for detect.c
 */

/*
 *  xdemorse: An application to decode Morse signals to text
 *
 *  Copyright (C) 2001  Neoklis Kyriazis
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */


#ifndef DETECT_H
#define DETECT_H 1

/* Buffers and data needed by tone detector */
struct detector_data
{
  int
	frag_len,
	samples_buff_len, /* Length of DSP samples buffer */	
	samples_buff_idx; /* Sample buffer index */

  /* Circular signal level buffer and index for edge detector */
  int
	sig_level_idx,
	*sig_level_buff;

  /* Variables for the Goertzel algorithm */
  double cosw, sinw, coeff;

  /* Circular signal samples buffer for Goertzel detector */
  char *samples_buff;

} detector_data;

#endif /* End of detect.h */

