/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.UserFunctionObject;

public class SetParameterTool
extends ObjectConstructor
implements Selector {
    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        if (constructionObject == null || constructionObject.isMainParameter()) {
            return;
        }
        constructionObject.setMainParameter();
        if (constructionObject.isMainParameter()) {
            constructionObject.setSelected(true);
            zirkelCanvas.getConstruction().addParameter(constructionObject);
            zirkelCanvas.repaint();
        }
        if (mouseEvent.isShiftDown()) {
            constructionObject.setSpecialParameter(true);
        }
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        return constructionObject instanceof PointObject || constructionObject instanceof PrimitiveLineObject || constructionObject instanceof PrimitiveCircleObject || constructionObject instanceof ExpressionObject || constructionObject instanceof AngleObject || constructionObject instanceof AreaObject || constructionObject instanceof FunctionObject || constructionObject instanceof UserFunctionObject;
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.clearSelected();
        zirkelCanvas.getConstruction().clearParameters();
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.parameters", "Macro Parameters: Select the Parameters!"));
    }
}

