/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

public class IntArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private int[] array;

    public IntArray() {
        this(512);
    }

    public IntArray(int n) {
        this.array = new int[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        this.valueCount = 0;
    }

    public void add(int n) {
        if (this.valueCount == this.array.length) {
            int[] nArray = new int[this.array.length + 256];
            System.arraycopy(this.array, 0, nArray, 0, this.array.length);
            this.array = nArray;
        }
        this.array[this.valueCount++] = n;
    }

    public void add(int[] nArray) {
        int n = this.valueCount + nArray.length;
        if (n >= this.array.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(this.array, 0, nArray2, 0, this.array.length);
            this.array = nArray2;
        }
        System.arraycopy(nArray, 0, this.array, this.valueCount, nArray.length);
        this.valueCount = n;
    }

    public int get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, int n2) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = n2;
    }

    public int remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return n2;
    }

    public int[] toArray() {
        int[] nArray = new int[this.valueCount];
        System.arraycopy(this.array, 0, nArray, 0, this.valueCount);
        return nArray;
    }

    public int[] toArray(int[] nArray) {
        int[] nArray2 = null;
        nArray2 = nArray.length >= this.valueCount ? nArray : new int[this.valueCount];
        System.arraycopy(this.array, 0, nArray2, 0, this.valueCount);
        return nArray2;
    }
}

