/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.Geom;
import org.odejava.HashSpace;
import org.odejava.PlaceableGeom;
import org.odejava.Space;
import org.odejava.World;
import org.odejava.collision.BulkContact;
import org.odejava.collision.JavaCollision;
import org.odejava.ode.OdeConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNBodyGroupNodeType;
import org.web3d.vrml.nodes.VRMLNBodySpaceNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseCollisionCollection
extends AbstractNode
implements VRMLNBodyGroupNodeType,
VRMLChildNodeType {
    protected static final int FIELD_COLLIDABLES = 1;
    protected static final int FIELD_ENABLED = 2;
    protected static final int FIELD_BOUNCE = 3;
    protected static final int FIELD_BOUNCE_SPEED = 4;
    protected static final int FIELD_FRICTION_COEFFICIENTS = 5;
    protected static final int FIELD_SLIP_COEFFICIENTS = 6;
    protected static final int FIELD_SURFACE_SPEED = 7;
    protected static final int FIELD_APPLIED_PARAMETERS = 8;
    protected static final int FIELD_SOFTNESS_CFM = 9;
    protected static final int FIELD_SOFTNESS_ERP = 10;
    protected static final int LAST_COLLECTION_INDEX = 10;
    private static final int NUM_FIELDS = 11;
    protected static final String COLLIDABLE_PROTO_MSG = "Collidables field proto value does not describe a CollisionSpace  node or NBodyCollidableNode type.";
    protected static final String COLLIDABLE_NODE_MSG = "Collidables field node value does not describe a CollisionSpace  node or NBodyCollidableNode type.";
    protected static final String NEG_BOUNCE_MSG = "bounce is required to be non-negative: ";
    protected static final String NEG_BOUNCE_SPEED_MSG = "minBounceSpeed is required to be non-negative: ";
    protected static final String NEG_ERP_MSG = "softnessErrorCorrection is required to be non-negative: ";
    protected static final String NEG_CFM_MSG = "softnessConstantForceMix is required to be non-negative: ";
    private static final int PARAM_BOUNCE = 1;
    private static final int PARAM_USER_FRICTION = 2;
    private static final int PARAM_FRICTION_COEFFICIENT_2 = 3;
    private static final int PARAM_ERROR_REDUCTION = 4;
    private static final int PARAM_CONSTANT_FORCE = 5;
    private static final int PARAM_SPEED_1 = 6;
    private static final int PARAM_SPEED_2 = 7;
    private static final int PARAM_SLIP_1 = 8;
    private static final int PARAM_SLIP_2 = 9;
    private static final int[] nodeFields = new int[]{0, 1};
    private static final VRMLFieldDeclaration[] fieldDecl = new VRMLFieldDeclaration[11];
    private static final HashMap fieldMap = new HashMap(33);
    protected static final HashMap parameterIdMap;
    protected static final HashMap internalParamIdMap;
    private ArrayList vfCollidables = new ArrayList();
    protected boolean vfEnabled = true;
    protected float vfBounce;
    protected float vfBounceSpeed = 0.1f;
    protected float[] vfFrictionCoefficients = new float[2];
    protected float[] vfSlipCoefficients = new float[2];
    protected float[] vfSurfaceSpeed = new float[2];
    protected String[] vfAppliedParameters = new String[]{"BOUNCE"};
    protected int numAppliedParameters = 1;
    protected float vfSoftnessErrorCorrection = 0.8f;
    protected float vfSoftnessConstantForceMix = 1.0E-4f;
    private VRMLNodeType[] nodeTmp;
    private ArrayList spaceChildren;
    private ArrayList geomChildren;
    private Space rootSpace;
    private JavaCollision javaCollider;
    private BulkContact contactCollection;
    private World odeWorld;
    private int surfaceModeFlags;
    private int[] appliedParamFlags = new int[]{1};

    public BaseCollisionCollection() {
        super("CollisionCollection");
        this.surfaceModeFlags = OdeConstants.dContactApprox1 | OdeConstants.dContactBounce;
        this.hasChanged = new boolean[11];
        this.spaceChildren = new ArrayList();
        this.geomChildren = new ArrayList();
        this.rootSpace = new HashSpace();
    }

    public BaseCollisionCollection(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("enabled");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("bounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("minBounceSpeed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBounceSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("softnessConstantForceMix");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSoftnessConstantForceMix = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("softnessErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSoftnessErrorCorrection = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setOwningWorld(World world) {
        if (this.odeWorld != null) {
            this.odeWorld.delete();
        } else {
            this.javaCollider = new JavaCollision(world);
            this.javaCollider.setSurfaceMode(this.surfaceModeFlags);
            this.javaCollider.setSurfaceBounce(0.0f);
            this.javaCollider.setSurfaceBounceVel(this.vfBounceSpeed);
            this.javaCollider.setSurfaceSoftCfm(this.vfSoftnessConstantForceMix);
            this.javaCollider.setSurfaceSoftErp(this.vfSoftnessErrorCorrection);
            this.javaCollider.setSurfaceMu(this.vfFrictionCoefficients[0]);
            this.javaCollider.setSurfaceMu2(this.vfFrictionCoefficients[1]);
            this.javaCollider.setSurfaceMotion1(this.vfSurfaceSpeed[0]);
            this.javaCollider.setSurfaceMotion2(this.vfSurfaceSpeed[1]);
            this.javaCollider.setSurfaceSlip1(this.vfSlipCoefficients[0]);
            this.javaCollider.setSurfaceSlip2(this.vfSlipCoefficients[1]);
            this.contactCollection = new BulkContact(this.javaCollider.getContactIntBuffer(), this.javaCollider.getContactFloatBuffer());
        }
        this.odeWorld = world;
    }

    public void delete() {
        this.rootSpace.delete();
        this.javaCollider.delete();
        this.odeWorld.delete();
    }

    public void evaluateCollisions() {
        this.javaCollider.collide(this.rootSpace);
        int n = this.javaCollider.getContactCount();
        if (n != 0) {
            this.contactCollection.load(n);
            for (int i = 0; i < n; ++i) {
                this.contactCollection.setIndex(i);
                this.contactCollection.setMu(this.vfFrictionCoefficients[0]);
                block12: for (int j = 0; j < this.numAppliedParameters; ++j) {
                    switch (this.appliedParamFlags[j]) {
                        case 1: {
                            this.contactCollection.setBounce(this.vfBounce);
                            this.contactCollection.setBounceVel(this.vfBounceSpeed);
                            continue block12;
                        }
                        case 2: {
                            continue block12;
                        }
                        case 3: {
                            this.contactCollection.setMu2(this.vfFrictionCoefficients[1]);
                            continue block12;
                        }
                        case 4: {
                            this.contactCollection.setSoftErp(this.vfSoftnessErrorCorrection);
                            continue block12;
                        }
                        case 5: {
                            this.contactCollection.setSoftCfm(this.vfSoftnessConstantForceMix);
                            continue block12;
                        }
                        case 6: {
                            this.contactCollection.setMotion1(this.vfSurfaceSpeed[0]);
                            continue block12;
                        }
                        case 7: {
                            this.contactCollection.setMotion2(this.vfSurfaceSpeed[1]);
                            continue block12;
                        }
                        case 8: {
                            this.contactCollection.setSlip1(this.vfSlipCoefficients[0]);
                            continue block12;
                        }
                        case 9: {
                            this.contactCollection.setSlip2(this.vfSlipCoefficients[1]);
                        }
                    }
                }
            }
        }
    }

    public int numContacts() {
        return this.javaCollider.getContactCount();
    }

    public BulkContact getContacts() {
        return this.contactCollection;
    }

    public void applyContacts() {
        this.contactCollection.commit();
        this.javaCollider.applyContacts();
    }

    public boolean isEnabled() {
        return this.vfEnabled;
    }

    public void setupFinished() {
        VRMLNodeType vRMLNodeType;
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n2 = this.spaceChildren.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNBodySpaceNodeType)this.spaceChildren.get(n);
            vRMLNodeType.setParentODESpace(this.rootSpace);
        }
        n2 = this.vfCollidables.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)this.vfCollidables.get(n);
            if (vRMLNodeType == null) continue;
            vRMLNodeType.setupFinished();
        }
        n2 = this.geomChildren.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNBodyCollidableNodeType)this.geomChildren.get(n);
            PlaceableGeom placeableGeom = vRMLNodeType.getODEGeometry();
            this.rootSpace.addGeom((Geom)placeableGeom);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 86;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                int n2 = this.vfCollidables.size();
                if (this.nodeTmp == null || this.nodeTmp.length < n2) {
                    this.nodeTmp = new VRMLNodeType[n2];
                }
                this.vfCollidables.toArray(this.nodeTmp);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = n2;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfBounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfFrictionCoefficients;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSlipCoefficients;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSurfaceSpeed;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfAppliedParameters;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.numAppliedParameters;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSoftnessConstantForceMix;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfSoftnessErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    int n3 = this.vfCollidables.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                        this.nodeTmp = new VRMLNodeType[n3];
                    }
                    this.vfCollidables.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n3);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfBounce);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfBounceSpeed);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfFrictionCoefficients, 2);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfSlipCoefficients, 2);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfSurfaceSpeed, 2);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfAppliedParameters, this.numAppliedParameters);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfSoftnessConstantForceMix);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfSoftnessErrorCorrection);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 2: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 3: {
                this.setBounce(f);
                break;
            }
            case 4: {
                this.setBounceSpeed(f);
                break;
            }
            case 9: {
                this.setSoftnessConstantForceMix(f);
                break;
            }
            case 10: {
                this.setSoftnessErrorCorrection(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 5: {
                this.setFrictionCoefficients(fArray);
                break;
            }
            case 6: {
                this.setSlipCoefficients(fArray);
                break;
            }
            case 7: {
                this.setSurfaceSpeed(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 8: {
                this.setAppliedParameters(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearCollidables();
                }
                this.addCollidable(vRMLNodeType2);
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.clearCollidables();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addCollidable(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    private void setEnabled(boolean bl) {
        this.vfEnabled = bl;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setSoftnessErrorCorrection(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_ERP_MSG + f);
        }
        this.vfSoftnessErrorCorrection = f;
        if (!this.inSetup) {
            this.javaCollider.setSurfaceSoftErp(this.vfSoftnessErrorCorrection);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    private void setSoftnessConstantForceMix(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_CFM_MSG + f);
        }
        this.vfSoftnessConstantForceMix = f;
        if (!this.inSetup) {
            this.javaCollider.setSurfaceSoftCfm(this.vfSoftnessConstantForceMix);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setBounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_BOUNCE_MSG + f);
        }
        this.vfBounce = f;
        if (!this.inSetup) {
            this.javaCollider.setSurfaceBounce(f);
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setBounceSpeed(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_BOUNCE_SPEED_MSG + f);
        }
        this.vfBounceSpeed = f;
        if (!this.inSetup) {
            this.javaCollider.setSurfaceBounceVel(f);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setFrictionCoefficients(float[] fArray) {
        this.vfFrictionCoefficients[0] = fArray[0];
        this.vfFrictionCoefficients[1] = fArray[1];
        if (!this.inSetup) {
            this.javaCollider.setSurfaceMu(fArray[0]);
            this.javaCollider.setSurfaceMu2(fArray[1]);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setSlipCoefficients(float[] fArray) {
        this.vfSlipCoefficients[0] = fArray[0];
        this.vfSlipCoefficients[1] = fArray[1];
        if (!this.inSetup) {
            this.javaCollider.setSurfaceSlip1(fArray[0]);
            this.javaCollider.setSurfaceSlip2(fArray[1]);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setSurfaceSpeed(float[] fArray) {
        this.vfSurfaceSpeed[0] = fArray[0];
        this.vfSurfaceSpeed[1] = fArray[1];
        if (!this.inSetup) {
            this.javaCollider.setSurfaceMotion1(fArray[0]);
            this.javaCollider.setSurfaceMotion2(fArray[1]);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setAppliedParameters(String[] stringArray, int n) {
        if (this.vfAppliedParameters.length < n) {
            this.vfAppliedParameters = new String[n];
            this.appliedParamFlags = new int[n];
        }
        this.surfaceModeFlags = OdeConstants.dContactApprox1;
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)parameterIdMap.get(stringArray[i]);
            if (n2 != null) {
                this.surfaceModeFlags |= n2.intValue();
                n2 = (Integer)internalParamIdMap.get(stringArray[i]);
                this.appliedParamFlags[i] = n2;
            }
            this.vfAppliedParameters[i] = stringArray[i];
        }
        this.numAppliedParameters = n;
        if (!this.inSetup) {
            this.javaCollider.setSurfaceMode(this.surfaceModeFlags);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void clearCollidables() {
        int n = this.vfCollidables.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfCollidables.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            this.updateRefs(this.nodeTmp[i], false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes(this.nodeTmp);
        }
        this.vfCollidables.clear();
        this.spaceChildren.clear();
        this.geomChildren.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addCollidable(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLNBodyCollidableNodeType) {
            this.vfCollidables.add(vRMLNodeType);
            this.geomChildren.add(vRMLNodeType);
        } else if (vRMLNodeType instanceof VRMLNBodySpaceNodeType) {
            this.vfCollidables.add(vRMLNodeType);
            this.spaceChildren.add(vRMLNodeType);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLNBodyCollidableNodeType) {
                this.vfCollidables.add(vRMLNodeType2);
                this.geomChildren.add(vRMLNodeType2);
            } else {
                if (!(vRMLNodeType2 instanceof VRMLNBodySpaceNodeType)) throw new InvalidFieldValueException(COLLIDABLE_PROTO_MSG);
                this.vfCollidables.add(vRMLNodeType2);
                this.spaceChildren.add(vRMLNodeType2);
            }
        } else if (vRMLNodeType != null) {
            throw new InvalidFieldValueException(COLLIDABLE_NODE_MSG);
        }
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, false);
        }
        if (this.inSetup) return;
        this.stateManager.registerAddedNode(vRMLNodeType);
    }

    static {
        BaseCollisionCollection.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCollisionCollection.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseCollisionCollection.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "collidables");
        BaseCollisionCollection.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "bounce");
        BaseCollisionCollection.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "minBounceSpeed");
        BaseCollisionCollection.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec2f", "frictionCoefficients");
        BaseCollisionCollection.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec2f", "slipCoefficients");
        BaseCollisionCollection.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFVec2f", "surfaceSpeed");
        BaseCollisionCollection.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "appliedParameters");
        BaseCollisionCollection.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "softnessErrorCorrection");
        BaseCollisionCollection.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "softnessConstantForceMix");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(1);
        fieldMap.put("collidables", n);
        fieldMap.put("set_collidables", n);
        fieldMap.put("collidables_changed", n);
        n = new Integer(3);
        fieldMap.put("bounce", n);
        fieldMap.put("set_bounce", n);
        fieldMap.put("bounce_changed", n);
        n = new Integer(4);
        fieldMap.put("minBounceSpeed", n);
        fieldMap.put("set_minBounceSpeed", n);
        fieldMap.put("minBounceSpeed_changed", n);
        n = new Integer(5);
        fieldMap.put("frictionCoefficients", n);
        fieldMap.put("set_frictionCoefficients", n);
        fieldMap.put("frictionCoefficients_changed", n);
        n = new Integer(6);
        fieldMap.put("slipCoefficients", n);
        fieldMap.put("set_slipCoefficients", n);
        fieldMap.put("slipCoefficients_changed", n);
        n = new Integer(7);
        fieldMap.put("surfaceSpeed", n);
        fieldMap.put("set_surfaceSpeed", n);
        fieldMap.put("surfaceSpeed_changed", n);
        n = new Integer(8);
        fieldMap.put("appliedParameters", n);
        fieldMap.put("set_appliedParameters", n);
        fieldMap.put("appliedParameters_changed", n);
        n = new Integer(9);
        fieldMap.put("softnessConstantForceMix", n);
        fieldMap.put("set_softnessConstantForceMix", n);
        fieldMap.put("softnessConstantForceMix_changed", n);
        n = new Integer(10);
        fieldMap.put("softnessErrorCorrection", n);
        fieldMap.put("set_softnessErrorCorrection", n);
        fieldMap.put("softnessErrorCorrection_changed", n);
        parameterIdMap = new HashMap();
        parameterIdMap.put("BOUNCE", new Integer(OdeConstants.dContactBounce));
        parameterIdMap.put("USER_FRICTION", new Integer(OdeConstants.dContactFDir1));
        parameterIdMap.put("FRICTION_COEFFICIENT-2", new Integer(OdeConstants.dContactMu2));
        parameterIdMap.put("ERROR_REDUCTION", new Integer(OdeConstants.dContactSoftERP));
        parameterIdMap.put("CONSTANT_FORCE", new Integer(OdeConstants.dContactSoftCFM));
        parameterIdMap.put("SPEED-1", new Integer(OdeConstants.dContactMotion1));
        parameterIdMap.put("SPEED-2", new Integer(OdeConstants.dContactMotion2));
        parameterIdMap.put("SLIP-1", new Integer(OdeConstants.dContactSlip1));
        parameterIdMap.put("SLIP-2", new Integer(OdeConstants.dContactSlip2));
        internalParamIdMap = new HashMap();
        internalParamIdMap.put("BOUNCE", new Integer(1));
        internalParamIdMap.put("USER_FRICTION", new Integer(2));
        internalParamIdMap.put("FRICTION_COEFFICIENT-2", new Integer(3));
        internalParamIdMap.put("ERROR_REDUCTION", new Integer(4));
        internalParamIdMap.put("CONSTANT_FORCE", new Integer(5));
        internalParamIdMap.put("SPEED-1", new Integer(6));
        internalParamIdMap.put("SPEED-2", new Integer(7));
        internalParamIdMap.put("SLIP-1", new Integer(8));
        internalParamIdMap.put("SLIP-2", new Integer(9));
    }
}

