/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_evcontain.h>
//#include <vdkb2/vdkb_labelbutton.h>
#include <vdkb2/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb2/vdkb_scrolled.h>
// #include <vdkb2/vdkb_grid.h>
#include <vdkb2/vdkb_fixed.h>
#include <vdkb2/vdkb_widpopmenu.h>
#include "./pixmaps/shadow.xpm"
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBScrolled
// put here vdk class name string
#define VDK_CLASS "VDKScrolled"
// put here vdk class name
#define VDK_ANCESTOR  VDKScrolled
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "scrolled"

extern char* wi_widget_prompts[];
static char buff[128];
int CLASS::Counter = 0;

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);

char* vdkscrolled_props[] = {  BORDERSHADOW,0 };
static char *shadows[] = 
{ 
"shadow_none","shadow_in","shadow_out","shadow_etched_in",
"shadow_etched_out",0 
};


/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  // add to VDKBObject properties 
  for(int t=0; vdkscrolled_props[t]; t++)
    proplist.add(VDKBProperty(vdkscrolled_props[t]));
  Init();
 }
/*
 */
void
CLASS::Init()
{
  AddBox();
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  delBox = new VDKMenuItem(popmenu,_("Remove scrolled"));
  selectparent =  new VDKMenuItem(popmenu,_(wi_widget_prompts[20]));
  SignalConnect(selectparent,"activate",
		&CLASS::SelectParentContainer);
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
  //
  CONNECT_COMMON_EVENTS;
  SetSize(100,100);
}
/*
 */
void
CLASS::AddBox()
{
  widget = sigwid = container = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (container),
				      GTK_POLICY_ALWAYS,
				      GTK_POLICY_ALWAYS);
  gtk_widget_show(container);
}

/*
extra args unused
 */
void
CLASS::AddWidget(VDKObject* obj, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
if (BinCheck(obj))
  {
    /*
    if(dynamic_cast<VDKBGrid*>(obj))
      gtk_container_add(GTK_CONTAINER(container),obj->Widget());
    else
      {
    */
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(container),
					      obj->Widget());
	gtk_container_set_focus_hadjustment ( GTK_CONTAINER (obj->Widget()),
					      gtk_scrolled_window_get_hadjustment
					      (GTK_SCROLLED_WINDOW (container)));
	gtk_container_set_focus_vadjustment (GTK_CONTAINER (obj->Widget()),
					     gtk_scrolled_window_get_vadjustment
					     (GTK_SCROLLED_WINDOW (container)));
	//  }
    VDKBEventContainer::Add(obj,l_justify,expand,fill,padding);
  }
else
  obj->Destroy();
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
  4 - unuseful call
*/
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  CLASS* scrolled = NULL;
  int result = 0;
  if(owner->Active)
    {
      for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  CLASS::Counter++)
	sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      scrolled = new CLASS(buff,owner);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      scrolled->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      scrolled->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(scrolled,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(scrolled);
	  scrolled->outerbox = container;
	}
      else if(! owner->Active->AddToParent(scrolled,ev))
	// target isn't a container
	  result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result && scrolled)
    scrolled->Destroy();
 return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventContainer::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	    PROP_BORDERSHADOW,
	    (char*) GetProp(BORDERSHADOW));
}

char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char bw[64];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];
  sprintf(temp,"\n%s = new %s(this);",obj_name,VDK_CLASS);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }

  if(parser.GetParam(bw,buffer,PROP_BORDERWIDTH) &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  // get shadow
  if(parser.GetParam(bw,buffer,PROP_BORDERSHADOW ) && 
     strcmp(bw,NIHIL_PROP))
    {
      int ndx = atoi(bw);
      ndx = (ndx >= 0) && (ndx <= 4) ? ndx : 0;
      sprintf(temp,"\n%s->%s = (GtkShadowType) %s;", 
	      obj_name,BORDERSHADOW,shadows[ndx]);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  CLASS* box;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  int bw; // border width
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,"_Padding:"))
    padding = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_BORDERWIDTH) &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new CLASS(obj_name,owner->InnerBox());
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new CLASS(obj_name,container);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  if(parser.GetParam(arg,buffer,PROP_BORDERSHADOW) &&
	 strcmp(arg,NIHIL_PROP))
	{
	  box->SetPropValue(BORDERSHADOW,arg);
	  int sh = atoi(arg);
	  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(box->ObjectFromVDK()->
								  WrappedWidget()),(GtkShadowType) sh);
	  //	  box->BorderShadow = (GtkShadowType) sh;
	}
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      box->BorderWidth(bw);
      box->SetPropValue(BORDERWIDTH,arg);
    }
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */

VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  inspector = isp;
  VDKBox* bframe = dynamic_cast<VDKBox*>(VDKBEventContainer::ExtraWidget(inspector));
  if(!bframe)
    return VDKBEventContainer::ExtraWidget(inspector);
  VDKBox* box = new VDKBox(inspector,h_box);
  VDKCustomButton *set = new VDKCustomButton(inspector,(const char**) shadow_xpm,NULL);
  set->Relief = (GtkReliefStyle) 2;
  set->SetTip(_(wi_widget_prompts[13]));
  box->Add(set,l_justify,false,false,0);
  set->Parent(this);
  SignalConnect(set,"clicked",&CLASS::OnSetShadow);
  shadow = new VDKCombo(isp,NULL);
  StringList sl;
  int t = 0;
  for(;shadows[t];t++)
    sl.add(VDKString(shadows[t]));
  shadow->PopdownStrings = sl;
  shadow->SetSize(120,-1);
  box->Add(shadow,l_justify,false,false,0);
  int r = atoi(GetProp(BORDERSHADOW));
  shadow->SelectItem(r);
  bframe->Add(box,l_justify,false,false,0);
  return bframe;
}
/*
 */
/*
 */
bool
CLASS::OnSetShadow(VDKObject*)
{
  int sel = shadow->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  SetPropValue(BORDERSHADOW ,buff);
  int shd = atoi(buff);
  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(ObjectFromVDK()->WrappedWidget()),
				      (GtkShadowType) shd);
  // BorderShadow = (GtkShadowType) shd;
  inspector->FormNeedToBeChanged();
  return true;
}





