/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       CryptUtils.cpp
//
//  Notes:      Implemintation of Crypt utils
//----------------------------------------------------------------------------
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "CryptUtils.h"
#include <string>
#ifdef _WIN32
	#include <objbase.h>
	#include <process.h>
	#include <wincrypt.h>
#endif


bool Crypt(bool encrypt, const void *data, unsigned long *size, void **out) {
#ifdef _WIN32
	DATA_BLOB DataIn, DataOut;
	BOOL res;

	if ((data == NULL) || (*size == 0)) {
		*out = NULL;
		return true;
	}

	DataIn.pbData = (BYTE*)data;
	DataIn.cbData = *size;

	if (encrypt) {
		res = CryptProtectData(&DataIn, L"DONT_REMOVE", NULL, NULL, NULL, 0, &DataOut);
	} else {
		res = CryptUnprotectData(&DataIn, NULL, NULL, NULL, NULL, 0, &DataOut);
	}

	if (!res) {
		return false;
	}
	*out = DataOut.pbData;
	*size = DataOut.cbData;
#else
	//no encryption in  linux
	*out = new char[*size];
	memcpy(*out,data,*size);
#endif
	return true;
}

bool Decrypt(const void *data, unsigned long *size, void **out) {
	return Crypt(false, data, size, out);
}

bool Encrypt(const void *data, unsigned long *size, void **out) {
	return Crypt(true, data, size, out);
}
