/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef UKUITASKBARPLUGIN_H
#define UKUITASKBARPLUGIN_H

#include "../panel/iukuipanel.h"
#include "../panel/iukuipanelplugin.h"
#include "ukuitaskbar.h"
#include <QDebug>
#include <QTranslator>
#include <QCoreApplication>

class UKUITaskBar;
class UKUITaskBarPlugin : public QObject, public IUKUIPanelPlugin
{
    Q_OBJECT
public:
    UKUITaskBarPlugin(const IUKUIPanelPluginStartupInfo &startupInfo);
    ~UKUITaskBarPlugin();

    QString themeId() const { return "TaskBar"; }
    virtual Flags flags() const { return HaveConfigDialog | NeedsHandle; }

    QWidget *widget() { return m_taskBar; }

    void realign();

    bool isSeparate() const { return true; }
    bool isExpandable() const { return true; }

private:
    void translator();

private:
    UKUITaskBar *m_taskBar;

};

class UKUITaskBarPluginLibrary: public QObject, public IUKUIPanelPluginLibrary
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "ukui.org/Panel/PluginInterface/3.0")
    Q_INTERFACES(IUKUIPanelPluginLibrary)
public:
    IUKUIPanelPlugin *instance(const IUKUIPanelPluginStartupInfo &startupInfo) const { return new UKUITaskBarPlugin(startupInfo);}
};

#endif // UKUITASKBARPLUGIN_H
