/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * da9053 register declarations.
 *
 * Copyright(c) 2009 Dialog Semiconductor Ltd.
 */

#ifndef __DIALOG_PMIC_H__
#define __DIALOG_PMIC_H__

enum {
	DA9053_PAGECON0_REG = 0,
	DA9053_STATUSA_REG,
	DA9053_STATUSB_REG,
	DA9053_STATUSC_REG,
	DA9053_STATUSD_REG,
	DA9053_EVENTA_REG,
	DA9053_EVENTB_REG,
	DA9053_EVENTC_REG,
	DA9053_EVENTD_REG,
	DA9053_FAULTLOG_REG,
	DA9053_IRQMASKA_REG,
	DA9053_IRQMASKB_REG,
	DA9053_IRQMASKC_REG,
	DA9053_IRQMASKD_REG,
	DA9053_CONTROLA_REG,
	DA9053_CONTROLB_REG,
	DA9053_CONTROLC_REG,
	DA9053_CONTROLD_REG,
	DA9053_PDDIS_REG,
	DA9053_INTERFACE_REG,
	DA9053_RESET_REG,
	DA9053_GPIO0001_REG,
	DA9053_GPIO0203_REG,
	DA9053_GPIO0405_REG,
	DA9053_GPIO0607_REG,
	DA9053_GPIO0809_REG,
	DA9053_GPIO1011_REG,
	DA9053_GPIO1213_REG,
	DA9053_GPIO1415_REG,
	DA9053_ID01_REG,
	DA9053_ID23_REG,
	DA9053_ID45_REG,
	DA9053_ID67_REG,
	DA9053_ID89_REG,
	DA9053_ID1011_REG,
	DA9053_ID1213_REG,
	DA9053_ID1415_REG,
	DA9053_ID1617_REG,
	DA9053_ID1819_REG,
	DA9053_ID2021_REG,
	DA9053_SEQSTATUS_REG,
	DA9053_SEQA_REG,
	DA9053_SEQB_REG,
	DA9053_SEQTIMER_REG,
	DA9053_BUCKA_REG,
	DA9053_BUCKB_REG,
	DA9053_BUCKCORE_REG,
	DA9053_BUCKPRO_REG,
	DA9053_BUCKMEM_REG,
	DA9053_BUCKPERI_REG,
	DA9053_LDO1_REG,
	DA9053_LDO2_REG,
	DA9053_LDO3_REG,
	DA9053_LDO4_REG,
	DA9053_LDO5_REG,
	DA9053_LDO6_REG,
	DA9053_LDO7_REG,
	DA9053_LDO8_REG,
	DA9053_LDO9_REG,
	DA9053_LDO10_REG,
	DA9053_SUPPLY_REG,
	DA9053_PULLDOWN_REG,
	DA9053_CHGBUCK_REG,
	DA9053_WAITCONT_REG,
	DA9053_ISET_REG,
	DA9053_BATCHG_REG,
	DA9053_CHGCONT_REG,
	DA9053_INPUTCONT_REG,
	DA9053_CHGTIME_REG,
	DA9053_BBATCONT_REG,
	DA9053_BOOST_REG,
	DA9053_LEDCONT_REG,
	DA9053_LEDMIN123_REG,
	DA9053_LED1CONF_REG,
	DA9053_LED2CONF_REG,
	DA9053_LED3CONF_REG,
	DA9053_LED1CONT_REG,
	DA9053_LED2CONT_REG,
	DA9053_LED3CONT_REG,
	DA9053_LED4CONT_REG,
	DA9053_LED5CONT_REG,
	DA9053_ADCMAN_REG,
	DA9053_ADCCONT_REG,
	DA9053_ADCRESL_REG,
	DA9053_ADCRESH_REG,
	DA9053_VDDRES_REG,
	DA9053_VDDMON_REG,
	DA9053_ICHGAV_REG,
	DA9053_ICHGTHD_REG,
	DA9053_ICHGEND_REG,
	DA9053_TBATRES_REG,
	DA9053_TBATHIGHP_REG,
	DA9053_TBATHIGHIN_REG,
	DA9053_TBATLOW_REG,
	DA9053_TOFFSET_REG,
	DA9053_ADCIN4RES_REG,
	DA9053_AUTO4HIGH_REG,
	DA9053_AUTO4LOW_REG,
	DA9053_ADCIN5RES_REG,
	DA9053_AUTO5HIGH_REG,
	DA9053_AUTO5LOW_REG,
	DA9053_ADCIN6RES_REG,
	DA9053_AUTO6HIGH_REG,
	DA9053_AUTO6LOW_REG,
	DA9053_TJUNCRES_REG,
	DA9053_TSICONTA_REG,
	DA9053_TSICONTB_REG,
	DA9053_TSIXMSB_REG,
	DA9053_TSIYMSB_REG,
	DA9053_TSILSB_REG,
	DA9053_TSIZMSB_REG,
	DA9053_COUNTS_REG,
	DA9053_COUNTMI_REG,
	DA9053_COUNTH_REG,
	DA9053_COUNTD_REG,
	DA9053_COUNTMO_REG,
	DA9053_COUNTY_REG,
	DA9053_ALARMMI_REG,
	DA9053_ALARMH_REG,
	DA9053_ALARMD_REG,
	DA9053_ALARMMO_REG,
	DA9053_ALARMY_REG,
	DA9053_SECONDA_REG,
	DA9053_SECONDB_REG,
	DA9053_SECONDC_REG,
	DA9053_SECONDD_REG,
	DA9053_PAGECON128_REG,
	DA9053_CHIPID_REG,
	DA9053_CONFIGID_REG,
	DA9053_OTPCONT_REG,
	DA9053_OSCTRIM_REG,
	DA9053_GPID0_REG,
	DA9053_GPID1_REG,
	DA9053_GPID2_REG,
	DA9053_GPID3_REG,
	DA9053_GPID4_REG,
	DA9053_GPID5_REG,
	DA9053_GPID6_REG,
	DA9053_GPID7_REG,
	DA9053_GPID8_REG,
	DA9053_GPID9_REG,
	DIALOG_NUM_OF_REGS,
};

#define DA_BUCKCORE_VBCORE_1_250V		0x1E

/* BUCKCORE REGISTER */
#define DA9052_BUCKCORE_BCORECONF               (1 << 7)
#define DA9052_BUCKCORE_BCOREEN                 (1 << 6)
#define DA9052_BUCKCORE_VBCORE                  63

/* SUPPLY REGISTER */
#define DA9052_SUPPLY_VLOCK                     (1 << 7)
#define DA9052_SUPPLY_VMEMSWEN                  (1 << 6)
#define DA9052_SUPPLY_VPERISWEN                 (1 << 5)
#define DA9052_SUPPLY_VLDO3GO                   (1 << 4)
#define DA9052_SUPPLY_VLDO2GO                   (1 << 3)
#define DA9052_SUPPLY_VBMEMGO                   (1 << 2)
#define DA9052_SUPPLY_VBPROGO                   (1 << 1)
#define DA9052_SUPPLY_VBCOREGO                  (1 << 0)

#endif /* __DIALOG_PMIC_H__ */
