# - Try to find MuPDF
# Once done this will define
#
#  MUPDF_FOUND - system has MuPDF
#  MUPDF_INCLUDE_DIR - The include directory for MuPDF headers
#  MUPDF_LIBRARIES - Link these to use MuPDF
#
# Redistribution and use is allowed according to the terms of the BSD license.
#

if ( MUPDF_LIBRARIES )
   # in cache already
   SET(MuPDF_FIND_QUIETLY TRUE)
endif ( MUPDF_LIBRARIES )

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
find_package(PkgConfig)
if( PKG_CONFIG_FOUND )
  pkg_check_modules(MUPDF_PKG QUIET mupdf)
endif( PKG_CONFIG_FOUND )

FIND_PATH(MUPDF_INCLUDE_DIR NAMES mupdf/pdf.h
  PATHS
    /usr/local/include
    /usr/include
  HINTS
    ${MUPDF_PKG_INCLUDE_DIRS} # Generated by pkg-config
)
IF ( NOT(MUPDF_INCLUDE_DIR) )
  FIND_PATH(MUPDF_INCLUDE_DIR NAMES mupdf.h
    PATHS
      /usr/local/include
      /usr/include
    HINTS
      ${MUPDF_PKG_INCLUDE_DIRS} # Generated by pkg-config
  )
ENDIF()
IF ( NOT(MUPDF_INCLUDE_DIR) )
  MESSAGE(STATUS "Could not find MuPDF headers." )
ENDIF ()

IF (MUPDF_INCLUDE_DIR)
  IF (EXISTS "${MUPDF_INCLUDE_DIR}/mupdf/pdf.h")
    SET(MUPDF_VERSION_STRING "1.3")
  ELSEIF (EXISTS "${MUPDF_INCLUDE_DIR}/mupdf.h")
    FILE(STRINGS "${MUPDF_INCLUDE_DIR}/mupdf.h" MUPDF_H)
    STRING(FIND "${MUPDF_H}" "pdf_new_obj_from_str" MUPDF_H_NEW_OBJ)
    STRING(FIND "${MUPDF_H}" "pdf_new_rect" MUPDF_H_NEW_RECT)
    STRING(FIND "${MUPDF_H}" "pdf_new_null" MUPDF_H_NEW_NULL)
    IF (MUPDF_H_NEW_OBJ GREATER -1)
      SET(MUPDF_VERSION_STRING "1.2")
    ELSEIF (MUPDF_H_NEW_RECT GREATER -1)
      SET(MUPDF_VERSION_STRING "1.1")
    ELSEIF (MUPDF_H_NEW_NULL GREATER -1)
      SET(MUPDF_VERSION_STRING "1.0")
    ELSE()
      SET(MUPDF_VERSION_STRING "0.9")
    ENDIF()
  ENDIF()
ENDIF()

# Find the libraries (Required; these vary between versions)
IF ("${MUPDF_VERSION_STRING}" VERSION_LESS "1.0")
  FIND_LIBRARY(MUPDF_LIBRARY NAMES mupdf
    PATHS
      /usr/local
      /usr
    HINTS
      ${MUPDF_PKG_LIBRARY_DIRS} # Generated by pkg-config
    PATH_SUFFIXES
      lib64
      lib
  )
  FIND_LIBRARY(FITZ_LIBRARY NAMES fitz
    PATHS
      /usr/local
      /usr
    HINTS
      ${MUPDF_PKG_LIBRARY_DIRS} # Generated by pkg-config
    PATH_SUFFIXES
      lib64
      lib
  )
  MARK_AS_ADVANCED(MUPDF_LIBRARY)
  MARK_AS_ADVANCED(FITZ_LIBRARY)
  IF ( NOT(MUPDF_LIBRARY) OR NOT(FITZ_LIBRARY) )
    MESSAGE(STATUS "Could not find MuPDF libraries." )
  ELSE()
    SET(MUPDF_LIBRARIES ${MUPDF_LIBRARY} ${FITZ_LIBRARY})
  ENDIF()
ELSEIF( "${MUPDF_VERSION_STRING}" VERSION_LESS "1.3" )
  FIND_LIBRARY(FITZ_LIBRARY NAMES fitz
    PATHS
      /usr/local
      /usr
    HINTS
      ${MUPDF_PKG_LIBRARY_DIRS} # Generated by pkg-config
    PATH_SUFFIXES
      lib64
      lib
  )
  MARK_AS_ADVANCED(FITZ_LIBRARY)
  IF ( NOT(FITZ_LIBRARY) )
    MESSAGE(STATUS "Could not find MuPDF libraries." )
  ELSE()
    SET(MUPDF_LIBRARIES ${FITZ_LIBRARY})
  ENDIF()
ELSE()
  FIND_LIBRARY(MUPDF_LIBRARY NAMES mupdf
    PATHS
      /usr/local
      /usr
    HINTS
      ${MUPDF_PKG_LIBRARY_DIRS} # Generated by pkg-config
    PATH_SUFFIXES
      lib64
      lib
  )
  FIND_LIBRARY(MUPDF_JS_LIBRARY NAMES mupdf-js-none
    PATHS
      /usr/local
      /usr
    HINTS
      ${MUPDF_PKG_LIBRARY_DIRS} # Generated by pkg-config
    PATH_SUFFIXES
      lib64
      lib
  )
  MARK_AS_ADVANCED(MUPDF_LIBRARY MUPDF_JS_LIBRARY)
  IF ( NOT(MUPDF_LIBRARY) OR NOT(MUPDF_JS_LIBRARY) )
    MESSAGE(STATUS "Could not find MuPDF libraries." )
  ELSE()
    SET(MUPDF_LIBRARIES ${MUPDF_LIBRARY} ${MUPDF_JS_LIBRARY})
  ENDIF()
ENDIF()



include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(MuPDF REQUIRED_VARS MUPDF_LIBRARIES MUPDF_INCLUDE_DIR VERSION_VAR MUPDF_VERSION_STRING)


# show the MUPDF_(XPDF/QT4)_INCLUDE_DIR and MUPDF_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(MUPDF_INCLUDE_DIR MUPDF_LIBRARIES)

