package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelCommonBandwidthPackageIpBandwidth invokes the vpc.CancelCommonBandwidthPackageIpBandwidth API synchronously
func (client *Client) CancelCommonBandwidthPackageIpBandwidth(request *CancelCommonBandwidthPackageIpBandwidthRequest) (response *CancelCommonBandwidthPackageIpBandwidthResponse, err error) {
	response = CreateCancelCommonBandwidthPackageIpBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// CancelCommonBandwidthPackageIpBandwidthWithChan invokes the vpc.CancelCommonBandwidthPackageIpBandwidth API asynchronously
func (client *Client) CancelCommonBandwidthPackageIpBandwidthWithChan(request *CancelCommonBandwidthPackageIpBandwidthRequest) (<-chan *CancelCommonBandwidthPackageIpBandwidthResponse, <-chan error) {
	responseChan := make(chan *CancelCommonBandwidthPackageIpBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelCommonBandwidthPackageIpBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelCommonBandwidthPackageIpBandwidthWithCallback invokes the vpc.CancelCommonBandwidthPackageIpBandwidth API asynchronously
func (client *Client) CancelCommonBandwidthPackageIpBandwidthWithCallback(request *CancelCommonBandwidthPackageIpBandwidthRequest, callback func(response *CancelCommonBandwidthPackageIpBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelCommonBandwidthPackageIpBandwidthResponse
		var err error
		defer close(result)
		response, err = client.CancelCommonBandwidthPackageIpBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelCommonBandwidthPackageIpBandwidthRequest is the request struct for api CancelCommonBandwidthPackageIpBandwidth
type CancelCommonBandwidthPackageIpBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BandwidthPackageId   string           `position:"Query" name:"BandwidthPackageId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EipId                string           `position:"Query" name:"EipId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CancelCommonBandwidthPackageIpBandwidthResponse is the response struct for api CancelCommonBandwidthPackageIpBandwidth
type CancelCommonBandwidthPackageIpBandwidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelCommonBandwidthPackageIpBandwidthRequest creates a request to invoke CancelCommonBandwidthPackageIpBandwidth API
func CreateCancelCommonBandwidthPackageIpBandwidthRequest() (request *CancelCommonBandwidthPackageIpBandwidthRequest) {
	request = &CancelCommonBandwidthPackageIpBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CancelCommonBandwidthPackageIpBandwidth", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelCommonBandwidthPackageIpBandwidthResponse creates a response to parse from CancelCommonBandwidthPackageIpBandwidth response
func CreateCancelCommonBandwidthPackageIpBandwidthResponse() (response *CancelCommonBandwidthPackageIpBandwidthResponse) {
	response = &CancelCommonBandwidthPackageIpBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
