from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


QtCore = _Mock()

compiler = _Mock()

indenter = _Mock()

main = _Mock()

optparse = _Mock()

processUI = _Mock()

qtproxies = _Mock()

sys = _Mock()

time = _Mock()

DISPLAY_CODE = '\nif __name__ == \'__main__\':\n    import sys\n    global app\n    class MainWin(kdeui.KMainWindow, %s):\n        def __init__ (self, *args):\n            kdeui.KMainWindow.__init__ (self)\n            rootWidget = QtGui.QWidget(self)\n            self.setupUi(rootWidget)\n            self.resize(640, 480)\n            self.setCentralWidget(rootWidget)\n\n    appName     = "default"\n    catalog     = ""\n    programName = kdecore.ki18n("default")\n    version     = "1.0"\n    description = kdecore.ki18n("Default Example")\n    license     = kdecore.KAboutData.License_GPL\n    copyright   = kdecore.ki18n("unknown")\n    text        = kdecore.ki18n("none")\n    homePage    = ""\n    bugEmail    = "email"\n\n    aboutData   = kdecore.KAboutData(appName, catalog, programName, version, description,\n                              license, copyright, text, homePage, bugEmail)\n    kdecore.KCmdLineArgs.init(sys.argv, aboutData)\n\n    app = kdeui.KApplication()\n    mainWindow = MainWin(None, "main window")\n    mainWindow.show()\n    app.lastWindowClosed.connect(app.quit)\n    app.exec_ ()\n'

HEADER = '#!/usr/bin/env python\n# coding=UTF-8\n#\n# Generated by pykdeuic4 from %s on %s\n#\n# WARNING! All changes to this file will be lost.\nfrom PyKDE4 import kdecore\nfrom PyKDE4 import kdeui\n'

MATCH = _Mock()

NO_MATCH = _Mock()

class kde_i18n_string(_Mock):
  pass


class original_i18n_string(_Mock):
  pass


