/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.UnknownType;
import adql.query.operand.function.geometry.GeometryFunction;

public class BoxFunction
extends GeometryFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "BOX", true, "Express a box on the sky.");
    private GeometryFunction.GeometryValue<GeometryFunction> centerPoint;
    private ADQLOperand coord1;
    private ADQLOperand coord2;
    private ADQLOperand width;
    private ADQLOperand height;

    public BoxFunction(ADQLOperand coordinateSystem, ADQLOperand firstCoord, ADQLOperand secondCoord, ADQLOperand boxWidth, ADQLOperand boxHeight) throws NullPointerException, Exception {
        super(coordinateSystem);
        if (firstCoord == null || secondCoord == null || boxWidth == null || boxHeight == null) {
            throw new NullPointerException("All the parameters of the BOX function must be different from NULL!");
        }
        this.coord1 = firstCoord;
        this.coord2 = secondCoord;
        this.width = boxWidth;
        this.height = boxHeight;
        this.centerPoint = null;
    }

    public BoxFunction(ADQLOperand coordinateSystem, GeometryFunction.GeometryValue<GeometryFunction> center, ADQLOperand boxWidth, ADQLOperand boxHeight) throws NullPointerException, Exception {
        super(coordinateSystem);
        if (center == null || boxWidth == null || boxHeight == null) {
            throw new NullPointerException("All the parameters of the BOX function must be different from NULL!");
        }
        this.coord1 = null;
        this.coord2 = null;
        this.width = boxWidth;
        this.height = boxHeight;
        this.centerPoint = center;
    }

    public BoxFunction(BoxFunction toCopy) throws Exception {
        super(toCopy);
        this.coord1 = (ADQLOperand)toCopy.coord1.getCopy();
        this.coord2 = (ADQLOperand)toCopy.coord2.getCopy();
        this.width = (ADQLOperand)toCopy.width.getCopy();
        this.height = (ADQLOperand)toCopy.height.getCopy();
        this.centerPoint = (GeometryFunction.GeometryValue)toCopy.centerPoint.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new BoxFunction(this);
    }

    @Override
    public String getName() {
        return "BOX";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    public final GeometryFunction.GeometryValue<GeometryFunction> getCenter() {
        return this.centerPoint;
    }

    public final void setCenter(GeometryFunction.GeometryValue<GeometryFunction> newCenter) {
        this.centerPoint = newCenter;
        this.coord1 = null;
        this.coord2 = null;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public final void setCoord1(ADQLOperand coord1) {
        this.coord1 = coord1;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public final void setCoord2(ADQLOperand coord2) {
        this.coord2 = coord2;
        this.setPosition(null);
    }

    public final ADQLOperand getWidth() {
        return this.width;
    }

    public final void setWidth(ADQLOperand width) {
        this.width = width;
        this.setPosition(null);
    }

    public final ADQLOperand getHeight() {
        return this.height;
    }

    public final void setHeight(ADQLOperand height) {
        this.height = height;
        this.setPosition(null);
    }

    @Override
    public ADQLOperand[] getParameters() {
        if (this.centerPoint == null) {
            return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2, this.width, this.height};
        }
        return new ADQLOperand[]{this.coordSys, this.centerPoint.getValue(), this.width, this.height};
    }

    @Override
    public int getNbParameters() {
        return this.centerPoint == null ? 5 : 4;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (this.centerPoint == null) {
            switch (index) {
                case 0: {
                    return this.coordSys;
                }
                case 1: {
                    return this.coord1;
                }
                case 2: {
                    return this.coord2;
                }
                case 3: {
                    return this.width;
                }
                case 4: {
                    return this.height;
                }
            }
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
        }
        switch (index) {
            case 0: {
                return this.coordSys;
            }
            case 1: {
                return this.centerPoint.getValue();
            }
            case 2: {
                return this.width;
            }
            case 3: {
                return this.height;
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        ADQLOperand replaced;
        block19: {
            block18: {
                if (replacer == null) {
                    throw new NullPointerException("Impossible to remove one parameter from a " + this.getName() + " function!");
                }
                if (!(replacer instanceof ADQLOperand)) {
                    throw new Exception("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                }
                replaced = null;
                if (this.centerPoint != null) break block18;
                switch (index) {
                    case 0: {
                        replaced = this.coordSys;
                        this.setCoordinateSystem(replacer);
                        break block19;
                    }
                    case 1: {
                        replaced = this.coord1;
                        this.setCoord1(replacer);
                        break block19;
                    }
                    case 2: {
                        replaced = this.coord2;
                        this.setCoord2(replacer);
                        break block19;
                    }
                    case 3: {
                        replaced = this.width;
                        this.setWidth(replacer);
                        break block19;
                    }
                    case 4: {
                        replaced = this.height;
                        this.setHeight(replacer);
                        break block19;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
                    }
                }
            }
            switch (index) {
                case 0: {
                    replaced = this.coordSys;
                    this.setCoordinateSystem(replacer);
                    break;
                }
                case 1: {
                    replaced = this.centerPoint;
                    if (replacer instanceof GeometryFunction.GeometryValue) {
                        this.setCenter((GeometryFunction.GeometryValue)replacer);
                        break;
                    }
                    if (replaced instanceof UnknownType) {
                        this.centerPoint.setUnknownTypeValue((UnknownType)replaced);
                        break;
                    }
                    if (replaced instanceof GeometryFunction) {
                        this.centerPoint.setGeometry((GeometryFunction)replaced);
                        break;
                    }
                    throw new Exception("Impossible to replace a GeometryValue/GeometryFunction/UnknownType by " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                }
                case 2: {
                    replaced = this.width;
                    this.setWidth(replacer);
                    break;
                }
                case 3: {
                    replaced = this.height;
                    this.setHeight(replacer);
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
                }
            }
        }
        return replaced;
    }
}

