/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.Healpix;
import cds.healpix.common.math.FastMath;
import cds.healpix.common.math.HackersDelight;

final class HealpixUnprojector {
    public static final double ONE_OVER_SQRT6 = 0.408248290463863;
    static final double EPS_POLE = 1.0E-13;
    static final double EPS_EDGE = 1.0E-12;
    private long signX;
    private double absX;
    private long signY;
    private double absY;
    private int xOffset;
    private double lon;
    private double lat;

    HealpixUnprojector() {
    }

    void unproject(double x, double y, double[] resultLonLat) {
        HealpixUnprojector.checkProjectionBoundsInY(y);
        this.computeAbsOfXYAndKeepSigns(x, y);
        this.shiftAbsXInMinus1ToPlus1RangeAndKeepRangeOffset();
        this.reduceRangeOffsetToMax7();
        if (this.isInEquatorialRegion()) {
            this.deprojCylindricalEquaArea(y);
        } else {
            this.deprojCollignon(x);
        }
        this.shiftLonToReducedRangeAndScaleToRadians();
        this.applyXYSignsToLonLat();
        this.storeResultIn(resultLonLat);
    }

    private static void checkProjectionBoundsInY(double y) {
        if (y < -2.0 || y > 2.0) {
            throw new IllegalArgumentException("Wrong y. Expected: in [-2, 2]. Actual: " + y);
        }
    }

    private void computeAbsOfXYAndKeepSigns(double x, double y) {
        this.computeAbsOfXAndKeepSign(x);
        this.computeAbsOfYAndKeepSign(y);
    }

    private void computeAbsOfXAndKeepSign(double x) {
        this.signX = HackersDelight.toBits(x);
        assert (x == HackersDelight.fromBits(this.signX));
        this.absX = HackersDelight.fromBits(this.signX & Long.MAX_VALUE);
        assert (0.0 <= this.absX);
        this.signX &= Long.MIN_VALUE;
        assert (0L == this.signX || Long.MIN_VALUE == this.signX);
    }

    private void computeAbsOfYAndKeepSign(double y) {
        this.signY = HackersDelight.toBits(y);
        assert (y == HackersDelight.fromBits(this.signY));
        this.absY = HackersDelight.fromBits(this.signY & Long.MAX_VALUE);
        assert (0.0 <= this.absY && this.absY <= 2.0);
        this.signY &= Long.MIN_VALUE;
        assert (0L == this.signY || Long.MIN_VALUE == this.signY);
    }

    private void shiftAbsXInMinus1ToPlus1RangeAndKeepRangeOffset() {
        this.xOffset = (int)this.absX | 1;
        assert (1 <= this.xOffset && this.xOffset % 2 == 1);
        this.lon = this.absX - (double)this.xOffset;
        assert (-1.0 <= this.lon && this.lon <= 1.0);
    }

    private void reduceRangeOffsetToMax7() {
        this.xOffset &= 7;
        assert (1 <= this.xOffset && this.xOffset <= 7 && this.xOffset % 2 == 1);
    }

    private boolean isInEquatorialRegion() {
        return this.absY <= 1.0;
    }

    private void deprojCylindricalEquaArea(double y) {
        this.lat = FastMath.asin(y * 0.6666666666666666);
        assert (-1.5707963267948966 <= this.lat && this.lat <= 1.5707963267948966);
    }

    private void deprojCollignon(double x) {
        this.lat = 2.0 - this.absY;
        assert (0.0 <= this.lat && this.lat < 1.0);
        if (HealpixUnprojector.isNotNearFromPole(this.lat)) {
            this.lon /= this.lat;
            assert (-1.000000000001 <= this.lon && this.lon <= 1.000000000001);
            this.dealWithNumericalApproxInEdge();
            assert (-1.0 <= this.lon && this.lon <= 1.0);
        }
        this.lat *= 0.408248290463863;
        assert (0.0 <= this.lat && this.lat < 0.408248290463863);
        this.lat = 2.0 * FastMath.acos(this.lat) - 1.5707963267948966;
        assert (Healpix.TRANSITION_LATITUDE < this.lat && this.lat <= 1.5707963267948966);
    }

    private void dealWithNumericalApproxInEdge() {
        if (this.lon > 1.0) {
            assert (this.lon - 1.0 < 1.0E-12);
            this.lon = 1.0;
        } else if (this.lon < -1.0) {
            assert (this.lon + 1.0 > -1.0E-12);
            this.lon = -1.0;
        }
    }

    static boolean isNotNearFromPole(double sqrtOfThreeTimeOneMinusSinOf) {
        return sqrtOfThreeTimeOneMinusSinOf > 1.0E-13;
    }

    private void shiftLonToReducedRangeAndScaleToRadians() {
        this.lon += (double)this.xOffset;
        assert (0.0 <= this.lon && this.lon <= 8.0);
        this.lon *= 0.7853981633974483;
        assert (0.0 <= this.lon && this.lon <= Math.PI * 2);
    }

    private void applyXYSignsToLonLat() {
        this.applyXSignToLon();
        this.applyYSignToLat();
    }

    private void applyXSignToLon() {
        this.lon = HackersDelight.fromBits(this.signX | HackersDelight.toBits(this.lon));
        assert (-Math.PI <= this.lat && this.lat <= Math.PI * 2);
    }

    private void applyYSignToLat() {
        this.lat = HackersDelight.fromBits(this.signY | HackersDelight.toBits(this.lat));
        assert (-1.5707963267948966 <= this.lat && this.lat <= 1.5707963267948966);
    }

    private void storeResultIn(double[] resultLonLat) {
        resultLonLat[0] = this.lon;
        resultLonLat[1] = this.lat;
    }
}

