/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.FlatHashIterator;
import cds.healpix.Healpix;
import cds.healpix.Range;
import cds.healpix.ToRangeItDecorator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class HealpixNestedBMOC
implements Iterable<CurrentValueAccessor> {
    private static final long MASK_EXCEPT_LSB = -2L;
    private final int depthMax;
    private final long[] cells;
    private final int to;

    private HealpixNestedBMOC(int mocDepth, long[] mocCells) {
        this(mocDepth, mocCells, mocCells.length);
    }

    private HealpixNestedBMOC(int mocDepth, long[] mocCells, int toIndex) {
        this.checkDepth(mocDepth);
        this.depthMax = mocDepth;
        this.cells = mocCells;
        this.to = toIndex;
    }

    public HealpixNestedBMOC toDeeperDepth(int newDepth) {
        if (newDepth <= this.depthMax) {
            throw new IllegalArgumentException("The given depth must be higher than the depth max of the MOC");
        }
        int twiceDepthDiff = newDepth - this.depthMax << 1;
        long[] mocNew = new long[this.to];
        for (int i = 0; i < this.to; ++i) {
            long c = this.cells[i];
            mocNew[i] = (c & 0xFFFFFFFFFFFFFFFEL) << twiceDepthDiff | c & 1L;
        }
        return new HealpixNestedBMOC(newDepth, mocNew);
    }

    public HealpixNestedBMOC toLowerDepth(int newDepth) {
        if (newDepth >= this.depthMax) {
            throw new IllegalArgumentException("The given depth must be lower than the depth max of the MOC");
        }
        long[] mocNew = new long[this.to];
        int iNew = 0;
        long prevHashAtNewDepth = -1L;
        for (int i = 0; i < this.to; ++i) {
            long raw = this.cells[i];
            int depth = HealpixNestedBMOC.getDepth(raw, this.depthMax);
            if (depth <= newDepth) {
                if (prevHashAtNewDepth != -1L) {
                    mocNew[iNew++] = prevHashAtNewDepth << 2 | 2L;
                    prevHashAtNewDepth = -1L;
                }
                int twice_delta_depth = this.depthMax - depth << 1;
                mocNew[iNew++] = raw >> twice_delta_depth | raw & 1L;
                continue;
            }
            long currHashAtNewDepth = HealpixNestedBMOC.getHashFromDepthDiff(raw, this.depthMax - depth);
            if (prevHashAtNewDepth == -1L) {
                prevHashAtNewDepth = currHashAtNewDepth;
                continue;
            }
            if (prevHashAtNewDepth == currHashAtNewDepth) continue;
            mocNew[iNew++] = prevHashAtNewDepth << 2 | 2L;
            prevHashAtNewDepth = currHashAtNewDepth;
        }
        return new HealpixNestedBMOC(newDepth, Arrays.copyOf(mocNew, iNew));
    }

    private void checkDepth(int depth) {
        if (depth >= 29) {
            throw new IllegalArgumentException("Depth larger than or equal to 29 not uspported.");
        }
    }

    public int size() {
        return this.to;
    }

    public long computeDeepSize() {
        long tot = 0L;
        for (int i = 0; i < this.to; ++i) {
            int depth = HealpixNestedBMOC.getDepth(this.cells[i], this.depthMax);
            tot += Healpix.nsideSquare(this.depthMax - depth);
        }
        return tot;
    }

    public static HealpixNestedBMOC createUnsafe(int mocDepth, long[] mocCells) {
        return new HealpixNestedBMOC(mocDepth, mocCells);
    }

    public static HealpixNestedBMOC createUnsafe(int mocDepth, long[] mocCells, int toIndex) {
        return new HealpixNestedBMOC(mocDepth, mocCells, toIndex);
    }

    public static HealpixNestedBMOC createCheck(int mocDepth, long[] mocCells) {
        HealpixNestedBMOC.checkIsSortedNoDuplicateNoOverlap(mocCells);
        return HealpixNestedBMOC.createUnsafe(mocDepth, mocCells);
    }

    public static HealpixNestedBMOC createCheck(int mocDepth, long[] mocCells, int toIndex) {
        HealpixNestedBMOC.checkIsSortedNoDuplicateNoOverlap(mocCells);
        return HealpixNestedBMOC.createUnsafe(mocDepth, mocCells, toIndex);
    }

    public static HealpixNestedBMOC createPacking(int mocDepth, long[] mocCells) {
        return HealpixNestedBMOC.createPacking(mocDepth, mocCells, mocCells.length);
    }

    public static HealpixNestedBMOC createPacking(int mocDepth, long[] mocCells, int toIndex) {
        int prevToIndex = 0;
        int currToIndex = toIndex;
        while (prevToIndex != currToIndex) {
            prevToIndex = currToIndex;
            int iPrevMoc = 0;
            int iCurrMoc = 0;
            while (iPrevMoc < prevToIndex) {
                long currCell = mocCells[iPrevMoc++];
                int currCellDepth = HealpixNestedBMOC.getDepth(currCell, mocDepth);
                long currCellHash = HealpixNestedBMOC.getHashFromDepthDiff(currCell, mocDepth - currCellDepth);
                while (iPrevMoc < prevToIndex && (currCellDepth == 0 || HealpixNestedBMOC.isPartial(currCell) || HealpixNestedBMOC.isNotFirstCellOfLargerCell(currCellHash))) {
                    if (iCurrMoc != iPrevMoc) {
                        mocCells[iCurrMoc++] = currCell;
                    }
                    currCell = mocCells[iPrevMoc++];
                    currCellDepth = HealpixNestedBMOC.getDepth(currCell, mocDepth);
                    currCellHash = HealpixNestedBMOC.getHashFromDepthDiff(currCell, mocDepth - currCellDepth);
                }
                if (iPrevMoc + 2 < prevToIndex && mocCells[iPrevMoc + 0] == HealpixNestedBMOC.buildValue(currCellDepth, currCellHash | 1L, true, mocDepth) && mocCells[iPrevMoc + 1] == HealpixNestedBMOC.buildValue(currCellDepth, currCellHash | 2L, true, mocDepth) && mocCells[iPrevMoc + 2] == HealpixNestedBMOC.buildValue(currCellDepth, currCellHash | 3L, true, mocDepth)) {
                    mocCells[iCurrMoc++] = HealpixNestedBMOC.buildValue(currCellDepth - 1, currCellHash >> 2, true, mocDepth);
                    iPrevMoc += 3;
                    continue;
                }
                if (iCurrMoc == iPrevMoc) continue;
                mocCells[iCurrMoc++] = currCell;
            }
            currToIndex = iCurrMoc;
        }
        return HealpixNestedBMOC.createUnsafe(mocDepth, mocCells, currToIndex);
    }

    private static final boolean isNotFirstCellOfLargerCell(long hash) {
        return (hash & 3L) != 0L;
    }

    private static void checkIsSortedNoDuplicateNoOverlap(long[] mocCells) {
        if (mocCells.length > 0) {
            long prev = HealpixNestedBMOC.rmFlag(mocCells[0]);
            long prevNoSentinel = HealpixNestedBMOC.rmSentinelNoFlag(prev);
            for (int i = 1; i < mocCells.length; ++i) {
                long curr = HealpixNestedBMOC.rmFlag(mocCells[i]);
                long currNoSentinel = HealpixNestedBMOC.rmSentinelNoFlag(curr);
                if (prev >= curr) {
                    throw new IllegalArgumentException("Not valid MOC: not sorted");
                }
                long aAndB = prevNoSentinel & currNoSentinel;
                if (aAndB == prevNoSentinel || aAndB == currNoSentinel) {
                    throw new IllegalArgumentException("Not valid MOC: elem " + curr + " overlap with " + prev);
                }
                prev = curr;
                prevNoSentinel = currNoSentinel;
            }
        }
    }

    private static long rmFlag(long rawVal) {
        return rawVal >> 1;
    }

    private static long setFlagTo0(long rawVal) {
        return rawVal & 0xFFFFFFFFFFFFFFFEL;
    }

    private static long rmSentinelNoFlag(long valNoFlag) {
        assert ((valNoFlag & 1L) == 0L);
        return HealpixNestedBMOC.turnOffRightmost1Bit(valNoFlag);
    }

    private static long getHash(long rawVal, int depthMax) {
        return HealpixNestedBMOC.getHashFromDepthDiff(rawVal, depthMax - HealpixNestedBMOC.getDepth(rawVal, depthMax));
    }

    private static long getHashFromDepthDiff(long rawVal, int depthDiff) {
        return rawVal >> 2 + (depthDiff << 1);
    }

    private static int getDepth(long rawVal, int depthMax) {
        return HealpixNestedBMOC.getDepthNoFlag(rawVal >> 1, depthMax);
    }

    private static int getDepthNoFlag(long valNoFlag, int depthMax) {
        return depthMax - (Long.numberOfTrailingZeros(valNoFlag) >> 1);
    }

    private static boolean isPartial(long mocEncodedHash) {
        return (mocEncodedHash & 1L) == 0L;
    }

    private static boolean isFull(long mocEncodedHash) {
        return (mocEncodedHash & 1L) == 1L;
    }

    public int getDepthMax() {
        return this.depthMax;
    }

    public Status status(int depth, long hash) {
        long hm1;
        long hm1NoFlag;
        this.checkDepth(depth);
        long h = HealpixNestedBMOC.buildValue(depth, hash, false, this.depthMax);
        long hNoSentinel = HealpixNestedBMOC.rmSentinelNoFlag(h);
        if (h < this.cells[0]) {
            long h0 = this.cells[0];
            long h0NoFlag = HealpixNestedBMOC.setFlagTo0(h0);
            if (h == h0NoFlag) {
                return Status.FULL;
            }
            long h0NoSentinelNoFlag = HealpixNestedBMOC.rmSentinelNoFlag(h0NoFlag);
            if (HealpixNestedBMOC.aIsALargerCellThanB(h, h0NoFlag)) {
                return HealpixNestedBMOC.contains(hNoSentinel, h0NoSentinelNoFlag) ? Status.PARTIAL : Status.EMPTY;
            }
            return HealpixNestedBMOC.contains(h0NoSentinelNoFlag, hNoSentinel) ? HealpixNestedBMOC.selfStatus(h0, h0NoFlag) : Status.EMPTY;
        }
        if (h > this.cells[this.to - 1]) {
            long hn = this.cells[this.to - 1];
            long hnNoFlag = HealpixNestedBMOC.setFlagTo0(hn);
            long hnNoSentinelNoFlag = HealpixNestedBMOC.rmSentinelNoFlag(hnNoFlag);
            if (HealpixNestedBMOC.aIsALargerCellThanB(h, hnNoFlag)) {
                return HealpixNestedBMOC.contains(hNoSentinel, hnNoSentinelNoFlag) ? Status.PARTIAL : Status.EMPTY;
            }
            return HealpixNestedBMOC.contains(hnNoSentinelNoFlag, hNoSentinel) ? HealpixNestedBMOC.selfStatus(hn, hnNoFlag) : Status.EMPTY;
        }
        int index = Arrays.binarySearch(this.cells, 0, this.to, h);
        if (index >= 0) {
            return Status.PARTIAL;
        }
        long hp1 = this.cells[-index - 1];
        long hp1NoFlag = HealpixNestedBMOC.setFlagTo0(hp1);
        if (h == hp1NoFlag) {
            return Status.FULL;
        }
        long hp1NoSentinelNoFlag = HealpixNestedBMOC.rmSentinelNoFlag(hp1NoFlag);
        if (HealpixNestedBMOC.aIsALargerCellThanB(h, hp1NoFlag)) {
            if (HealpixNestedBMOC.contains(hNoSentinel, hp1NoSentinelNoFlag)) {
                return Status.PARTIAL;
            }
        } else if (HealpixNestedBMOC.contains(hp1NoSentinelNoFlag, hNoSentinel)) {
            return HealpixNestedBMOC.selfStatus(hp1, hp1NoFlag);
        }
        if (h == (hm1NoFlag = HealpixNestedBMOC.setFlagTo0(hm1 = this.cells[-index - 2]))) {
            return Status.FULL;
        }
        long hm1NoSentinelNoFlag = HealpixNestedBMOC.rmSentinelNoFlag(hm1NoFlag);
        if (HealpixNestedBMOC.aIsALargerCellThanB(h, hm1NoFlag)) {
            if (HealpixNestedBMOC.contains(hNoSentinel, hm1NoSentinelNoFlag)) {
                return Status.PARTIAL;
            }
        } else if (HealpixNestedBMOC.contains(hm1NoSentinelNoFlag, hNoSentinel)) {
            return HealpixNestedBMOC.selfStatus(hm1, hm1NoFlag);
        }
        return Status.EMPTY;
    }

    private static Status selfStatus(long val) {
        return (val & 1L) == 0L ? Status.PARTIAL : Status.FULL;
    }

    private static Status selfStatus(long val, long valFlagSetTo0) {
        return val == valFlagSetTo0 ? Status.PARTIAL : Status.FULL;
    }

    public static final long buildValue(int depth, long hash, boolean isFull, int depthMax) {
        hash <<= 1;
        hash |= 1L;
        hash <<= 1 + (depthMax - depth << 1);
        return hash |= isFull ? 1L : 0L;
    }

    private static final boolean aIsALargerCellThanB(long aNoFlag, long bNoFlag) {
        return HealpixNestedBMOC.aHasSmallerDepthThanB(aNoFlag, bNoFlag);
    }

    private static final boolean aHasSmallerDepthThanB(long aNoFlag, long bNoFlag) {
        return HealpixNestedBMOC.isolateRightmost1Bit(aNoFlag) < HealpixNestedBMOC.isolateRightmost1Bit(bNoFlag);
    }

    private static final long turnOffRightmost1Bit(long x) {
        return x & x - 1L;
    }

    private static final long isolateRightmost1Bit(long x) {
        return x & -x;
    }

    private static final boolean contains(long largerCellHashNoFlagNoSentinel, long smallerCellHashNoFlagNoSentinek) {
        return (largerCellHashNoFlagNoSentinel & smallerCellHashNoFlagNoSentinek) == largerCellHashNoFlagNoSentinel;
    }

    @Override
    public Iterator<CurrentValueAccessor> iterator() {
        return new Iter();
    }

    public Iterator<Range> rangeIterator() {
        return new ToRangeItDecorator(this.iterator());
    }

    public FlatHashIterator flatHashIterator() {
        return new FlatHashIterator(){
            private int i = 0;
            private long currVal = HealpixNestedBMOC.access$200(HealpixNestedBMOC.this) == 0 ? -1L : this.init();
            private long currMax;

            private long init() {
                long mocEncodedHash = HealpixNestedBMOC.this.cells[this.i++];
                int depth = HealpixNestedBMOC.getDepth(mocEncodedHash, HealpixNestedBMOC.this.depthMax);
                int depthDiff = HealpixNestedBMOC.this.depthMax - depth;
                long hash = HealpixNestedBMOC.getHashFromDepthDiff(mocEncodedHash, depthDiff);
                int twiceDepthDiff = depthDiff << 1;
                this.currVal = hash << twiceDepthDiff;
                this.currMax = this.currVal | (1L << twiceDepthDiff) - 1L;
                return this.currVal;
            }

            private void internalNext() {
                if (this.currVal < this.currMax) {
                    ++this.currVal;
                } else if (this.i < HealpixNestedBMOC.this.to) {
                    this.init();
                } else {
                    this.currVal = -1L;
                }
            }

            @Override
            public int depth() {
                return HealpixNestedBMOC.this.depthMax;
            }

            @Override
            public boolean hasNext() {
                return this.currVal != -1L;
            }

            @Override
            public long next() {
                long res = this.currVal;
                if (res == -1L) {
                    throw new NoSuchElementException();
                }
                this.internalNext();
                return res;
            }
        };
    }

    private final class Iter
    implements Iterator<CurrentValueAccessor>,
    CurrentValueAccessor {
        private int i = 0;
        private long h = -1L;
        private int d = 0;

        private Iter() {
        }

        @Override
        public long getRawValue() {
            return this.h;
        }

        @Override
        public int getDepth() {
            return HealpixNestedBMOC.this.depthMax - this.d;
        }

        @Override
        public long getHash() {
            return this.h >> 2 + (this.d << 1);
        }

        @Override
        public boolean isFull() {
            return HealpixNestedBMOC.isFull(this.h);
        }

        @Override
        public boolean hasNext() {
            return this.i < HealpixNestedBMOC.this.to;
        }

        @Override
        public CurrentValueAccessor next() {
            this.h = HealpixNestedBMOC.this.cells[this.i++];
            this.d = Long.numberOfTrailingZeros(this.h >> 1) >> 1;
            return this;
        }

        public String toString() {
            return String.format("d: %d; h: %d; full: %s; raw: %d", this.getDepth(), this.getHash(), this.isFull(), this.getRawValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface CurrentValueAccessor {
        public long getRawValue();

        public int getDepth();

        public long getHash();

        public boolean isFull();
    }

    public static enum Status {
        EMPTY,
        PARTIAL,
        FULL;

    }
}

