/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core;

import edu.jhu.htm.core.Domain;
import edu.jhu.htm.core.ErrorHandler;
import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMedge;
import edu.jhu.htm.core.HTMfunc;
import edu.jhu.htm.core.HTMindex;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.Layer;
import edu.jhu.htm.core.QuadNode;
import edu.jhu.htm.core.Vector3d;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class HTMindexImp
implements HTMindex {
    public int maxlevel_;
    public int buildlevel_;
    public int addlevel_;
    protected int leaves_;
    protected int storedleaves_;
    protected List nodes_;
    protected List layers_;
    protected List vertices_;
    protected int index_;
    protected int nNodes_;
    protected int nVertices_;
    protected int lastSavedLeafIndex_;
    static final int IOFFSET = 9;

    public HTMindexImp(double d) throws HTMException {
        int n = 5;
        double d2 = 2.8125;
        while (d2 > d && n < 25) {
            d2 /= 2.0;
            ++n;
        }
        if (d2 > d) {
            ErrorHandler.handleError(-5);
        }
        this.init(n, 5);
    }

    public HTMindexImp() {
        this(20, 5);
    }

    public HTMindexImp(int n) {
        this(n, 5);
    }

    public HTMindexImp(int n, int n2) {
        this.init(n, n2);
    }

    protected void init(int n, int n2) {
        this.maxlevel_ = n;
        this.buildlevel_ = n2 == 0 || n2 > n ? n : n2;
        this.addlevel_ = n - this.buildlevel_;
        this.layers_ = new ArrayList(this.buildlevel_);
        this.vMax();
        if (HTMfunc.verbose) {
            System.out.println(this.nNodes_ + " Nodes " + this.nVertices_ + " Vertices ");
            System.out.println(this.leaves_ + " Leaf Nodes " + this.storedleaves_ + " Stored");
        }
        this.nodes_ = new ArrayList(this.nNodes_);
        this.vertices_ = new ArrayList(this.nVertices_);
        QuadNode quadNode = new QuadNode();
        quadNode.index_ = 0;
        this.nodes_.add(0, quadNode);
        Layer layer = new Layer();
        layer.level_ = 0;
        layer.nVert_ = 6;
        layer.nNode_ = 8;
        layer.nEdge_ = 12;
        layer.firstIndex_ = 1;
        layer.firstVertex_ = 0;
        this.layers_.add(0, layer);
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}};
        int n3 = 0;
        while (n3 < 6) {
            Vector3d vector3d = new Vector3d(dArrayArray[n3][0], dArrayArray[n3][1], dArrayArray[n3][2]);
            this.vertices_.add(n3, vector3d);
            ++n3;
        }
        this.index_ = 1;
        this.newNode(1, 5, 2, 8L, 0);
        this.newNode(2, 5, 3, 9L, 0);
        this.newNode(3, 5, 4, 10L, 0);
        this.newNode(4, 5, 1, 11L, 0);
        this.newNode(1, 0, 4, 12L, 0);
        this.newNode(4, 0, 3, 13L, 0);
        this.newNode(3, 0, 2, 14L, 0);
        this.newNode(2, 0, 1, 15L, 0);
        int n4 = 0;
        int n5 = this.buildlevel_;
        while (n5-- > 0) {
            HTMedge hTMedge = new HTMedge(this, n4);
            hTMedge.makeMidPoints();
            this.makeNewLayer(n4);
            ++n4;
        }
        this.sortIndex();
    }

    public void showVertices(PrintStream printStream) {
        int n = 0;
        while (n < this.vertices_.size() - 1) {
            printStream.println(this.vertices_.get(n));
            ++n;
        }
    }

    public int[] nodeVertexIds(int n) {
        return this.getNode((int)n).v_;
    }

    public Vector3d[] nodeVertex(int n) {
        Vector3d[] vector3dArray = new Vector3d[3];
        if (this.buildlevel_ == this.maxlevel_) {
            int n2 = n + 9;
            QuadNode quadNode = this.getNode(n2);
            int n3 = 0;
            while (n3 < 3) {
                vector3dArray[n3] = this.getVertex(quadNode.v_[n3]);
                ++n3;
            }
            return vector3dArray;
        }
        int n4 = this.idByLeafNumber(n);
        int n5 = n4 >> (this.maxlevel_ - this.buildlevel_) * 2;
        int n6 = n5 - this.storedleaves_ + 9;
        QuadNode quadNode = this.getNode(n6);
        int n7 = 0;
        while (n7 < 3) {
            vector3dArray[n7] = this.getVertex(quadNode.v_[n7]);
            ++n7;
        }
        String string = this.nameByLeafNumber(n);
        int n8 = this.buildlevel_ + 2;
        while (n8 < this.maxlevel_ + 2) {
            Vector3d vector3d = vector3dArray[1].add(vector3dArray[2]);
            vector3d.normalize();
            Vector3d vector3d2 = vector3dArray[0].add(vector3dArray[2]);
            vector3d2.normalize();
            Vector3d vector3d3 = vector3dArray[1].add(vector3dArray[0]);
            vector3d3.normalize();
            switch (string.charAt(n8)) {
                case '0': {
                    vector3dArray[1] = vector3d3;
                    vector3dArray[2] = vector3d2;
                    break;
                }
                case '1': {
                    vector3dArray[0] = vector3dArray[1];
                    vector3dArray[1] = vector3d;
                    vector3dArray[2] = vector3d3;
                    break;
                }
                case '2': {
                    vector3dArray[0] = vector3dArray[2];
                    vector3dArray[1] = vector3d2;
                    vector3dArray[2] = vector3d;
                    break;
                }
                case '3': {
                    vector3dArray[0] = vector3d;
                    vector3dArray[1] = vector3d2;
                    vector3dArray[2] = vector3d3;
                }
            }
            ++n8;
        }
        return vector3dArray;
    }

    void makeNewLayer(int n) {
        int n2;
        int n3 = n + 1;
        Layer layer = new Layer();
        this.layers_.add(n3, layer);
        Layer layer2 = (Layer)this.layers_.get(n);
        layer.level_ = layer2.level_ + 1;
        layer.nVert_ = layer2.nVert_ + layer2.nEdge_;
        layer.nNode_ = 4 * layer2.nNode_;
        layer.nEdge_ = layer.nNode_ + layer.nVert_ - 2;
        layer.firstIndex_ = this.index_;
        layer.firstVertex_ = layer2.firstVertex_ + layer2.nVert_;
        int n4 = n2 = layer2.firstIndex_;
        while (n4 < n2 + layer2.nNode_) {
            QuadNode quadNode = this.getNode(n4);
            long l = quadNode.id_ << 2;
            quadNode.childID_[0] = this.newNode(quadNode.v_[0], quadNode.w_[2], quadNode.w_[1], l++, n4);
            quadNode.childID_[1] = this.newNode(quadNode.v_[1], quadNode.w_[0], quadNode.w_[2], l++, n4);
            quadNode.childID_[2] = this.newNode(quadNode.v_[2], quadNode.w_[1], quadNode.w_[0], l++, n4);
            quadNode.childID_[3] = this.newNode(quadNode.w_[0], quadNode.w_[1], quadNode.w_[2], l, n4);
            ++n4;
        }
    }

    public int newNode(int n, int n2, int n3, long l, int n4) {
        QuadNode quadNode = new QuadNode();
        quadNode.v_[0] = n;
        quadNode.v_[1] = n2;
        quadNode.v_[2] = n3;
        quadNode.w_[0] = 0;
        quadNode.w_[1] = 0;
        quadNode.w_[2] = 0;
        quadNode.childID_[0] = 0;
        quadNode.childID_[1] = 0;
        quadNode.childID_[2] = 0;
        quadNode.childID_[3] = 0;
        quadNode.id_ = l;
        quadNode.index_ = this.index_;
        quadNode.parent_ = n4;
        this.nodes_.add(this.index_, quadNode);
        return this.index_++;
    }

    public double area(String string) {
        Object[] objectArray = HTMfunc.nameToTriangle(string);
        Vector3d[] vector3dArray = new Vector3d[3];
        double[] dArray = null;
        int n = 0;
        while (n < 3) {
            dArray = (double[])objectArray[n];
            vector3dArray[n] = new Vector3d(dArray[0], dArray[1], dArray[2]);
            ++n;
        }
        return this.area(vector3dArray[0], vector3dArray[1], vector3dArray[2]);
    }

    public double area(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = Math.acos(vector3d.mul(vector3d2));
        double d2 = Math.acos(vector3d2.mul(vector3d3));
        double d3 = Math.acos(vector3d3.mul(vector3d));
        double d4 = (d + d2 + d3) / 2.0;
        double d5 = 4.0 * Math.atan(Math.sqrt(Math.tan(d4 / 2.0) * Math.tan((d4 - d) / 2.0) * Math.tan((d4 - d2) / 2.0) * Math.tan((d4 - d3) / 2.0)));
        return d5;
    }

    void vMax() {
        int n = 6;
        int n2 = 12;
        int n3 = 8;
        int n4 = this.buildlevel_;
        this.nNodes_ = n3;
        while (n4-- > 0) {
            n2 = (n3 *= 4) + (n += n2) - 2;
            this.nNodes_ += n3;
        }
        this.nVertices_ = n;
        this.storedleaves_ = n3;
        n4 = this.maxlevel_ - this.buildlevel_;
        while (n4-- > 0) {
            n3 *= 4;
        }
        this.leaves_ = n3;
    }

    void sortIndex() {
        QuadNode[] quadNodeArray = this.nodes_.toArray(new QuadNode[0]);
        int n = 9;
        int n2 = 9;
        int n3 = this.nodes_.size() - 1;
        while (n < this.nodes_.size()) {
            QuadNode quadNode;
            if (quadNodeArray[n].childID_[0] == 0) {
                this.nodes_.set(n2, quadNodeArray[n]);
                int n4 = 0;
                while (n4 < 4) {
                    QuadNode quadNode2 = (QuadNode)this.nodes_.get(n2);
                    quadNode = (QuadNode)this.nodes_.get(quadNode2.parent_);
                    if (quadNode.childID_[n4] == n) {
                        quadNode.childID_[n4] = n2;
                        break;
                    }
                    ++n4;
                }
                ++n2;
            } else {
                QuadNode quadNode3 = quadNodeArray[n];
                this.nodes_.set(n3, quadNode3);
                quadNodeArray[quadNode3.childID_[0]].parent_ = n3;
                quadNodeArray[quadNode3.childID_[1]].parent_ = n3;
                quadNodeArray[quadNode3.childID_[2]].parent_ = n3;
                quadNodeArray[quadNode3.childID_[3]].parent_ = n3;
                int n5 = 0;
                while (n5 < 4) {
                    quadNode = (QuadNode)this.nodes_.get(quadNode3.parent_);
                    if (quadNode.childID_[n5] == n) {
                        quadNode.childID_[n5] = n3;
                        break;
                    }
                    ++n5;
                }
                --n3;
            }
            ++n;
        }
        this.lastSavedLeafIndex_ = n2;
    }

    public long nameToId(String string) throws HTMException {
        return HTMfunc.nameToId(string);
    }

    public String idToName(long l) throws HTMException {
        return HTMfunc.idToName(l);
    }

    public long lookupId(Vector3d vector3d) throws HTMException {
        return HTMfunc.lookupId(vector3d.x(), vector3d.y(), vector3d.z(), this.maxlevel_);
    }

    public String lookup(Vector3d vector3d) throws HTMException {
        return HTMfunc.lookup(vector3d.x(), vector3d.y(), vector3d.z(), this.maxlevel_);
    }

    boolean isInside(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        if (vector3d2.cross(vector3d3).mul(vector3d) < 0.0) {
            return false;
        }
        if (vector3d3.cross(vector3d4).mul(vector3d) < 0.0) {
            return false;
        }
        return !(vector3d4.cross(vector3d2).mul(vector3d) < 0.0);
    }

    public int leafCount() {
        return this.leaves_;
    }

    public int nVertices() {
        return this.vertices_.size();
    }

    public int leafNumberById(long l) {
        return (int)(l - (long)this.leafCount());
    }

    public int idByLeafNumber(int n) {
        return this.leafCount() + n;
    }

    public String nameByLeafNumber(int n) {
        try {
            return this.idToName(this.idByLeafNumber(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String lookup(double d, double d2) throws HTMException {
        return HTMfunc.lookup(d, d2, this.maxlevel_);
    }

    public long lookupId(double d, double d2) throws HTMException {
        return HTMfunc.lookupId(d, d2, this.maxlevel_);
    }

    Vector3d getVertex(int n) {
        return (Vector3d)this.vertices_.get(n);
    }

    Vector3d V(int n, int n2) {
        return (Vector3d)this.vertices_.get(this.getNode((int)n).v_[n2]);
    }

    QuadNode getNode(int n) {
        return (QuadNode)this.nodes_.get(n);
    }

    Layer getLayer(int n) {
        return (Layer)this.layers_.get(n);
    }

    int noNodes() {
        return this.nodes_.size();
    }

    int noVertices() {
        return this.vertices_.size();
    }

    void add(Vector3d vector3d, int n) {
        this.vertices_.add(n, vector3d);
    }

    boolean isLeaf(int n) {
        return n < this.lastSavedLeafIndex_;
    }

    public Vector3d idToPoint(long l) throws HTMException {
        double[] dArray = HTMfunc.idToPoint(l);
        return new Vector3d(dArray[0], dArray[1], dArray[2]);
    }

    public Vector3d idToPoint(String string) throws HTMException {
        double[] dArray = HTMfunc.idToPoint(string);
        return new Vector3d(dArray[0], dArray[1], dArray[2]);
    }

    public Domain simplify(Domain domain) {
        return domain.simplify();
    }

    public boolean contains(Domain domain, Vector3d vector3d) {
        return domain.contains(vector3d);
    }

    public double distance(long l, long l2) throws HTMException {
        return HTMfunc.distance(l, l2);
    }

    public double distance(String string, String string2) throws HTMException {
        return HTMfunc.distance(string, string2);
    }

    public HTMrange intersect(Domain domain) {
        HTMrange hTMrange = new HTMrange();
        domain.intersect(this, hTMrange, true);
        return hTMrange;
    }

    public Domain intersection(Domain domain, Domain domain2) {
        throw new UnsupportedOperationException("Method intersection() not yet implemented.");
    }

    public Domain union(Domain domain, Domain domain2) {
        Domain domain3 = new Domain();
        domain3.add(domain);
        domain3.add(domain2);
        return domain3;
    }

    public Domain compliment(Domain domain) {
        throw new UnsupportedOperationException("Method compliment() not yet implemented.");
    }

    public Domain smooth(Domain domain) {
        throw new UnsupportedOperationException("Method smooth() not yet implemented.");
    }
}

