/*
  sqcwa -- workaround for squid not caching pages with
           <meta http-equiv="pragma" content="no-cache">
           or others
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>
                      Jos Roberto Monteiro <jrm@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* memory debug */
//#define MEMDEBUG

/* verbose mode, usefull for debug */
//#define SQCWA_VERBOSE

/* undefine to run in the command line for debugging */
#define SQCWA_DAEMON_MODE
#define PIDBASEFILENAME "sqcwa"

/* run with privileges of user 'proxy'
 * Debian systems, its uid and gid are 13
 * if you do not want the program to drop
 * privileges, use UID -1 and GID -1.
 * drop privileges is only enabled in daemon_mode */
#define SQCWA_PROXY_UID 13
#define SQCWA_PROXY_GID 13

/* PID file */

#define SQCWA_VERSION "0.3"

#include "common.h"
#include "htmlchk.h"
#include "sqclient.h"
#include "watchlog.h"
#include "daemon.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <malloc.h>

int main(int argc, char * argv[]) {
  char * ss, * sn, * si, * sdata[4];
  int i, error;
  int http_code;
  htmlchk_t * ht;
  watchlog_t * wl;

#ifdef SQCWA_DAEMON_MODE
  run_daemon_run (PIDBASEFILENAME, SQCWA_PROXY_UID, SQCWA_PROXY_GID);
#endif

  /* IMPROVE compare argv to --version, -v, --help, -h */
  fprintf(stderr,"sqcwa - SQuid Cache WorkAround\n"
	  "Version: " SQCWA_VERSION "\n"
	  "Website: http://www.autsens.com/sqcwa/\n"
	  "Usage: sqcwa [logfilename]\n"
	  "\n"
	  "sqcwa is running now...\n");

  ht = htmlchk_init ();

  if (argc>1)
    { /* user defined logfile */
      wl = watchlog_init (argv[1]);      
    }
  else
    { /* default logfile */
      fprintf(stderr,"WARNING: you did not specify a logfilename\n"
	      "         will use '/var/log/squid/access.log'\n");
      wl = watchlog_init ("/var/log/squid/access.log");
    }

  //  while ((ss = fgets(s, LOGLINEMAXSIZE, stdin))) {
  while (1) {
    int idata = 0;

    //    fprintf(stderr,"will getline\n");
    watchlog_getline(wl);
    //    fprintf(stderr,"     gotline %s\n", wl->data);
    ss = wl->data;


#ifdef MEMDEBUG
    fprintf(stderr,"memory allocated: %d\n",mallinfo().arena);
#endif

#ifdef SQCWA_VERBOSE
    fprintf(stderr,"\nfound log line: %s",ss);
#endif

    error = 0;
    //    s[LOGLINEMAXSIZE-1] = '\0';       // end line safety
    //if (strlen(s) >= LOGLINEMAXSIZE)  // verify line size
    //  continue;                // skips if it has the maximum size

    //sn = ss = strdup(s);       // copies line
    sn = ss;

    for (i = 0; i < 4; i++)
      sdata[i] = NULL;

    i = 0;
    while ((si = strsep(& sn, " \t\n\r"))) {

      if (i > 10) {
	error = 1;
	break;
      }

      if (si && strlen(si)) {

	switch (i) {
	case 2:
	case 3:
	case 6:
	case 9:
	  sdata[idata++] = strdup(si);
	  break;

	}

	i++;
      }
    }

    if (i < 10) {
      error |= 2;
    }

    if (! error) {
      http_code = -1;
      for (i = 0; i < strlen(sdata[1]) - 1; i++) {
	if (sdata[1][i] == '/') {
	  sdata[1][i+2] = '\0';
	  http_code = atoi(sdata[1]+i+1);
	}
      }

      if (strcmp(sdata[0], "127.0.0.1") != 0 &&
	  strcmp(sdata[3], "text/html") == 0 &&
	  (http_code == 2 || http_code == 3)) {

#ifdef SQCWA_VERBOSE
	fprintf(stderr," will open and check this html file. decision = ");
#endif	
	if (htmlchk_pagestate(ht,sdata[2]) == 2)
	  {
#ifdef SQCWA_VERBOSE
	    fprintf(stderr,"need to PURGE\n");
#endif	
	    sqclient_purge_from_cache(sdata[2]);
	  }
	else
	  {
#ifdef SQCWA_VERBOSE
	    fprintf(stderr,"nothing to do\n");
#endif	
	  }

      }
      else 
	{
#ifdef SQCWA_VERBOSE
	  fprintf(stderr," no need to check this logline\n");
	  /* "IP = %s  HTTP Code = %d "
	     " Mime = %s\nURL = %s\n",
	     sdata[0], http_code, sdata[3], sdata[2]); */
#endif
	}

    }
    else {
      fprintf(stderr," Error parsing logfile line. error code: %d\n", error);
    }
    
    for (i = 0; i < 4; i++)
      if (sdata[i])
	free(sdata[i]);

    //free(ss);
  }

  htmlchk_destroy(ht);
  watchlog_destroy(wl);

  return 0;

}
