/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_33 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 27213, "epsg", 27213,
        "NZGD49 / Wellington Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Wellington Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-41.30131963888888],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",174.7766231111111],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",300000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"27213\"]]");
    p = add_epsg_def (filter, first, last, 27214, "epsg", 27214,
        "NZGD49 / Collingwood Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Collingwood Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-40.71475905555556],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",172.6720465],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27214\"]]");
    p = add_epsg_def (filter, first, last, 27215, "epsg", 27215,
        "NZGD49 / Nelson Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168");
    add_proj4text (p, 1,
        "055555 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Nelson Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-41.27454472222222],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",173.2993168055555],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27215\"]]");
    p = add_epsg_def (filter, first, last, 27216, "epsg", 27216,
        "NZGD49 / Karamea Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Karamea Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-41.28991152777778],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",172.1090281944444],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27216\"]]");
    p = add_epsg_def (filter, first, last, 27217, "epsg", 27217,
        "NZGD49 / Buller Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600");
    add_proj4text (p, 1,
        "555556 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Buller Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-41.81080286111111],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",171.5812600555556],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27217\"]]");
    p = add_epsg_def (filter, first, last, 27218, "epsg", 27218,
        "NZGD49 / Grey Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713");
    add_proj4text (p, 1,
        "055556 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Grey Circuit\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",-42.33369427777778],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",171.5497713055556],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27218\"]]");
    p = add_epsg_def (filter, first, last, 27219, "epsg", 27219,
        "NZGD49 / Amuri Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333");
    add_proj4text (p, 1,
        "888889 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Amuri Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"427");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",-42.68911658333333],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",173.0101333888889],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27219\"]]");
    p = add_epsg_def (filter, first, last, 27220, "epsg", 27220,
        "NZGD49 / Marlborough Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741");
    add_proj4text (p, 1,
        "111111 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Marlborough Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-41.54448666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",173.8020741111111],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",300000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"27220\"]]");
    p = add_epsg_def (filter, first, last, 27221, "epsg", 27221,
        "NZGD49 / Hokitika Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935");
    add_proj4text (p, 1,
        " +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Hokitika Circuit\",GEOGCS[\"NZGD49\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-42.88632236111111],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",170.9799935],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",300000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"27221\"]]");
    p = add_epsg_def (filter, first, last, 27222, "epsg", 27222,
        "NZGD49 / Okarito Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Okarito Circuit\",GEOGCS[\"NZGD49\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-43.11012813888889],PARAMETER[\"cen");
    add_srs_wkt (p, 9,
        "tral_meridian\",170.2609258333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27222\"]]");
    p = add_epsg_def (filter, first, last, 27223, "epsg", 27223,
        "NZGD49 / Jacksons Bay Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Jacksons Bay Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",-43.97780288888889],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",168.606267],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AUTHORITY[\"EPSG\",\"27223\"]]");
    p = add_epsg_def (filter, first, last, 27224, "epsg", 27224,
        "NZGD49 / Mount Pleasant Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.59063758333333 +lon_0=172.7271935");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Pleasant Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5");
    add_srs_wkt (p, 4,
        "993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",-43.59063758333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",172.7271935833333],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",300000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27224\"]]");
    p = add_epsg_def (filter, first, last, 27225, "epsg", 27225,
        "NZGD49 / Gawler Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-43.74871155555556 +lon_0=171.3607484");
    add_proj4text (p, 1,
        "722222 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Gawler Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-43.74871155555556],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",171.3607484722222],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27225\"]]");
    p = add_epsg_def (filter, first, last, 27226, "epsg", 27226,
        "NZGD49 / Timaru Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508");
    add_proj4text (p, 1,
        "333333 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Timaru Circuit\",GEOGCS[\"NZGD49\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "72\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",-44.40222036111111],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",171.0572508333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"27226\"]]");
    p = add_epsg_def (filter, first, last, 27227, "epsg", 27227,
        "NZGD49 / Lindis Peak Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550");
    add_proj4text (p, 1,
        "833333 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Lindis Peak Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-44.73526797222222],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",169.4677550833333],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",300000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"27227\"]]");
    p = add_epsg_def (filter, first, last, 27228, "epsg", 27228,
        "NZGD49 / Mount Nicholas Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411");
    add_proj4text (p, 1,
        "944444 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount Nicholas Circuit\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5");
    add_srs_wkt (p, 4,
        "993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",-45.13290258333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",168.3986411944444],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",300000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",700000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"27228\"]]");
    p = add_epsg_def (filter, first, last, 27229, "epsg", 27229,
        "NZGD49 / Mount York Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617");
    add_proj4text (p, 1,
        "777778 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Mount York Circuit\",GEOGCS[\"NZGD49\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-45.56372616666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",167.7388617777778],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",300000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",700000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"27229\"]]");
    p = add_epsg_def (filter, first, last, 27230, "epsg", 27230,
        "NZGD49 / Observation Point Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=300000 +y_0=700000 +datum=nzgd49 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Observation Point Circuit\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD49\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-");
    add_srs_wkt (p, 4,
        "4.5993],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 5,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",-45.81619661111111],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",170.6285951666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",300000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27230\"]]");
    p = add_epsg_def (filter, first, last, 27231, "epsg", 27231,
        "NZGD49 / North Taieri Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891");
    add_proj4text (p, 1,
        "111111 +k=0.99996 +x_0=300000 +y_0=700000 +datum=nzgd49 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Taieri Circuit\",GEOGCS[\"NZGD49");
    add_srs_wkt (p, 1,
        "\",DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.599");
    add_srs_wkt (p, 4,
        "3],AUTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",-45.86151336111111],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",170.2825891111111],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.99996],PARAMETER[\"false_easting\",300000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",700000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"27231\"]]");
    p = add_epsg_def (filter, first, last, 27232, "epsg", 27232,
        "NZGD49 / Bluff Circuit");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 ");
    add_proj4text (p, 1,
        "+k=1 +x_0=300002.66 +y_0=699999.58 +datum=nzgd49 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / Bluff Circuit\",GEOGCS[\"NZGD49\",DATU");
    add_srs_wkt (p, 1,
        "M[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"427");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",-46.60000961111111],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",168.342872],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",300002.66],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",699999.58],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"27232\"]]");
    p = add_epsg_def (filter, first, last, 27258, "epsg", 27258,
        "NZGD49 / UTM zone 58S");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +datum=nzgd49 +units=m +no_def");
    add_proj4text (p, 1,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 58S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",165]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27258\"]]");
    p = add_epsg_def (filter, first, last, 27259, "epsg", 27259,
        "NZGD49 / UTM zone 59S");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +datum=nzgd49 +units=m +no_def");
    add_proj4text (p, 1,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 59S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",171]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27259\"]]");
    p = add_epsg_def (filter, first, last, 27260, "epsg", 27260,
        "NZGD49 / UTM zone 60S");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +datum=nzgd49 +units=m +no_def");
    add_proj4text (p, 1,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / UTM zone 60S\",GEOGCS[\"NZGD49\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4272");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",177]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",500000],PARAMETER[\"false_northing\",10000000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"27260\"]]");
    p = add_epsg_def (filter, first, last, 27291, "epsg", 27291,
        "NZGD49 / North Island Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.524");
    add_proj4text (p, 1,
        "3848086 +y_0=365759.3658464114 +datum=nzgd49 +to_meter=0");
    add_proj4text (p, 2,
        ".9143984146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / North Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-39],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",175.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",300000],PARAMETER[\"false_northing\",400000],U");
    add_srs_wkt (p, 11,
        "NIT[\"British yard (Sears 1922)\",0.9143984146160287,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27291\"]]");
    p = add_epsg_def (filter, first, last, 27292, "epsg", 27292,
        "NZGD49 / South Island Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.207");
    add_proj4text (p, 1,
        "3080143 +y_0=457199.2073080143 +datum=nzgd49 +to_meter=0");
    add_proj4text (p, 2,
        ".9143984146160287 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD49 / South Island Grid\",GEOGCS[\"NZGD49\",");
    add_srs_wkt (p, 1,
        "DATUM[\"New_Zealand_Geodetic_Datum_1949\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6272\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4272\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",-44],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",171.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",500000],U");
    add_srs_wkt (p, 11,
        "NIT[\"British yard (Sears 1922)\",0.9143984146160287,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9040\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"27292\"]]");
    p = add_epsg_def (filter, first, last, 27391, "epsg", 27391,
        "NGO 1948 (Oslo) / NGO zone I");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone I\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",58],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-4.666666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27391\"]]");
    p = add_epsg_def (filter, first, last, 27392, "epsg", 27392,
        "NGO 1948 (Oslo) / NGO zone II");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=");
    add_proj4text (p, 2,
        "278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone II\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-2.333333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27392\"]]");
    p = add_epsg_def (filter, first, last, 27393, "epsg", 27393,
        "NGO 1948 (Oslo) / NGO zone III");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=637");
    add_proj4text (p, 1,
        "7492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.");
    add_proj4text (p, 2,
        "889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone III\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.722916666");
    add_srs_wkt (p, 5,
        "66667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27393\"]]");
    p = add_epsg_def (filter, first, last, 27394, "epsg", 27394,
        "NGO 1948 (Oslo) / NGO zone IV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,");
    add_proj4text (p, 2,
        "7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone IV\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",2.5],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"x\",NOR");
    add_srs_wkt (p, 12,
        "TH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"27394\"]]");
    p = add_epsg_def (filter, first, last, 27395, "epsg", 27395,
        "NGO 1948 (Oslo) / NGO zone V");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone V\",GEOGCS[\"NGO 194");
    add_srs_wkt (p, 1,
        "8 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mod");
    add_srs_wkt (p, 2,
        "ified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666666");
    add_srs_wkt (p, 5,
        "667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 6,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",58],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",6.166666666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27395\"]]");
    p = add_epsg_def (filter, first, last, 27396, "epsg", 27396,
        "NGO 1948 (Oslo) / NGO zone VI");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VI\",GEOGCS[\"NGO 19");
    add_srs_wkt (p, 1,
        "48 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel Mo");
    add_srs_wkt (p, 2,
        "dified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "05\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.7229166666");
    add_srs_wkt (p, 5,
        "6667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 6,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",10.16666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27396\"]]");
    p = add_epsg_def (filter, first, last, 27397, "epsg", 27397,
        "NGO 1948 (Oslo) / NGO zone VII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VII\",GEOGCS[\"NGO 1");
    add_srs_wkt (p, 1,
        "948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel M");
    add_srs_wkt (p, 2,
        "odified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.722916666");
    add_srs_wkt (p, 5,
        "66667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 7,
        "EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_origin\",58],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",14.16666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "27397\"]]");
    p = add_epsg_def (filter, first, last, 27398, "epsg", 27398,
        "NGO 1948 (Oslo) / NGO zone VIII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=2");
    add_proj4text (p, 2,
        "78.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +n");
    add_proj4text (p, 3,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGO 1948 (Oslo) / NGO zone VIII\",GEOGCS[\"NGO ");
    add_srs_wkt (p, 1,
        "1948 (Oslo)\",DATUM[\"NGO_1948_Oslo\",SPHEROID[\"Bessel ");
    add_srs_wkt (p, 2,
        "Modified\",6377492.018,299.1528128,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7005\"]],TOWGS84[278.3,93,474.5,7.889,0.05,-6.61,6.21],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6817\"]],PRIMEM[\"Oslo\",10.72291666");
    add_srs_wkt (p, 5,
        "666667,AUTHORITY[\"EPSG\",\"8913\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4817\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",58],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",18.33333333333333],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"27398\"]]");
    p = add_epsg_def (filter, first, last, 27429, "epsg", 27429,
        "Datum 73 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=intl +towgs84=-223.237,110.193");
    add_proj4text (p, 1,
        ",36.649,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / UTM zone 29N\",GEOGCS[\"Datum 73\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Datum_73\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-223.237,110");
    add_srs_wkt (p, 3,
        ".193,36.649,0,0,0,0],AUTHORITY[\"EPSG\",\"6274\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4274\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-9],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"27429\"]]");
    p = add_epsg_def (filter, first, last, 27492, "epsg", 27492,
        "Datum 73 / Modified Portuguese Grid (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-223.237,110.193,36.649,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6274\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",39.66666666666666],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-8.131906111111112],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",180.598],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",-86.99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"27492\"]]");
    p = add_epsg_def (filter, first, last, 27493, "epsg", 27493,
        "Datum 73 / Modified Portuguese Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111");
    add_proj4text (p, 1,
        "111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=");
    add_proj4text (p, 2,
        "intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Datum 73 / Modified Portuguese Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Datum 73\",DATUM[\"Datum_73\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-223.237,110.193,36.649,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "74\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4274\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "9.66666666666666],PARAMETER[\"central_meridian\",-8.1319");
    add_srs_wkt (p, 9,
        "06111111112],PARAMETER[\"scale_factor\",1],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",180.598],PARAMETER[\"false_northing\",-86");
    add_srs_wkt (p, 11,
        ".99],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2749");
    add_srs_wkt (p, 13,
        "3\"]]");
    p = add_epsg_def (filter, first, last, 27500, "epsg", 27500,
        "ATF (Paris) / Nord de Guerre");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=5.4 +k_0=0.99950908 +x_0=500000 +y_0=300000 +");
    add_proj4text (p, 2,
        "a=6376523 +b=6355862.933255573 +pm=2.337208333333333 +un");
    add_proj4text (p, 3,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ATF (Paris) / Nord de Guerre\",GEOGCS[\"ATF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Ancienne_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Plessis 1817\",6376523,308.64,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7027\"]],AUTHORITY[\"EPSG\",\"6901\"]],PRIMEM[\"Pa");
    add_srs_wkt (p, 4,
        "ris RGS\",2.337208333333333,AUTHORITY[\"EPSG\",\"8914\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9105\"]],AUTHORITY[\"EPSG\",\"4901\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",55],PARAMETER[\"central_meridian\",6],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.99950908],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",300000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"27500\"]]");
    p = add_epsg_def (filter, first, last, 27561, "epsg", 27561,
        "NTF (Paris) / Lambert Nord France");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Nord France\",GEOGCS[\"NT");
    add_srs_wkt (p, 1,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 2,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 3,
        "2936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,3");
    add_srs_wkt (p, 4,
        "20,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 5,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 6,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_");
    add_srs_wkt (p, 8,
        "Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".999877341],PARAMETER[\"false_easting\",600000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"27561\"]]");
    p = add_epsg_def (filter, first, last, 27562, "epsg", 27562,
        "NTF (Paris) / Lambert Centre France");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Centre France\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AU");
    add_srs_wkt (p, 7,
        "THORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conform");
    add_srs_wkt (p, 8,
        "al_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99987742],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"27562\"]]");
    p = add_epsg_def (filter, first, last, 27563, "epsg", 27563,
        "NTF (Paris) / Lambert Sud France");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Sud France\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 6,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "999877499],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"27563\"]]");
    p = add_epsg_def (filter, first, last, 27564, "epsg", 27564,
        "NTF (Paris) / Lambert Corse");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert Corse\",GEOGCS[\"NTF (Par");
    add_srs_wkt (p, 1,
        "is)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021293626");
    add_srs_wkt (p, 3,
        "9,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,0");
    add_srs_wkt (p, 4,
        ",0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.3");
    add_srs_wkt (p, 5,
        "3722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.01");
    add_srs_wkt (p, 6,
        "570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 8,
        "_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "9994471],PARAMETER[\"false_easting\",234.358],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",185861.369],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"27564\"]]");
    p = add_epsg_def (filter, first, last, 27571, "epsg", 27571,
        "NTF (Paris) / Lambert zone I");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone I\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 1,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 3,
        "69,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 5,
        "33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0");
    add_srs_wkt (p, 6,
        "1570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_1SP\"],PARAMETER[\"latitude_of_origin\",55],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",0],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "877341],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",1200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"27571\"]]");
    p = add_epsg_def (filter, first, last, 27572, "epsg", 27572,
        "NTF (Paris) / Lambert zone II");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 5,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 6,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "987742],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"27572\"]]");
    p = add_epsg_def (filter, first, last, 27573, "epsg", 27573,
        "NTF (Paris) / Lambert zone III");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 1,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 5,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 6,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "9877499],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"27573\"]]");
    p = add_epsg_def (filter, first, last, 27574, "epsg", 27574,
        "NTF (Paris) / Lambert zone IV");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Lambert zone IV\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 1,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 3,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 4,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 5,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 6,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORIT");
    add_srs_wkt (p, 7,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 8,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".99994471],PARAMETER[\"false_easting\",234.358],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",4185861.369],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"27574\"]]");
    p = add_epsg_def (filter, first, last, 27581, "epsg", 27581,
        "NTF (Paris) / France I (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France I (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AU");
    add_srs_wkt (p, 7,
        "THORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conform");
    add_srs_wkt (p, 8,
        "al_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.999877341],PARAMETER[\"false_easting\",600000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",1200000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"27581\"]]");
    p = add_epsg_def (filter, first, last, 27582, "epsg", 27582,
        "NTF (Paris) / France II (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AU");
    add_srs_wkt (p, 7,
        "THORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conform");
    add_srs_wkt (p, 8,
        "al_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99987742],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",2200000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"27582\"]]");
    p = add_epsg_def (filter, first, last, 27583, "epsg", 27583,
        "NTF (Paris) / France III (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France III (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 3,
        "60212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-");
    add_srs_wkt (p, 4,
        "60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"P");
    add_srs_wkt (p, 5,
        "aris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",49],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",0],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999877499],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",3200000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"27583\"]]");
    p = add_epsg_def (filter, first, last, 27584, "epsg", 27584,
        "NTF (Paris) / France IV (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.3");
    add_proj4text (p, 2,
        "69 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0");
    add_proj4text (p, 3,
        " +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / France IV (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 3,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 4,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 5,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 6,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AU");
    add_srs_wkt (p, 7,
        "THORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conform");
    add_srs_wkt (p, 8,
        "al_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.99994471],PARAMETER[\"false_easting\",234.358],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",4185861.369],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"27584\"]]");
    p = add_epsg_def (filter, first, last, 27591, "epsg", 27591,
        "NTF (Paris) / Nord France (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Nord France (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francais");
    add_srs_wkt (p, 2,
        "e_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4");
    add_srs_wkt (p, 3,
        "660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,");
    add_srs_wkt (p, 4,
        "-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",55],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.999877341],PARAMETER[\"false_easting\",600000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",200000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"27591\"]]");
    p = add_epsg_def (filter, first, last, 27592, "epsg", 27592,
        "NTF (Paris) / Centre France (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towg");
    add_proj4text (p, 2,
        "s84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Centre France (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Franca");
    add_srs_wkt (p, 2,
        "ise_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293");
    add_srs_wkt (p, 3,
        ".4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-16");
    add_srs_wkt (p, 4,
        "8,-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[");
    add_srs_wkt (p, 5,
        "\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.99987742],PARAMETER[\"false_easting\",600000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",200000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"27592\"]]");
    p = add_epsg_def (filter, first, last, 27593, "epsg", 27593,
        "NTF (Paris) / Sud France (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a");
    add_proj4text (p, 2,
        "=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=");
    add_proj4text (p, 3,
        "paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Sud France (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 3,
        "60212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-");
    add_srs_wkt (p, 4,
        "60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"P");
    add_srs_wkt (p, 5,
        "aris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 6,
        "rad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",49],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",0],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.999877499],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",200000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"27593\"]]");
    p = add_epsg_def (filter, first, last, 27594, "epsg", 27594,
        "NTF (Paris) / Corse (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.36");
    add_proj4text (p, 2,
        "9 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 ");
    add_proj4text (p, 3,
        "+pm=paris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NTF (Paris) / Corse (deprecated)\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 6,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 8,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",46.85],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",0],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.99994471],PARAMETER[\"false_easting\",234.358],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",185861.369],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"27594\"]]");
    p = add_epsg_def (filter, first, last, 27700, "epsg", 27700,
        "OSGB 1936 / British National Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +datum=OSGB36 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSGB 1936 / British National Grid\",GEOGCS[\"OS");
    add_srs_wkt (p, 1,
        "GB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy 1830\",637");
    add_srs_wkt (p, 2,
        "7563.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[375,-111,431,0,0,0,0],AUTHORITY[\"EPSG\",\"6277\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4277\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",49],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-2],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996012717],PARAMETER[\"false_easting\",400000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",-100000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"27700\"]]");
    p = add_epsg_def (filter, first, last, 28191, "epsg", 28191,
        "Palestine 1923 / Palestine Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=126867.909 +a=6378300.789 +b=6");
    add_proj4text (p, 2,
        "356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.4");
    add_proj4text (p, 3,
        "2,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Grid\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.4663155389811,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7010\"]],TOWGS84[-275.722,94.7824,340.894,-8.");
    add_srs_wkt (p, 4,
        "001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6281\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Sold");
    add_srs_wkt (p, 8,
        "ner\"],PARAMETER[\"latitude_of_origin\",31.7340969444444");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",35.21208055555556],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",170251.555],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"28191\"]]");
    p = add_epsg_def (filter, first, last, 28192, "epsg", 28192,
        "Palestine 1923 / Palestine Belt");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.212080555");
    add_proj4text (p, 1,
        "55556 +k=1 +x_0=170251.555 +y_0=1126867.909 +a=6378300.7");
    add_proj4text (p, 2,
        "89 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.0");
    add_proj4text (p, 3,
        "01,-4.42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Palestine Belt\",GEOGCS[\"Pale");
    add_srs_wkt (p, 1,
        "stine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (Benoit)\",6378300.789,293.4663155389811,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7010\"]],TOWGS84[-275.722,94.7824,340.894,-8.");
    add_srs_wkt (p, 4,
        "001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6281\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",31.734096944");
    add_srs_wkt (p, 9,
        "44445],PARAMETER[\"central_meridian\",35.21208055555556]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",170251.555],PARAMETER[\"false_northing\",1126867.909]");
    add_srs_wkt (p, 12,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"28192\"]]");
    p = add_epsg_def (filter, first, last, 28193, "epsg", 28193,
        "Palestine 1923 / Israeli CS Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=31.73409694444445 +lon_0=35.2120805555");
    add_proj4text (p, 1,
        "5556 +x_0=170251.555 +y_0=1126867.909 +a=6378300.789 +b=");
    add_proj4text (p, 2,
        "6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.");
    add_proj4text (p, 3,
        "42,-11.821,1 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Palestine 1923 / Israeli CS Grid\",GEOGCS[\"Pal");
    add_srs_wkt (p, 1,
        "estine 1923\",DATUM[\"Palestine_1923\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1880 (Benoit)\",6378300.789,293.4663155389811,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7010\"]],TOWGS84[-275.722,94.7824,340.894,-8");
    add_srs_wkt (p, 4,
        ".001,-4.42,-11.821,1],AUTHORITY[\"EPSG\",\"6281\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4281\"]],PROJECTION[\"Cassini_Sol");
    add_srs_wkt (p, 8,
        "dner\"],PARAMETER[\"latitude_of_origin\",31.734096944444");
    add_srs_wkt (p, 9,
        "45],PARAMETER[\"central_meridian\",35.21208055555556],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",170251.555],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",1126867.909],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"28193\"]]");
    p = add_epsg_def (filter, first, last, 28232, "epsg", 28232,
        "Pointe Noire / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 1,
        "84=-148,51,-291,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pointe Noire / UTM zone 32S\",GEOGCS[\"Pointe N");
    add_srs_wkt (p, 1,
        "oire\",DATUM[\"Congo_1960_Pointe_Noire\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1880 (IGN)\",6378249.2,293.4660212936269,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7011\"]],TOWGS84[-148,51,-291,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6282\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4282\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2823");
    add_srs_wkt (p, 13,
        "2\"]]");
    p = add_epsg_def (filter, first, last, 28348, "epsg", 28348,
        "GDA94 / MGA zone 48");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 48\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",105],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28348\"]]");
    p = add_epsg_def (filter, first, last, 28349, "epsg", 28349,
        "GDA94 / MGA zone 49");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 49\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",111],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28349\"]]");
    p = add_epsg_def (filter, first, last, 28350, "epsg", 28350,
        "GDA94 / MGA zone 50");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 50\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",117],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28350\"]]");
    p = add_epsg_def (filter, first, last, 28351, "epsg", 28351,
        "GDA94 / MGA zone 51");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 51\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",123],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28351\"]]");
    p = add_epsg_def (filter, first, last, 28352, "epsg", 28352,
        "GDA94 / MGA zone 52");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 52\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",129],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28352\"]]");
    p = add_epsg_def (filter, first, last, 28353, "epsg", 28353,
        "GDA94 / MGA zone 53");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 53\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",135],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28353\"]]");
    p = add_epsg_def (filter, first, last, 28354, "epsg", 28354,
        "GDA94 / MGA zone 54");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 54\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",141],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28354\"]]");
    p = add_epsg_def (filter, first, last, 28355, "epsg", 28355,
        "GDA94 / MGA zone 55");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 55\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",147],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28355\"]]");
    p = add_epsg_def (filter, first, last, 28356, "epsg", 28356,
        "GDA94 / MGA zone 56");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 56\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",153],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28356\"]]");
    p = add_epsg_def (filter, first, last, 28357, "epsg", 28357,
        "GDA94 / MGA zone 57");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 57\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",159],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28357\"]]");
    p = add_epsg_def (filter, first, last, 28358, "epsg", 28358,
        "GDA94 / MGA zone 58");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 58\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",165],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"28358\"]]");
    p = add_epsg_def (filter, first, last, 28402, "epsg", 28402,
        "Pulkovo 1942 / Gauss-Kruger zone 2 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 2 (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.1");
    add_srs_wkt (p, 4,
        "2],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28402\"]]");
    p = add_epsg_def (filter, first, last, 28403, "epsg", 28403,
        "Pulkovo 1942 / Gauss-Kruger zone 3 (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 3 (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.1");
    add_srs_wkt (p, 4,
        "2],AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 12,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28403\"]]");
    p = add_epsg_def (filter, first, last, 28404, "epsg", 28404,
        "Pulkovo 1942 / Gauss-Kruger zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",21],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",450");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"28404\"]]");
    p = add_epsg_def (filter, first, last, 28405, "epsg", 28405,
        "Pulkovo 1942 / Gauss-Kruger zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",27],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",550");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"28405\"]]");
    p = add_epsg_def (filter, first, last, 28406, "epsg", 28406,
        "Pulkovo 1942 / Gauss-Kruger zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",33],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",650");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"28406\"]]");
    p = add_epsg_def (filter, first, last, 28407, "epsg", 28407,
        "Pulkovo 1942 / Gauss-Kruger zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",39],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",750");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"28407\"]]");
    p = add_epsg_def (filter, first, last, 28408, "epsg", 28408,
        "Pulkovo 1942 / Gauss-Kruger zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",45],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",850");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"28408\"]]");
    p = add_epsg_def (filter, first, last, 28409, "epsg", 28409,
        "Pulkovo 1942 / Gauss-Kruger zone 9");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",0],PARAMETER[\"central_meridian\",51],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1],PARAMETER[\"false_easting\",950");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"28409\"]]");
    p = add_epsg_def (filter, first, last, 28410, "epsg", 28410,
        "Pulkovo 1942 / Gauss-Kruger zone 10");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",57],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",10");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28410\"]]");
    p = add_epsg_def (filter, first, last, 28411, "epsg", 28411,
        "Pulkovo 1942 / Gauss-Kruger zone 11");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",63],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",11");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28411\"]]");
    p = add_epsg_def (filter, first, last, 28412, "epsg", 28412,
        "Pulkovo 1942 / Gauss-Kruger zone 12");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",69],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",12");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28412\"]]");
    p = add_epsg_def (filter, first, last, 28413, "epsg", 28413,
        "Pulkovo 1942 / Gauss-Kruger zone 13");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",75],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",13");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28413\"]]");
    p = add_epsg_def (filter, first, last, 28414, "epsg", 28414,
        "Pulkovo 1942 / Gauss-Kruger zone 14");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",81],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",14");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28414\"]]");
    p = add_epsg_def (filter, first, last, 28415, "epsg", 28415,
        "Pulkovo 1942 / Gauss-Kruger zone 15");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",87],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",15");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28415\"]]");
    p = add_epsg_def (filter, first, last, 28416, "epsg", 28416,
        "Pulkovo 1942 / Gauss-Kruger zone 16");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",93],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",16");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28416\"]]");
    p = add_epsg_def (filter, first, last, 28417, "epsg", 28417,
        "Pulkovo 1942 / Gauss-Kruger zone 17");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",99],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",17");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28417\"]]");
    p = add_epsg_def (filter, first, last, 28418, "epsg", 28418,
        "Pulkovo 1942 / Gauss-Kruger zone 18");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",105],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "8500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28418\"]]");
    p = add_epsg_def (filter, first, last, 28419, "epsg", 28419,
        "Pulkovo 1942 / Gauss-Kruger zone 19");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",111],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",1");
    add_srs_wkt (p, 10,
        "9500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28419\"]]");
    p = add_epsg_def (filter, first, last, 28420, "epsg", 28420,
        "Pulkovo 1942 / Gauss-Kruger zone 20");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",117],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "0500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28420\"]]");
    p = add_epsg_def (filter, first, last, 28421, "epsg", 28421,
        "Pulkovo 1942 / Gauss-Kruger zone 21");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",123],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "1500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28421\"]]");
    p = add_epsg_def (filter, first, last, 28422, "epsg", 28422,
        "Pulkovo 1942 / Gauss-Kruger zone 22");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",129],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "2500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28422\"]]");
    p = add_epsg_def (filter, first, last, 28423, "epsg", 28423,
        "Pulkovo 1942 / Gauss-Kruger zone 23");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",135],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "3500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28423\"]]");
    p = add_epsg_def (filter, first, last, 28424, "epsg", 28424,
        "Pulkovo 1942 / Gauss-Kruger zone 24");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",141],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "4500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28424\"]]");
    p = add_epsg_def (filter, first, last, 28425, "epsg", 28425,
        "Pulkovo 1942 / Gauss-Kruger zone 25");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",147],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "5500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28425\"]]");
    p = add_epsg_def (filter, first, last, 28426, "epsg", 28426,
        "Pulkovo 1942 / Gauss-Kruger zone 26");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",153],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "6500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28426\"]]");
    p = add_epsg_def (filter, first, last, 28427, "epsg", 28427,
        "Pulkovo 1942 / Gauss-Kruger zone 27");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",159],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "7500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28427\"]]");
    p = add_epsg_def (filter, first, last, 28428, "epsg", 28428,
        "Pulkovo 1942 / Gauss-Kruger zone 28");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",165],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "8500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28428\"]]");
    p = add_epsg_def (filter, first, last, 28429, "epsg", 28429,
        "Pulkovo 1942 / Gauss-Kruger zone 29");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",171],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "9500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28429\"]]");
    p = add_epsg_def (filter, first, last, 28430, "epsg", 28430,
        "Pulkovo 1942 / Gauss-Kruger zone 30");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82");
    add_proj4text (p, 2,
        ",-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",177],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",3");
    add_srs_wkt (p, 10,
        "0500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"28430\"]]");
    p = add_epsg_def (filter, first, last, 28431, "epsg", 28431,
        "Pulkovo 1942 / Gauss-Kruger zone 31");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.8");
    add_proj4text (p, 2,
        "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-177],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "31500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",EAST],AUTHORITY[\"EPSG\",\"28431\"]]");
    p = add_epsg_def (filter, first, last, 28432, "epsg", 28432,
        "Pulkovo 1942 / Gauss-Kruger zone 32");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.8");
    add_proj4text (p, 2,
        "2,-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4284\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-171],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "32500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",EAST],AUTHORITY[\"EPSG\",\"28432\"]]");
    p = add_epsg_def (filter, first, last, 28462, "epsg", 28462,
        "Pulkovo 1942 / Gauss-Kruger 2N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +e");
    add_proj4text (p, 1,
        "llps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.");
    add_proj4text (p, 2,
        "12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 2N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28462\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

