-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
function Substitute_Protected_Type_Self_Reference (Sym, Prefix_Symbol : Dictionary.Symbol) return Dictionary.Symbol is
   Result : Dictionary.Symbol;
begin
   -- if Sym is the implicitly-declared own variable of a protected type
   -- then we must replace it with the "current instance of the protected object"
   -- before checking whether it is visible.
   -- Background: given protected type PT its operations will globally reference and
   -- derive PT meaning, in this case, "myself".
   -- If an object PO of type PT (or a subtype of PT) is declared then calls to its
   -- operations will take the form PO.Op and the calling environment will be annotated
   -- in terms of PO.  Therefore, when checking that the globals necessary for the call
   -- PO.Op are visible (for example), we need to replace all references to PT into
   -- references to PO before making the check.  The Prefix Symbol of the call is the
   -- symbol we need to substitute in.
   Result := Sym;
   if Dictionary.IsOwnVariable (Sym) and then Dictionary.IsProtectedType (Dictionary.GetOwner (Sym)) then
      Result := Prefix_Symbol;
   end if;
   return Result;
end Substitute_Protected_Type_Self_Reference;
