separate (ErrorHandler.Conversions.ToString.UsageError)
procedure UsageErrorExpl (E_Str   : in out E_Strings.T)

is
begin
   case Err_Type is
      when ErrorHandler.Redefined_Import =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "The updating of imported-only variables is forbidden under all" &
              " circumstances.");
      when ErrorHandler.Ineffective_Import =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "The meaning of this message is explained in Section 4.2 of Appendix A");
      when ErrorHandler.Referenced_But_Not_In_Partition =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "This message is only issued when processing the partition annotation.  The partition annotation" &
              " must describe all the actions of the tasks and interrupt handlers making up the program.  Therefore," &
              " if a variable is imported somewhere in the program by a task or interrupt handler, then it must" &
              " also be an import at the partition level.  As well as the omission of explicit imports, this message is also" &
              " generated if the implicit imports of tasks and interrupt handlers are omitted.  For tasks this means" &
              " any variable the task suspends on and for interrupt handlers it means the name of the protected" &
              " object containing the handler or, if given, the name of the interrupt stream associated with the" &
              " handler.");
      when ErrorHandler.Updated_But_Not_In_Partition =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "This message is only issued when processing the partition annotation.  The partition annotation" &
              " must describe all the actions of the tasks and interrupt handlers making up the program.  Therefore," &
              " if a variable is exported somewhere in the program by a task or interrupt handler, then it must" &
              " also be an export at the partition level.");
      when ErrorHandler.Uninitialized_Protected_Element =>
         E_Strings.Append_String
            (E_Str => E_Str,
             Str   => "To avoid potential race conditions during program startup, all" &
              " elements of a protected type must be initialized with a constant value" &
              " at the point of declaration.");
      when others => null;
   end case;
end UsageErrorExpl;
