5.6 変数値

# 変数値

コードを書いていく中で役に立つことは、覚えやすい名前を作成することです。 Sonic Piはこれをとても簡単に作ることができます。あなたが使用したいと思う名前に続けて、
等号のイコール(`=`)を書き、そのあとに覚えておきたい名前を書きます。

```
sample_name = :loop_amen
```

ここで変数`sample_name`は`:loop_amen`という記号として記憶されます。
sample_nameを使うときはどこでも`:loop_amen`を使ったことになるのです。
例、

```
sample_name = :loop_amen
sample sample_name
```

Sonic Piでは変数を使う際、3つの主要な使い方があります。意味の伝達、繰り返しの操作、そして結果の獲得です。

## 意味の伝達

コードを書くとき、あなたはコンピュータが理解しOKを出してくれることだけを考え、どのようにコンピュータに伝えて動作させるのかを意識するだけであれば、それは簡単な事ですね。しかし、覚えておかなくてはいけない大事なことは、コンピュータがコードを読むということだけではないということです。他の人もそれを読み、何が起こっているか理解をしようとするでしょう。あなた自身も将来、自分の書いたコードを見返して、どんなことをしたのか？理解する必要がある時が来るかもしれません。たぶん確実にあなたにも他の人にも、そういったことが起こるのです!

あなたのコードがどのように動いているのか他人が理解をするためにコメントを書く（前章で確認できます）という方法があります。もう一つの方法として、理解しやすい変数名を使うという方法があります。

```
sleep 1.7533
```

上の例だけを見ると、なぜ `1.7533`という数値を使ったのでしょう？その数値はどこから来たのか？それは何を意味しているのか？という疑問がわきます。しかし、次のコードを見てみましょう。

```
loop_amen_duration = 1.7533
sleep loop_amen_duration
```
こう書くとすぐに `1.7533` がサンプル音源`:loop_amen`の長さであるということがわかりますね。もちろん、下記のように一行に書くことも可能です。

```
sleep sample_duration(:loop_amen)
```

どちらを用いたとしても、コードの意味がよりわかりやすいものになりました。

## 繰り返しの操作

コードの中では沢山の繰り返しが頻繁に見られます。また、もし何かを変更したいときは、膨大な場所を変更する必要も出てきます。次のコードをみて下さい。

```
sample :loop_amen
sleep sample_duration(:loop_amen)
sample :loop_amen, rate: 0.5
sleep sample_duration(:loop_amen, rate: 0.5)
sample :loop_amen
sleep sample_duration(:loop_amen)
```

`:loop_amen`によって沢山の事ができるのです！もし`:loop_garzul`のような他のサンプルの繰り返しによる音が聞きたい場合はどうしましょう？そうするにはすべての`:loop_amen`を探しだして`:loop_garzul`に変更する必要があります。そんな変更ができる沢山の時間があればいいんですが…もし仮にあなたがステージの上で演奏している最中だったらどうでしょう？特にみんなのダンスを止めないために、変更するためのそんな優雅な時間はないかもしれません。

下記のようなコードを書いたとして、

```
sample_name = :loop_amen
sample sample_name
sleep sample_duration(sample_name)
sample sample_name, rate: 0.5
sleep sample_duration(sample_name, rate: 0.5)
sample sample_name
sleep sample_duration(sample_name)
```

そして、これは試しの前述のものと同様のものです。これも`sample_name = :loop_amenをsample_name = :loop_garzul`に一行を変更する機能を備えています。つまりこのように変数の魔法によって多くのポイントを変更させることができるのです。

## 結果の獲得

最後に、変数を使う優れた理由はそのコードの結果の獲得をするということです。例えば、サンプル音源の長さを使って何かを行いたい時など。

```
sd = sample_duration(:loop_amen)
```

上記のように書くことで、今、`:loop_amen`というサンプルの長さが必要な時、どこにでも`sd`を使うことが出来るようになります。
おそらくもっと重要なのは、変数は、playやsampleの結果をキャプチャすることができることです。

```
s = play 50, release: 8
```

またこのように書くことで `s` が変数として記憶され、シンセをコントロールすることを許容するようになります。

```
s = play 50, release: 8
sleep 2
control s, note: 62
```

また、後の章ではもっと詳しくシンセをコントロールすることも学びます。
