5.2 Iteración y Bucles

# Iteración y Bucles

Hasta ahora hemos invertido tiempo en los diferentes sonidos que 
puedes crear con bloques de `play` y `sample`. También hemos aprendido
a disparar estos sonidos a través de `sleep`.

Como probablemente ya notaste, hay mucha diversión a ser obtenida con
estos bloques básicos de construcción. Sin embargo, una dimensión 
totalmente diferente de diversión se abre cuando comienzas a usar el
poder de codificar para estructurar tu música y composiciones. En los
próximos segmentos exploraremos algunas de estas poderosas herramientas.
Primero están las iteraciones y bucles.


## Repetición

¿Has escrito código que te gustaría se repita unas cuantas veces?
Por ejemplo, algo así:


```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

¿qué tal si quieeres repetirlo 3 veces? Bueno, podrías hacer algo simple 
y copiarlo 3 veces:

```
play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25

play 50
sleep 0.5
sample :elec_blup
sleep 0.5
play 62
sleep 0.25
```

¡Eso fué bastante código! ¿qué pasa si quieres cambiar el sample a
`:elec_plip`? Tendrías que buscar todos los lugares con el original
`:elec_blup` y cambiarlo. Más importantemente, ¿qué si quisieras 
repetir l apieza original 1000 veces? Eso tomaría muchas líneas de
código y lugares a los que ir a alterar si quisieses cambiar algo.


## Iteración

De hecho, repetir código debería ser tan fácil como decirle *haz esto
tres veces*. Bueno, así es, casi..Recuerda nuestro viejo amigo el 
bloque de código, lo podemos usar para marcar el comienzo y final de
código que querramos repetir tres veces. Después usamos el código
especial `3.times`. Así, en vez de escribir *do this three times*, 
escribimos `3.times do` - ¿sencillo, no? Sólo recuerda escribir `end`
al final del código que quieras repetir:

```
3.times do
  play 50
  sleep 0.5
  sample :elec_blup
  sleep 0.5
  play 62
  sleep 0.25
end
```

¿Eso fué mucho más elegante que cortar y pegar! Así crearemos muchas
estructuras repetitivas_:


```
4.times do
  play 50
  sleep 0.5
end

8.times do
  play 55, release: 0.2
  sleep 0.25
end

4.times do
  play 50
  sleep 0.5
end
```

## Iteraciones anidadas

Podemos insertar iteraciones dentro de iteraciones para crear patrones
interesantes. Por ejemplo:


```
4.times do
  sample :drum_heavy_kick
  2.times do
    sample :elec_blip2, rate: 2
    sleep 0.25
  end
  sample :elec_snare
  4.times do
    sample :drum_tom_mid_soft
    sleep 0.125
  end
end
```

## Bucleando

Si deseas que algo se repita muchas veces, te puedes encontrar usando 
números realmente grandes como `1000.times do`. En este caso es mejor
pedirle a Sonic Pi que repita al infinito (hasta que aprietes el botón
de parar). Bucleemos el amen break infinitamente:

```
loop do
  sample :loop_amen
  sleep sample_duration :loop_amen
end
```

Lo importante de saber acerca de los blucles (loops) es que actúan
como hoyos negros para el código. Una vez que se entra ahí, sólo se
sale con el botón de parar (stop). Esto significa que si tienes código
después del loop, nunca lo escucharás. Por ejemplo, el platillo después 
de este bucle nunca se ejecutará:


```
loop do
  play 50
  sleep 1
end

sample :drum_cymbal_open
```

¡Ahora ve a estructurar tus códigos con iteración y bucles!
