<?php

class TP_yyToken implements ArrayAccess
{
    public $string = '';

    public $metadata = array();

    public function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    public function __toString()
    {
        return $this->string;
    }

    public function offsetExists($offset)
    {
        return isset($this->metadata[ $offset ]);
    }

    public function offsetGet($offset)
    {
        return $this->metadata[ $offset ];
    }

    public function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[ 0 ])) {
                $x = ($value instanceof TP_yyToken) ? $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);

                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[ $offset ] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[ $offset ] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        unset($this->metadata[ $offset ]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
}

;

#line 11 "../smarty/lexer/smarty_internal_templateparser.y"

/**
 * Smarty Template Parser Class
 *
 * This is the template parser.
 * It is generated from the smarty_internal_templateparser.y file
 *
 * @author Uwe Tews <uwe.tews@googlemail.com>
 */
class Smarty_Internal_Templateparser
{
    #line 23 "../smarty/lexer/smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";

    const Err2 = "Security error: Call to dynamic object member not allowed";

    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";

    /**
     * result status
     *
     * @var bool
     */
    public $successful = true;

    /**
     * return value
     *
     * @var mixed
     */
    public $retvalue = 0;

    /**
     * @var
     */
    public $yymajor;

    /**
     * last index of array variable
     *
     * @var mixed
     */
    public $last_index;

    /**
     * last variable name
     *
     * @var string
     */
    public $last_variable;

    /**
     * root parse tree buffer
     *
     * @var Smarty_Internal_ParseTree
     */
    public $root_buffer;

    /**
     * current parse tree object
     *
     * @var Smarty_Internal_ParseTree
     */
    public $current_buffer;

    /**
     * lexer object
     *
     * @var Smarty_Internal_Templatelexer
     */
    public $lex;

    /**
     * internal error flag
     *
     * @var bool
     */
    private $internalError = false;

    /**
     * {strip} status
     *
     * @var bool
     */
    public $strip = false;

    /**
     * compiler object
     *
     * @var Smarty_Internal_TemplateCompilerBase
     */
    public $compiler = null;

    /**
     * smarty object
     *
     * @var Smarty
     */
    public $smarty = null;

    /**
     * template object
     *
     * @var Smarty_Internal_Template
     */
    public $template = null;

    /**
     * block nesting level
     *
     * @var int
     */
    public $block_nesting_level = 0;

    /**
     * security object
     *
     * @var Smarty_Security
     */
    public $security = null;

    /**
     * template prefix array
     *
     * @var \Smarty_Internal_ParseTree[]
     */
    public $template_prefix = array();

    /**
     * security object
     *
     * @var \Smarty_Internal_ParseTree[]
     */
    public $template_postfix = array();

    /**
     * constructor
     *
     * @param Smarty_Internal_Templatelexer        $lex
     * @param Smarty_Internal_TemplateCompilerBase $compiler
     */
    function __construct(Smarty_Internal_Templatelexer $lex, Smarty_Internal_TemplateCompilerBase $compiler)
    {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->template = $this->compiler->template;
        $this->smarty = $this->template->smarty;
        $this->security = isset($this->smarty->security_policy) ? $this->smarty->security_policy : false;
        $this->current_buffer = $this->root_buffer = new Smarty_Internal_ParseTree_Template();
    }

    /**
     * insert PHP code in current buffer
     *
     * @param string $code
     */
    public function insertPhpCode($code)
    {
        $this->current_buffer->append_subtree($this, new Smarty_Internal_ParseTree_Tag($this, $code));
    }

    /**
     *  merge PHP code with prefix code and return parse tree tag object
     *
     * @param string $code
     *
     * @return Smarty_Internal_ParseTree_Tag
     */
    public function mergePrefixCode($code)
    {
        $tmp = '';
        foreach ($this->compiler->prefix_code as $preCode) {
            $tmp .= $preCode;
        }
        $this->compiler->prefix_code = array();
        $tmp .= $code;
        return new Smarty_Internal_ParseTree_Tag($this, $this->compiler->processNocacheCode($tmp, true));
    }

    const TP_VERT = 1;

    const TP_COLON = 2;

    const TP_PHP = 3;

    const TP_TEXT = 4;

    const TP_STRIPON = 5;

    const TP_STRIPOFF = 6;

    const TP_LITERALSTART = 7;

    const TP_LITERALEND = 8;

    const TP_LITERAL = 9;

    const TP_RDEL = 10;

    const TP_SIMPELOUTPUT = 11;

    const TP_LDEL = 12;

    const TP_DOLLARID = 13;

    const TP_EQUAL = 14;

    const TP_SIMPLETAG = 15;

    const TP_ID = 16;

    const TP_PTR = 17;

    const TP_LDELMAKENOCACHE = 18;

    const TP_LDELIF = 19;

    const TP_LDELFOR = 20;

    const TP_SEMICOLON = 21;

    const TP_INCDEC = 22;

    const TP_TO = 23;

    const TP_STEP = 24;

    const TP_LDELFOREACH = 25;

    const TP_SPACE = 26;

    const TP_AS = 27;

    const TP_APTR = 28;

    const TP_LDELSETFILTER = 29;

    const TP_SMARTYBLOCKCHILDPARENT = 30;

    const TP_CLOSETAG = 31;

    const TP_LDELSLASH = 32;

    const TP_ATTR = 33;

    const TP_INTEGER = 34;

    const TP_COMMA = 35;

    const TP_OPENP = 36;

    const TP_CLOSEP = 37;

    const TP_MATH = 38;

    const TP_UNIMATH = 39;

    const TP_ISIN = 40;

    const TP_QMARK = 41;

    const TP_NOT = 42;

    const TP_TYPECAST = 43;

    const TP_HEX = 44;

    const TP_DOT = 45;

    const TP_INSTANCEOF = 46;

    const TP_SINGLEQUOTESTRING = 47;

    const TP_DOUBLECOLON = 48;

    const TP_NAMESPACE = 49;

    const TP_AT = 50;

    const TP_HATCH = 51;

    const TP_OPENB = 52;

    const TP_CLOSEB = 53;

    const TP_DOLLAR = 54;

    const TP_LOGOP = 55;

    const TP_SLOGOP = 56;

    const TP_TLOGOP = 57;

    const TP_SINGLECOND = 58;

    const TP_QUOTE = 59;

    const TP_BACKTICK = 60;

    const YY_NO_ACTION = 532;

    const YY_ACCEPT_ACTION = 531;

    const YY_ERROR_ACTION = 530;

    const YY_SZ_ACTTAB = 2114;

    static public $yy_action = array(268, 8, 132, 210, 245, 197, 183, 228, 7, 84, 176, 264, 275, 302, 112, 44, 36, 278,
                                     233, 136, 305, 221, 281, 203, 237, 26, 234, 202, 41, 104, 189, 39, 42, 256, 213,
                                     216, 224, 78, 207, 129, 82, 1, 316, 297, 102, 268, 8, 133, 79, 245, 80, 302, 228,
                                     7, 84, 330, 299, 82, 272, 112, 297, 273, 325, 233, 285, 305, 221, 214, 231, 34, 26,
                                     3, 101, 41, 230, 78, 39, 42, 256, 213, 35, 239, 314, 207, 300, 82, 1, 13, 297, 333,
                                     268, 8, 135, 79, 245, 201, 302, 228, 7, 84, 35, 85, 322, 109, 112, 29, 196, 13,
                                     233, 269, 305, 221, 237, 231, 249, 26, 136, 104, 41, 219, 78, 39, 42, 256, 213,
                                     459, 239, 267, 207, 355, 82, 1, 459, 297, 446, 268, 8, 135, 79, 245, 193, 302, 228,
                                     7, 84, 35, 446, 297, 28, 112, 247, 263, 13, 233, 82, 305, 221, 297, 231, 309, 26,
                                     185, 292, 41, 298, 78, 39, 42, 256, 213, 27, 239, 237, 207, 232, 82, 1, 104, 297,
                                     459, 268, 8, 135, 79, 245, 195, 459, 228, 7, 84, 446, 297, 283, 11, 112, 25, 188,
                                     282, 233, 236, 305, 221, 446, 204, 294, 26, 32, 318, 41, 90, 210, 39, 42, 256, 213,
                                     174, 239, 137, 207, 402, 82, 1, 210, 297, 9, 268, 8, 136, 79, 245, 201, 223, 228,
                                     7, 84, 402, 142, 235, 225, 112, 22, 227, 402, 233, 166, 305, 221, 35, 231, 27, 33,
                                     210, 101, 41, 13, 210, 39, 42, 256, 213, 361, 239, 302, 207, 399, 82, 1, 210, 297,
                                     101, 268, 8, 135, 79, 245, 201, 402, 228, 7, 84, 399, 235, 297, 109, 112, 447, 78,
                                     399, 233, 319, 305, 221, 402, 194, 172, 26, 279, 447, 41, 402, 307, 39, 42, 256,
                                     213, 182, 239, 16, 207, 296, 82, 1, 210, 297, 101, 268, 8, 131, 79, 245, 201, 357,
                                     228, 7, 84, 283, 11, 475, 475, 112, 282, 303, 475, 233, 24, 305, 221, 35, 231, 175,
                                     4, 279, 271, 41, 13, 109, 39, 42, 256, 213, 181, 239, 178, 207, 12, 82, 1, 16, 297,
                                     274, 268, 8, 135, 79, 245, 200, 475, 228, 7, 84, 475, 475, 283, 11, 112, 475, 189,
                                     282, 233, 210, 305, 221, 20, 231, 38, 26, 179, 292, 41, 148, 446, 39, 42, 256, 213,
                                     229, 239, 180, 207, 332, 82, 1, 446, 297, 190, 268, 8, 134, 79, 245, 201, 215, 228,
                                     7, 84, 168, 16, 188, 243, 112, 104, 189, 303, 233, 140, 305, 221, 325, 231, 255,
                                     26, 177, 214, 41, 218, 312, 39, 42, 256, 213, 277, 239, 128, 207, 101, 82, 1, 92,
                                     297, 2, 268, 8, 136, 79, 245, 201, 23, 228, 7, 84, 210, 108, 251, 184, 112, 297,
                                     304, 289, 233, 367, 305, 221, 137, 231, 315, 33, 220, 5, 41, 9, 5, 39, 42, 256,
                                     213, 35, 239, 189, 207, 113, 82, 311, 13, 297, 106, 446, 214, 212, 79, 116, 72,
                                     114, 258, 260, 261, 222, 102, 446, 214, 257, 280, 187, 308, 334, 270, 206, 242,
                                     152, 299, 210, 128, 83, 262, 250, 252, 253, 176, 332, 211, 329, 268, 8, 151, 143,
                                     245, 189, 178, 228, 7, 84, 210, 265, 332, 332, 112, 188, 21, 311, 233, 153, 305,
                                     221, 214, 212, 17, 122, 67, 114, 164, 141, 189, 13, 102, 149, 266, 257, 280, 183,
                                     332, 332, 270, 206, 242, 332, 299, 295, 44, 36, 278, 235, 311, 208, 279, 145, 169,
                                     214, 212, 91, 122, 67, 114, 189, 320, 332, 167, 102, 146, 139, 257, 280, 94, 171,
                                     159, 270, 206, 242, 332, 299, 210, 38, 311, 189, 332, 155, 209, 214, 212, 317, 122,
                                     53, 107, 123, 232, 332, 189, 102, 291, 400, 257, 280, 6, 217, 276, 270, 206, 242,
                                     311, 299, 297, 158, 313, 214, 212, 400, 122, 49, 107, 154, 117, 332, 400, 102, 30,
                                     446, 257, 280, 248, 332, 173, 270, 206, 242, 279, 299, 324, 446, 186, 292, 332, 95,
                                     279, 268, 10, 326, 170, 245, 88, 87, 228, 7, 84, 279, 138, 89, 279, 112, 86, 309,
                                     311, 233, 115, 305, 221, 214, 212, 254, 122, 67, 114, 105, 303, 163, 165, 102, 303,
                                     93, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 303, 303, 303, 286, 19, 311,
                                     205, 303, 303, 303, 214, 212, 303, 116, 72, 114, 303, 43, 40, 37, 102, 303, 303,
                                     257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 324, 327, 323, 288, 287, 303,
                                     303, 268, 10, 326, 331, 245, 303, 303, 228, 7, 84, 303, 303, 303, 303, 112, 303,
                                     303, 311, 233, 303, 305, 221, 214, 212, 303, 122, 70, 114, 303, 303, 303, 303, 102,
                                     303, 303, 257, 280, 303, 283, 11, 270, 206, 242, 282, 299, 303, 311, 303, 290, 19,
                                     303, 214, 212, 35, 122, 54, 114, 303, 303, 303, 13, 102, 162, 303, 257, 280, 183,
                                     303, 303, 270, 206, 242, 332, 299, 311, 44, 36, 278, 303, 214, 212, 303, 122, 68,
                                     114, 303, 303, 303, 303, 102, 189, 303, 257, 280, 303, 303, 303, 270, 206, 242,
                                     303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 100, 73, 114, 303, 303, 303, 303,
                                     102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303,
                                     303, 303, 214, 212, 303, 122, 77, 114, 303, 303, 303, 303, 102, 147, 303, 257, 280,
                                     183, 303, 303, 270, 206, 242, 332, 299, 311, 44, 36, 278, 303, 214, 212, 303, 122,
                                     76, 114, 303, 303, 303, 303, 102, 189, 303, 257, 280, 303, 303, 303, 270, 206, 242,
                                     303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 99, 71, 114, 303, 303, 303, 303,
                                     102, 161, 303, 257, 280, 183, 303, 303, 270, 206, 242, 332, 299, 311, 44, 36, 278,
                                     303, 214, 212, 303, 122, 47, 114, 303, 303, 303, 303, 102, 189, 303, 257, 280, 303,
                                     303, 303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 59,
                                     114, 303, 303, 303, 303, 102, 150, 303, 257, 280, 183, 303, 303, 270, 206, 242,
                                     332, 299, 311, 44, 36, 278, 303, 214, 198, 303, 118, 55, 114, 303, 303, 303, 303,
                                     102, 189, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303,
                                     303, 303, 214, 212, 303, 122, 69, 114, 303, 303, 303, 303, 102, 160, 303, 257, 280,
                                     183, 303, 303, 270, 206, 242, 332, 299, 311, 44, 36, 278, 303, 214, 97, 303, 81,
                                     48, 103, 303, 303, 303, 303, 102, 189, 303, 257, 280, 303, 303, 303, 270, 206, 242,
                                     303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 57, 114, 303, 303, 303, 303,
                                     102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303,
                                     303, 303, 214, 212, 303, 122, 65, 114, 303, 303, 303, 303, 102, 303, 303, 257, 280,
                                     303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 96, 303, 81,
                                     46, 103, 303, 303, 303, 303, 102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242,
                                     303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 111, 50, 114, 303, 303, 303, 303,
                                     102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303,
                                     303, 303, 214, 212, 303, 98, 61, 114, 303, 303, 303, 303, 102, 303, 303, 257, 280,
                                     303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 199, 303,
                                     122, 56, 114, 303, 303, 303, 303, 102, 303, 303, 257, 280, 303, 303, 303, 270, 206,
                                     242, 303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 51, 114, 303, 303, 303,
                                     303, 102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303,
                                     303, 303, 303, 214, 212, 303, 122, 58, 114, 303, 303, 303, 303, 102, 303, 303, 257,
                                     280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 212,
                                     303, 122, 74, 114, 303, 303, 303, 303, 102, 303, 303, 257, 280, 303, 303, 303, 270,
                                     206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 62, 114, 303, 303,
                                     303, 303, 102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311,
                                     303, 303, 303, 303, 214, 212, 303, 122, 60, 114, 303, 303, 303, 303, 102, 303, 303,
                                     257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214,
                                     212, 303, 122, 45, 114, 303, 303, 303, 303, 102, 303, 303, 257, 280, 303, 303, 303,
                                     270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 64, 114, 303,
                                     303, 303, 303, 102, 303, 303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299,
                                     311, 303, 303, 303, 303, 214, 212, 303, 122, 75, 114, 303, 303, 303, 303, 102, 303,
                                     303, 257, 280, 303, 303, 303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303,
                                     214, 212, 303, 122, 63, 114, 303, 303, 303, 303, 102, 303, 303, 257, 280, 303, 303,
                                     303, 270, 206, 242, 303, 299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 66, 114,
                                     303, 303, 303, 303, 102, 303, 303, 257, 280, 303, 412, 412, 270, 206, 242, 303,
                                     299, 311, 303, 303, 303, 303, 214, 212, 303, 122, 53, 114, 303, 303, 303, 303, 102,
                                     303, 303, 257, 280, 210, 303, 303, 270, 206, 242, 303, 299, 446, 301, 412, 412,
                                     412, 303, 531, 52, 259, 260, 261, 222, 446, 303, 214, 303, 303, 35, 303, 412, 412,
                                     412, 412, 303, 13, 303, 303, 303, 303, 43, 40, 37, 210, 303, 303, 311, 303, 303,
                                     303, 303, 214, 212, 210, 130, 303, 114, 327, 323, 288, 287, 102, 303, 303, 303,
                                     241, 31, 303, 35, 270, 206, 242, 303, 299, 303, 13, 303, 303, 35, 303, 43, 40, 37,
                                     303, 303, 13, 303, 303, 303, 303, 43, 40, 37, 303, 303, 303, 311, 327, 323, 288,
                                     287, 214, 212, 210, 124, 303, 114, 327, 323, 288, 287, 102, 192, 303, 303, 310,
                                     303, 303, 303, 270, 206, 242, 311, 299, 226, 303, 303, 214, 212, 303, 120, 303,
                                     114, 475, 475, 303, 28, 102, 475, 459, 43, 40, 37, 303, 303, 270, 206, 242, 303,
                                     299, 303, 303, 303, 303, 303, 303, 311, 327, 323, 288, 287, 214, 212, 303, 126,
                                     303, 114, 459, 303, 303, 459, 102, 475, 303, 459, 226, 303, 303, 303, 270, 206,
                                     242, 303, 299, 475, 475, 226, 18, 303, 475, 459, 303, 303, 303, 303, 475, 475, 303,
                                     303, 226, 475, 459, 283, 11, 303, 303, 303, 282, 475, 475, 303, 303, 303, 475, 459,
                                     303, 303, 35, 459, 144, 303, 459, 303, 475, 13, 459, 303, 303, 303, 459, 303, 303,
                                     459, 311, 475, 303, 459, 321, 214, 212, 303, 119, 459, 114, 303, 459, 303, 475,
                                     102, 459, 303, 303, 303, 303, 303, 303, 270, 206, 242, 303, 299, 311, 210, 14, 303,
                                     303, 214, 212, 303, 127, 303, 114, 303, 284, 303, 303, 102, 129, 303, 303, 303,
                                     303, 102, 303, 270, 206, 242, 311, 299, 210, 303, 293, 214, 212, 299, 121, 303,
                                     114, 311, 43, 40, 37, 102, 214, 212, 303, 125, 303, 114, 303, 270, 206, 242, 102,
                                     299, 156, 327, 323, 288, 287, 210, 270, 206, 242, 210, 299, 43, 40, 37, 210, 303,
                                     303, 303, 244, 303, 303, 303, 303, 303, 303, 110, 303, 303, 327, 323, 288, 287,
                                     303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 43, 40, 37, 210, 43, 40, 37, 210,
                                     303, 43, 40, 37, 240, 210, 303, 303, 191, 327, 323, 288, 287, 327, 323, 288, 287,
                                     303, 327, 323, 288, 287, 303, 306, 303, 303, 303, 303, 303, 303, 303, 303, 43, 40,
                                     37, 303, 43, 40, 37, 210, 303, 238, 43, 40, 37, 303, 303, 303, 303, 327, 323, 288,
                                     287, 327, 323, 288, 287, 15, 303, 327, 323, 288, 287, 303, 303, 303, 475, 475, 303,
                                     303, 303, 475, 459, 210, 303, 246, 43, 40, 37, 210, 303, 303, 303, 303, 303, 475,
                                     475, 283, 11, 303, 475, 459, 282, 327, 323, 288, 287, 303, 303, 303, 459, 303, 35,
                                     459, 157, 475, 303, 459, 303, 13, 43, 40, 37, 303, 303, 303, 43, 40, 37, 459, 303,
                                     303, 459, 303, 475, 328, 459, 327, 323, 288, 287, 303, 303, 327, 323, 288, 287,
                                     303, 406, 303, 303, 303, 303, 303, 303, 303, 303, 303, 303, 406, 303, 406, 303,
                                     303, 406, 303, 303, 303, 303, 303, 303, 406, 303, 406, 303, 406, 303, 303, 303,
                                     303, 303, 303, 303, 235,);

    static public $yy_lookahead = array(11, 12, 13, 1, 15, 16, 76, 18, 19, 20, 7, 8, 9, 22, 25, 85, 86, 87, 29, 13, 31,
                                        32, 16, 34, 75, 36, 77, 78, 39, 80, 100, 42, 43, 44, 45, 71, 47, 46, 49, 75, 51,
                                        52, 53, 54, 80, 11, 12, 13, 59, 15, 16, 22, 18, 19, 20, 49, 92, 51, 66, 25, 54,
                                        69, 65, 29, 30, 31, 32, 70, 34, 14, 36, 35, 17, 39, 16, 46, 42, 43, 44, 45, 26,
                                        47, 53, 49, 10, 51, 52, 33, 54, 53, 11, 12, 13, 59, 15, 16, 22, 18, 19, 20, 26,
                                        104, 105, 48, 25, 12, 13, 33, 29, 16, 31, 32, 75, 34, 77, 36, 13, 80, 39, 16,
                                        46, 42, 43, 44, 45, 45, 47, 34, 49, 10, 51, 52, 52, 54, 36, 11, 12, 13, 59, 15,
                                        16, 22, 18, 19, 20, 26, 48, 54, 14, 25, 13, 34, 33, 29, 51, 31, 32, 54, 34, 94,
                                        36, 96, 97, 39, 97, 46, 42, 43, 44, 45, 14, 47, 75, 49, 77, 51, 52, 80, 54, 45,
                                        11, 12, 13, 59, 15, 16, 52, 18, 19, 20, 36, 54, 11, 12, 25, 21, 100, 16, 29, 45,
                                        31, 32, 48, 34, 16, 36, 14, 53, 39, 35, 1, 42, 43, 44, 45, 93, 47, 45, 49, 10,
                                        51, 52, 1, 54, 52, 11, 12, 13, 59, 15, 16, 50, 18, 19, 20, 26, 27, 45, 50, 25,
                                        12, 13, 33, 29, 16, 31, 32, 26, 34, 14, 36, 1, 17, 39, 33, 1, 42, 43, 44, 45,
                                        10, 47, 22, 49, 10, 51, 52, 1, 54, 17, 11, 12, 13, 59, 15, 16, 10, 18, 19, 20,
                                        26, 45, 54, 48, 25, 36, 46, 33, 29, 53, 31, 32, 26, 34, 93, 36, 95, 48, 39, 33,
                                        60, 42, 43, 44, 45, 81, 47, 35, 49, 37, 51, 52, 1, 54, 17, 11, 12, 13, 59, 15,
                                        16, 10, 18, 19, 20, 11, 12, 11, 12, 25, 16, 101, 16, 29, 14, 31, 32, 26, 34, 93,
                                        36, 95, 22, 39, 33, 48, 42, 43, 44, 45, 81, 47, 76, 49, 41, 51, 52, 35, 54, 37,
                                        11, 12, 13, 59, 15, 16, 50, 18, 19, 20, 11, 12, 11, 12, 25, 16, 100, 16, 29, 1,
                                        31, 32, 28, 34, 2, 36, 96, 97, 39, 72, 36, 42, 43, 44, 45, 17, 47, 76, 49, 82,
                                        51, 52, 48, 54, 16, 11, 12, 13, 59, 15, 16, 50, 18, 19, 20, 75, 35, 100, 37, 25,
                                        80, 100, 101, 29, 13, 31, 32, 65, 34, 37, 36, 13, 70, 39, 16, 91, 42, 43, 44,
                                        45, 16, 47, 98, 49, 17, 51, 52, 36, 54, 36, 11, 12, 13, 59, 15, 16, 12, 18, 19,
                                        20, 1, 48, 4, 76, 25, 54, 16, 105, 29, 10, 31, 32, 45, 34, 53, 36, 17, 36, 39,
                                        52, 36, 42, 43, 44, 45, 26, 47, 100, 49, 16, 51, 65, 33, 54, 80, 36, 70, 71, 59,
                                        73, 74, 75, 64, 65, 66, 67, 80, 48, 70, 83, 84, 76, 98, 91, 88, 89, 90, 72, 92,
                                        1, 98, 16, 3, 4, 5, 6, 7, 82, 102, 103, 11, 12, 72, 72, 15, 100, 76, 18, 19, 20,
                                        1, 16, 82, 82, 25, 100, 28, 65, 29, 51, 31, 32, 70, 71, 26, 73, 74, 75, 72, 72,
                                        100, 33, 80, 72, 10, 83, 84, 76, 82, 82, 88, 89, 90, 82, 92, 16, 85, 86, 87, 45,
                                        65, 99, 95, 72, 51, 70, 71, 76, 73, 74, 75, 100, 53, 82, 93, 80, 72, 13, 83, 84,
                                        76, 93, 72, 88, 89, 90, 82, 92, 1, 2, 65, 100, 82, 72, 99, 70, 71, 53, 73, 74,
                                        75, 16, 77, 82, 100, 80, 16, 10, 83, 84, 36, 14, 34, 88, 89, 90, 65, 92, 54, 72,
                                        13, 70, 71, 26, 73, 74, 75, 72, 77, 82, 33, 80, 23, 36, 83, 84, 82, 82, 72, 88,
                                        89, 90, 95, 92, 4, 48, 96, 97, 82, 81, 95, 11, 12, 13, 93, 15, 80, 80, 18, 19,
                                        20, 95, 80, 80, 95, 25, 80, 94, 65, 29, 79, 31, 32, 70, 71, 8, 73, 74, 75, 68,
                                        106, 93, 93, 80, 106, 93, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 106, 106,
                                        106, 59, 60, 65, 99, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 38, 39, 40,
                                        80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 4, 55, 56, 57, 58,
                                        106, 106, 11, 12, 13, 103, 15, 106, 106, 18, 19, 20, 106, 106, 106, 106, 25,
                                        106, 106, 65, 29, 106, 31, 32, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80,
                                        106, 106, 83, 84, 106, 11, 12, 88, 89, 90, 16, 92, 106, 65, 106, 59, 60, 106,
                                        70, 71, 26, 73, 74, 75, 106, 106, 106, 33, 80, 72, 106, 83, 84, 76, 106, 106,
                                        88, 89, 90, 82, 92, 65, 85, 86, 87, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106,
                                        106, 80, 100, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106,
                                        106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84,
                                        106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74,
                                        75, 106, 106, 106, 106, 80, 72, 106, 83, 84, 76, 106, 106, 88, 89, 90, 82, 92,
                                        65, 85, 86, 87, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 100, 106,
                                        83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106,
                                        73, 74, 75, 106, 106, 106, 106, 80, 72, 106, 83, 84, 76, 106, 106, 88, 89, 90,
                                        82, 92, 65, 85, 86, 87, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80,
                                        100, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106,
                                        70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 72, 106, 83, 84, 76, 106, 106,
                                        88, 89, 90, 82, 92, 65, 85, 86, 87, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106,
                                        106, 80, 100, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106,
                                        106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 72, 106, 83, 84, 76,
                                        106, 106, 88, 89, 90, 82, 92, 65, 85, 86, 87, 106, 70, 71, 106, 73, 74, 75, 106,
                                        106, 106, 106, 80, 100, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65,
                                        106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106,
                                        83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106,
                                        73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90,
                                        106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106,
                                        80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106,
                                        106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 106,
                                        106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75,
                                        106, 106, 106, 106, 80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92,
                                        65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106,
                                        106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71,
                                        106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 106, 106, 106, 88,
                                        89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106,
                                        106, 80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106,
                                        106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84,
                                        106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74,
                                        75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106,
                                        92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80,
                                        106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106,
                                        70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 106, 106,
                                        106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106,
                                        106, 106, 106, 80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65,
                                        106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106,
                                        83, 84, 106, 106, 106, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106, 70, 71, 106,
                                        73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 106, 106, 106, 88, 89, 90,
                                        106, 92, 65, 106, 106, 106, 106, 70, 71, 106, 73, 74, 75, 106, 106, 106, 106,
                                        80, 106, 106, 83, 84, 106, 1, 2, 88, 89, 90, 106, 92, 65, 106, 106, 106, 106,
                                        70, 71, 106, 73, 74, 75, 106, 106, 106, 106, 80, 106, 106, 83, 84, 1, 106, 106,
                                        88, 89, 90, 106, 92, 36, 10, 38, 39, 40, 106, 62, 63, 64, 65, 66, 67, 48, 106,
                                        70, 106, 106, 26, 106, 55, 56, 57, 58, 106, 33, 106, 106, 106, 106, 38, 39, 40,
                                        1, 106, 106, 65, 106, 106, 106, 106, 70, 71, 1, 73, 106, 75, 55, 56, 57, 58, 80,
                                        106, 106, 106, 84, 24, 106, 26, 88, 89, 90, 106, 92, 106, 33, 106, 106, 26, 106,
                                        38, 39, 40, 106, 106, 33, 106, 106, 106, 106, 38, 39, 40, 106, 106, 106, 65, 55,
                                        56, 57, 58, 70, 71, 1, 73, 106, 75, 55, 56, 57, 58, 80, 10, 106, 106, 84, 106,
                                        106, 106, 88, 89, 90, 65, 92, 2, 106, 106, 70, 71, 106, 73, 106, 75, 11, 12,
                                        106, 14, 80, 16, 17, 38, 39, 40, 106, 106, 88, 89, 90, 106, 92, 106, 106, 106,
                                        106, 106, 106, 65, 55, 56, 57, 58, 70, 71, 106, 73, 106, 75, 45, 106, 106, 48,
                                        80, 50, 106, 52, 2, 106, 106, 106, 88, 89, 90, 106, 92, 11, 12, 2, 14, 106, 16,
                                        17, 106, 106, 106, 106, 11, 12, 106, 106, 2, 16, 17, 11, 12, 106, 106, 106, 16,
                                        11, 12, 106, 106, 106, 16, 17, 106, 106, 26, 45, 28, 106, 48, 106, 50, 33, 52,
                                        106, 106, 106, 45, 106, 106, 48, 65, 50, 106, 52, 53, 70, 71, 106, 73, 45, 75,
                                        106, 48, 106, 50, 80, 52, 106, 106, 106, 106, 106, 106, 88, 89, 90, 106, 92, 65,
                                        1, 2, 106, 106, 70, 71, 106, 73, 106, 75, 106, 71, 106, 106, 80, 75, 106, 106,
                                        106, 106, 80, 106, 88, 89, 90, 65, 92, 1, 106, 89, 70, 71, 92, 73, 106, 75, 65,
                                        38, 39, 40, 80, 70, 71, 106, 73, 106, 75, 106, 88, 89, 90, 80, 92, 27, 55, 56,
                                        57, 58, 1, 88, 89, 90, 1, 92, 38, 39, 40, 1, 106, 106, 106, 10, 106, 106, 106,
                                        106, 106, 106, 21, 106, 106, 55, 56, 57, 58, 106, 106, 106, 106, 106, 106, 106,
                                        106, 106, 106, 38, 39, 40, 1, 38, 39, 40, 1, 106, 38, 39, 40, 10, 1, 106, 106,
                                        10, 55, 56, 57, 58, 55, 56, 57, 58, 106, 55, 56, 57, 58, 106, 60, 106, 106, 106,
                                        106, 106, 106, 106, 106, 38, 39, 40, 106, 38, 39, 40, 1, 106, 37, 38, 39, 40,
                                        106, 106, 106, 106, 55, 56, 57, 58, 55, 56, 57, 58, 2, 106, 55, 56, 57, 58, 106,
                                        106, 106, 11, 12, 106, 106, 106, 16, 17, 1, 106, 37, 38, 39, 40, 1, 106, 106,
                                        106, 106, 106, 11, 12, 11, 12, 106, 16, 17, 16, 55, 56, 57, 58, 106, 106, 106,
                                        45, 106, 26, 48, 28, 50, 106, 52, 106, 33, 38, 39, 40, 106, 106, 106, 38, 39,
                                        40, 45, 106, 106, 48, 106, 50, 53, 52, 55, 56, 57, 58, 106, 106, 55, 56, 57, 58,
                                        106, 10, 106, 106, 106, 106, 106, 106, 106, 106, 106, 106, 21, 106, 23, 106,
                                        106, 26, 106, 106, 106, 106, 106, 106, 33, 106, 35, 106, 37, 106, 106, 106, 106,
                                        106, 106, 106, 45,);

    const YY_SHIFT_USE_DFLT = - 12;

    const YY_SHIFT_MAX = 238;

    static public $yy_shift_ofst = array(519, 349, 79, 349, 304, 79, 79, 304, 34, - 11, 34, 79, 394, 79, 79, 124, 79,
                                         169, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 259, 79, 79, 79, 79, 79, 79, 169,
                                         79, 214, 214, 439, 439, 439, 439, 439, 439, 1617, 1577, 1627, 1627, 1627, 1627,
                                         1627, 519, 1944, 1978, 2012, 1903, 1938, 1677, 1836, 1934, 1863, 1898, 1894,
                                         2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018, 695,
                                         695, 6, 660, 459, 311, 103, 221, 411, 745, 1766, 2016, 783, 783, 411, 221, 411,
                                         427, 221, 607, 74, 119, 209, 266, 254, 228, 181, 55, 314, 3, 314, 235, 418,
                                         418, 584, 250, 528, 378, 297, 54, 518, 54, 539, 2, 2, 2, 2, 2, 2, 2, 2, 2, 252,
                                         252, - 12, 1697, 1759, 1748, 1995, 1772, 2014, 93, 361, 359, 134, 54, 137, 54,
                                         137, 54, 54, 54, 54, 54, 54, 54, 54, 80, 54, 54, 137, 137, 54, 54, 54, 54, 54,
                                         172, 54, 172, 444, 172, 320, 80, 172, 172, 172, 54, 172, 172, 687, 594, 2, 252,
                                         2, 382, 382, 2, 2, 252, 252, 2, - 12, - 12, - 12, - 12, - 12, 1550, 2068, 617,
                                         316, 154, 29, 240, 354, 98, 174, 236, 192, 272, 413, 249, 322, 381, 188, 36,
                                         - 9, 598, 554, 424, 533, 525, 441, 498, 505, 473, 458, 450, 421, 559, 610, 594,
                                         627, 605, 564, 534, 392, 388, 629, 117, 58, 156, 313,);

    const YY_REDUCE_USE_DFLT = - 71;

    const YY_REDUCE_MAX = 192;

    static public $yy_reduce_ofst = array(1530, 426, 482, 656, 545, 515, 623, 571, 1017, 961, 1101, 1325, 933, 793, 849,
                                          821, 1465, 1157, 1129, 1185, 1073, 989, 1045, 1241, 1381, 1437, 1493, 1409,
                                          1269, 1297, 1353, 1213, 708, 737, 905, 877, 765, 1606, 1556, 1632, 1808, 1797,
                                          1771, 1666, 1743, 886, 491, 830, 491, 746, 942, 998, 438, - 70, - 70, - 70,
                                          - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70,
                                          - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, - 70, 1777, - 3, 524, 460,
                                          - 36, 511, - 51, 362, 487, 575, 567, 586, 37, 445, 97, 65, 317, 321, 541, 541,
                                          276, 276, 276, 414, 246, 290, 246, - 8, 201, 290, 344, 422, 340, 276, 461,
                                          387, 290, 486, 276, 530, 276, 276, 276, 276, 276, 435, 276, 276, 276, 276,
                                          570, 290, 276, 122, 122, 122, 122, 122, 122, 602, 589, 122, 122, 574, 606,
                                          574, 603, 574, 574, 574, 574, 574, 574, 574, 574, 581, 574, 574, 597, 596,
                                          574, 574, 574, 574, 574, 593, 574, 593, 609, 593, 611, 608, 593, 593, 593,
                                          574, 593, 593, 631, 612, 96, 67, 96, 230, 230, 96, 96, 67, 67, 96, 269, 224,
                                          588, 508, 501,);

    static public $yyExpectedTokens = array(array(3, 4, 5, 6, 7, 11, 12, 15, 18, 19, 20, 25, 29, 31, 32,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 30, 31, 32, 34, 36, 39, 42,
                                                  43, 44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 53, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 30, 31, 32, 34, 36, 39, 42,
                                                  43, 44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 52, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 54, 59,),
                                            array(11, 12, 13, 15, 16, 18, 19, 20, 25, 29, 31, 32, 34, 36, 39, 42, 43,
                                                  44, 45, 47, 49, 51, 54, 59,),
                                            array(1, 24, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 10, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 26, 33, 38, 39, 40, 55, 56, 57, 58,),
                                            array(3, 4, 5, 6, 7, 11, 12, 15, 18, 19, 20, 25, 29, 31, 32,),
                                            array(1, 37, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 37, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 53, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58, 60,),
                                            array(1, 10, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 10, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 2, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 10, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 27, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 10, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 21, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,),
                                            array(1, 38, 39, 40, 55, 56, 57, 58,), array(38, 39, 40, 55, 56, 57, 58,),
                                            array(38, 39, 40, 55, 56, 57, 58,), array(13, 16, 49, 51, 54,),
                                            array(4, 11, 12, 13, 15, 18, 19, 20, 25, 29, 31, 32, 59, 60,),
                                            array(1, 10, 17, 26, 33, 36, 48,), array(1, 10, 26, 33,),
                                            array(13, 16, 51, 54,), array(1, 26, 33,), array(13, 36, 54,),
                                            array(4, 11, 12, 13, 15, 18, 19, 20, 25, 29, 31, 32, 59, 60,),
                                            array(11, 12, 16, 26, 28, 33,), array(11, 12, 16, 26, 28, 33,),
                                            array(11, 12, 16, 26, 33,), array(11, 12, 16, 26, 33,), array(13, 36, 54,),
                                            array(1, 26, 33,), array(13, 36, 54,), array(17, 45, 52,),
                                            array(1, 26, 33,), array(1, 2,), array(10, 22, 26, 33, 46,),
                                            array(10, 22, 26, 33, 46,), array(1, 10, 26, 27, 33,),
                                            array(1, 10, 26, 33,), array(1, 10, 26, 33,), array(12, 13, 16, 54,),
                                            array(11, 12, 16, 50,), array(14, 17, 48,), array(11, 12, 16,),
                                            array(7, 8, 9,), array(11, 12, 16,), array(14, 17, 48,), array(13, 16,),
                                            array(13, 16,), array(13, 54,), array(1, 10,), array(26, 33,),
                                            array(1, 17,), array(17, 48,), array(26, 33,), array(1, 28,),
                                            array(26, 33,), array(1, 53,), array(1,), array(1,), array(1,), array(1,),
                                            array(1,), array(1,), array(1,), array(1,), array(1,), array(17,),
                                            array(17,), array(), array(2, 11, 12, 14, 16, 17, 45, 48, 50, 52,),
                                            array(2, 11, 12, 16, 17, 45, 48, 50, 52, 53,),
                                            array(2, 11, 12, 14, 16, 17, 45, 48, 50, 52,),
                                            array(2, 11, 12, 16, 17, 45, 48, 50, 52,),
                                            array(2, 11, 12, 16, 17, 45, 48, 50, 52,),
                                            array(11, 12, 16, 17, 45, 48, 50, 52,), array(12, 13, 16, 34, 54,),
                                            array(11, 12, 16, 50,), array(11, 12, 16,), array(14, 45, 52,),
                                            array(26, 33,), array(13, 54,), array(26, 33,), array(13, 54,),
                                            array(26, 33,), array(26, 33,), array(26, 33,), array(26, 33,),
                                            array(26, 33,), array(26, 33,), array(26, 33,), array(26, 33,),
                                            array(45, 52,), array(26, 33,), array(26, 33,), array(13, 54,),
                                            array(13, 54,), array(26, 33,), array(26, 33,), array(26, 33,),
                                            array(26, 33,), array(26, 33,), array(45, 52,), array(26, 33,),
                                            array(45, 52,), array(12, 36,), array(45, 52,), array(14, 22,),
                                            array(45, 52,), array(45, 52,), array(45, 52,), array(45, 52,),
                                            array(26, 33,), array(45, 52,), array(45, 52,), array(8,), array(36,),
                                            array(1,), array(17,), array(1,), array(2,), array(2,), array(1,),
                                            array(1,), array(17,), array(17,), array(1,), array(), array(), array(),
                                            array(), array(), array(1, 2, 36, 38, 39, 40, 48, 55, 56, 57, 58,),
                                            array(10, 21, 23, 26, 33, 35, 37, 45,), array(10, 14, 26, 33, 36, 48,),
                                            array(11, 12, 16, 50,), array(36, 45, 48, 53,), array(22, 46, 53,),
                                            array(22, 46, 60,), array(28, 36, 48,), array(36, 48,), array(21, 35,),
                                            array(45, 53,), array(14, 45,), array(35, 37,), array(36, 48,),
                                            array(36, 48,), array(35, 37,), array(35, 37,), array(16, 50,),
                                            array(35, 53,), array(22, 46,), array(34,), array(10,), array(16,),
                                            array(51,), array(16,), array(36,), array(51,), array(16,), array(16,),
                                            array(4,), array(16,), array(53,), array(16,), array(16,), array(36,),
                                            array(13,), array(16,), array(53,), array(45,), array(37,), array(16,),
                                            array(23,), array(34,), array(16,), array(14,), array(41,), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(), array(),
                                            array(), array(), array(), array(), array(), array(), array(),);

    static public $yy_default = array(338, 515, 494, 530, 530, 494, 494, 530, 530, 530, 530, 530, 530, 530, 530, 530,
                                      530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530,
                                      530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 530, 396, 530, 396,
                                      359, 372, 362, 396, 335, 530, 530, 530, 530, 530, 530, 530, 530, 401, 530, 530,
                                      377, 517, 492, 493, 418, 516, 403, 401, 518, 398, 407, 408, 423, 422, 530, 530,
                                      434, 410, 530, 396, 530, 530, 396, 396, 396, 396, 530, 396, 530, 506, 396, 386,
                                      424, 424, 410, 410, 410, 530, 459, 449, 459, 530, 459, 449, 530, 530, 530, 410,
                                      396, 390, 449, 396, 410, 374, 410, 417, 426, 425, 410, 392, 421, 414, 413, 427,
                                      503, 449, 501, 448, 448, 448, 448, 448, 448, 530, 461, 459, 475, 382, 530, 381,
                                      530, 369, 366, 364, 368, 360, 363, 358, 370, 452, 384, 356, 530, 530, 385, 375,
                                      380, 379, 373, 455, 376, 484, 459, 487, 530, 454, 453, 486, 485, 383, 456, 457,
                                      350, 459, 443, 481, 387, 495, 496, 416, 391, 507, 504, 393, 500, 500, 500, 459,
                                      459, 434, 430, 434, 460, 434, 424, 424, 434, 434, 530, 430, 430, 530, 530, 444,
                                      530, 530, 530, 530, 424, 530, 530, 530, 530, 530, 505, 530, 530, 530, 342, 530,
                                      439, 530, 530, 475, 530, 530, 530, 430, 530, 530, 404, 432, 530, 530, 436, 439,
                                      480, 502, 440, 490, 465, 365, 436, 475, 394, 405, 343, 344, 345, 346, 347, 409,
                                      429, 411, 337, 336, 339, 340, 341, 431, 348, 397, 353, 464, 354, 463, 435, 378,
                                      351, 349, 489, 352, 433, 462, 419, 477, 415, 446, 478, 479, 438, 388, 519, 511,
                                      510, 521, 520, 412, 482, 437, 498, 497, 491, 476, 483, 451, 526, 527, 428, 499,
                                      450, 389, 524, 523, 488, 458, 420, 442, 445, 371, 471, 468, 474, 467, 466, 469,
                                      472, 470, 522, 509, 529, 528, 525, 508, 473, 513, 447, 514, 395, 512, 441,);

    const YYNOCODE = 107;

    const YYSTACKDEPTH = 500;

    const YYNSTATE = 335;

    const YYNRULE = 195;

    const YYERRORSYMBOL = 61;

    const YYERRSYMDT = 'yy0';

    const YYFALLBACK = 0;

    public static $yyFallback = array();

    public function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        $this->yyTraceFILE = $TraceFILE;
        $this->yyTracePrompt = $zTracePrompt;
    }

    public function PrintTrace()
    {
        $this->yyTraceFILE = fopen('php://output', 'w');
        $this->yyTracePrompt = '<br>';
    }

    public $yyTraceFILE;

    public $yyTracePrompt;

    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array('$', 'VERT', 'COLON', 'PHP', 'TEXT', 'STRIPON', 'STRIPOFF', 'LITERALSTART',
                                'LITERALEND', 'LITERAL', 'RDEL', 'SIMPELOUTPUT', 'LDEL', 'DOLLARID', 'EQUAL',
                                'SIMPLETAG', 'ID', 'PTR', 'LDELMAKENOCACHE', 'LDELIF', 'LDELFOR', 'SEMICOLON', 'INCDEC',
                                'TO', 'STEP', 'LDELFOREACH', 'SPACE', 'AS', 'APTR', 'LDELSETFILTER',
                                'SMARTYBLOCKCHILDPARENT', 'CLOSETAG', 'LDELSLASH', 'ATTR', 'INTEGER', 'COMMA', 'OPENP',
                                'CLOSEP', 'MATH', 'UNIMATH', 'ISIN', 'QMARK', 'NOT', 'TYPECAST', 'HEX', 'DOT',
                                'INSTANCEOF', 'SINGLEQUOTESTRING', 'DOUBLECOLON', 'NAMESPACE', 'AT', 'HATCH', 'OPENB',
                                'CLOSEB', 'DOLLAR', 'LOGOP', 'SLOGOP', 'TLOGOP', 'SINGLECOND', 'QUOTE', 'BACKTICK',
                                'error', 'start', 'template', 'template_element', 'smartytag', 'literal',
                                'text_content', 'literal_elements', 'literal_element', 'tag', 'variable', 'attributes',
                                'value', 'expr', 'varindexed', 'modifierlist', 'statement', 'statements', 'foraction',
                                'varvar', 'modparameters', 'attribute', 'ternary', 'array', 'tlop', 'lop', 'scond',
                                'function', 'ns1', 'doublequoted_with_quotes', 'static_class_access', 'object',
                                'arrayindex', 'indexdef', 'varvarele', 'objectchain', 'objectelement', 'method',
                                'params', 'modifier', 'modparameter', 'arrayelements', 'arrayelement', 'doublequoted',
                                'doublequotedcontent',);

    public static $yyRuleName = array('start ::= template', 'template ::= template_element',
                                      'template ::= template template_element', 'template ::=',
                                      'template_element ::= smartytag', 'template_element ::= literal',
                                      'template_element ::= PHP', 'template_element ::= text_content',
                                      'text_content ::= TEXT', 'text_content ::= text_content TEXT',
                                      'template_element ::= STRIPON', 'template_element ::= STRIPOFF',
                                      'literal ::= LITERALSTART LITERALEND',
                                      'literal ::= LITERALSTART literal_elements LITERALEND',
                                      'literal_elements ::= literal_elements literal_element', 'literal_elements ::=',
                                      'literal_element ::= literal', 'literal_element ::= LITERAL',
                                      'smartytag ::= tag RDEL', 'smartytag ::= SIMPELOUTPUT', 'tag ::= LDEL variable',
                                      'tag ::= LDEL variable attributes', 'tag ::= LDEL value',
                                      'tag ::= LDEL value attributes', 'tag ::= LDEL expr',
                                      'tag ::= LDEL expr attributes', 'tag ::= LDEL DOLLARID EQUAL value',
                                      'tag ::= LDEL DOLLARID EQUAL expr', 'tag ::= LDEL DOLLARID EQUAL expr attributes',
                                      'tag ::= LDEL varindexed EQUAL expr attributes', 'smartytag ::= SIMPLETAG',
                                      'tag ::= LDEL ID attributes', 'tag ::= LDEL ID',
                                      'tag ::= LDEL ID modifierlist attributes', 'tag ::= LDEL ID PTR ID attributes',
                                      'tag ::= LDEL ID PTR ID modifierlist attributes',
                                      'tag ::= LDELMAKENOCACHE DOLLARID', 'tag ::= LDELIF expr',
                                      'tag ::= LDELIF expr attributes', 'tag ::= LDELIF statement',
                                      'tag ::= LDELIF statement attributes',
                                      'tag ::= LDELFOR statements SEMICOLON expr SEMICOLON varindexed foraction attributes',
                                      'foraction ::= EQUAL expr', 'foraction ::= INCDEC',
                                      'tag ::= LDELFOR statement TO expr attributes',
                                      'tag ::= LDELFOR statement TO expr STEP expr attributes',
                                      'tag ::= LDELFOREACH attributes',
                                      'tag ::= LDELFOREACH SPACE value AS varvar attributes',
                                      'tag ::= LDELFOREACH SPACE value AS varvar APTR varvar attributes',
                                      'tag ::= LDELFOREACH SPACE expr AS varvar attributes',
                                      'tag ::= LDELFOREACH SPACE expr AS varvar APTR varvar attributes',
                                      'tag ::= LDELSETFILTER ID modparameters',
                                      'tag ::= LDELSETFILTER ID modparameters modifierlist',
                                      'tag ::= LDEL SMARTYBLOCKCHILDPARENT', 'smartytag ::= CLOSETAG',
                                      'tag ::= LDELSLASH ID', 'tag ::= LDELSLASH ID modifierlist',
                                      'tag ::= LDELSLASH ID PTR ID', 'tag ::= LDELSLASH ID PTR ID modifierlist',
                                      'attributes ::= attributes attribute', 'attributes ::= attribute',
                                      'attributes ::=', 'attribute ::= SPACE ID EQUAL ID', 'attribute ::= ATTR expr',
                                      'attribute ::= ATTR value', 'attribute ::= SPACE ID', 'attribute ::= SPACE expr',
                                      'attribute ::= SPACE value', 'attribute ::= SPACE INTEGER EQUAL expr',
                                      'statements ::= statement', 'statements ::= statements COMMA statement',
                                      'statement ::= DOLLARID EQUAL INTEGER', 'statement ::= DOLLARID EQUAL expr',
                                      'statement ::= varindexed EQUAL expr', 'statement ::= OPENP statement CLOSEP',
                                      'expr ::= value', 'expr ::= ternary', 'expr ::= DOLLARID COLON ID',
                                      'expr ::= expr MATH value', 'expr ::= expr UNIMATH value', 'expr ::= array',
                                      'expr ::= expr modifierlist', 'expr ::= expr tlop value',
                                      'expr ::= expr lop expr', 'expr ::= expr scond', 'expr ::= expr ISIN array',
                                      'expr ::= expr ISIN value',
                                      'ternary ::= OPENP expr CLOSEP QMARK DOLLARID COLON expr',
                                      'ternary ::= OPENP expr CLOSEP QMARK expr COLON expr', 'value ::= variable',
                                      'value ::= UNIMATH value', 'value ::= NOT value', 'value ::= TYPECAST value',
                                      'value ::= variable INCDEC', 'value ::= HEX', 'value ::= INTEGER',
                                      'value ::= INTEGER DOT INTEGER', 'value ::= INTEGER DOT', 'value ::= DOT INTEGER',
                                      'value ::= ID', 'value ::= function', 'value ::= OPENP expr CLOSEP',
                                      'value ::= variable INSTANCEOF ns1', 'value ::= variable INSTANCEOF variable',
                                      'value ::= SINGLEQUOTESTRING', 'value ::= doublequoted_with_quotes',
                                      'value ::= varindexed DOUBLECOLON static_class_access', 'value ::= smartytag',
                                      'value ::= value modifierlist', 'value ::= NAMESPACE',
                                      'value ::= ns1 DOUBLECOLON static_class_access', 'ns1 ::= ID',
                                      'ns1 ::= NAMESPACE', 'variable ::= DOLLARID', 'variable ::= varindexed',
                                      'variable ::= varvar AT ID', 'variable ::= object', 'variable ::= HATCH ID HATCH',
                                      'variable ::= HATCH ID HATCH arrayindex', 'variable ::= HATCH variable HATCH',
                                      'variable ::= HATCH variable HATCH arrayindex',
                                      'varindexed ::= DOLLARID arrayindex', 'varindexed ::= varvar arrayindex',
                                      'arrayindex ::= arrayindex indexdef', 'arrayindex ::=',
                                      'indexdef ::= DOT DOLLARID', 'indexdef ::= DOT varvar',
                                      'indexdef ::= DOT varvar AT ID', 'indexdef ::= DOT ID',
                                      'indexdef ::= DOT INTEGER', 'indexdef ::= DOT LDEL expr RDEL',
                                      'indexdef ::= OPENB ID CLOSEB', 'indexdef ::= OPENB ID DOT ID CLOSEB',
                                      'indexdef ::= OPENB SINGLEQUOTESTRING CLOSEB',
                                      'indexdef ::= OPENB INTEGER CLOSEB', 'indexdef ::= OPENB DOLLARID CLOSEB',
                                      'indexdef ::= OPENB variable CLOSEB', 'indexdef ::= OPENB value CLOSEB',
                                      'indexdef ::= OPENB expr CLOSEB', 'indexdef ::= OPENB CLOSEB',
                                      'varvar ::= DOLLARID', 'varvar ::= DOLLAR', 'varvar ::= varvar varvarele',
                                      'varvarele ::= ID', 'varvarele ::= SIMPELOUTPUT', 'varvarele ::= LDEL expr RDEL',
                                      'object ::= varindexed objectchain', 'objectchain ::= objectelement',
                                      'objectchain ::= objectchain objectelement',
                                      'objectelement ::= PTR ID arrayindex', 'objectelement ::= PTR varvar arrayindex',
                                      'objectelement ::= PTR LDEL expr RDEL arrayindex',
                                      'objectelement ::= PTR ID LDEL expr RDEL arrayindex',
                                      'objectelement ::= PTR method', 'function ::= ns1 OPENP params CLOSEP',
                                      'method ::= ID OPENP params CLOSEP', 'method ::= DOLLARID OPENP params CLOSEP',
                                      'params ::= params COMMA expr', 'params ::= expr', 'params ::=',
                                      'modifierlist ::= modifierlist modifier modparameters',
                                      'modifierlist ::= modifier modparameters', 'modifier ::= VERT AT ID',
                                      'modifier ::= VERT ID', 'modparameters ::= modparameters modparameter',
                                      'modparameters ::=', 'modparameter ::= COLON value',
                                      'modparameter ::= COLON array', 'static_class_access ::= method',
                                      'static_class_access ::= method objectchain', 'static_class_access ::= ID',
                                      'static_class_access ::= DOLLARID arrayindex',
                                      'static_class_access ::= DOLLARID arrayindex objectchain', 'lop ::= LOGOP',
                                      'lop ::= SLOGOP', 'tlop ::= TLOGOP', 'scond ::= SINGLECOND',
                                      'array ::= OPENB arrayelements CLOSEB', 'arrayelements ::= arrayelement',
                                      'arrayelements ::= arrayelements COMMA arrayelement', 'arrayelements ::=',
                                      'arrayelement ::= value APTR expr', 'arrayelement ::= ID APTR expr',
                                      'arrayelement ::= expr', 'doublequoted_with_quotes ::= QUOTE QUOTE',
                                      'doublequoted_with_quotes ::= QUOTE doublequoted QUOTE',
                                      'doublequoted ::= doublequoted doublequotedcontent',
                                      'doublequoted ::= doublequotedcontent',
                                      'doublequotedcontent ::= BACKTICK variable BACKTICK',
                                      'doublequotedcontent ::= BACKTICK expr BACKTICK',
                                      'doublequotedcontent ::= DOLLARID', 'doublequotedcontent ::= LDEL variable RDEL',
                                      'doublequotedcontent ::= LDEL expr RDEL', 'doublequotedcontent ::= smartytag',
                                      'doublequotedcontent ::= TEXT',);

    public function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[ $tokenType ];
        } else {
            return "Unknown";
        }
    }

    public static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:
                break;   /* If no destructor action specified: do nothing */
        }
    }

    public function yy_pop_parser_stack()
    {
        if (empty($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if ($this->yyTraceFILE && $this->yyidx >= 0) {
            fwrite($this->yyTraceFILE, $this->yyTracePrompt . 'Popping ' . $this->yyTokenName[ $yytos->major ] . "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx --;

        return $yymajor;
    }

    public function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    public function yy_get_expected_tokens($token)
    {
        static $res3 = array();
        static $res4 = array();
        $state = $this->yystack[ $this->yyidx ]->stateno;
        $expected = self::$yyExpectedTokens[ $state ];
        if (isset($res3[ $state ][ $token ])) {
            if ($res3[ $state ][ $token ]) {
                return $expected;
            }
        } else {
            if ($res3[ $state ][ $token ] = in_array($token, self::$yyExpectedTokens[ $state ], true)) {
                return $expected;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done ++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[ $yyruleno ][ 1 ];
                    $nextstate = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno,
                                                              self::$yyRuleInfo[ $yyruleno ][ 0 ]);
                    if (isset(self::$yyExpectedTokens[ $nextstate ])) {
                        $expected = array_merge($expected, self::$yyExpectedTokens[ $nextstate ]);
                        if (isset($res4[ $nextstate ][ $token ])) {
                            if ($res4[ $nextstate ][ $token ]) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        } else {
                            if ($res4[ $nextstate ][ $token ] =
                                in_array($token, self::$yyExpectedTokens[ $nextstate ], true)
                            ) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx ++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[ $yyruleno ][ 0 ];
                        $this->yystack[ $this->yyidx ] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                }
                while (true);
            }
            break;
        }
        while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return array_unique($expected);
    }

    public function yy_is_expected_token($token)
    {
        static $res = array();
        static $res2 = array();
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[ $this->yyidx ]->stateno;
        if (isset($res[ $state ][ $token ])) {
            if ($res[ $state ][ $token ]) {
                return true;
            }
        } else {
            if ($res[ $state ][ $token ] = in_array($token, self::$yyExpectedTokens[ $state ], true)) {
                return true;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done ++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[ $yyruleno ][ 1 ];
                    $nextstate = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno,
                                                              self::$yyRuleInfo[ $yyruleno ][ 0 ]);
                    if (isset($res2[ $nextstate ][ $token ])) {
                        if ($res2[ $nextstate ][ $token ]) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    } else {
                        if ($res2[ $nextstate ][ $token ] = (isset(self::$yyExpectedTokens[ $nextstate ]) &&
                                                             in_array($token, self::$yyExpectedTokens[ $nextstate ],
                                                                      true))
                        ) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx ++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[ $yyruleno ][ 0 ];
                        $this->yystack[ $this->yyidx ] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                }
                while (true);
            }
            break;
        }
        while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return true;
    }

    public function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[ $this->yyidx ]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[ $stateno ])) {
            // no shift actions
            return self::$yy_default[ $stateno ];
        }
        $i = self::$yy_shift_ofst[ $stateno ];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[ $stateno ];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB || self::$yy_lookahead[ $i ] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback) &&
                ($iFallback = self::$yyFallback[ $iLookAhead ]) != 0
            ) {
                if ($this->yyTraceFILE) {
                    fwrite($this->yyTraceFILE,
                           $this->yyTracePrompt . "FALLBACK " . $this->yyTokenName[ $iLookAhead ] . " => " .
                           $this->yyTokenName[ $iFallback ] . "\n");
                }

                return $this->yy_find_shift_action($iFallback);
            }

            return self::$yy_default[ $stateno ];
        } else {
            return self::$yy_action[ $i ];
        }
    }

    public function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[ $stateno ])) {
            return self::$yy_default[ $stateno ];
        }
        $i = self::$yy_reduce_ofst[ $stateno ];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[ $stateno ];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB || self::$yy_lookahead[ $i ] != $iLookAhead) {
            return self::$yy_default[ $stateno ];
        } else {
            return self::$yy_action[ $i ];
        }
    }

    public function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx ++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx --;
            if ($this->yyTraceFILE) {
                fprintf($this->yyTraceFILE, "%sStack Overflow!\n", $this->yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            #line 207 "../smarty/lexer/smarty_internal_templateparser.y"

            $this->internalError = true;
            $this->compiler->trigger_template_error("Stack overflow in template parser");

            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        $this->yystack[] = $yytos;
        if ($this->yyTraceFILE && $this->yyidx > 0) {
            fprintf($this->yyTraceFILE, "%sShift %d\n", $this->yyTracePrompt, $yyNewState);
            fprintf($this->yyTraceFILE, "%sStack:", $this->yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i ++) {
                fprintf($this->yyTraceFILE, " %s", $this->yyTokenName[ $this->yystack[ $i ]->major ]);
            }
            fwrite($this->yyTraceFILE, "\n");
        }
    }

    public static $yyRuleInfo = array(array(0 => 62, 1 => 1), array(0 => 63, 1 => 1), array(0 => 63, 1 => 2),
                                      array(0 => 63, 1 => 0), array(0 => 64, 1 => 1), array(0 => 64, 1 => 1),
                                      array(0 => 64, 1 => 1), array(0 => 64, 1 => 1), array(0 => 67, 1 => 1),
                                      array(0 => 67, 1 => 2), array(0 => 64, 1 => 1), array(0 => 64, 1 => 1),
                                      array(0 => 66, 1 => 2), array(0 => 66, 1 => 3), array(0 => 68, 1 => 2),
                                      array(0 => 68, 1 => 0), array(0 => 69, 1 => 1), array(0 => 69, 1 => 1),
                                      array(0 => 65, 1 => 2), array(0 => 65, 1 => 1), array(0 => 70, 1 => 2),
                                      array(0 => 70, 1 => 3), array(0 => 70, 1 => 2), array(0 => 70, 1 => 3),
                                      array(0 => 70, 1 => 2), array(0 => 70, 1 => 3), array(0 => 70, 1 => 4),
                                      array(0 => 70, 1 => 4), array(0 => 70, 1 => 5), array(0 => 70, 1 => 5),
                                      array(0 => 65, 1 => 1), array(0 => 70, 1 => 3), array(0 => 70, 1 => 2),
                                      array(0 => 70, 1 => 4), array(0 => 70, 1 => 5), array(0 => 70, 1 => 6),
                                      array(0 => 70, 1 => 2), array(0 => 70, 1 => 2), array(0 => 70, 1 => 3),
                                      array(0 => 70, 1 => 2), array(0 => 70, 1 => 3), array(0 => 70, 1 => 8),
                                      array(0 => 79, 1 => 2), array(0 => 79, 1 => 1), array(0 => 70, 1 => 5),
                                      array(0 => 70, 1 => 7), array(0 => 70, 1 => 2), array(0 => 70, 1 => 6),
                                      array(0 => 70, 1 => 8), array(0 => 70, 1 => 6), array(0 => 70, 1 => 8),
                                      array(0 => 70, 1 => 3), array(0 => 70, 1 => 4), array(0 => 70, 1 => 2),
                                      array(0 => 65, 1 => 1), array(0 => 70, 1 => 2), array(0 => 70, 1 => 3),
                                      array(0 => 70, 1 => 4), array(0 => 70, 1 => 5), array(0 => 72, 1 => 2),
                                      array(0 => 72, 1 => 1), array(0 => 72, 1 => 0), array(0 => 82, 1 => 4),
                                      array(0 => 82, 1 => 2), array(0 => 82, 1 => 2), array(0 => 82, 1 => 2),
                                      array(0 => 82, 1 => 2), array(0 => 82, 1 => 2), array(0 => 82, 1 => 4),
                                      array(0 => 78, 1 => 1), array(0 => 78, 1 => 3), array(0 => 77, 1 => 3),
                                      array(0 => 77, 1 => 3), array(0 => 77, 1 => 3), array(0 => 77, 1 => 3),
                                      array(0 => 74, 1 => 1), array(0 => 74, 1 => 1), array(0 => 74, 1 => 3),
                                      array(0 => 74, 1 => 3), array(0 => 74, 1 => 3), array(0 => 74, 1 => 1),
                                      array(0 => 74, 1 => 2), array(0 => 74, 1 => 3), array(0 => 74, 1 => 3),
                                      array(0 => 74, 1 => 2), array(0 => 74, 1 => 3), array(0 => 74, 1 => 3),
                                      array(0 => 83, 1 => 7), array(0 => 83, 1 => 7), array(0 => 73, 1 => 1),
                                      array(0 => 73, 1 => 2), array(0 => 73, 1 => 2), array(0 => 73, 1 => 2),
                                      array(0 => 73, 1 => 2), array(0 => 73, 1 => 1), array(0 => 73, 1 => 1),
                                      array(0 => 73, 1 => 3), array(0 => 73, 1 => 2), array(0 => 73, 1 => 2),
                                      array(0 => 73, 1 => 1), array(0 => 73, 1 => 1), array(0 => 73, 1 => 3),
                                      array(0 => 73, 1 => 3), array(0 => 73, 1 => 3), array(0 => 73, 1 => 1),
                                      array(0 => 73, 1 => 1), array(0 => 73, 1 => 3), array(0 => 73, 1 => 1),
                                      array(0 => 73, 1 => 2), array(0 => 73, 1 => 1), array(0 => 73, 1 => 3),
                                      array(0 => 89, 1 => 1), array(0 => 89, 1 => 1), array(0 => 71, 1 => 1),
                                      array(0 => 71, 1 => 1), array(0 => 71, 1 => 3), array(0 => 71, 1 => 1),
                                      array(0 => 71, 1 => 3), array(0 => 71, 1 => 4), array(0 => 71, 1 => 3),
                                      array(0 => 71, 1 => 4), array(0 => 75, 1 => 2), array(0 => 75, 1 => 2),
                                      array(0 => 93, 1 => 2), array(0 => 93, 1 => 0), array(0 => 94, 1 => 2),
                                      array(0 => 94, 1 => 2), array(0 => 94, 1 => 4), array(0 => 94, 1 => 2),
                                      array(0 => 94, 1 => 2), array(0 => 94, 1 => 4), array(0 => 94, 1 => 3),
                                      array(0 => 94, 1 => 5), array(0 => 94, 1 => 3), array(0 => 94, 1 => 3),
                                      array(0 => 94, 1 => 3), array(0 => 94, 1 => 3), array(0 => 94, 1 => 3),
                                      array(0 => 94, 1 => 3), array(0 => 94, 1 => 2), array(0 => 80, 1 => 1),
                                      array(0 => 80, 1 => 1), array(0 => 80, 1 => 2), array(0 => 95, 1 => 1),
                                      array(0 => 95, 1 => 1), array(0 => 95, 1 => 3), array(0 => 92, 1 => 2),
                                      array(0 => 96, 1 => 1), array(0 => 96, 1 => 2), array(0 => 97, 1 => 3),
                                      array(0 => 97, 1 => 3), array(0 => 97, 1 => 5), array(0 => 97, 1 => 6),
                                      array(0 => 97, 1 => 2), array(0 => 88, 1 => 4), array(0 => 98, 1 => 4),
                                      array(0 => 98, 1 => 4), array(0 => 99, 1 => 3), array(0 => 99, 1 => 1),
                                      array(0 => 99, 1 => 0), array(0 => 76, 1 => 3), array(0 => 76, 1 => 2),
                                      array(0 => 100, 1 => 3), array(0 => 100, 1 => 2), array(0 => 81, 1 => 2),
                                      array(0 => 81, 1 => 0), array(0 => 101, 1 => 2), array(0 => 101, 1 => 2),
                                      array(0 => 91, 1 => 1), array(0 => 91, 1 => 2), array(0 => 91, 1 => 1),
                                      array(0 => 91, 1 => 2), array(0 => 91, 1 => 3), array(0 => 86, 1 => 1),
                                      array(0 => 86, 1 => 1), array(0 => 85, 1 => 1), array(0 => 87, 1 => 1),
                                      array(0 => 84, 1 => 3), array(0 => 102, 1 => 1), array(0 => 102, 1 => 3),
                                      array(0 => 102, 1 => 0), array(0 => 103, 1 => 3), array(0 => 103, 1 => 3),
                                      array(0 => 103, 1 => 1), array(0 => 90, 1 => 2), array(0 => 90, 1 => 3),
                                      array(0 => 104, 1 => 2), array(0 => 104, 1 => 1), array(0 => 105, 1 => 3),
                                      array(0 => 105, 1 => 3), array(0 => 105, 1 => 1), array(0 => 105, 1 => 3),
                                      array(0 => 105, 1 => 3), array(0 => 105, 1 => 1), array(0 => 105, 1 => 1),);

    public static $yyReduceMap = array(0 => 0, 1 => 1, 2 => 2, 4 => 4, 5 => 5, 6 => 6, 7 => 7, 8 => 8, 16 => 8, 17 => 8,
                                       43 => 8, 66 => 8, 67 => 8, 75 => 8, 76 => 8, 80 => 8, 89 => 8, 94 => 8, 95 => 8,
                                       100 => 8, 104 => 8, 105 => 8, 109 => 8, 111 => 8, 116 => 8, 178 => 8, 183 => 8,
                                       9 => 9, 10 => 10, 11 => 11, 12 => 12, 15 => 12, 13 => 13, 74 => 13, 14 => 14,
                                       90 => 14, 92 => 14, 93 => 14, 123 => 14, 18 => 18, 19 => 19, 20 => 20, 22 => 20,
                                       24 => 20, 21 => 21, 23 => 21, 25 => 21, 26 => 26, 27 => 26, 28 => 28, 29 => 29,
                                       30 => 30, 31 => 31, 32 => 32, 33 => 33, 34 => 34, 35 => 35, 36 => 36, 37 => 37,
                                       38 => 38, 40 => 38, 39 => 39, 41 => 41, 42 => 42, 44 => 44, 45 => 45, 46 => 46,
                                       47 => 47, 49 => 47, 48 => 48, 50 => 48, 51 => 51, 52 => 52, 53 => 53, 54 => 54,
                                       55 => 55, 56 => 56, 57 => 57, 58 => 58, 59 => 59, 60 => 60, 69 => 60, 158 => 60,
                                       162 => 60, 166 => 60, 167 => 60, 61 => 61, 159 => 61, 165 => 61, 62 => 62,
                                       63 => 63, 64 => 63, 65 => 65, 143 => 65, 68 => 68, 70 => 70, 71 => 71, 72 => 71,
                                       73 => 73, 77 => 77, 78 => 78, 79 => 78, 81 => 81, 108 => 81, 82 => 82, 83 => 83,
                                       84 => 84, 85 => 85, 86 => 86, 87 => 87, 88 => 88, 91 => 91, 96 => 96, 97 => 97,
                                       98 => 98, 99 => 99, 101 => 101, 102 => 102, 103 => 102, 106 => 106, 107 => 107,
                                       110 => 110, 112 => 112, 113 => 113, 114 => 114, 115 => 115, 117 => 117,
                                       118 => 118, 119 => 119, 120 => 120, 121 => 121, 122 => 122, 124 => 124,
                                       180 => 124, 125 => 125, 126 => 126, 127 => 127, 128 => 128, 129 => 129,
                                       130 => 130, 138 => 130, 131 => 131, 132 => 132, 133 => 133, 134 => 133,
                                       136 => 133, 137 => 133, 135 => 135, 139 => 139, 140 => 140, 141 => 141,
                                       184 => 141, 142 => 142, 144 => 144, 145 => 145, 146 => 146, 147 => 147,
                                       148 => 148, 149 => 149, 150 => 150, 151 => 151, 152 => 152, 153 => 153,
                                       154 => 154, 155 => 155, 156 => 156, 157 => 157, 160 => 160, 161 => 161,
                                       163 => 163, 164 => 164, 168 => 168, 169 => 169, 170 => 170, 171 => 171,
                                       172 => 172, 173 => 173, 174 => 174, 175 => 175, 176 => 176, 177 => 177,
                                       179 => 179, 181 => 181, 182 => 182, 185 => 185, 186 => 186, 187 => 187,
                                       188 => 188, 189 => 188, 191 => 188, 190 => 190, 192 => 192, 193 => 193,
                                       194 => 194,);

    #line 218 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r0()
    {
        $this->root_buffer->prepend_array($this, $this->template_prefix);
        $this->root_buffer->append_array($this, $this->template_postfix);
        $this->_retvalue = $this->root_buffer->to_smarty_php($this);
    }

    #line 228 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r1()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor != null) {
            $this->current_buffer->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 235 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r2()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor != null) {
            // because of possible code injection
            $this->current_buffer->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 249 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r4()
    {
        if ($this->compiler->has_code) {
            $this->_retvalue = $this->mergePrefixCode($this->yystack[ $this->yyidx + 0 ]->minor);
        } else {
            $this->_retvalue = null;
        }
        $this->compiler->has_variable_string = false;
        $this->block_nesting_level = count($this->compiler->_tag_stack);
    }

    #line 260 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r5()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Text($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 264 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r6()
    {
        $code = $this->compiler->compileTag('private_php',
                                            array(array('code' => $this->yystack[ $this->yyidx + 0 ]->minor),
                                                  array('type' => $this->lex->phpType)), array());
        if ($this->compiler->has_code && !empty($code)) {
            $tmp = '';
            foreach ($this->compiler->prefix_code as $code) {
                $tmp .= $code;
            }
            $this->compiler->prefix_code = array();
            $this->_retvalue =
                new Smarty_Internal_ParseTree_Tag($this, $this->compiler->processNocacheCode($tmp . $code, true));
        } else {
            $this->_retvalue = null;
        }
    }

    #line 275 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r7()
    {
        $this->_retvalue = $this->compiler->processText($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 279 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r8()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 283 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r9()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 288 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r10()
    {
        $this->strip = true;
    }

    #line 292 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r11()
    {
        $this->strip = false;
    }

    #line 297 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r12()
    {
        $this->_retvalue = '';
    }

    #line 301 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r13()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 305 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r14()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 321 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r18()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 327 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r19()
    {
        $var =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' $');
        if (preg_match('/^(.*)(\s+nocache)$/', $var, $match)) {
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array('nocache'),
                                                           array('value' => $this->compiler->compileVariable('\'' .
                                                                                                             $match[ 1 ] .
                                                                                                             '\'')));
        } else {
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                           array('value' => $this->compiler->compileVariable('\'' .
                                                                                                             $var .
                                                                                                             '\'')));
        }
    }

    #line 337 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r20()
    {
        $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                       array('value' => $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 341 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r21()
    {
        $this->_retvalue =
            $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                        array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor));
    }

    #line 364 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r26()
    {
        $this->_retvalue = $this->compiler->compileTag('assign', array(array('value' => $this->yystack[ $this->yyidx +
                                                                                                        0 ]->minor),
                                                                       array('var' => '\'' .
                                                                                      substr($this->yystack[ $this->yyidx +
                                                                                                             - 2 ]->minor,
                                                                                             1) . '\'')));
    }

    #line 372 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r28()
    {
        $this->_retvalue = $this->compiler->compileTag('assign',
                                                       array_merge(array(array('value' => $this->yystack[ $this->yyidx +
                                                                                                          - 1 ]->minor),
                                                                         array('var' => '\'' .
                                                                                        substr($this->yystack[ $this->yyidx +
                                                                                                               - 3 ]->minor,
                                                                                               1) . '\'')),
                                                                   $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 376 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r29()
    {
        $this->_retvalue = $this->compiler->compileTag('assign',
                                                       array_merge(array(array('value' => $this->yystack[ $this->yyidx +
                                                                                                          - 1 ]->minor),
                                                                         array('var' => $this->yystack[ $this->yyidx +
                                                                                                        - 3 ]->minor[ 'var' ])),
                                                                   $this->yystack[ $this->yyidx + 0 ]->minor),
                                                       array('smarty_internal_index' => $this->yystack[ $this->yyidx +
                                                                                                        - 3 ]->minor[ 'smarty_internal_index' ]));
    }

    #line 381 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r30()
    {
        $tag =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length));
        if ($tag == 'strip') {
            $this->strip = true;
            $this->_retvalue = null;;
        } else {
            if (defined($tag)) {
                if ($this->security) {
                    $this->security->isTrustedConstant($tag, $this->compiler);
                }
                $this->_retvalue =
                    $this->compiler->compileTag('private_print_expression', array(), array('value' => $tag));
            } else {
                if (preg_match('/^(.*)(\s+nocache)$/', $tag, $match)) {
                    $this->_retvalue = $this->compiler->compileTag($match[ 1 ], array("'nocache'"));
                } else {
                    $this->_retvalue = $this->compiler->compileTag($tag, array());
                }
            }
        }
    }

    #line 403 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r31()
    {
        if (defined($this->yystack[ $this->yyidx + - 1 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + - 1 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                            array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                           $this->yystack[ $this->yyidx + 0 ]->minor);
        }
    }

    #line 413 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r32()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compileTag('private_print_expression', array(),
                                                           array('value' => $this->yystack[ $this->yyidx + 0 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + 0 ]->minor, array());
        }
    }

    #line 426 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r33()
    {
        if (defined($this->yystack[ $this->yyidx + - 2 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + - 2 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                $this->compiler->compileTag('private_print_expression', $this->yystack[ $this->yyidx + 0 ]->minor,
                                            array('value' => $this->yystack[ $this->yyidx + - 2 ]->minor,
                                                  'modifierlist' => $this->yystack[ $this->yyidx + - 1 ]->minor));
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 2 ]->minor,
                                                           $this->yystack[ $this->yyidx + 0 ]->minor,
                                                           array('modifierlist' => $this->yystack[ $this->yyidx +
                                                                                                   - 1 ]->minor));
        }
    }

    #line 438 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r34()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 3 ]->minor,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                                                                - 1 ]->minor));
    }

    #line 443 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r35()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 4 ]->minor,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('modifierlist' => $this->yystack[ $this->yyidx +
                                                                                               - 1 ]->minor,
                                                             'object_method' => $this->yystack[ $this->yyidx +
                                                                                                - 2 ]->minor));
    }

    #line 448 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r36()
    {
        $this->_retvalue = $this->compiler->compileTag('make_nocache', array(array('var' => '\'' .
                                                                                            substr($this->yystack[ $this->yyidx +
                                                                                                                   0 ]->minor,
                                                                                                   1) . '\'')));
    }

    #line 453 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r37()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 1 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag, array(),
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                                                               0 ]->minor));
    }

    #line 458 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r38()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 2 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag,
                                                       $this->yystack[ $this->yyidx + 0 ]->minor,
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                                                               - 1 ]->minor));
    }

    #line 463 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r39()
    {
        $tag = trim(substr($this->yystack[ $this->yyidx + - 1 ]->minor, $this->lex->ldel_length));
        $this->_retvalue = $this->compiler->compileTag(($tag == 'else if') ? 'elseif' : $tag, array(),
                                                       array('if condition' => $this->yystack[ $this->yyidx +
                                                                                               0 ]->minor));
    }

    #line 474 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r41()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                                                                 - 6 ]->minor),
                                                                                array('ifexp' => $this->yystack[ $this->yyidx +
                                                                                                                 - 4 ]->minor),
                                                                                array('var' => $this->yystack[ $this->yyidx +
                                                                                                               - 2 ]->minor),
                                                                                array('step' => $this->yystack[ $this->yyidx +
                                                                                                                - 1 ]->minor))),
                                                       1);
    }

    #line 478 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r42()
    {
        $this->_retvalue = '=' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 486 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r44()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                                                                 - 3 ]->minor),
                                                                                array('to' => $this->yystack[ $this->yyidx +
                                                                                                              - 1 ]->minor))),
                                                       0);
    }

    #line 490 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r45()
    {
        $this->_retvalue = $this->compiler->compileTag('for', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                          array(array('start' => $this->yystack[ $this->yyidx +
                                                                                                                 - 5 ]->minor),
                                                                                array('to' => $this->yystack[ $this->yyidx +
                                                                                                              - 3 ]->minor),
                                                                                array('step' => $this->yystack[ $this->yyidx +
                                                                                                                - 1 ]->minor))),
                                                       0);
    }

    #line 495 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r46()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 500 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r47()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                              array(array('from' => $this->yystack[ $this->yyidx +
                                                                                                                    - 3 ]->minor),
                                                                                    array('item' => $this->yystack[ $this->yyidx +
                                                                                                                    - 1 ]->minor))));
    }

    #line 504 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r48()
    {
        $this->_retvalue = $this->compiler->compileTag('foreach', array_merge($this->yystack[ $this->yyidx + 0 ]->minor,
                                                                              array(array('from' => $this->yystack[ $this->yyidx +
                                                                                                                    - 5 ]->minor),
                                                                                    array('item' => $this->yystack[ $this->yyidx +
                                                                                                                    - 1 ]->minor),
                                                                                    array('key' => $this->yystack[ $this->yyidx +
                                                                                                                   - 3 ]->minor))));
    }

    #line 517 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r51()
    {
        $this->_retvalue = $this->compiler->compileTag('setfilter', array(),
                                                       array('modifier_list' => array(array_merge(array($this->yystack[ $this->yyidx +
                                                                                                                        - 1 ]->minor),
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  0 ]->minor))));
    }

    #line 521 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r52()
    {
        $this->_retvalue = $this->compiler->compileTag('setfilter', array(),
                                                       array('modifier_list' => array_merge(array(array_merge(array($this->yystack[ $this->yyidx +
                                                                                                                                    - 2 ]->minor),
                                                                                                              $this->yystack[ $this->yyidx +
                                                                                                                              - 1 ]->minor)),
                                                                                            $this->yystack[ $this->yyidx +
                                                                                                            0 ]->minor)));
    }

    #line 526 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r53()
    {
        $j = strrpos($this->yystack[ $this->yyidx + 0 ]->minor, '.');
        if ($this->yystack[ $this->yyidx + 0 ]->minor[ $j + 1 ] == 'c') {
            // {$smarty.block.child}
            $this->_retvalue = $this->compiler->compileTag('block_child', array());;
        } else {
            // {$smarty.block.parent}
            $this->_retvalue = $this->compiler->compileTag('block_parent', array());;
        }
    }

    #line 539 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r54()
    {
        $tag =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' /');
        if ($tag == 'strip') {
            $this->strip = false;
            $this->_retvalue = null;
        } else {
            $this->_retvalue = $this->compiler->compileTag($tag . 'close', array());
        }
    }

    #line 548 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r55()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + 0 ]->minor . 'close', array());
    }

    #line 552 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r56()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 1 ]->minor . 'close', array(),
                                                       array('modifier_list' => $this->yystack[ $this->yyidx +
                                                                                                0 ]->minor));
    }

    #line 557 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r57()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 2 ]->minor . 'close', array(),
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                                                                0 ]->minor));
    }

    #line 561 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r58()
    {
        $this->_retvalue = $this->compiler->compileTag($this->yystack[ $this->yyidx + - 3 ]->minor . 'close', array(),
                                                       array('object_method' => $this->yystack[ $this->yyidx +
                                                                                                - 1 ]->minor,
                                                             'modifier_list' => $this->yystack[ $this->yyidx +
                                                                                                0 ]->minor));
    }

    #line 569 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r59()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
        $this->_retvalue[] = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 575 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r60()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 580 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r61()
    {
        $this->_retvalue = array();
    }

    #line 585 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r62()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue =
                array($this->yystack[ $this->yyidx + - 2 ]->minor => $this->yystack[ $this->yyidx + 0 ]->minor);
        } else {
            $this->_retvalue =
                array($this->yystack[ $this->yyidx + - 2 ]->minor => '\'' . $this->yystack[ $this->yyidx + 0 ]->minor .
                                                                     '\'');
        }
    }

    #line 596 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r63()
    {
        $this->_retvalue =
            array(trim($this->yystack[ $this->yyidx + - 1 ]->minor, " =\n\r\t") => $this->yystack[ $this->yyidx +
                                                                                                   0 ]->minor);
    }

    #line 604 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r65()
    {
        $this->_retvalue = '\'' . $this->yystack[ $this->yyidx + 0 ]->minor . '\'';
    }

    #line 616 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r68()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 2 ]->minor => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 629 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r70()
    {
        $this->yystack[ $this->yyidx + - 2 ]->minor[] = $this->yystack[ $this->yyidx + 0 ]->minor;
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor;
    }

    #line 634 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r71()
    {
        $this->_retvalue = array('var' => '\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '\'',
                                 'value' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 641 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r73()
    {
        $this->_retvalue = array('var' => $this->yystack[ $this->yyidx + - 2 ]->minor,
                                 'value' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 665 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r77()
    {
        $this->_retvalue =
            '$_smarty_tpl->getStreamVariable(\'' . substr($this->yystack[ $this->yyidx + - 2 ]->minor, 1) . '://' .
            $this->yystack[ $this->yyidx + 0 ]->minor . '\')';
    }

    #line 670 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r78()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . trim($this->yystack[ $this->yyidx + - 1 ]->minor) .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 684 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r81()
    {
        $this->_retvalue = $this->compiler->compileTag('private_modifier', array(),
                                                       array('value' => $this->yystack[ $this->yyidx + - 1 ]->minor,
                                                             'modifierlist' => $this->yystack[ $this->yyidx +
                                                                                               0 ]->minor));
    }

    #line 690 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r82()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 1 ]->minor[ 'pre' ] . $this->yystack[ $this->yyidx + - 2 ]->minor .
            $this->yystack[ $this->yyidx + - 1 ]->minor[ 'op' ] . $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 694 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r83()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor .
                           $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 698 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r84()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + 0 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 702 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r85()
    {
        $this->_retvalue = 'in_array(' . $this->yystack[ $this->yyidx + - 2 ]->minor . ',' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 706 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r86()
    {
        $this->_retvalue = 'in_array(' . $this->yystack[ $this->yyidx + - 2 ]->minor . ',(array)' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ')';
    }

    #line 714 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r87()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 5 ]->minor . ' ? ' . $this->compiler->compileVariable('\'' .
                                                                                                                  substr($this->yystack[ $this->yyidx +
                                                                                                                                         - 2 ]->minor,
                                                                                                                         1) .
                                                                                                                  '\'') .
                           ' : ' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 718 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r88()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 5 ]->minor . ' ? ' . $this->yystack[ $this->yyidx + - 2 ]->minor . ' : ' .
            $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 733 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r91()
    {
        $this->_retvalue = '!' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 754 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r96()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 758 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r97()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . '.';
    }

    #line 762 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r98()
    {
        $this->_retvalue = '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 767 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r99()
    {
        if (defined($this->yystack[ $this->yyidx + 0 ]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler);
            }
            $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
        } else {
            $this->_retvalue = '\'' . $this->yystack[ $this->yyidx + 0 ]->minor . '\'';
        }
    }

    #line 784 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r101()
    {
        $this->_retvalue = "(" . $this->yystack[ $this->yyidx + - 1 ]->minor . ")";
    }

    #line 788 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r102()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + - 1 ]->minor .
                           $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 806 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r106()
    {
        $prefixVar = $this->compiler->getNewPrefixVariable();
        if ($this->yystack[ $this->yyidx + - 2 ]->minor[ 'var' ] == '\'smarty\'') {
            $this->compiler->appendPrefixCode("<?php $prefixVar" . ' = ' .
                                              $this->compiler->compileTag('private_special_variable', array(),
                                                                          $this->yystack[ $this->yyidx +
                                                                                          - 2 ]->minor[ 'smarty_internal_index' ]) .
                                              ';?>');
        } else {
            $this->compiler->appendPrefixCode("<?php $prefixVar" . ' = ' .
                                              $this->compiler->compileVariable($this->yystack[ $this->yyidx +
                                                                                               - 2 ]->minor[ 'var' ]) .
                                              $this->yystack[ $this->yyidx + - 2 ]->minor[ 'smarty_internal_index' ] .
                                              ';?>');
        }
        $this->_retvalue = $prefixVar . '::' . $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] .
                           $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
    }

    #line 817 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r107()
    {
        $prefixVar = $this->compiler->getNewPrefixVariable();
        $tmp = $this->compiler->appendCode('<?php ob_start();?>', $this->yystack[ $this->yyidx + 0 ]->minor);
        $this->compiler->appendPrefixCode($this->compiler->appendCode($tmp, "<?php $prefixVar" . '=ob_get_clean();?>'));
        $this->_retvalue = $prefixVar;
    }

    #line 834 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r110()
    {
        if (!in_array(strtolower($this->yystack[ $this->yyidx + - 2 ]->minor), array('self', 'parent')) &&
            (!$this->security ||
             $this->security->isTrustedStaticClassAccess($this->yystack[ $this->yyidx + - 2 ]->minor,
                                                         $this->yystack[ $this->yyidx + 0 ]->minor, $this->compiler))
        ) {
            if (isset($this->smarty->registered_classes[ $this->yystack[ $this->yyidx + - 2 ]->minor ])) {
                $this->_retvalue =
                    $this->smarty->registered_classes[ $this->yystack[ $this->yyidx + - 2 ]->minor ] . '::' .
                    $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] . $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
            } else {
                $this->_retvalue = $this->yystack[ $this->yyidx + - 2 ]->minor . '::' .
                                   $this->yystack[ $this->yyidx + 0 ]->minor[ 0 ] .
                                   $this->yystack[ $this->yyidx + 0 ]->minor[ 1 ];
            }
        } else {
            $this->compiler->trigger_template_error("static class '" . $this->yystack[ $this->yyidx + - 2 ]->minor .
                                                    "' is undefined or not allowed by security setting");
        }
    }

    #line 853 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r112()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 864 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r113()
    {
        $this->_retvalue =
            $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'');
    }

    #line 867 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r114()
    {
        if ($this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ] == '\'smarty\'') {
            $smarty_var = $this->compiler->compileTag('private_special_variable', array(),
                                                      $this->yystack[ $this->yyidx +
                                                                      0 ]->minor[ 'smarty_internal_index' ]);
            $this->_retvalue = $smarty_var;
        } else {
            // used for array reset,next,prev,end,current
            $this->last_variable = $this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ];
            $this->last_index = $this->yystack[ $this->yyidx + 0 ]->minor[ 'smarty_internal_index' ];
            $this->_retvalue = $this->compiler->compileVariable($this->yystack[ $this->yyidx + 0 ]->minor[ 'var' ]) .
                               $this->yystack[ $this->yyidx + 0 ]->minor[ 'smarty_internal_index' ];
        }
    }

    #line 880 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r115()
    {
        $this->_retvalue = '$_smarty_tpl->tpl_vars[' . $this->yystack[ $this->yyidx + - 2 ]->minor . ']->' .
                           $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 890 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r117()
    {
        $this->_retvalue =
            $this->compiler->compileConfigVariable("'" . $this->yystack[ $this->yyidx + - 1 ]->minor . "'");
    }

    #line 894 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r118()
    {
        $this->_retvalue = '(is_array($tmp = ' .
                           $this->compiler->compileConfigVariable("'" . $this->yystack[ $this->yyidx + - 2 ]->minor .
                                                                  "'") . ') ? $tmp' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ' :null)';
    }

    #line 898 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r119()
    {
        $this->_retvalue = $this->compiler->compileConfigVariable($this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 902 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r120()
    {
        $this->_retvalue =
            '(is_array($tmp = ' . $this->compiler->compileConfigVariable($this->yystack[ $this->yyidx + - 2 ]->minor) .
            ') ? $tmp' . $this->yystack[ $this->yyidx + 0 ]->minor . ' : null)';
    }

    #line 906 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r121()
    {
        $this->_retvalue = array('var' => '\'' . substr($this->yystack[ $this->yyidx + - 1 ]->minor, 1) . '\'',
                                 'smarty_internal_index' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 909 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r122()
    {
        $this->_retvalue = array('var' => $this->yystack[ $this->yyidx + - 1 ]->minor,
                                 'smarty_internal_index' => $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 922 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r124()
    {
        return;
    }

    #line 928 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r125()
    {
        $this->_retvalue =
            '[' . $this->compiler->compileVariable('\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'') .
            ']';
    }

    #line 931 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r126()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + 0 ]->minor) . ']';
    }

    #line 935 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r127()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 2 ]->minor) . '->' .
                           $this->yystack[ $this->yyidx + 0 ]->minor . ']';
    }

    #line 939 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r128()
    {
        $this->_retvalue = "['" . $this->yystack[ $this->yyidx + 0 ]->minor . "']";
    }

    #line 943 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r129()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + 0 ]->minor . ']';
    }

    #line 948 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r130()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + - 1 ]->minor . ']';
    }

    #line 953 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r131()
    {
        $this->_retvalue = '[' . $this->compiler->compileTag('private_special_variable', array(), '[\'section\'][\'' .
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  - 1 ]->minor .
                                                                                                  '\'][\'index\']') .
                           ']';
    }

    #line 957 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r132()
    {
        $this->_retvalue = '[' . $this->compiler->compileTag('private_special_variable', array(), '[\'section\'][\'' .
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  - 3 ]->minor .
                                                                                                  '\'][\'' .
                                                                                                  $this->yystack[ $this->yyidx +
                                                                                                                  - 1 ]->minor .
                                                                                                  '\']') . ']';
    }

    #line 960 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r133()
    {
        $this->_retvalue = '[' . $this->yystack[ $this->yyidx + - 1 ]->minor . ']';
    }

    #line 966 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r135()
    {
        $this->_retvalue = '[' . $this->compiler->compileVariable('\'' .
                                                                  substr($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                                         1) . '\'') . ']';;
    }

    #line 982 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r139()
    {
        $this->_retvalue = '[]';
    }

    #line 992 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r140()
    {
        $this->_retvalue = '\'' . substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) . '\'';
    }

    #line 996 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r141()
    {
        $this->_retvalue = "''";
    }

    #line 1001 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r142()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 1 ]->minor . '.' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1009 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r144()
    {
        $var =
            trim(substr($this->yystack[ $this->yyidx + 0 ]->minor, $this->lex->ldel_length, - $this->lex->rdel_length),
                 ' $');
        $this->_retvalue = $this->compiler->compileVariable('\'' . $var . '\'');
    }

    #line 1015 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r145()
    {
        $this->_retvalue = '(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 1022 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r146()
    {
        if ($this->yystack[ $this->yyidx + - 1 ]->minor[ 'var' ] == '\'smarty\'') {
            $this->_retvalue = $this->compiler->compileTag('private_special_variable', array(),
                                                           $this->yystack[ $this->yyidx +
                                                                           - 1 ]->minor[ 'smarty_internal_index' ]) .
                               $this->yystack[ $this->yyidx + 0 ]->minor;
        } else {
            $this->_retvalue = $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 1 ]->minor[ 'var' ]) .
                               $this->yystack[ $this->yyidx + - 1 ]->minor[ 'smarty_internal_index' ] .
                               $this->yystack[ $this->yyidx + 0 ]->minor;
        }
    }

    #line 1031 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r147()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1036 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r148()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1041 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r149()
    {
        if ($this->security && substr($this->yystack[ $this->yyidx + - 1 ]->minor, 0, 1) == '_') {
            $this->compiler->trigger_template_error(self::Err1);
        }
        $this->_retvalue =
            '->' . $this->yystack[ $this->yyidx + - 1 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1048 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r150()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue = '->{' . $this->compiler->compileVariable($this->yystack[ $this->yyidx + - 1 ]->minor) .
                           $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1055 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r151()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue =
            '->{' . $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor . '}';
    }

    #line 1062 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r152()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $this->_retvalue = '->{\'' . $this->yystack[ $this->yyidx + - 4 ]->minor . '\'.' .
                           $this->yystack[ $this->yyidx + - 2 ]->minor . $this->yystack[ $this->yyidx + 0 ]->minor .
                           '}';
    }

    #line 1070 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r153()
    {
        $this->_retvalue = '->' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1078 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r154()
    {
        $this->_retvalue = $this->compiler->compilePHPFunctionCall($this->yystack[ $this->yyidx + - 3 ]->minor,
                                                                   $this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 1086 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r155()
    {
        if ($this->security && substr($this->yystack[ $this->yyidx + - 3 ]->minor, 0, 1) == '_') {
            $this->compiler->trigger_template_error(self::Err1);
        }
        $this->_retvalue = $this->yystack[ $this->yyidx + - 3 ]->minor . "(" .
                           implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ")";
    }

    #line 1093 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r156()
    {
        if ($this->security) {
            $this->compiler->trigger_template_error(self::Err2);
        }
        $prefixVar = $this->compiler->getNewPrefixVariable();
        $this->compiler->appendPrefixCode("<?php $prefixVar" . '=' . $this->compiler->compileVariable('\'' .
                                                                                                      substr($this->yystack[ $this->yyidx +
                                                                                                                             - 3 ]->minor,
                                                                                                             1) .
                                                                                                      '\'') . ';?>');
        $this->_retvalue = $prefixVar . '(' . implode(',', $this->yystack[ $this->yyidx + - 1 ]->minor) . ')';
    }

    #line 1104 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r157()
    {
        $this->_retvalue =
            array_merge($this->yystack[ $this->yyidx + - 2 ]->minor, array($this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 1121 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r160()
    {
        $this->_retvalue = array_merge($this->yystack[ $this->yyidx + - 2 ]->minor,
                                       array(array_merge($this->yystack[ $this->yyidx + - 1 ]->minor,
                                                         $this->yystack[ $this->yyidx + 0 ]->minor)));
    }

    #line 1125 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r161()
    {
        $this->_retvalue =
            array(array_merge($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor));
    }

    #line 1133 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r163()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1141 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r164()
    {
        $this->_retvalue =
            array_merge($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1160 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r168()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor, '', 'method');
    }

    #line 1165 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r169()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor, 'method');
    }

    #line 1170 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r170()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + 0 ]->minor, '');
    }

    #line 1175 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r171()
    {
        $this->_retvalue =
            array($this->yystack[ $this->yyidx + - 1 ]->minor, $this->yystack[ $this->yyidx + 0 ]->minor, 'property');
    }

    #line 1180 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r172()
    {
        $this->_retvalue = array($this->yystack[ $this->yyidx + - 2 ]->minor,
                                 $this->yystack[ $this->yyidx + - 1 ]->minor .
                                 $this->yystack[ $this->yyidx + 0 ]->minor, 'property');
    }

    #line 1186 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r173()
    {
        $this->_retvalue = ' ' . trim($this->yystack[ $this->yyidx + 0 ]->minor) . ' ';
    }

    #line 1190 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r174()
    {
        static $lops =
            array('eq' => ' == ', 'ne' => ' != ', 'neq' => ' != ', 'gt' => ' > ', 'ge' => ' >= ', 'gte' => ' >= ',
                  'lt' => ' < ', 'le' => ' <= ', 'lte' => ' <= ', 'mod' => ' % ', 'and' => ' && ', 'or' => ' || ',
                  'xor' => ' xor ',);
        $op = strtolower(preg_replace('/\s*/', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $lops[ $op ];
    }

    #line 1209 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r175()
    {
        static $tlops =
            array('isdivby' => array('op' => ' % ', 'pre' => '!('), 'isnotdivby' => array('op' => ' % ', 'pre' => '('),
                  'isevenby' => array('op' => ' / ', 'pre' => '!(1 & '),
                  'isnotevenby' => array('op' => ' / ', 'pre' => '(1 & '),
                  'isoddby' => array('op' => ' / ', 'pre' => '(1 & '),
                  'isnotoddby' => array('op' => ' / ', 'pre' => '!(1 & '),);
        $op = strtolower(preg_replace('/\s*/', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $tlops[ $op ];
    }

    #line 1222 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r176()
    {
        static $scond =
            array('iseven' => '!(1 & ', 'isnoteven' => '(1 & ', 'isodd' => '(1 & ', 'isnotodd' => '!(1 & ',);
        $op = strtolower(str_replace(' ', '', $this->yystack[ $this->yyidx + 0 ]->minor));
        $this->_retvalue = $scond[ $op ];
    }

    #line 1236 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r177()
    {
        $this->_retvalue = 'array(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')';
    }

    #line 1244 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r179()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . ',' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1252 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r181()
    {
        $this->_retvalue =
            $this->yystack[ $this->yyidx + - 2 ]->minor . '=>' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1256 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r182()
    {
        $this->_retvalue =
            '\'' . $this->yystack[ $this->yyidx + - 2 ]->minor . '\'=>' . $this->yystack[ $this->yyidx + 0 ]->minor;
    }

    #line 1272 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r185()
    {
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor->to_smarty_php($this);
    }

    #line 1277 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r186()
    {
        $this->yystack[ $this->yyidx + - 1 ]->minor->append_subtree($this, $this->yystack[ $this->yyidx + 0 ]->minor);
        $this->_retvalue = $this->yystack[ $this->yyidx + - 1 ]->minor;
    }

    #line 1282 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r187()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Dq($this, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1286 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r188()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Code('(string)' . $this->yystack[ $this->yyidx + - 1 ]->minor);
    }

    #line 1294 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r190()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Code('(string)$_smarty_tpl->tpl_vars[\'' .
                                                              substr($this->yystack[ $this->yyidx + 0 ]->minor, 1) .
                                                              '\']->value');
    }

    #line 1302 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r192()
    {
        $this->_retvalue =
            new Smarty_Internal_ParseTree_Code('(string)(' . $this->yystack[ $this->yyidx + - 1 ]->minor . ')');
    }

    #line 1306 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r193()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_Tag($this, $this->yystack[ $this->yyidx + 0 ]->minor);
    }

    #line 1310 "../smarty/lexer/smarty_internal_templateparser.y"
    function yy_r194()
    {
        $this->_retvalue = new Smarty_Internal_ParseTree_DqContent($this->yystack[ $this->yyidx + 0 ]->minor);
    }

    private $_retvalue;

    public function yy_reduce($yyruleno)
    {
        if ($this->yyTraceFILE && $yyruleno >= 0 && $yyruleno < count(self::$yyRuleName)) {
            fprintf($this->yyTraceFILE, "%sReduce (%d) [%s].\n", $this->yyTracePrompt, $yyruleno,
                    self::$yyRuleName[ $yyruleno ]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (isset(self::$yyReduceMap[ $yyruleno ])) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[ $yyruleno ]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[ $yyruleno ][ 0 ];
        $yysize = self::$yyRuleInfo[ $yyruleno ][ 1 ];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i --) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[ $this->yyidx ]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!$this->yyTraceFILE && $yysize) {
                $this->yyidx ++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[ $this->yyidx ] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    public function yy_parse_failed()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sFail!\n", $this->yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    public function yy_syntax_error($yymajor, $TOKEN)
    {
        #line 200 "../smarty/lexer/smarty_internal_templateparser.y"

        $this->internalError = true;
        $this->yymajor = $yymajor;
        $this->compiler->trigger_template_error();
    }

    public function yy_accept()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sAccept!\n", $this->yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        #line 193 "../smarty/lexer/smarty_internal_templateparser.y"

        $this->successful = !$this->internalError;
        $this->internalError = false;
        $this->retvalue = $this->_retvalue;
    }

    public function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = - 1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            $this->yystack[] = $x;
        }
        $yyendofinput = ($yymajor == 0);

        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sInput %s\n", $this->yyTracePrompt, $this->yyTokenName[ $yymajor ]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL && !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt --;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if ($this->yyTraceFILE) {
                    fprintf($this->yyTraceFILE, "%sSyntax Error!\n", $this->yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[ $this->yyidx ]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit) {
                        if ($this->yyTraceFILE) {
                            fprintf($this->yyTraceFILE, "%sDiscard input token %s\n", $this->yyTracePrompt,
                                    $this->yyTokenName[ $yymajor ]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 && $yymx != self::YYERRORSYMBOL &&
                               ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE) {
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor == 0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        }
        while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}

