/* Public domain. */

/* MT-unsafe */

#include <errno.h>
#include <signal.h>
#include "sig.h"
#include "nsig.h"

static struct skasigaction oldactions[NSIG] ;

int sig_catcha (int sig, struct skasigaction const *ssa)
{
  if ((sig <= 0) || (sig > NSIG)) return (errno = EINVAL, -1) ;
  return skasigaction(sig, ssa, oldactions + (sig-1)) ;
}

int sig_restore (int sig)
{
  if ((sig <= 0) || (sig > NSIG)) return (errno = EINVAL, -1) ;
  if (!oldactions[sig-1].handler) oldactions[sig-1] = SKASIG_DFL ;
  if (skasigaction(sig, oldactions + (sig-1), 0) == -1) return -1 ;
  oldactions[sig-1] = SKASIG_DFL ;
  return 0 ;
}
