/* Public domain. */

#include <errno.h>
#include "bytestr.h"
#include "fmtscan.h"
#include "tai.h"
#include "djbunix.h"
#include "dns_transmit.h"

static int init (char *ip)
{
  unsigned int iplen = 0 ;
  char const *x = env_get("DNSCACHEIP") ;
  if (x)
    while (iplen <= 60)
    {
      if (*x == '.') ++x ;
      else
      {
        unsigned int i = ip4_scan(x, ip + iplen) ;
	if (!i) break ;
	x += i ;
	iplen += 4 ;
      }
    }

  if (!iplen)
  {
    char tmp[257] ;
    int n = openreadnclose("/etc/resolv.conf", tmp, 256) ;
    if (n == -1)
    {
      if (errno != ENOENT) return 0 ;
      else n = 0 ;
    }
    if (n)
    {
      unsigned int i = 0, j = 0 ;
      errno = 0 ;
      tmp[n++] = '\n' ;
      for (; (int)j < n ; j++)
        if (tmp[j] == '\n')
        {
          if (byte_equal("nameserver ", 11, tmp + i) || byte_equal("nameserver\t", 11, tmp + i))
          {
            i += 10 ;
            while ((tmp[i] == ' ') || (tmp[i] == '\t')) ++i ;
            if (iplen <= 60)
              if (ip4_scan(tmp + i, ip + iplen))
              {
		if (byte_equal(ip + iplen, 4, "\0\0\0"))
		  byte_copy(ip + iplen, 4, "\177\0\0\1") ;
                iplen += 4 ;
	      }
          }
          i = j + 1 ;
        }
    }
  }

  if (!iplen)
  {
    byte_copy(ip, 4, "\177\0\0\1") ;
    iplen = 4 ;
  }
  byte_zero(ip + iplen, 64 - iplen) ;
  return 1 ;
}

int dns_resolvconfipit (struct dns_rcip_info *dr)
{
  struct taia now ;
  taia_now(&now) ;
  if (!dr->uses-- || taia_less(&dr->deadline, &now))
  {
    if (!init(dr->ip)) return 0 ;
    taia_addsec(&dr->deadline, &now, 600) ;
    dr->uses = 10000 ;
  }
  return 1 ;
}
