/************************************************************************
 *
 * Copyright (C) 2009-2015 IRCAD France
 * Copyright (C) 2012-2015 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#ifndef __FWTOOLS_UT_UUIDTEST_HPP__
#define __FWTOOLS_UT_UUIDTEST_HPP__

#include <fwTools/Object.hpp>

#include <cppunit/extensions/HelperMacros.h>

namespace fwTools
{
namespace ut
{

class UUIDTest : public CPPUNIT_NS::TestFixture
{
CPPUNIT_TEST_SUITE( UUIDTest );
CPPUNIT_TEST( objectUUIDTest );
CPPUNIT_TEST( conccurentAccessOnUUIDMapTest );
CPPUNIT_TEST( conccurentAccessOnSameObjUUIDTest );
CPPUNIT_TEST_SUITE_END();

public:
    // interface
    void setUp();
    void tearDown();

    void objectUUIDTest();

    void conccurentAccessOnUUIDMapTest();
    void conccurentAccessOnSameObjUUIDTest();

private:
    void runUUIDCreation();
    void runAccessToObjectUUID();

    ::fwTools::Object::sptr m_object;
    std::string m_uuid;
};

} // namespace ut
} // namespace fwTools

#endif //__FWTOOLS_UT_UUIDTEST_HPP__
