#!/bin/sh

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/^Version: \(\([0-9]+\)\)\?\(.*\)-.*/\3/p' | sed 's/[+~-].*//') 
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
GIT_COMMIT='git log -1 --oneline | cut -d" " -f1'
GIT_DATE='git log -1 --date=iso | sed -ne "s/Date:\s\+\(.*\).*/\1/p" | cut -d" " -f1 | tr -d "-"'

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
git clone git://git.berlios.de/showq showq
cd showq/
#SHOWQ_GIT_COMMIT=$(eval "${GIT_COMMIT}")
SHOWQ_GIT_DATE=$(eval "${GIT_DATE}")
cd .. && tar cfz \
	${OLDDIR}/showq_${BASE_REL}+git${SHOWQ_GIT_DATE}.orig.tar.gz \
	showq --exclude=.git --exclude=.gitignore
rm -rf ${GOS_DIR}
