// ============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Sylvain GENIN
// Copyright (C) 2021 - Samuel GOUGEON
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================

// <-- TEST WITH GRAPHIC -->
// <-- NO CHECK REF -->

//handle
handle1 = gcf();
handle2 = gca();

assert_checkequal(handle1 <> handle1, %f);
assert_checkequal(handle1 <> handle2, %t);

delete(handle1);

// With type 0:
L = list(,2);
uitree = uiCreateTree(uiCreateNode('Root', 'path\rootImage.jpg', 'rootCallback'));
for object = list(gdf(), uitree)
    assert_checktrue(object <> L(1));
    assert_checktrue(object <> null());
    assert_checktrue(null() <> object);
    assert_checktrue(L(1) <> object);
end
