/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Select.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifndef __SELECT_H__
#define __SELECT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
/* 選択されている図形を 1 で赤くし、0 で戻す。
 * 図形描画  DrawType
 * 選択敞  ： DrawType = 1  SCD_SELECT
 * 元の色  ： DrawType = 0	SCD_ORG
 * 消　竿  ： DrawType = 2  SCD_HIDE
 */
#define SCD_ORG 	0
#define SCD_SELECT	1
#define SCD_HIDE	2
#define SCD_CAM 	3

#define UPDATE_ON 	1
#define UPDATE_OFF 	0




/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _SELECT_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL SELECT mouse_select_frag;


#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _SELECT_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int MouseSelect(GtkWidget *widget, double X, double Y, int SelectFrag, int Type);
gint BrinkEnd(gpointer data);
int DataInfo(SELECT *select, char *str);
int MouseSelectL(double x, double y, int SelectFrag, SELECT *RetSelect);

CAD *Look( double x , double y , int SelectFrag);
void OnlyOne(int Frag);
// セレクト図形のレイヤー変更
int Change_Layer(int Change_Frag);
/* データ№ から SA EA を求める */
int iSaEa(CAD_LIST *p, struct RtnDat *RtnDumy);
int ArcIn(CAD_LIST *p, double Angle);

/* 点を探す */
CAD *TenLook(double x, double y);
int TenCheck(double x, double y, CAD_LIST *p);
/* 線を探す */
CAD *LineLook(double x, double y);
int LineCheck(double x, double y, CAD_LIST *p);
/* 円弧を探す */
CAD *ArcLook(double x, double y);
int ArcCheck( double x , double y , CAD_LIST *p);
/* 円を探す */
CAD *CirLook(double x, double y);
int CirCheck(double x, double y, CAD_LIST *p);

/* セレクト図形の線種変更 */
int Change_Line_Style(void);

int SelectCheck(CAD *data);
/* ２点で作られるl角の中にすっぽり入るものを探し、セレクトデータに入れる。*/
int SqSelect(GtkWidget *widget, double Mode310X1, double Mode310Y1, double Mode310X2, double Mode310Y2);

void SelectCadDraw(GtkWidget *widget, CAD *cad, int DrawType);
void SelectDelete(GtkWidget *widget);
void SelectCancel(GtkWidget *widget);
int SelectMaskColor(CAD *p_cad);
int SelectChain(CAD *p_cad);
int TanTenLook(SELECT *a);
DIMENSION *SnpLook(double x, double y);
int SelectDimensionCheck(DIMENSION *data);

int SelectChain2(CAD *start, int frag);
int SelectChain2_Search(double x, double y);
void SelectChain2_OnlyOne(int Frag);
void SelectChain2_Draw(CAD cad, int frag, int DrawType);
int SelectChain2_S_Bow(double SX, double SY, double EX, double EY, long color);
int SelectChain2_ArcBow(double CX, double CY, double R, double SX, double SY, double EX, double EY, long color, int frag);

int LineDataCheck(double sx, double sy, double ex, double ey, double x, double y);
int normal_polyline_search(POLYLINE *PolyLine, double px, double py);
int open_spline_search(POLYLINE *PolyLine, double px, double py);
int close_spline_search(POLYLINE *PolyLine, double px, double py);
int b_spline_search(POLYLINE *PolyLine, double px, double py);
POLYLINE *PolyLine_search(double x, double y);
int SelectPolyLineCheck(POLYLINE *data);




int SelectDraw(GtkWidget *widget, SELECT *select, int DrawType, int UpDate);
int CadDraw(GtkWidget *widget, CAD *cad, int DrawType, int update);

int ellipse_search_sub(ELLIPSE *ellipse, double px, double py);
/* 楕円探索メイン */
ELLIPSE *ellipse_search(double x, double y);
/* ELLIPSE Data がセレクトされているかを確認 */
int SelectEllipseCheck(ELLIPSE *data);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SELECT_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Select.h
 * ====================================================================
 */
