#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-06   
# _preinstall.sh

### P A R A M S

package="$1"

### H E L P E R S

function readlink2()
{
	[ ! -L $1 ] || ls -l $1 | sed s/.*-\>\ *//g
}

function followlink()
{
	prg="$1"
	while [ -h "$prg" ] ; do
		ls=`ls -ld "$prg"`
		link=`expr "$ls" : '.*-> \(.*\)$'`
		if expr "$link" : '.*/.*' > /dev/null; then
			prg="$link"
		else
			prg=`dirname "$prg"`/"$link"
		fi
	done
	echo $prg
}

function absdir() 
{ 
	[ -n "$1" ] && ( cd "$1" 2> /dev/null && pwd ; ) 
}

where=`followlink $0`
where=`dirname ${where}`
where=`absdir ${where}`
cd ${where}

### I N C L U D E

. ./_include.sh

### S T A R T

#  D I S T R I B U T I O N
case ${DISTRIBUTION} in
	Redhat)
		./_preinstall-rh.sh ${package}
		exit 0
		;;
	Fedora)
		./_preinstall-fc.sh ${package}
		exit 0
		;;
	Mandriva)
		./_preinstall-mdk.sh ${package}
		exit 0
		;;
	Debian)
		./_preinstall-debian.sh ${package}
		exit 0
		;;
	Ubuntu)
		./_preinstall-ubuntu.sh ${package}
		exit 0
		;;
	Suse)
		./_preinstall-suse.sh ${package}
		exit 0
		;;
	*)
		;;
esac

echo "Automated setup is not supported for this distribution"
echo "You have to do the following:"
echo "-install samba 3"
echo "-install krb5-workstation"
echo "-install pam_mount with dependencies (if PAM is indeed used)"
exit 1
