#!/bin/bash
# bbou@ac-toulouse.fr
# 2008-03-01 18:39:27  
# _include-distribution.sh
# script-invoked only

### S E T S
DISTRIBUTION=
DISTRIBUTIONTAG=
DISTRIBUTIONVERSION=

### S T A R T

OS=`uname -s`
ARCHITECTURE=`uname -m`
KERNEL=`uname -r`

function debian_packageversion
{
	dpkg -s $1 | grep '^Version:' | awk '{print $2}'
}

function rh_packageversion
{
	rpm -q $1 | sed "s/$1-//"
}

function debian_addservice
{
	update-rc.d $1 defaults
}

function rh_addservice
{
	[ -e /etc/init.d/$1 ] || chkconfig --add $1
	chkconfig --level 345 $1 on
}

function debian_removeservice
{
	update-rc.d -f $1 remove
}

function rh_removeservice
{
	chkconfig --level 345 $1 off
	chkconfig --remove $1
}

function suse_service
{
	/usr/sbin/rc$1
}

function debian_servicestatus
{
	daemon=$1
	case $1 in
		samba) 
			daemon="(smbd|nmbd)"
			;;
		winbind) 
			daemon="winbindd"
			;;
	esac
	ps ax | egrep ${daemon} | grep -v grep
}

function rh_servicestatus
{
	service $1 status
}

function suse_servicestatus
{
	/usr/sbin/rc$1 status
}

function rh_hasinstalledfile()
{
	f=`rpm -ql $1 | grep $2` 
	test ! -z "${f}" -a -e "${f}"
	return $?
}

function debian_hasinstalledfile()
{
	f=`dpkg -S $2 | grep "^$1" | awk '{print $2}'` 
	test ! -z "${f}" -a -e "${f}"
	return $?
}

function debian_packageisinstalled()
{
	test "`dpkg-query -W --showformat '${Status}\n' $1 2> /dev/null`" == 'install ok installed';
	return $?
}

# DETECTION
if [ "${OS}" = "SunOS" ] ; then
	OS=Solaris
	ARCHITECTURE=`uname -p`
	OSINFO="${OS} ${DISTRIBUTIONVERSION}(${ARCHITECTURE} `uname -v`)"
	echo "Unsupported OS ${OSINFO}" >&2
	exit

elif [ "${OS}" = "AIX" ] ; then
	OSINFO="${OS} `oslevel` (`oslevel -r`)"
	echo "Unsupported OS ${OSINFO}" >&2
	exit

elif [ "${OS}" = "Linux" ] ; then
	distribution=`./lsb_release.sh -s -i`
	distributiontag=`./lsb_release.sh -s -c`
	distributionrelease=`./lsb_release.sh -s -r`
	distributioninfo=`./lsb_release.sh -s -d`
	#echo "distribution=${distribution}"
	#echo "distributiontag=${distributiontag}"
	#echo "distributionrelease=${distributionrelease}"
	#echo "distributioninfo=${distributioninfo}"
	
	case ${distribution} in
	Redhat*|RedHat*)
		export DISTRIBUTION="Redhat"
		export DISTRIBUTIONRELEASEINFO="${distributioninfo}"
		export DISTRIBUTIONVERSION="${distributionrelease}"
		export DISTRIBUTIONTAG="${distributiontag}"
		export PACKAGETEST="rpm -q"
		export PACKAGEVERSION="rh_packageversion"
		export PACKAGEINSTALL="rpm -Uvh"
		export PACKAGEINSTALLFILE="rpm -Uvh"
		export PACKAGEUNINSTALL="rpm -e"
		export PACKAGEUPDATE="rpm -Uvh"
		export PACKAGEEXT="rpm"
		export PACKAGEHASFILE="rh_hasinstalledfile"
		export SAMBASERVICE="smb"
		export NMBSERVICE=
		export WINBINDSERVICE="winbind"
		export NSCDSERVICE="nscd"
		export AVAHISERVICE="avahi-daemon"
		export SERVICE="service"
		export SERVICESTATUS="rh_servicestatus"
		export SERVICEADD="rh_addservice"
		export SERVICEREMOVE="rh_removeservice"
		export PAMSERVICES="system-auth"
		export PAMMODES="all"
		export PAMMOUNTPACKAGE="pam_mount"
		export RIDPACKAGE="samba-common"
		export XINITRCDIR="xinit/xinitrc.d"
		export XINITRCCIFSMOUNT="cifsmount.sh"
		export KINIT="/usr/kerberos/bin/kinit"
		export KLIST="/usr/kerberos/bin/klist"
		export PIDOF="/sbin/pidof"
		export SAMBAPKG="samba"
		export SAMBAPKGS="samba samba-client samba-common"
		;;

	FedoraCore|Fedora)
		export DISTRIBUTION="Fedora"
		export DISTRIBUTIONRELEASEINFO="${distributioninfo}"
		export DISTRIBUTIONVERSION="${distributionrelease}"
		export DISTRIBUTIONTAG="${distributiontag}"
		export PACKAGETEST="rpm -q"
		export PACKAGEVERSION="rh_packageversion"
		export PACKAGEINSTALL="rpm -Uvh"
		export PACKAGEINSTALLFILE="rpm -Uvh"
		export PACKAGEUNINSTALL="rpm -e"
		export PACKAGEUPDATE="rpm -Uvh"
		export PACKAGEEXT="rpm"
		export PACKAGEHASFILE="rh_hasinstalledfile"
		export SAMBASERVICE="smb"
		export NMBSERVICE=
		export WINBINDSERVICE="winbind"
		export NSCDSERVICE="nscd"
		export AVAHISERVICE="avahi-daemon"
		export SERVICE="service"
		export SERVICESTATUS="rh_servicestatus"
		export SERVICEADD="rh_addservice"
		export SERVICEREMOVE="rh_removeservice"
		export PAMSERVICES="system-auth"
		export PAMMODES="all"
		export PAMMOUNTPACKAGE="pam_mount"
		export RIDPACKAGE="samba-common"
		export XINITRCDIR="xinit/xinitrc.d"
		export XINITRCCIFSMOUNT="cifsmount.sh"
		export KINIT="/usr/kerberos/bin/kinit"
		export KLIST="/usr/kerberos/bin/klist"
		export PIDOF="/sbin/pidof"
		export SAMBAPKG="samba"
		export SAMBAPKGS="samba samba-client samba-common"
		if (( ${DISTRIBUTIONVERSION} >= 7 )); then
			export NMBSERVICE=nmb
		fi
		if [ "${DISTRIBUTIONTAG}" == "Stentz" ]; then
			export MALLOC_CHECK_=0
		fi
		;;

	Mandrakelinux|Mandrake|Mandriva|MandrivaLinux)
		export DISTRIBUTION="Mandriva"
		export DISTRIBUTIONRELEASEINFO="${distributioninfo}"
		export DISTRIBUTIONVERSION="${distributionrelease}"
		export DISTRIBUTIONTAG="${distributiontag}"
		export PACKAGETEST="rpm -q"
		export PACKAGEVERSION="rh_packageversion"
		export PACKAGEINSTALL="rpm -Uvh"
		export PACKAGEINSTALLFILE="rpm -Uvh"
		export PACKAGEUNINSTALL="rpm -e"
		export PACKAGEUPDATE="rpm -Uvh"
		export PACKAGEEXT="rpm"
		export PACKAGEHASFILE="rh_hasinstalledfile"
		export SAMBASERVICE="smb"
		export NMBSERVICE=
		export WINBINDSERVICE="winbind"
		export NSCDSERVICE="nscd"
		export AVAHISERVICE="avahi-daemon"
		export SERVICE="service"
		export SERVICESTATUS="rh_servicestatus"
		export SERVICEADD="rh_addservice"
		export SERVICEREMOVE="rh_removeservice"
		export PAMSERVICES="system-auth"
		export PAMMODES="all"
		export PAMMOUNTPACKAGE="pam_mount"
		export RIDPACKAGE="samba-winbind"
		export XINITRCDIR="xinit.d"
		export XINITRCCIFSMOUNT="cifsmount"
		export KINIT="/usr/bin/kinit"
		export KLIST="/usr/bin/klist"
		export PIDOF="/sbin/pidof"
		export SAMBAPKG="samba-common"
		export SAMBAPKGS="samba-common samba-server samba-winbind samba-client"
		;;

	Debian)
		export DISTRIBUTION="${distribution}"
		export DISTRIBUTIONRELEASEINFO="${distributioninfo}"
		export DISTRIBUTIONVERSION="${distributionrelease}"
		export DISTRIBUTIONTAG="${distributiontag}"
		export PACKAGETEST="debian_packageisinstalled"
		export PACKAGEVERSION="debian_packageversion"
		export PACKAGEINSTALL="apt-get install"
		export PACKAGEINSTALLFILE="dpkg --install"
		export PACKAGEUNINSTALL="apt-get remove"
		export PACKAGEUPDATE="apt-get update"
		export PACKAGEEXT="deb"
		export PACKAGEHASFILE="debian_hasinstalledfile"
		export SAMBASERVICE="smbd"
		export NMBSERVICE="nmbd"
		export WINBINDSERVICE="winbind"
		export NSCDSERVICE="nscd"
		export AVAHISERVICE="avahi-daemon"
		export SERVICE="invoke-rc.d"
		export SERVICESTATUS="debian_servicestatus"
		export SERVICEADD="debian_addservice"
		export SERVICEREMOVE="debian_removeservice"
		export PAMSERVICES="common-auth common-account common-password common-session"
		export PAMMODES="auth account password session"
		export PAMMOUNTPACKAGE="libpam-mount"
		export RIDPACKAGE="winbind"
		export XINITRCDIR="Xsession.d"
		export XINITRCCIFSMOUNT="99cifsmount"
		export KINIT="/usr/bin/kinit"
		export KLIST="/usr/bin/klist"
		export PIDOF="/bin/pidof"
		export SAMBAPKG="samba"
		export SAMBAPKGS="samba samba-common winbind"
		;;

	Ubuntu)
		export DISTRIBUTION="${distribution}"
		export DISTRIBUTIONRELEASEINFO="${distributioninfo}"
		export DISTRIBUTIONVERSION="${distributionrelease}"
		export DISTRIBUTIONTAG="${distributiontag}"
		export PACKAGETEST="debian_packageisinstalled"
		export PACKAGEVERSION="debian_packageversion"
		export PACKAGEINSTALL="apt-get install"
		export PACKAGEINSTALLFILE="dpkg --install"
		export PACKAGEUNINSTALL="apt-get remove"
		export PACKAGEUPDATE="apt-get update"
		export PACKAGEEXT="deb"
		export PACKAGEHASFILE="debian_hasinstalledfile"
		export SAMBASERVICE="smbd"
		export NMBSERVICE="nmbd"
		export WINBINDSERVICE="winbind"
		export NSCDSERVICE="nscd"
		export AVAHISERVICE="avahi-daemon"
		export SERVICE="invoke-rc.d"
		export SERVICESTATUS="debian_servicestatus"
		export SERVICEADD="debian_addservice"
		export SERVICEREMOVE="debian_removeservice"
		export PAMSERVICES="common-auth common-account common-password common-session"
		export PAMMODES="auth account password session"
		export PAMMOUNTPACKAGE="libpam-mount"
		export RIDPACKAGE="winbind"
		export XINITRCDIR="Xsession.d"
		export XINITRCCIFSMOUNT="99cifsmount"
		export KINIT="/usr/bin/kinit"
		export KLIST="/usr/bin/klist"
		export PIDOF="/bin/pidof"
		export SAMBAPKG="samba"
		export SAMBAPKGS="samba samba-common winbind"
		;;

	SuSE|Suse)
		export DISTRIBUTION="Suse"
		export DISTRIBUTIONRELEASEINFO="${distributioninfo}"
		export DISTRIBUTIONVERSION="${distributionrelease}"
		export DISTRIBUTIONTAG="${distributiontag}"
		export PACKAGETEST="rpm -q"
		export PACKAGEVERSION="rh_packageversion"
		export PACKAGEINSTALL="rpm -Uvh"
		export PACKAGEINSTALLFILE="rpm -Uvh"
		export PACKAGEUNINSTALL="rpm -e"
		export PACKAGEUPDATE="rpm -Uvh"
		export PACKAGEEXT="rpm"
		export PACKAGEHASFILE="rh_hasinstalledfile"
		export SAMBASERVICE="smb"
		export NMBSERVICE="nmb"
		export WINBINDSERVICE="winbind"
		export NSCDSERVICE="nscd"
		export AVAHISERVICE="avahi-daemon"
		export SERVICE="suse_service"
		export SERVICESTATUS="suse_servicestatus"
		export SERVICEADD="rh_addservice"
		export SERVICEREMOVE="rh_removeservice"
		export PAMSERVICES="common-auth common-account common-password common-session"
		export PAMMODES="auth account password session"
		export PAMMOUNTPACKAGE="pam_mount"
		export RIDPACKAGE="samba"
		export XINITRCDIR="xinit/xinitrc.d"
		export XINITRCCIFSMOUNT="cifsmount.sh"
		export KINIT="/usr/bin/kinit"
		export KLIST="/usr/bin/klist"
		export PIDOF="/sbin/pidof"
		export SAMBAPKG="samba"
		export SAMBAPKGS="samba samba-winbind samba-client"
		;;
	esac
	OSINFO="${OS} ${DISTRIBUTION} ${DISTRIBUTIONVERSION}(${DISTRIBUTIONTAG} ${KERNEL} ${ARCHITECTURE})"
fi

# RESULTS
if [ ! -n "${DISTRIBUTION}" ]; then
	echo "Unsupported distribution ${OSINFO}" >&2
	exit 1
fi

#echo "OS=${OS}"
#echo "KERNEL=${KERNEL}"
#echo "ARCHITECTURE=${ARCHITECTURE}"
#echo "DISTRIBUTION=${DISTRIBUTION}"
#echo "DISTRIBUTIONTAG=${DISTRIBUTIONTAG}"
#echo "DISTRIBUTIONVERSION=${DISTRIBUTIONVERSION}"
