// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{TabPage, TabView};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "HdyTabBar")]
    pub struct TabBar(Object<ffi::HdyTabBar, ffi::HdyTabBarClass>) @extends gtk::Bin, gtk::Container, gtk::Widget, @implements gtk::Buildable;

    match fn {
        type_ => || ffi::hdy_tab_bar_get_type(),
    }
}

impl TabBar {
    #[doc(alias = "hdy_tab_bar_new")]
    pub fn new() -> TabBar {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::hdy_tab_bar_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TabBar`] objects.
    ///
    /// This method returns an instance of [`TabBarBuilder`](crate::builders::TabBarBuilder) which can be used to create [`TabBar`] objects.
    pub fn builder() -> TabBarBuilder {
        TabBarBuilder::new()
    }

    #[doc(alias = "hdy_tab_bar_get_autohide")]
    #[doc(alias = "get_autohide")]
    pub fn is_autohide(&self) -> bool {
        unsafe { from_glib(ffi::hdy_tab_bar_get_autohide(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_tab_bar_get_end_action_widget")]
    #[doc(alias = "get_end_action_widget")]
    pub fn end_action_widget(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_tab_bar_get_end_action_widget(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_tab_bar_get_expand_tabs")]
    #[doc(alias = "get_expand_tabs")]
    pub fn expands_tabs(&self) -> bool {
        unsafe { from_glib(ffi::hdy_tab_bar_get_expand_tabs(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_tab_bar_get_extra_drag_dest_targets")]
    #[doc(alias = "get_extra_drag_dest_targets")]
    pub fn extra_drag_dest_targets(&self) -> Option<gtk::TargetList> {
        unsafe {
            from_glib_none(ffi::hdy_tab_bar_get_extra_drag_dest_targets(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_tab_bar_get_inverted")]
    #[doc(alias = "get_inverted")]
    pub fn is_inverted(&self) -> bool {
        unsafe { from_glib(ffi::hdy_tab_bar_get_inverted(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_tab_bar_get_is_overflowing")]
    #[doc(alias = "get_is_overflowing")]
    pub fn is_overflowing(&self) -> bool {
        unsafe { from_glib(ffi::hdy_tab_bar_get_is_overflowing(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_tab_bar_get_start_action_widget")]
    #[doc(alias = "get_start_action_widget")]
    pub fn start_action_widget(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_tab_bar_get_start_action_widget(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_tab_bar_get_tabs_revealed")]
    #[doc(alias = "get_tabs_revealed")]
    pub fn is_tabs_revealed(&self) -> bool {
        unsafe { from_glib(ffi::hdy_tab_bar_get_tabs_revealed(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_tab_bar_get_view")]
    #[doc(alias = "get_view")]
    pub fn view(&self) -> Option<TabView> {
        unsafe { from_glib_none(ffi::hdy_tab_bar_get_view(self.to_glib_none().0)) }
    }

    #[doc(alias = "hdy_tab_bar_set_autohide")]
    pub fn set_autohide(&self, autohide: bool) {
        unsafe {
            ffi::hdy_tab_bar_set_autohide(self.to_glib_none().0, autohide.into_glib());
        }
    }

    #[doc(alias = "hdy_tab_bar_set_end_action_widget")]
    pub fn set_end_action_widget(&self, widget: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::hdy_tab_bar_set_end_action_widget(
                self.to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_tab_bar_set_expand_tabs")]
    pub fn set_expand_tabs(&self, expand_tabs: bool) {
        unsafe {
            ffi::hdy_tab_bar_set_expand_tabs(self.to_glib_none().0, expand_tabs.into_glib());
        }
    }

    #[doc(alias = "hdy_tab_bar_set_extra_drag_dest_targets")]
    pub fn set_extra_drag_dest_targets(&self, extra_drag_dest_targets: Option<&gtk::TargetList>) {
        unsafe {
            ffi::hdy_tab_bar_set_extra_drag_dest_targets(
                self.to_glib_none().0,
                extra_drag_dest_targets.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_tab_bar_set_inverted")]
    pub fn set_inverted(&self, inverted: bool) {
        unsafe {
            ffi::hdy_tab_bar_set_inverted(self.to_glib_none().0, inverted.into_glib());
        }
    }

    #[doc(alias = "hdy_tab_bar_set_start_action_widget")]
    pub fn set_start_action_widget(&self, widget: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::hdy_tab_bar_set_start_action_widget(
                self.to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_tab_bar_set_view")]
    pub fn set_view(&self, view: Option<&TabView>) {
        unsafe {
            ffi::hdy_tab_bar_set_view(self.to_glib_none().0, view.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "extra-drag-data-received")]
    pub fn connect_extra_drag_data_received<
        F: Fn(&Self, &TabPage, &gdk::DragContext, &gtk::SelectionData, u32, u32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn extra_drag_data_received_trampoline<
            F: Fn(&TabBar, &TabPage, &gdk::DragContext, &gtk::SelectionData, u32, u32) + 'static,
        >(
            this: *mut ffi::HdyTabBar,
            page: *mut ffi::HdyTabPage,
            context: *mut gdk::ffi::GdkDragContext,
            data: *mut gtk::ffi::GtkSelectionData,
            info: libc::c_uint,
            time: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(page),
                &from_glib_borrow(context),
                &from_glib_borrow(data),
                info,
                time,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"extra-drag-data-received\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    extra_drag_data_received_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "autohide")]
    pub fn connect_autohide_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_autohide_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::autohide\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_autohide_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "end-action-widget")]
    pub fn connect_end_action_widget_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_end_action_widget_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::end-action-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_end_action_widget_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "expand-tabs")]
    pub fn connect_expand_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expand_tabs_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expand-tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_expand_tabs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "extra-drag-dest-targets")]
    pub fn connect_extra_drag_dest_targets_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_extra_drag_dest_targets_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::extra-drag-dest-targets\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_extra_drag_dest_targets_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "inverted")]
    pub fn connect_inverted_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inverted_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::inverted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_inverted_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "is-overflowing")]
    pub fn connect_is_overflowing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_overflowing_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-overflowing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_overflowing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "start-action-widget")]
    pub fn connect_start_action_widget_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_start_action_widget_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::start-action-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_start_action_widget_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "tabs-revealed")]
    pub fn connect_tabs_revealed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_revealed_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs-revealed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_revealed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "view")]
    pub fn connect_view_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_view_trampoline<F: Fn(&TabBar) + 'static>(
            this: *mut ffi::HdyTabBar,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::view\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_view_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl Default for TabBar {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TabBar`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TabBarBuilder {
    builder: glib::object::ObjectBuilder<'static, TabBar>,
}

impl TabBarBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn autohide(self, autohide: bool) -> Self {
        Self {
            builder: self.builder.property("autohide", autohide),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn end_action_widget(self, end_action_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("end-action-widget", end_action_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn expand_tabs(self, expand_tabs: bool) -> Self {
        Self {
            builder: self.builder.property("expand-tabs", expand_tabs),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn extra_drag_dest_targets(self, extra_drag_dest_targets: &gtk::TargetList) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-drag-dest-targets", extra_drag_dest_targets.clone()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn inverted(self, inverted: bool) -> Self {
        Self {
            builder: self.builder.property("inverted", inverted),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn start_action_widget(self, start_action_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("start-action-widget", start_action_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn view(self, view: &TabView) -> Self {
        Self {
            builder: self.builder.property("view", view.clone()),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: gtk::ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<gtk::Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    //pub fn style(self, style: &impl IsA</*Ignored*/gtk::Style>) -> Self {
    //    Self { builder: self.builder.property("style", style.clone().upcast()), }
    //}

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TabBar`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TabBar {
        self.builder.build()
    }
}

impl fmt::Display for TabBar {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TabBar")
    }
}
