// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{LeafletTransitionType, NavigationDirection, Swipeable};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "HdyLeaflet")]
    pub struct Leaflet(Object<ffi::HdyLeaflet, ffi::HdyLeafletClass>) @extends gtk::Container, gtk::Widget, @implements gtk::Buildable, gtk::Orientable, Swipeable;

    match fn {
        type_ => || ffi::hdy_leaflet_get_type(),
    }
}

impl Leaflet {
    pub const NONE: Option<&'static Leaflet> = None;

    #[doc(alias = "hdy_leaflet_new")]
    pub fn new() -> Leaflet {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::hdy_leaflet_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Leaflet`] objects.
    ///
    /// This method returns an instance of [`LeafletBuilder`](crate::builders::LeafletBuilder) which can be used to create [`Leaflet`] objects.
    pub fn builder() -> LeafletBuilder {
        LeafletBuilder::new()
    }
}

impl Default for Leaflet {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Leaflet`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct LeafletBuilder {
    builder: glib::object::ObjectBuilder<'static, Leaflet>,
}

impl LeafletBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn can_swipe_back(self, can_swipe_back: bool) -> Self {
        Self {
            builder: self.builder.property("can-swipe-back", can_swipe_back),
        }
    }

    pub fn can_swipe_forward(self, can_swipe_forward: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("can-swipe-forward", can_swipe_forward),
        }
    }

    pub fn child_transition_duration(self, child_transition_duration: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("child-transition-duration", child_transition_duration),
        }
    }

    pub fn hhomogeneous_folded(self, hhomogeneous_folded: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("hhomogeneous-folded", hhomogeneous_folded),
        }
    }

    pub fn hhomogeneous_unfolded(self, hhomogeneous_unfolded: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("hhomogeneous-unfolded", hhomogeneous_unfolded),
        }
    }

    pub fn interpolate_size(self, interpolate_size: bool) -> Self {
        Self {
            builder: self.builder.property("interpolate-size", interpolate_size),
        }
    }

    pub fn mode_transition_duration(self, mode_transition_duration: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("mode-transition-duration", mode_transition_duration),
        }
    }

    pub fn transition_type(self, transition_type: LeafletTransitionType) -> Self {
        Self {
            builder: self.builder.property("transition-type", transition_type),
        }
    }

    pub fn vhomogeneous_folded(self, vhomogeneous_folded: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("vhomogeneous-folded", vhomogeneous_folded),
        }
    }

    pub fn vhomogeneous_unfolded(self, vhomogeneous_unfolded: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("vhomogeneous-unfolded", vhomogeneous_unfolded),
        }
    }

    pub fn visible_child(self, visible_child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("visible-child", visible_child.clone().upcast()),
        }
    }

    pub fn visible_child_name(self, visible_child_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("visible-child-name", visible_child_name.into()),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: gtk::ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<gtk::Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    //pub fn style(self, style: &impl IsA</*Ignored*/gtk::Style>) -> Self {
    //    Self { builder: self.builder.property("style", style.clone().upcast()), }
    //}

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn orientation(self, orientation: gtk::Orientation) -> Self {
        Self {
            builder: self.builder.property("orientation", orientation),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Leaflet`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Leaflet {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Leaflet>> Sealed for T {}
}

pub trait LeafletExt: IsA<Leaflet> + sealed::Sealed + 'static {
    #[doc(alias = "hdy_leaflet_get_adjacent_child")]
    #[doc(alias = "get_adjacent_child")]
    fn adjacent_child(&self, direction: NavigationDirection) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_adjacent_child(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_can_swipe_back")]
    #[doc(alias = "get_can_swipe_back")]
    fn can_swipe_back(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_can_swipe_back(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_can_swipe_forward")]
    #[doc(alias = "get_can_swipe_forward")]
    fn can_swipe_forward(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_can_swipe_forward(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_child_by_name")]
    #[doc(alias = "get_child_by_name")]
    fn child_by_name(&self, name: &str) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_child_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_child_transition_duration")]
    #[doc(alias = "get_child_transition_duration")]
    fn child_transition_duration(&self) -> u32 {
        unsafe { ffi::hdy_leaflet_get_child_transition_duration(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "hdy_leaflet_get_child_transition_running")]
    #[doc(alias = "get_child_transition_running")]
    fn is_child_transition_running(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_child_transition_running(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_folded")]
    #[doc(alias = "get_folded")]
    fn is_folded(&self) -> bool {
        unsafe { from_glib(ffi::hdy_leaflet_get_folded(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "hdy_leaflet_get_homogeneous")]
    #[doc(alias = "get_homogeneous")]
    fn is_homogeneous(&self, folded: bool, orientation: gtk::Orientation) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_homogeneous(
                self.as_ref().to_glib_none().0,
                folded.into_glib(),
                orientation.into_glib(),
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_interpolate_size")]
    #[doc(alias = "get_interpolate_size")]
    fn is_interpolate_size(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_interpolate_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_mode_transition_duration")]
    #[doc(alias = "get_mode_transition_duration")]
    fn mode_transition_duration(&self) -> u32 {
        unsafe { ffi::hdy_leaflet_get_mode_transition_duration(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "hdy_leaflet_get_transition_type")]
    #[doc(alias = "get_transition_type")]
    fn transition_type(&self) -> LeafletTransitionType {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_transition_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_visible_child")]
    #[doc(alias = "get_visible_child")]
    fn visible_child(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_visible_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "hdy_leaflet_get_visible_child_name")]
    #[doc(alias = "get_visible_child_name")]
    fn visible_child_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_visible_child_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_leaflet_insert_child_after")]
    fn insert_child_after(
        &self,
        child: &impl IsA<gtk::Widget>,
        sibling: Option<&impl IsA<gtk::Widget>>,
    ) {
        unsafe {
            ffi::hdy_leaflet_insert_child_after(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_leaflet_navigate")]
    fn navigate(&self, direction: NavigationDirection) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_navigate(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_leaflet_prepend")]
    fn prepend(&self, child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::hdy_leaflet_prepend(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_leaflet_reorder_child_after")]
    fn reorder_child_after(
        &self,
        child: &impl IsA<gtk::Widget>,
        sibling: Option<&impl IsA<gtk::Widget>>,
    ) {
        unsafe {
            ffi::hdy_leaflet_reorder_child_after(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_can_swipe_back")]
    fn set_can_swipe_back(&self, can_swipe_back: bool) {
        unsafe {
            ffi::hdy_leaflet_set_can_swipe_back(
                self.as_ref().to_glib_none().0,
                can_swipe_back.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_can_swipe_forward")]
    fn set_can_swipe_forward(&self, can_swipe_forward: bool) {
        unsafe {
            ffi::hdy_leaflet_set_can_swipe_forward(
                self.as_ref().to_glib_none().0,
                can_swipe_forward.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_child_transition_duration")]
    fn set_child_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_leaflet_set_child_transition_duration(
                self.as_ref().to_glib_none().0,
                duration,
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_homogeneous")]
    fn set_homogeneous(&self, folded: bool, orientation: gtk::Orientation, homogeneous: bool) {
        unsafe {
            ffi::hdy_leaflet_set_homogeneous(
                self.as_ref().to_glib_none().0,
                folded.into_glib(),
                orientation.into_glib(),
                homogeneous.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_interpolate_size")]
    fn set_interpolate_size(&self, interpolate_size: bool) {
        unsafe {
            ffi::hdy_leaflet_set_interpolate_size(
                self.as_ref().to_glib_none().0,
                interpolate_size.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_mode_transition_duration")]
    fn set_mode_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_leaflet_set_mode_transition_duration(self.as_ref().to_glib_none().0, duration);
        }
    }

    #[doc(alias = "hdy_leaflet_set_transition_type")]
    fn set_transition_type(&self, transition: LeafletTransitionType) {
        unsafe {
            ffi::hdy_leaflet_set_transition_type(
                self.as_ref().to_glib_none().0,
                transition.into_glib(),
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_visible_child")]
    fn set_visible_child(&self, visible_child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::hdy_leaflet_set_visible_child(
                self.as_ref().to_glib_none().0,
                visible_child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hdy_leaflet_set_visible_child_name")]
    fn set_visible_child_name(&self, name: &str) {
        unsafe {
            ffi::hdy_leaflet_set_visible_child_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "hhomogeneous-folded")]
    fn is_hhomogeneous_folded(&self) -> bool {
        ObjectExt::property(self.as_ref(), "hhomogeneous-folded")
    }

    #[doc(alias = "hhomogeneous-folded")]
    fn set_hhomogeneous_folded(&self, hhomogeneous_folded: bool) {
        ObjectExt::set_property(self.as_ref(), "hhomogeneous-folded", hhomogeneous_folded)
    }

    #[doc(alias = "hhomogeneous-unfolded")]
    fn is_hhomogeneous_unfolded(&self) -> bool {
        ObjectExt::property(self.as_ref(), "hhomogeneous-unfolded")
    }

    #[doc(alias = "hhomogeneous-unfolded")]
    fn set_hhomogeneous_unfolded(&self, hhomogeneous_unfolded: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "hhomogeneous-unfolded",
            hhomogeneous_unfolded,
        )
    }

    #[doc(alias = "vhomogeneous-folded")]
    fn is_vhomogeneous_folded(&self) -> bool {
        ObjectExt::property(self.as_ref(), "vhomogeneous-folded")
    }

    #[doc(alias = "vhomogeneous-folded")]
    fn set_vhomogeneous_folded(&self, vhomogeneous_folded: bool) {
        ObjectExt::set_property(self.as_ref(), "vhomogeneous-folded", vhomogeneous_folded)
    }

    #[doc(alias = "vhomogeneous-unfolded")]
    fn is_vhomogeneous_unfolded(&self) -> bool {
        ObjectExt::property(self.as_ref(), "vhomogeneous-unfolded")
    }

    #[doc(alias = "vhomogeneous-unfolded")]
    fn set_vhomogeneous_unfolded(&self, vhomogeneous_unfolded: bool) {
        ObjectExt::set_property(
            self.as_ref(),
            "vhomogeneous-unfolded",
            vhomogeneous_unfolded,
        )
    }

    #[doc(alias = "child.icon-name")]
    fn child_icon_name<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString> {
        gtk::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "icon-name",
        )
    }

    #[doc(alias = "child.icon-name")]
    fn set_child_icon_name<T: IsA<gtk::Widget>>(&self, item: &T, icon_name: Option<&str>) {
        gtk::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "icon-name",
            &icon_name,
        )
    }

    fn child_name<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString> {
        gtk::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "name",
        )
    }

    fn set_child_name<T: IsA<gtk::Widget>>(&self, item: &T, name: Option<&str>) {
        gtk::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "name",
            &name,
        )
    }

    #[doc(alias = "child.needs-attention")]
    fn child_needs_attention<T: IsA<gtk::Widget>>(&self, item: &T) -> bool {
        gtk::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "needs-attention",
        )
    }

    #[doc(alias = "child.needs-attention")]
    fn set_child_needs_attention<T: IsA<gtk::Widget>>(&self, item: &T, needs_attention: bool) {
        gtk::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "needs-attention",
            &needs_attention,
        )
    }

    fn child_position<T: IsA<gtk::Widget>>(&self, item: &T) -> i32 {
        gtk::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "position",
        )
    }

    fn set_child_position<T: IsA<gtk::Widget>>(&self, item: &T, position: i32) {
        gtk::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "position",
            &position,
        )
    }

    fn child_title<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString> {
        gtk::prelude::ContainerExtManual::child_property(
            self.as_ref(),
            &item.clone().upcast(),
            "title",
        )
    }

    fn set_child_title<T: IsA<gtk::Widget>>(&self, item: &T, title: Option<&str>) {
        gtk::prelude::ContainerExtManual::child_set_property(
            self.as_ref(),
            &item.clone().upcast(),
            "title",
            &title,
        )
    }

    #[doc(alias = "can-swipe-back")]
    fn connect_can_swipe_back_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_swipe_back_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-swipe-back\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_swipe_back_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "can-swipe-forward")]
    fn connect_can_swipe_forward_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_swipe_forward_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-swipe-forward\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_swipe_forward_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "child-transition-duration")]
    fn connect_child_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_transition_duration_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child-transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_transition_duration_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "child-transition-running")]
    fn connect_child_transition_running_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_transition_running_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child-transition-running\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_transition_running_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "folded")]
    fn connect_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_folded_trampoline<P: IsA<Leaflet>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_folded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hhomogeneous-folded")]
    fn connect_hhomogeneous_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_folded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hhomogeneous-folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hhomogeneous_folded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hhomogeneous-unfolded")]
    fn connect_hhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_unfolded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hhomogeneous-unfolded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hhomogeneous_unfolded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "interpolate-size")]
    fn connect_interpolate_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_interpolate_size_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::interpolate-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_interpolate_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "mode-transition-duration")]
    fn connect_mode_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_mode_transition_duration_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mode-transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mode_transition_duration_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "transition-type")]
    fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_type_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vhomogeneous-folded")]
    fn connect_vhomogeneous_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_folded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vhomogeneous-folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vhomogeneous_folded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "vhomogeneous-unfolded")]
    fn connect_vhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_unfolded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vhomogeneous-unfolded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vhomogeneous_unfolded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visible-child")]
    fn connect_visible_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_child_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "visible-child-name")]
    fn connect_visible_child_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_child_name_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible-child-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_child_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Leaflet>> LeafletExt for O {}

impl fmt::Display for Leaflet {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Leaflet")
    }
}
