
#line 1 "ragel/i18n/tt.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/tt.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_tt/gherkin_lexer_tt.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 14, 20, 21, 22, 23, 25, 
	27, 40, 42, 44, 45, 46, 47, 48, 
	49, 50, 51, 52, 53, 54, 55, 56, 
	57, 58, 59, 60, 61, 62, 63, 64, 
	65, 66, 67, 68, 69, 70, 71, 72, 
	81, 85, 87, 89, 91, 93, 95, 97, 
	99, 101, 103, 116, 117, 118, 121, 122, 
	123, 124, 125, 126, 127, 128, 129, 130, 
	131, 132, 133, 134, 135, 136, 137, 139, 
	141, 146, 151, 156, 161, 165, 169, 171, 
	172, 173, 174, 175, 176, 177, 178, 179, 
	180, 181, 182, 183, 184, 185, 186, 191, 
	198, 203, 207, 213, 216, 218, 224, 237, 
	240, 242, 244, 246, 248, 250, 252, 254, 
	256, 258, 260, 262, 264, 266, 268, 270, 
	272, 274, 276, 278, 280, 282, 284, 286, 
	288, 290, 292, 294, 296, 298, 300, 302, 
	304, 306, 308, 310, 312, 314, 316, 318, 
	320, 322, 324, 327, 329, 331, 333, 335, 
	337, 339, 341, 343, 345, 347, 349, 351, 
	353, 355, 357, 359, 361, 363, 365, 367, 
	369, 371, 373, 376, 378, 380, 382, 384, 
	386, 388, 390, 392, 394, 396, 398, 400, 
	402, 404, 406, 408, 410, 412, 414, 416, 
	418, 420, 422, 424, 426, 428, 430, 432, 
	434, 436, 438, 440, 442, 444, 446, 448, 
	450, 452, 454, 456, 458, 460, 462, 464, 
	465, 466, 467, 468, 469, 470, 471, 472, 
	473, 474, 475, 476, 477, 478, 479, 480, 
	488, 490, 492, 494, 496, 498, 500, 502, 
	504, 506, 508, 510, 512, 514, 516, 518, 
	520, 522, 524, 526, 528, 530, 532, 534, 
	536, 538, 540, 542, 544, 546, 548, 550, 
	552, 554, 556, 558, 560, 562, 564, 566, 
	567, 568, 569, 570, 571, 572, 573, 574, 
	575, 576, 577, 578, 579, 580, 581, 592, 
	598, 600, 602, 604, 606, 608, 610, 612, 
	614, 616, 618, 620, 622, 624, 626, 628, 
	630, 632, 634, 636, 638, 640, 642, 644, 
	646, 648, 650, 652, 654, 656, 658, 660, 
	662, 664, 666, 668, 670, 672, 674, 676, 
	678, 680, 682, 684, 686, 688, 690, 692, 
	694, 696, 698, 700, 702, 704, 706, 709, 
	711, 713, 715, 717, 719, 721, 723, 725, 
	727, 729, 731, 733, 735, 737, 739, 741, 
	743, 745, 747, 749, 751, 753, 756, 758, 
	760, 762, 764, 766, 768, 770, 772, 774, 
	776, 778, 780, 782, 784, 786, 788, 790, 
	792, 794, 796, 798, 800, 802, 804, 806, 
	808, 812, 814, 816, 818, 820, 822, 824, 
	826, 828, 830, 832, 834, 836, 838, 840, 
	842, 844, 846, 848, 850, 852, 854, 856, 
	858, 860, 862, 864, 866, 868, 869, 870, 
	871, 872, 873, 874, 875, 876, 878, 879, 
	880, 881, 882, 883, 884, 885, 886, 887, 
	888, 889, 890, 891, 892, 893, 894, 895, 
	896, 897, 898, 899, 900, 901, 902, 903, 
	904, 905, 906, 907, 908, 909, 910, 911, 
	912, 913, 914, 915, 916, 917, 918, 919, 
	920, 921, 922, 923, 924, 926, 927, 928, 
	929, 930, 931, 932, 933, 934, 935, 936, 
	937, 938, 939, 940, 941, 942, 943, 944, 
	945, 946, 947, 948, 949, 950, 951, 962, 
	968, 970, 972, 974, 976, 978, 980, 982, 
	984, 986, 988, 990, 992, 994, 996, 998, 
	1000, 1002, 1004, 1006, 1008, 1010, 1012, 1014, 
	1016, 1018, 1020, 1022, 1024, 1026, 1028, 1030, 
	1032, 1034, 1036, 1038, 1040, 1042, 1044, 1046, 
	1048, 1050, 1052, 1054, 1056, 1058, 1060, 1062, 
	1064, 1066, 1068, 1070, 1072, 1074, 1076, 1079, 
	1081, 1083, 1085, 1087, 1089, 1091, 1093, 1095, 
	1097, 1099, 1101, 1103, 1105, 1107, 1109, 1111, 
	1113, 1115, 1117, 1119, 1121, 1123, 1125, 1127, 
	1129, 1131, 1135, 1137, 1139, 1141, 1143, 1145, 
	1147, 1149, 1151, 1153, 1155, 1157, 1159, 1161, 
	1163, 1165, 1167, 1169, 1171, 1173, 1175, 1177, 
	1179, 1181, 1183, 1185, 1187, 1189, 1191, 1192, 
	1193, 1204, 1211, 1213, 1215, 1217, 1219, 1221, 
	1223, 1225, 1227, 1229, 1231, 1233, 1235, 1237, 
	1239, 1241, 1243, 1245, 1247, 1249, 1251, 1253, 
	1255, 1257, 1259, 1261, 1263, 1265, 1267, 1269, 
	1271, 1273, 1275, 1277, 1279, 1281, 1283, 1285, 
	1287, 1289, 1291, 1293, 1295, 1297, 1299, 1301, 
	1303, 1305, 1307, 1309, 1311, 1313, 1315, 1317, 
	1319, 1321, 1323, 1325, 1327, 1329, 1331, 1333, 
	1335, 1338, 1340, 1342, 1344, 1346, 1348, 1350, 
	1352, 1354, 1356, 1358, 1360, 1362, 1364, 1366, 
	1368, 1370, 1372, 1374, 1376, 1378, 1380, 1382, 
	1385, 1387, 1389, 1391, 1393, 1395, 1397, 1399, 
	1401, 1403, 1405, 1407, 1409, 1411, 1413, 1415, 
	1417, 1419, 1421, 1423, 1425, 1427, 1429, 1431, 
	1433, 1435, 1437, 1441, 1443, 1445, 1447, 1449, 
	1451, 1453, 1455, 1457, 1459, 1461, 1463, 1465, 
	1467, 1469, 1471, 1473, 1475, 1477, 1479, 1481, 
	1483, 1485, 1487, 1489, 1491, 1493, 1495, 1497, 
	1498, 1499
};

static const char _lexer_trans_keys[] = {
	-48, -46, -45, -17, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, -110, -102, 
	-101, -100, -99, -95, -45, -103, 32, 10, 
	13, 10, 13, -48, -46, -45, 10, 32, 
	34, 35, 37, 42, 64, 124, 9, 13, 
	-82, -70, -48, -47, -73, -48, -75, -48, 
	-67, -47, -121, -45, -103, -48, -69, -48, 
	-75, -48, -70, -48, -69, -48, -75, -48, 
	-69, -48, -75, -48, -70, 58, 10, 10, 
	-48, -46, 10, 32, 35, 37, 64, 9, 
	13, -102, -100, -95, 10, -48, 10, -75, 
	10, -47, 10, -128, 10, -48, 10, -75, 
	10, -47, 10, -120, 10, 10, 58, -48, 
	-46, -45, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -104, -48, -77, -71, 
	-68, -45, -103, -47, -128, -47, -126, -48, 
	-72, -48, -70, -48, -68, -48, -80, 34, 
	34, 10, 13, 10, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 34, 9, 13, 10, 32, 34, 9, 
	13, 10, 32, 9, 13, 10, 32, 9, 
	13, 10, 13, 10, 95, 70, 69, 65, 
	84, 85, 82, 69, 95, 69, 78, 68, 
	95, 37, 13, 32, 64, 9, 10, 9, 
	10, 13, 32, 64, 11, 12, 10, 32, 
	64, 9, 13, 32, 124, 9, 13, 10, 
	32, 92, 124, 9, 13, 10, 92, 124, 
	10, 92, 10, 32, 92, 124, 9, 13, 
	-48, -46, -45, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, -48, -45, 10, 
	-72, 10, -47, 10, -127, 10, -48, 10, 
	-80, 10, -48, 10, -69, 10, -48, 10, 
	-69, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -87, 10, -48, 10, -68, 10, 
	-48, 10, -70, 10, -48, 10, -72, 10, 
	-48, 10, -67, 10, -48, 10, -69, 10, 
	-48, 10, -75, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -71, 10, -48, 10, 58, -67, 
	10, -47, 10, -117, 10, -46, 10, -93, 
	10, 10, 32, -47, 10, -126, 10, -45, 
	10, -87, 10, -48, 10, -73, 10, -48, 
	10, -75, 10, -48, 10, -69, 10, -48, 
	10, -75, 10, -47, 10, -120, 10, -48, 
	10, -75, 10, -82, 10, -48, -47, 10, 
	-73, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -47, 10, -121, 10, -45, 10, 
	-103, 10, -48, 10, -69, 10, -48, 10, 
	-75, 10, -48, 10, -70, 10, -48, 10, 
	-69, 10, -48, 10, -75, 10, -128, 10, 
	-48, 10, -67, 10, -45, 10, -103, 10, 
	-48, 10, -70, 10, -48, 10, -69, 10, 
	-45, 10, -103, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-128, -48, -67, -45, -103, -48, -70, -48, 
	-69, -45, -103, -47, -128, 58, 10, 10, 
	-48, -46, 10, 32, 35, 124, 9, 13, 
	-100, 10, -45, 10, -87, 10, -48, 10, 
	-68, 10, -48, 10, -70, 10, -48, 10, 
	-72, 10, -48, 10, -67, 10, -48, 10, 
	-69, 10, -48, 10, -75, 10, -48, 10, 
	-70, 10, 10, 58, -82, 10, -48, 10, 
	-73, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -47, 10, -121, 10, -45, 10, 
	-103, 10, -48, 10, -69, 10, -48, 10, 
	-75, 10, -48, 10, -70, 10, -48, 10, 
	-69, 10, -48, 10, -75, 10, -45, -103, 
	-48, -68, -48, -75, -47, -128, -48, -75, 
	-47, -120, 58, 10, 10, -48, -46, -45, 
	10, 32, 35, 37, 42, 64, 9, 13, 
	-110, -101, -100, -99, -95, 10, -45, 10, 
	-103, 10, 10, 32, -45, 10, -103, 10, 
	-48, 10, -70, 10, -48, 10, -72, 10, 
	-48, 10, -67, 10, -45, 10, -87, 10, 
	-48, 10, -68, 10, -48, 10, -70, 10, 
	-48, 10, -72, 10, -48, 10, -67, 10, 
	-48, 10, -69, 10, -48, 10, -75, 10, 
	-48, 10, -70, 10, 10, 58, -45, 10, 
	-103, 10, -47, 10, -126, 10, -48, 10, 
	-72, 10, -46, 10, -105, 10, -45, 10, 
	-103, 10, -48, 10, -76, 10, -47, 10, 
	-122, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, -48, 10, 58, -67, 10, -47, 
	10, -117, 10, -46, 10, -93, 10, 10, 
	32, -47, 10, -126, 10, -45, 10, -87, 
	10, -48, 10, -73, 10, -48, 10, -75, 
	10, -48, 10, -69, 10, -48, 10, -75, 
	10, -47, 10, -120, 10, -48, 10, -75, 
	10, -82, -70, 10, -48, 10, -73, 10, 
	-48, 10, -75, 10, -48, 10, -67, 10, 
	-47, 10, -121, 10, -45, 10, -103, 10, 
	-48, 10, -69, 10, -48, 10, -75, 10, 
	-48, 10, -70, 10, -48, 10, -69, 10, 
	-48, 10, -75, 10, -45, 10, -103, 10, 
	-48, 10, -68, 10, -104, 10, -48, 10, 
	-77, -71, -68, 10, -45, 10, -103, 10, 
	-47, 10, -128, 10, -47, 10, -126, 10, 
	-48, 10, -72, 10, -48, 10, -70, 10, 
	-48, 10, -68, 10, -48, 10, -80, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -45, -103, -48, -70, 
	-48, -72, -48, -67, -48, -45, -72, -47, 
	-127, -48, -80, -48, -69, -48, -69, -48, 
	-80, -87, -48, -68, -48, -70, -48, -72, 
	-48, -67, -45, -103, -47, -126, -48, -72, 
	-46, -105, -45, -103, -48, -76, -47, -122, 
	-48, -75, -48, -67, -48, -80, -47, -128, 
	-48, -72, -48, -71, -48, 58, -67, -47, 
	-117, -46, -93, 32, -47, -126, -45, -87, 
	-48, -73, -48, -75, -48, -69, -48, -75, 
	-47, -120, -48, -75, 58, 10, 10, -48, 
	-46, -45, 10, 32, 35, 37, 42, 64, 
	9, 13, -110, -101, -100, -99, -95, 10, 
	-45, 10, -103, 10, 10, 32, -45, 10, 
	-103, 10, -48, 10, -70, 10, -48, 10, 
	-72, 10, -48, 10, -67, 10, -45, 10, 
	-87, 10, -48, 10, -68, 10, -48, 10, 
	-70, 10, -48, 10, -72, 10, -48, 10, 
	-67, 10, -48, 10, -69, 10, -48, 10, 
	-75, 10, -48, 10, -70, 10, 10, 58, 
	-45, 10, -103, 10, -47, 10, -126, 10, 
	-48, 10, -72, 10, -46, 10, -105, 10, 
	-45, 10, -103, 10, -48, 10, -76, 10, 
	-47, 10, -122, 10, -48, 10, -75, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-48, 10, -71, 10, -82, -70, 10, -48, 
	10, -73, 10, -48, 10, -75, 10, -48, 
	10, -67, 10, -47, 10, -121, 10, -45, 
	10, -103, 10, -48, 10, -69, 10, -48, 
	10, -75, 10, -48, 10, -70, 10, -48, 
	10, -69, 10, -48, 10, -75, 10, -45, 
	10, -103, 10, -48, 10, -68, 10, -104, 
	10, -48, 10, -77, -71, -68, 10, -45, 
	10, -103, 10, -47, 10, -128, 10, -47, 
	10, -126, 10, -48, 10, -72, 10, -48, 
	10, -70, 10, -48, 10, -68, 10, -48, 
	10, -80, 10, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	10, -48, -46, -45, 10, 32, 35, 37, 
	42, 64, 9, 13, -110, -102, -101, -100, 
	-99, -95, 10, -45, 10, -103, 10, 10, 
	32, -48, 10, -75, 10, -47, 10, -128, 
	10, -48, 10, -75, 10, -47, 10, -120, 
	10, 10, 58, -45, 10, -103, 10, -48, 
	10, -70, 10, -48, 10, -72, 10, -48, 
	10, -67, 10, -45, 10, -87, 10, -48, 
	10, -68, 10, -48, 10, -70, 10, -48, 
	10, -72, 10, -48, 10, -67, 10, -48, 
	10, -69, 10, -48, 10, -75, 10, -48, 
	10, -70, 10, -45, 10, -103, 10, -47, 
	10, -126, 10, -48, 10, -72, 10, -46, 
	10, -105, 10, -45, 10, -103, 10, -48, 
	10, -76, 10, -47, 10, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -48, 10, -71, 10, -48, 
	10, 58, -67, 10, -47, 10, -117, 10, 
	-46, 10, -93, 10, 10, 32, -47, 10, 
	-126, 10, -45, 10, -87, 10, -48, 10, 
	-73, 10, -48, 10, -75, 10, -48, 10, 
	-69, 10, -48, 10, -75, 10, -47, 10, 
	-120, 10, -48, 10, -75, 10, -82, -70, 
	10, -48, 10, -73, 10, -48, 10, -75, 
	10, -48, 10, -67, 10, -47, 10, -121, 
	10, -45, 10, -103, 10, -48, 10, -69, 
	10, -48, 10, -75, 10, -48, 10, -70, 
	10, -48, 10, -69, 10, -48, 10, -75, 
	10, -45, 10, -103, 10, -48, 10, -68, 
	10, -104, 10, -48, 10, -77, -71, -68, 
	10, -45, 10, -103, 10, -47, 10, -128, 
	10, -47, 10, -126, 10, -48, 10, -72, 
	10, -48, 10, -70, 10, -48, 10, -68, 
	10, -48, 10, -80, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 12, 6, 1, 1, 1, 2, 2, 
	11, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 7, 
	4, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 11, 1, 1, 3, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 2, 
	3, 3, 3, 3, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 3, 5, 
	3, 2, 4, 3, 2, 4, 11, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 9, 6, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	4, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 9, 6, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 4, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	9, 7, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 4, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 0, 0, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 14, 21, 23, 25, 27, 30, 
	33, 46, 49, 52, 54, 56, 58, 60, 
	62, 64, 66, 68, 70, 72, 74, 76, 
	78, 80, 82, 84, 86, 88, 90, 92, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	117, 122, 125, 128, 131, 134, 137, 140, 
	143, 146, 149, 162, 164, 166, 170, 172, 
	174, 176, 178, 180, 182, 184, 186, 188, 
	190, 192, 194, 196, 198, 200, 202, 205, 
	208, 213, 218, 223, 228, 232, 236, 239, 
	241, 243, 245, 247, 249, 251, 253, 255, 
	257, 259, 261, 263, 265, 267, 269, 274, 
	281, 286, 290, 296, 300, 303, 309, 322, 
	326, 329, 332, 335, 338, 341, 344, 347, 
	350, 353, 356, 359, 362, 365, 368, 371, 
	374, 377, 380, 383, 386, 389, 392, 395, 
	398, 401, 404, 407, 410, 413, 416, 419, 
	422, 425, 428, 431, 434, 437, 440, 443, 
	446, 449, 452, 456, 459, 462, 465, 468, 
	471, 474, 477, 480, 483, 486, 489, 492, 
	495, 498, 501, 504, 507, 510, 513, 516, 
	519, 522, 525, 529, 532, 535, 538, 541, 
	544, 547, 550, 553, 556, 559, 562, 565, 
	568, 571, 574, 577, 580, 583, 586, 589, 
	592, 595, 598, 601, 604, 607, 610, 613, 
	616, 619, 622, 625, 628, 631, 634, 637, 
	640, 643, 646, 649, 652, 655, 658, 661, 
	663, 665, 667, 669, 671, 673, 675, 677, 
	679, 681, 683, 685, 687, 689, 691, 693, 
	701, 704, 707, 710, 713, 716, 719, 722, 
	725, 728, 731, 734, 737, 740, 743, 746, 
	749, 752, 755, 758, 761, 764, 767, 770, 
	773, 776, 779, 782, 785, 788, 791, 794, 
	797, 800, 803, 806, 809, 812, 815, 818, 
	820, 822, 824, 826, 828, 830, 832, 834, 
	836, 838, 840, 842, 844, 846, 848, 859, 
	866, 869, 872, 875, 878, 881, 884, 887, 
	890, 893, 896, 899, 902, 905, 908, 911, 
	914, 917, 920, 923, 926, 929, 932, 935, 
	938, 941, 944, 947, 950, 953, 956, 959, 
	962, 965, 968, 971, 974, 977, 980, 983, 
	986, 989, 992, 995, 998, 1001, 1004, 1007, 
	1010, 1013, 1016, 1019, 1022, 1025, 1028, 1032, 
	1035, 1038, 1041, 1044, 1047, 1050, 1053, 1056, 
	1059, 1062, 1065, 1068, 1071, 1074, 1077, 1080, 
	1083, 1086, 1089, 1092, 1095, 1098, 1102, 1105, 
	1108, 1111, 1114, 1117, 1120, 1123, 1126, 1129, 
	1132, 1135, 1138, 1141, 1144, 1147, 1150, 1153, 
	1156, 1159, 1162, 1165, 1168, 1171, 1174, 1177, 
	1180, 1185, 1188, 1191, 1194, 1197, 1200, 1203, 
	1206, 1209, 1212, 1215, 1218, 1221, 1224, 1227, 
	1230, 1233, 1236, 1239, 1242, 1245, 1248, 1251, 
	1254, 1257, 1260, 1263, 1266, 1269, 1271, 1273, 
	1275, 1277, 1279, 1281, 1283, 1285, 1288, 1290, 
	1292, 1294, 1296, 1298, 1300, 1302, 1304, 1306, 
	1308, 1310, 1312, 1314, 1316, 1318, 1320, 1322, 
	1324, 1326, 1328, 1330, 1332, 1334, 1336, 1338, 
	1340, 1342, 1344, 1346, 1348, 1350, 1352, 1354, 
	1356, 1358, 1360, 1362, 1364, 1366, 1368, 1370, 
	1372, 1374, 1376, 1378, 1380, 1383, 1385, 1387, 
	1389, 1391, 1393, 1395, 1397, 1399, 1401, 1403, 
	1405, 1407, 1409, 1411, 1413, 1415, 1417, 1419, 
	1421, 1423, 1425, 1427, 1429, 1431, 1433, 1444, 
	1451, 1454, 1457, 1460, 1463, 1466, 1469, 1472, 
	1475, 1478, 1481, 1484, 1487, 1490, 1493, 1496, 
	1499, 1502, 1505, 1508, 1511, 1514, 1517, 1520, 
	1523, 1526, 1529, 1532, 1535, 1538, 1541, 1544, 
	1547, 1550, 1553, 1556, 1559, 1562, 1565, 1568, 
	1571, 1574, 1577, 1580, 1583, 1586, 1589, 1592, 
	1595, 1598, 1601, 1604, 1607, 1610, 1613, 1617, 
	1620, 1623, 1626, 1629, 1632, 1635, 1638, 1641, 
	1644, 1647, 1650, 1653, 1656, 1659, 1662, 1665, 
	1668, 1671, 1674, 1677, 1680, 1683, 1686, 1689, 
	1692, 1695, 1700, 1703, 1706, 1709, 1712, 1715, 
	1718, 1721, 1724, 1727, 1730, 1733, 1736, 1739, 
	1742, 1745, 1748, 1751, 1754, 1757, 1760, 1763, 
	1766, 1769, 1772, 1775, 1778, 1781, 1784, 1786, 
	1788, 1799, 1807, 1810, 1813, 1816, 1819, 1822, 
	1825, 1828, 1831, 1834, 1837, 1840, 1843, 1846, 
	1849, 1852, 1855, 1858, 1861, 1864, 1867, 1870, 
	1873, 1876, 1879, 1882, 1885, 1888, 1891, 1894, 
	1897, 1900, 1903, 1906, 1909, 1912, 1915, 1918, 
	1921, 1924, 1927, 1930, 1933, 1936, 1939, 1942, 
	1945, 1948, 1951, 1954, 1957, 1960, 1963, 1966, 
	1969, 1972, 1975, 1978, 1981, 1984, 1987, 1990, 
	1993, 1997, 2000, 2003, 2006, 2009, 2012, 2015, 
	2018, 2021, 2024, 2027, 2030, 2033, 2036, 2039, 
	2042, 2045, 2048, 2051, 2054, 2057, 2060, 2063, 
	2067, 2070, 2073, 2076, 2079, 2082, 2085, 2088, 
	2091, 2094, 2097, 2100, 2103, 2106, 2109, 2112, 
	2115, 2118, 2121, 2124, 2127, 2130, 2133, 2136, 
	2139, 2142, 2145, 2150, 2153, 2156, 2159, 2162, 
	2165, 2168, 2171, 2174, 2177, 2180, 2183, 2186, 
	2189, 2192, 2195, 2198, 2201, 2204, 2207, 2210, 
	2213, 2216, 2219, 2222, 2225, 2228, 2231, 2234, 
	2236, 2238
};

static const short _lexer_trans_targs[] = {
	2, 9, 51, 759, 8, 8, 68, 78, 
	80, 5, 94, 97, 8, 0, 3, 275, 
	421, 429, 450, 462, 0, 4, 0, 5, 
	0, 6, 0, 8, 79, 7, 8, 79, 
	7, 2, 9, 51, 8, 8, 68, 78, 
	80, 5, 94, 97, 8, 0, 10, 271, 
	0, 11, 215, 0, 12, 0, 13, 0, 
	14, 0, 15, 0, 16, 0, 17, 0, 
	18, 0, 19, 0, 20, 0, 21, 0, 
	22, 0, 23, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 32, 0, 33, 0, 
	34, 0, 35, 0, 36, 0, 37, 0, 
	39, 38, 39, 38, 40, 169, 39, 39, 
	8, 201, 8, 39, 38, 41, 103, 132, 
	39, 38, 42, 39, 38, 43, 39, 38, 
	44, 39, 38, 45, 39, 38, 46, 39, 
	38, 47, 39, 38, 48, 39, 38, 49, 
	39, 38, 39, 50, 38, 2, 9, 51, 
	8, 8, 68, 78, 80, 5, 94, 97, 
	8, 0, 52, 0, 53, 0, 54, 58, 
	64, 0, 55, 0, 56, 0, 57, 0, 
	5, 0, 59, 0, 60, 0, 61, 0, 
	62, 0, 63, 0, 5, 0, 65, 0, 
	66, 0, 67, 0, 5, 0, 69, 0, 
	70, 0, 72, 71, 71, 72, 71, 71, 
	73, 73, 74, 73, 73, 73, 73, 74, 
	73, 73, 73, 73, 75, 73, 73, 73, 
	73, 76, 73, 73, 8, 77, 77, 0, 
	8, 77, 77, 0, 8, 79, 78, 8, 
	0, 81, 0, 82, 0, 83, 0, 84, 
	0, 85, 0, 86, 0, 87, 0, 88, 
	0, 89, 0, 90, 0, 91, 0, 92, 
	0, 93, 0, 761, 0, 0, 0, 0, 
	0, 95, 96, 8, 96, 96, 94, 95, 
	95, 8, 96, 94, 96, 0, 97, 98, 
	97, 0, 102, 101, 100, 98, 101, 99, 
	0, 100, 98, 99, 0, 100, 99, 102, 
	101, 100, 98, 101, 99, 2, 9, 51, 
	102, 102, 68, 78, 80, 5, 94, 97, 
	102, 0, 104, 117, 39, 38, 105, 39, 
	38, 106, 39, 38, 107, 39, 38, 108, 
	39, 38, 109, 39, 38, 110, 39, 38, 
	111, 39, 38, 112, 39, 38, 113, 39, 
	38, 114, 39, 38, 115, 39, 38, 116, 
	39, 38, 49, 39, 38, 118, 39, 38, 
	119, 39, 38, 120, 39, 38, 121, 39, 
	38, 122, 39, 38, 123, 39, 38, 124, 
	39, 38, 125, 39, 38, 126, 39, 38, 
	127, 39, 38, 128, 39, 38, 129, 39, 
	38, 130, 39, 38, 131, 39, 38, 49, 
	39, 38, 133, 39, 38, 134, 39, 38, 
	135, 39, 38, 136, 39, 38, 137, 39, 
	38, 138, 39, 38, 139, 39, 38, 140, 
	39, 38, 141, 39, 38, 142, 39, 38, 
	143, 39, 38, 144, 39, 38, 145, 39, 
	38, 146, 39, 38, 147, 39, 50, 38, 
	148, 39, 38, 149, 39, 38, 150, 39, 
	38, 151, 39, 38, 152, 39, 38, 39, 
	153, 38, 154, 39, 38, 155, 39, 38, 
	156, 39, 38, 157, 39, 38, 158, 39, 
	38, 159, 39, 38, 160, 39, 38, 161, 
	39, 38, 162, 39, 38, 163, 39, 38, 
	164, 39, 38, 165, 39, 38, 166, 39, 
	38, 167, 39, 38, 168, 39, 38, 49, 
	39, 38, 170, 39, 38, 171, 190, 39, 
	38, 172, 39, 38, 173, 39, 38, 174, 
	39, 38, 175, 39, 38, 176, 39, 38, 
	177, 39, 38, 178, 39, 38, 179, 39, 
	38, 180, 39, 38, 181, 39, 38, 182, 
	39, 38, 183, 39, 38, 184, 39, 38, 
	185, 39, 38, 186, 39, 38, 187, 39, 
	38, 188, 39, 38, 189, 39, 38, 126, 
	39, 38, 191, 39, 38, 192, 39, 38, 
	193, 39, 38, 194, 39, 38, 195, 39, 
	38, 196, 39, 38, 197, 39, 38, 198, 
	39, 38, 199, 39, 38, 200, 39, 38, 
	115, 39, 38, 39, 202, 38, 39, 203, 
	38, 39, 204, 38, 39, 205, 38, 39, 
	206, 38, 39, 207, 38, 39, 208, 38, 
	39, 209, 38, 39, 210, 38, 39, 211, 
	38, 39, 212, 38, 39, 213, 38, 39, 
	214, 38, 39, 8, 38, 216, 0, 217, 
	0, 218, 0, 219, 0, 220, 0, 221, 
	0, 222, 0, 223, 0, 224, 0, 225, 
	0, 226, 0, 227, 0, 228, 0, 229, 
	0, 231, 230, 231, 230, 232, 250, 231, 
	231, 8, 8, 231, 230, 233, 231, 230, 
	234, 231, 230, 235, 231, 230, 236, 231, 
	230, 237, 231, 230, 238, 231, 230, 239, 
	231, 230, 240, 231, 230, 241, 231, 230, 
	242, 231, 230, 243, 231, 230, 244, 231, 
	230, 245, 231, 230, 246, 231, 230, 247, 
	231, 230, 248, 231, 230, 249, 231, 230, 
	231, 50, 230, 251, 231, 230, 252, 231, 
	230, 253, 231, 230, 254, 231, 230, 255, 
	231, 230, 256, 231, 230, 257, 231, 230, 
	258, 231, 230, 259, 231, 230, 260, 231, 
	230, 261, 231, 230, 262, 231, 230, 263, 
	231, 230, 264, 231, 230, 265, 231, 230, 
	266, 231, 230, 267, 231, 230, 268, 231, 
	230, 269, 231, 230, 270, 231, 230, 243, 
	231, 230, 272, 0, 273, 0, 274, 0, 
	5, 0, 276, 0, 277, 0, 278, 0, 
	279, 0, 280, 0, 281, 0, 282, 0, 
	283, 0, 284, 0, 286, 285, 286, 285, 
	287, 365, 390, 286, 286, 8, 407, 290, 
	8, 286, 285, 288, 291, 299, 316, 328, 
	286, 285, 289, 286, 285, 290, 286, 285, 
	286, 50, 285, 292, 286, 285, 293, 286, 
	285, 294, 286, 285, 295, 286, 285, 296, 
	286, 285, 297, 286, 285, 298, 286, 285, 
	290, 286, 285, 300, 286, 285, 301, 286, 
	285, 302, 286, 285, 303, 286, 285, 304, 
	286, 285, 305, 286, 285, 306, 286, 285, 
	307, 286, 285, 308, 286, 285, 309, 286, 
	285, 310, 286, 285, 311, 286, 285, 312, 
	286, 285, 313, 286, 285, 314, 286, 285, 
	315, 286, 285, 286, 50, 285, 317, 286, 
	285, 318, 286, 285, 319, 286, 285, 320, 
	286, 285, 321, 286, 285, 322, 286, 285, 
	323, 286, 285, 324, 286, 285, 325, 286, 
	285, 326, 286, 285, 327, 286, 285, 288, 
	286, 285, 329, 286, 285, 330, 286, 285, 
	331, 286, 285, 332, 286, 285, 333, 286, 
	285, 334, 286, 285, 335, 286, 285, 336, 
	286, 285, 337, 286, 285, 338, 286, 285, 
	339, 286, 285, 340, 286, 285, 341, 286, 
	285, 342, 286, 285, 343, 286, 50, 285, 
	344, 286, 285, 345, 286, 285, 346, 286, 
	285, 347, 286, 285, 348, 286, 285, 286, 
	349, 285, 350, 286, 285, 351, 286, 285, 
	352, 286, 285, 353, 286, 285, 354, 286, 
	285, 355, 286, 285, 356, 286, 285, 357, 
	286, 285, 358, 286, 285, 359, 286, 285, 
	360, 286, 285, 361, 286, 285, 362, 286, 
	285, 363, 286, 285, 364, 286, 285, 315, 
	286, 285, 366, 386, 286, 285, 367, 286, 
	285, 368, 286, 285, 369, 286, 285, 370, 
	286, 285, 371, 286, 285, 372, 286, 285, 
	373, 286, 285, 374, 286, 285, 375, 286, 
	285, 376, 286, 285, 377, 286, 285, 378, 
	286, 285, 379, 286, 285, 380, 286, 285, 
	381, 286, 285, 382, 286, 285, 383, 286, 
	285, 384, 286, 285, 385, 286, 285, 309, 
	286, 285, 387, 286, 285, 388, 286, 285, 
	389, 286, 285, 290, 286, 285, 391, 286, 
	285, 392, 286, 285, 393, 397, 403, 286, 
	285, 394, 286, 285, 395, 286, 285, 396, 
	286, 285, 290, 286, 285, 398, 286, 285, 
	399, 286, 285, 400, 286, 285, 401, 286, 
	285, 402, 286, 285, 290, 286, 285, 404, 
	286, 285, 405, 286, 285, 406, 286, 285, 
	290, 286, 285, 286, 408, 285, 286, 409, 
	285, 286, 410, 285, 286, 411, 285, 286, 
	412, 285, 286, 413, 285, 286, 414, 285, 
	286, 415, 285, 286, 416, 285, 286, 417, 
	285, 286, 418, 285, 286, 419, 285, 286, 
	420, 285, 286, 8, 285, 422, 0, 423, 
	0, 424, 0, 425, 0, 426, 0, 427, 
	0, 428, 0, 5, 0, 430, 441, 0, 
	431, 0, 432, 0, 433, 0, 434, 0, 
	435, 0, 436, 0, 437, 0, 438, 0, 
	439, 0, 440, 0, 226, 0, 442, 0, 
	443, 0, 444, 0, 445, 0, 446, 0, 
	447, 0, 448, 0, 449, 0, 30, 0, 
	451, 0, 452, 0, 453, 0, 454, 0, 
	455, 0, 456, 0, 457, 0, 458, 0, 
	459, 0, 460, 0, 461, 0, 3, 0, 
	463, 0, 464, 0, 465, 0, 466, 0, 
	467, 0, 468, 0, 469, 0, 470, 0, 
	471, 0, 472, 0, 473, 0, 474, 0, 
	475, 0, 476, 0, 477, 614, 0, 478, 
	0, 479, 0, 480, 0, 481, 0, 482, 
	0, 483, 0, 484, 0, 485, 0, 486, 
	0, 487, 0, 488, 0, 489, 0, 490, 
	0, 491, 0, 492, 0, 493, 0, 494, 
	0, 495, 0, 496, 0, 497, 0, 498, 
	0, 499, 0, 500, 0, 502, 501, 502, 
	501, 503, 558, 583, 502, 502, 8, 600, 
	506, 8, 502, 501, 504, 507, 515, 532, 
	544, 502, 501, 505, 502, 501, 506, 502, 
	501, 502, 50, 501, 508, 502, 501, 509, 
	502, 501, 510, 502, 501, 511, 502, 501, 
	512, 502, 501, 513, 502, 501, 514, 502, 
	501, 506, 502, 501, 516, 502, 501, 517, 
	502, 501, 518, 502, 501, 519, 502, 501, 
	520, 502, 501, 521, 502, 501, 522, 502, 
	501, 523, 502, 501, 524, 502, 501, 525, 
	502, 501, 526, 502, 501, 527, 502, 501, 
	528, 502, 501, 529, 502, 501, 530, 502, 
	501, 531, 502, 501, 502, 50, 501, 533, 
	502, 501, 534, 502, 501, 535, 502, 501, 
	536, 502, 501, 537, 502, 501, 538, 502, 
	501, 539, 502, 501, 540, 502, 501, 541, 
	502, 501, 542, 502, 501, 543, 502, 501, 
	504, 502, 501, 545, 502, 501, 546, 502, 
	501, 547, 502, 501, 548, 502, 501, 549, 
	502, 501, 550, 502, 501, 551, 502, 501, 
	552, 502, 501, 553, 502, 501, 554, 502, 
	501, 555, 502, 501, 556, 502, 501, 557, 
	502, 501, 531, 502, 501, 559, 579, 502, 
	501, 560, 502, 501, 561, 502, 501, 562, 
	502, 501, 563, 502, 501, 564, 502, 501, 
	565, 502, 501, 566, 502, 501, 567, 502, 
	501, 568, 502, 501, 569, 502, 501, 570, 
	502, 501, 571, 502, 501, 572, 502, 501, 
	573, 502, 501, 574, 502, 501, 575, 502, 
	501, 576, 502, 501, 577, 502, 501, 578, 
	502, 501, 525, 502, 501, 580, 502, 501, 
	581, 502, 501, 582, 502, 501, 506, 502, 
	501, 584, 502, 501, 585, 502, 501, 586, 
	590, 596, 502, 501, 587, 502, 501, 588, 
	502, 501, 589, 502, 501, 506, 502, 501, 
	591, 502, 501, 592, 502, 501, 593, 502, 
	501, 594, 502, 501, 595, 502, 501, 506, 
	502, 501, 597, 502, 501, 598, 502, 501, 
	599, 502, 501, 506, 502, 501, 502, 601, 
	501, 502, 602, 501, 502, 603, 501, 502, 
	604, 501, 502, 605, 501, 502, 606, 501, 
	502, 607, 501, 502, 608, 501, 502, 609, 
	501, 502, 610, 501, 502, 611, 501, 502, 
	612, 501, 502, 613, 501, 502, 8, 501, 
	616, 615, 616, 615, 617, 703, 728, 616, 
	616, 8, 745, 620, 8, 616, 615, 618, 
	621, 630, 638, 654, 666, 616, 615, 619, 
	616, 615, 620, 616, 615, 616, 50, 615, 
	622, 616, 615, 623, 616, 615, 624, 616, 
	615, 625, 616, 615, 626, 616, 615, 627, 
	616, 615, 628, 616, 615, 629, 616, 615, 
	616, 50, 615, 631, 616, 615, 632, 616, 
	615, 633, 616, 615, 634, 616, 615, 635, 
	616, 615, 636, 616, 615, 637, 616, 615, 
	620, 616, 615, 639, 616, 615, 640, 616, 
	615, 641, 616, 615, 642, 616, 615, 643, 
	616, 615, 644, 616, 615, 645, 616, 615, 
	646, 616, 615, 647, 616, 615, 648, 616, 
	615, 649, 616, 615, 650, 616, 615, 651, 
	616, 615, 652, 616, 615, 653, 616, 615, 
	629, 616, 615, 655, 616, 615, 656, 616, 
	615, 657, 616, 615, 658, 616, 615, 659, 
	616, 615, 660, 616, 615, 661, 616, 615, 
	662, 616, 615, 663, 616, 615, 664, 616, 
	615, 665, 616, 615, 618, 616, 615, 667, 
	616, 615, 668, 616, 615, 669, 616, 615, 
	670, 616, 615, 671, 616, 615, 672, 616, 
	615, 673, 616, 615, 674, 616, 615, 675, 
	616, 615, 676, 616, 615, 677, 616, 615, 
	678, 616, 615, 679, 616, 615, 680, 616, 
	615, 681, 616, 50, 615, 682, 616, 615, 
	683, 616, 615, 684, 616, 615, 685, 616, 
	615, 686, 616, 615, 616, 687, 615, 688, 
	616, 615, 689, 616, 615, 690, 616, 615, 
	691, 616, 615, 692, 616, 615, 693, 616, 
	615, 694, 616, 615, 695, 616, 615, 696, 
	616, 615, 697, 616, 615, 698, 616, 615, 
	699, 616, 615, 700, 616, 615, 701, 616, 
	615, 702, 616, 615, 629, 616, 615, 704, 
	724, 616, 615, 705, 616, 615, 706, 616, 
	615, 707, 616, 615, 708, 616, 615, 709, 
	616, 615, 710, 616, 615, 711, 616, 615, 
	712, 616, 615, 713, 616, 615, 714, 616, 
	615, 715, 616, 615, 716, 616, 615, 717, 
	616, 615, 718, 616, 615, 719, 616, 615, 
	720, 616, 615, 721, 616, 615, 722, 616, 
	615, 723, 616, 615, 648, 616, 615, 725, 
	616, 615, 726, 616, 615, 727, 616, 615, 
	620, 616, 615, 729, 616, 615, 730, 616, 
	615, 731, 735, 741, 616, 615, 732, 616, 
	615, 733, 616, 615, 734, 616, 615, 620, 
	616, 615, 736, 616, 615, 737, 616, 615, 
	738, 616, 615, 739, 616, 615, 740, 616, 
	615, 620, 616, 615, 742, 616, 615, 743, 
	616, 615, 744, 616, 615, 620, 616, 615, 
	616, 746, 615, 616, 747, 615, 616, 748, 
	615, 616, 749, 615, 616, 750, 615, 616, 
	751, 615, 616, 752, 615, 616, 753, 615, 
	616, 754, 615, 616, 755, 615, 616, 756, 
	615, 616, 757, 615, 616, 758, 615, 616, 
	8, 615, 760, 0, 8, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 29, 29, 0, 54, 0, 5, 1, 
	0, 29, 1, 35, 0, 43, 0, 0, 
	0, 0, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 149, 126, 57, 110, 23, 
	0, 29, 29, 29, 54, 0, 5, 1, 
	0, 29, 1, 35, 0, 43, 0, 0, 
	43, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 84, 54, 0, 
	69, 33, 69, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 13, 0, 63, 63, 63, 
	130, 31, 60, 57, 31, 63, 57, 66, 
	31, 43, 0, 43, 0, 43, 0, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 139, 48, 9, 106, 11, 0, 
	134, 45, 45, 45, 3, 122, 33, 33, 
	33, 0, 122, 33, 33, 33, 0, 122, 
	33, 0, 33, 0, 102, 7, 7, 43, 
	54, 0, 0, 43, 114, 25, 0, 54, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 43, 43, 43, 
	43, 0, 27, 118, 27, 27, 51, 27, 
	0, 54, 0, 1, 0, 43, 0, 0, 
	0, 43, 54, 37, 37, 87, 37, 37, 
	43, 0, 39, 0, 43, 0, 0, 54, 
	0, 0, 39, 0, 0, 96, 96, 96, 
	54, 0, 93, 90, 41, 96, 90, 99, 
	0, 43, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 13, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 13, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 84, 54, 
	0, 81, 81, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 21, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 144, 57, 54, 0, 
	84, 84, 84, 54, 0, 72, 33, 84, 
	72, 0, 0, 0, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 15, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 15, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 15, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 84, 84, 54, 0, 78, 33, 
	84, 78, 0, 0, 0, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 19, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 19, 0, 
	144, 57, 54, 0, 84, 84, 84, 54, 
	0, 75, 33, 84, 75, 0, 0, 0, 
	0, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	17, 0, 0, 43, 0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 761;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/tt.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1540 "ext/gherkin_lexer_tt/gherkin_lexer_tt.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/tt.c.rl"
    
#line 1547 "ext/gherkin_lexer_tt/gherkin_lexer_tt.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/tt.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/tt.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/tt.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/tt.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/tt.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/tt.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/tt.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/tt.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/tt.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/tt.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/tt.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/tt.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/tt.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/tt.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/tt.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/tt.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/tt.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/tt.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/tt.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/tt.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/tt.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/tt.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/tt.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/tt.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1837 "ext/gherkin_lexer_tt/gherkin_lexer_tt.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/tt.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1900 "ext/gherkin_lexer_tt/gherkin_lexer_tt.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/tt.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_tt()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Tt", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

