%define oname rtslib

Name:           python-rtslib
License:        Apache License 2.0
Group:          System Environment/Libraries
Summary:        A framework to implement simple but nice CLIs.
Version:        3.0.pre4.1~g1b33ceb
Release:        1%{?dist}
URL:            http://www.risingtidesystems.com/git/
Source:         %{oname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-rpmroot
BuildArch:      noarch
BuildRequires:  python-devel, epydoc, python-configobj, python-netifaces, python-ipaddr, pyparsing
Requires:       python-configobj, python-netifaces, python-ipaddr, pyparsing
Vendor:         Datera, Inc.

%description
API for RisingTide Systems generic SCSI target.

%prep
%setup -q -n %{oname}-%{version}

%build
%{__python} setup.py build
mkdir -p doc
epydoc --no-sourcecode --html -n %{oname} --exclude configobj %{oname}/*.py
mv html doc/

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot} --prefix usr
mkdir -p %{buildroot}/var/target/fabric
cp specs/*.spec %{buildroot}/var/target/fabric
mkdir -p %{buildroot}/var/target/policy
cp policy/*.lio %{buildroot}/var/target/policy
mkdir -p %{buildroot}/usr/share/doc/python-rtslib-doc-%{version}
cp -r doc/* specs/*.txt %{buildroot}/usr/share/doc/python-rtslib-doc-%{version}/

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{python_sitelib}
/var/target
/usr/share/doc/python-rtslib-doc-%{version}
%doc COPYING README.md

%changelog
* Sat Dec 13 2014 Marc Fleischmann <mwf@datera.io> 3.0.pre4.1~g1b33ceb-1
  - Generated from git commit 1b33ceb05ed2fbf68b3c3fa1c6daeba69d5e96fb.
