/*#define GRBS_ROUTE_REMOVE_TRACE*/

#undef tprinf
#ifdef GRBS_ROUTE_REMOVE_TRACE
#include <stdio.h>
#define tprintf printf
#else
#define tprintf grbs_nullprintf
#endif

/* Calculate the minimum r for the lowest concave orbit from the highest
   convex arc */
static double shrink_get_highest_convex(grbs_t *grbs, grbs_arc_t *conc_sentinel, double *highest_copper, double *highest_clearance)
{
	int conv_segi;
	double highest = 0, hnewr;

	for(conv_segi = 0; conv_segi < GRBS_MAX_SEG; conv_segi++) {
		grbs_arc_t *convex_last;
		grbs_arc_t *conv_sentinel = gdl_first(&conc_sentinel->parent_pt->arcs[0][conv_segi]);

		if ((conv_sentinel == NULL) || (!grbs_arc_overlaps_arc_new(conv_sentinel, conc_sentinel))) continue;

		convex_last = gdl_last(&conv_sentinel->parent_pt->arcs[0][conv_segi]);

		hnewr = convex_last->r + convex_last->copper + convex_last->clearance;
		if (hnewr > highest) {
			highest = hnewr;
			*highest_copper = convex_last->copper;
			*highest_clearance = convex_last->clearance;
		}
	}

	return highest;
}

/* if there is anything above the new arc, shrink radius pushing the
   above-arcs lower (by exactly as much as twonet tn took) */
static grbs_arc_t *shrink_seg_radii_any(grbs_t *grbs, grbs_arc_t *arc, int *need_narc_post_update, double *narc_oldr_out, int is_concave)
{
	grbs_arc_t *next, *prev;
	double prev_copper, prev_clearance, newr, incr, prevr;
	double narc_oldr = 0, narcr;


	prev = grbs_prev_arc_in_use(arc);

	/* simple case: either convex or concave without convex segments below:
	   previous radius:copper:clearance is the same-segment arc below or the point */
	if ((!arc->in_use) || (prev == NULL)) {
		prev_copper = arc->parent_pt->copper;
		prev_clearance = arc->parent_pt->clearance;
		prevr = 0;
	}
	else {
		prev_copper = prev->copper;
		prev_clearance = prev->clearance;
		prevr = prev->r;
	}

	next = grbs_next_arc_in_use(arc);
	if (next == NULL) {
		*narc_oldr_out = 0;
		return NULL;
	}
	narcr = next->r;

		/* when removing a concave on bottom it's radius may depend on any
		   convex region that overlaps with ours */
	if (is_concave && (arc->link_point.prev == NULL)) {
		double cop, clr, hnewr;
		hnewr = shrink_get_highest_convex(grbs, arc, &cop, &clr);

		/* new radius of our concave arc if it was only for the highest convex below */
		if ((hnewr > 0) && (hnewr > narcr))
			narcr = hnewr;
	}


	newr = prevr + prev_copper + next->copper + GRBS_MAX(prev_clearance, next->clearance); /* new arc added on top of the previous */
	tprintf("remove: newr=%f != %f (prev=%f/%f next=%f/%f)\n", newr, narcr, prev_copper, prev_clearance, next->copper, next->clearance);
	if (newr != narcr) {
		narc_oldr = narcr;
		narcr = newr; /* may replace an arc with smaller or larger spacing reqs... */
		tprintf(" new narc r: %f -> %f\n",  narc_oldr, narcr);
		*need_narc_post_update = 1;
	}

	incr = newr - next->r;
	tprintf("decr; narc->r=%f newr=%f oldr=%f incr=%f W: next=%f/%f\n", narcr, newr, next->r, incr, next->copper, next->clearance);

	bump_seg_radii(grbs, next, incr, -1, -1, 1, 0);
	*narc_oldr_out = narc_oldr;
	return next;
}

static void grbs_path_remove_incident(grbs_t *grbs, grbs_arc_t *arc)
{
	grbs_del_arc(grbs, arc);
}

/* shrink any concave segment that is in overlap with our convex */
static void shrink_seg_radii_concave_above_convex(grbs_t *grbs, grbs_arc_t *convex_sentinel)
{
	int conc_segi;

	for(conc_segi = 0; conc_segi < GRBS_MAX_SEG; conc_segi++) {
		double newr;
		grbs_arc_t *convex_last, *conc_first;
		grbs_arc_t *conc_sentinel = gdl_first(&convex_sentinel->parent_pt->arcs[1][conc_segi]);

		if ((conc_sentinel == NULL) || (!grbs_arc_overlaps_arc(convex_sentinel, conc_sentinel))) continue;

		convex_last = gdl_last(&convex_sentinel->parent_pt->arcs[0][convex_sentinel->segi]);
		conc_first = conc_sentinel->link_point.next;

		if (conc_first == NULL)
			return; /* orphaned concave */

		newr = convex_last->r + convex_last->copper + conc_first->copper + GRBS_MAX(convex_last->clearance, conc_first->clearance); /* new arc added on top of the previous */
		if (newr < conc_first->r)
			bump_seg_radii(grbs, conc_first, newr - conc_first->r, -1, -1, 1, 0);
	}
}

void grbs_path_remove_arc(grbs_t *grbs, grbs_arc_t *arc)
{
	grbs_arc_t *first, *sarc, *sentinel;
	int need_narc_post_update = 0;
	double narc_oldr;
	grbs_point_t *pt;

	if (arc->r == 0) {
		grbs_path_remove_incident(grbs, arc);
		return;
	}

	pt = arc->parent_pt;
	first = sentinel = gdl_first(&pt->arcs[arc->concave][arc->segi]);
	if (!first->new_in_use)
		first = gdl_next(&pt->arcs[arc->concave][arc->segi], first); /* for already realized arcs: first is the first above sentinel */

	/* free room of the arc being removed */
	arc->in_use = 0; /* do not consider this arc in any radii or sentinel calculation */
	sarc = shrink_seg_radii_any(grbs, arc, &need_narc_post_update, &narc_oldr, arc->concave);
	if (arc == first) {
		if (sarc != NULL)
			update_seg_sentinel_angles(sentinel, sarc);
		else
			grbs_del_arc(grbs, sentinel);
	}

	/* if we removed a convex, we need to bump any concave above it as well */
	if (!arc->concave)
		shrink_seg_radii_concave_above_convex(grbs, first);

	grbs_del_arc(grbs, arc);
}


void grbs_path_remove_addr(grbs_t *grbs, grbs_addr_t *addr)
{
	int type = (addr->type & 0x0F);

	switch(type) {
		case ADDR_ARC_CONVEX:
		case ADDR_ARC_CONCAVE:
		case ADDR_ARC_VCONCAVE:
			grbs_path_remove_arc(grbs, addr->obj.arc);
			break;

		case ADDR_POINT:
			/* an address without an actual grbs_arc_t has no further effect - nothing to do here */
			break;

		default: abort();
	}
}



void grbs_path_remove_2net(grbs_t *grbs, grbs_2net_t *tn)
{
	grbs_arc_t *n, *next;
	for(n = gdl_first(&tn->arcs); n != NULL; n = next) {
		next = gdl_next(&tn->arcs, n);
		grbs_path_remove_arc(grbs, n);
	}

	grbs_2net_free(grbs, tn);
}

