
NPROC_MIN=${NPROC_MIN-"1"}
silent_run () {
  run_status=0
  command="$*"
  echo "      $command"
  eval "$command"
  if test $? -ne 0; then run_status=1; fi
  return $run_status
}
run () {
  run_status=0
  if test x"${NPROC_MAX}" != x"0"; then
    command="$*"
    echo "      $command"
    eval "$command"
    if test $? -ne 0; then run_status=1; echo "        => *NO*"; fi
  fi
  return $run_status
}
loop_mpirun () {
  mpi_status=0
  mpi_command="$*"
  if test "${MPIRUN}" = "" -o "${NPROC_MAX}" = ""; then
    export RUN=""
    nompi_command=`echo ${mpi_command} | sed -e "s%\\\$RUN%${RUN}%g"`
    silent_run ${nompi_command}
    if test $? -ne 0; then mpi_status=1; echo "        => *NO*"; fi
  else
    nproc=${NPROC_MIN}
    while test ${nproc} -le ${NPROC_MAX}; do
      export RUN="${MPIRUN} -np ${nproc}"
      #echo "@@mpi1_command=\"$mpi_command\""
      mpi3_command=`echo ${mpi_command} | sed -e "s%\\\$RUN%${RUN}%g"`
      #echo "@@mpi3_command=\"$mpi3_command\""
      silent_run "${RUN} ${mpi3_command}"
      if test $? -ne 0; then mpi_status=1; echo "        => *NO*"; fi
      #sleep 1
      nproc=`expr ${nproc} + 1`
    done
  fi
  return $mpi_status
}
