#ifndef _RHEOLEF_HAZEL_1D_H
#define _RHEOLEF_HAZEL_1D_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// for 1d mesh : list of connected components
// with increasing ordered elements, when not imbeded in 2D or 3D geometry
//
// also : fast (dichotomy) localization procedures
//        for interpolate() and geomap()
//
// author: Pierre.Saramito@imag.fr
//
// date: 16 july 2009
//
#include "rheolef/compiler.h"
namespace rheolef { 

class hazel_1d : public std::vector<std::vector<size_t> > {
public:
  typedef size_t size_type;
  hazel_1d ();
  hazel_1d (const class georep& Ih);
  void initialize (const class georep& Ih);
  size_type localize (const class georep& Ih, const Float& x0) const;
  bool localize_nearest (const class georep& Ih, const Float& x,
	Float& y, size_type& k) const;
  bool trace (const class georep& Ih, const Float& x0, const Float& v, Float& x, Float& t, size_type& k) const;
protected:
  static void insert (std::pair<size_type,size_type>& v2e, size_type K_idx);
  std::vector<std::pair<Float,Float> > _interval;
};

inline
hazel_1d::hazel_1d ()
 : std::vector<std::vector<size_type> >(),
   _interval()
{
}
}// namespace rheolef
#endif // _RHEOLEF_HAZEL_1D_H
