///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/fdstream.h"
using namespace rheolef;
using namespace std;

void popen_test (std::string const& command)
{
    FILE* fp;

    // open pipe to read from
    if ((fp=popen(command.c_str(),"r")) == NULL) {
        throw "popen() failed";
    }

    // and initialize input stream to read from it
    fdistream in(fileno(fp));

    // print all characters with indent
    std::cerr << "output of " << command << ":\n";
    std::cout.put('>');
    std::cout.put(' ');
    char c;
    while (in.get(c)) {
        std::cout.put(c);
        if (c == '\n') {
            std::cout.put('>');
            std::cout.put(' ');
        }
    }
    std::cout.put('\n');

    pclose(fp);
}

int main(int argc, char**argv)
{
    string arg = argc > 1 ? argv[1] : "fdstream.h";
    string command = "cat " + arg;
    popen_test(command);
}

