set terminal pslatex color auxfile
set output "p-laplacian-damped-newton-square-r1.tex"

set logscale y
set size square 0.7
set xtics (0,50)
set ytics (\
        "[r]{$10^{-15}$}" 1e-15, \
        "[r]{$10^{-10}$}" 1e-10, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$10^{0}$}" 1 )
set xlabel "[c]{$n$}"
set  label "[r]{\\Large $\\|r_h\\|_{L^2(\\Omega)}$}" at graph -0.05,0.50

set logscale y
plot [0:50][1e-15:10] \
"p-laplacian-damped-newton-square-p=3.0.gdat" title "[r]{$p=3$}" w l, \
"p-laplacian-damped-newton-square-p=4.0.gdat" title "[r]{$p=4$}" w l, \
"p-laplacian-damped-newton-square-p=5.0.gdat" title "[r]{$p=5$}" w l,\
"p-laplacian-damped-newton-square-p=10.0.gdat" title "[r]{$p=10$}" w l

#pause -1 "<retour>"

