# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from testrpc.idl.

use strict;

package Raritan::RPC::test::FeatSerial;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "test.FeatSerial:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::test::FeatSerial::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant OK => 0;

use constant ERR_NO_TEST_MODE => 1;

use constant ERR_INVAL_PORT_NUM => 2;

use constant ERR_TEST_FAILED => 3;

sub getNumberOfPorts($$) {
    my ($self, $numPorts) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getNumberOfPorts', $args);
    $$numPorts = $rsp->{'numPorts'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setPower($$$) {
    my ($self, $portNum, $hasPower) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'portNum'} = 1 * $portNum;
    $args->{'hasPower'} = ($hasPower) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPower', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub testLoopTxRx($$$) {
    my ($self, $portNum, $errstr) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'portNum'} = 1 * $portNum;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testLoopTxRx', $args);
    $$errstr = $rsp->{'errstr'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub testLoopDtrDcd($$$) {
    my ($self, $portNum, $errstr) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'portNum'} = 1 * $portNum;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testLoopDtrDcd', $args);
    $$errstr = $rsp->{'errstr'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('test.FeatSerial', 1, 0, 0, 'Raritan::RPC::test::FeatSerial');
1;
