% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combine_coef_se}
\alias{combine_coef_se}
\title{Combines estimated coefficients and associated statistics
from models estimated with multiply imputed data sets or bootstrapped}
\source{
Partially based on \code{\link{mi.meld}} from Amelia.
}
\usage{
combine_coef_se(obj, out_type = "matrix", bagging = FALSE,
  messages = TRUE)
}
\arguments{
\item{obj}{a zelig object with an estimated model}

\item{out_type}{either \code{"matrix"} or \code{"list"} specifying
whether the results should be returned as a matrix or a list.}

\item{bagging}{logical whether or not to bag the bootstrapped coefficients}

\item{messages}{logical whether or not to return messages for what is being
returned}
}
\value{
If the model uses multiply imputed or bootstrapped data then a
 matrix (default) or list of combined coefficients (\code{coef}), standard
 errors (\code{se}), z values (\code{zvalue}), p-values (\code{p}) is
 returned. Rubin's Rules are used to combine output from multiply imputed
 data. An error is returned if no imputations were included or there wasn't
 bootstrapping. Please use \code{get_coef}, \code{get_se}, and
 \code{get_pvalue} methods instead in cases where there are no imputations or
 bootstrap.
}
\description{
Combines estimated coefficients and associated statistics
from models estimated with multiply imputed data sets or bootstrapped
}
\examples{
set.seed(123)

## Multiple imputation example
# Create fake imputed data
n <- 100
x1 <- runif(n)
x2 <- runif(n)
y <- rnorm(n)
data.1 <- data.frame(y = y, x = x1)
data.2 <- data.frame(y = y, x = x2)

# Estimate model
mi.out <- to_zelig_mi(data.1, data.2)
z.out.mi <- zelig(y ~ x, model = "ls", data = mi.out)

# Combine and extract coefficients and standard errors
combine_coef_se(z.out.mi)

## Bootstrap example
z.out.boot <- zelig(y ~ x, model = "ls", data = data.1, bootstrap = 20)
combine_coef_se(z.out.boot)

}
\author{
Christopher Gandrud and James Honaker
}
