% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-data-frame.R
\name{data_frame}
\alias{data_frame}
\title{Construct a data frame}
\usage{
data_frame(
  ...,
  .size = NULL,
  .name_repair = c("check_unique", "unique", "universal", "minimal")
)
}
\arguments{
\item{...}{Vectors to become columns in the data frame. When inputs are
named, those names are used for column names.}

\item{.size}{The number of rows in the data frame. If \code{NULL}, this will
be computed as the common size of the inputs.}

\item{.name_repair}{One of \code{"check_unique"}, \code{"unique"}, \code{"universal"} or
\code{"minimal"}. See \code{\link[=vec_as_names]{vec_as_names()}} for the meaning of these options.}
}
\description{
\code{data_frame()} constructs a data frame. It is similar to
\code{\link[base:data.frame]{base::data.frame()}}, but there are a few notable differences that make it
more in line with vctrs principles. The Properties section outlines these.
}
\details{
If no column names are supplied, \code{""} will be used as a default for all
columns. This is applied before name repair occurs, so the default
name repair of \code{"check_unique"} will error if any unnamed inputs
are supplied and \code{"unique"} will repair the empty string column names
appropriately. If the column names don't matter, use a \code{"minimal"} name
repair for convenience and performance.
}
\section{Properties}{

\itemize{
\item Inputs are recycled to a common size with \code{\link[=vec_recycle_common]{vec_recycle_common()}}.
\item With the exception of data frames, inputs are not modified in any way.
Character vectors are never converted to factors, and lists are stored
as-is for easy creation of list-columns.
\item Unnamed data frame inputs are automatically spliced. Named data frame
inputs are stored unmodified as data frame columns.
\item \code{NULL} inputs are completely ignored.
\item The dots are dynamic, allowing for splicing of lists with \verb{!!!} and
unquoting.
}
}

\examples{
data_frame(x = 1, y = 2)

# Inputs are recycled using tidyverse recycling rules
data_frame(x = 1, y = 1:3)

# Strings are never converted to factors
class(data_frame(x = "foo")$x)

# List columns can be easily created
df <- data_frame(x = list(1:2, 2, 3:4), y = 3:1)

# However, the base print method is suboptimal for displaying them,
# so it is recommended to convert them to tibble
if (rlang::is_installed("tibble")) {
  tibble::as_tibble(df)
}

# Named data frame inputs create data frame columns
df <- data_frame(x = data_frame(y = 1:2, z = "a"))

# The `x` column itself is another data frame
df$x

# Again, it is recommended to convert these to tibbles for a better
# print method
if (rlang::is_installed("tibble")) {
  tibble::as_tibble(df)
}

# Unnamed data frame input is automatically spliced
data_frame(x = 1, data_frame(y = 1:2, z = "a"))
}
\seealso{
\code{\link[=df_list]{df_list()}} for safely creating a data frame's underlying data structure from
individual columns. \code{\link[=new_data_frame]{new_data_frame()}} for constructing the actual data
frame from that underlying data structure. Together, these can be useful
for developers when creating new data frame subclasses supporting
standard evaluation.
}
