% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names_list.r
\name{names_list}
\alias{names_list}
\title{Get a random vector of species names.}
\usage{
names_list(rank = "genus", size = 10)
}
\arguments{
\item{rank}{(character) Taxonomic rank, one of species, genus (default),
family, order}

\item{size}{(integer/numeric) Number of names to get. Maximum depends on
the rank}
}
\value{
character vector of taxonomic names
}
\description{
Family and order names come from the APG plant names list. Genus and
species names come from Theplantlist.org.
}
\examples{
names_list()
names_list('species')
names_list('genus')
names_list('family')
names_list('order')
names_list('order', 2)
names_list('order', 15)

# You can get a lot of genus or species names if you want
nrow(theplantlist)
names_list('genus', 500)
}
\author{
Scott Chamberlain
}
