\name{dclf.test}
\alias{dclf.test}
\alias{mad.test}
\title{
  Diggle-Cressie-Loosmore-Ford and Maximum Absolute Deviation Tests
}
\description{
  Perform the Diggle (1986) / Cressie (1991) / Loosmore and Ford (2006)
  test or the Maximum Absolute Deviation test for a spatial point pattern.
}
\usage{
dclf.test(X, ..., rinterval = NULL, use.theo=FALSE)
mad.test(X, ..., rinterval = NULL, use.theo=FALSE)
}
\arguments{
  \item{X}{
    Data for the test.
    Either a point pattern (object of class \code{"ppp"}, \code{"lpp"}
    or other class), a fitted point process model (object of class \code{"ppm"},
    \code{"kppm"} or other class), a simulation envelope (object of class
    \code{"envelope"}) or a previous result of \code{dclf.test} or
    \code{mad.test}. 
  }
  \item{\dots}{
    Arguments passed to \code{\link{envelope}}.
    Useful arguments include \code{fun} to determine the summary
    function, \code{nsim} to specify the number of Monte Carlo
    simulations, \code{verbose=FALSE} to turn off the messages,
    and \code{savefuns} or \code{savepatterns} to save the simulation
    results.
  }
  \item{rinterval}{
    Interval of values of the summary function argument \code{r}
    over which the maximum absolute deviation, or the integral,
    will be computed for the test. A numeric vector of length 2.
  }
  \item{use.theo}{
    Logical value determining whether to compare the summary function
    for the data to its theoretical value for CSR (\code{use.theo=TRUE})
    or to the sample mean of simulations from CSR (\code{use.theo=FALSE}).
  }
}
\details{
  These functions perform hypothesis tests for goodness-of-fit
  of a point pattern dataset to a point process model, based on
  Monte Carlo simulation from the model.

  \code{dclf.test} performs the test advocated by Loosmore and Ford (2006)
  which is also described in Diggle (1986), Cressie (1991, page 667, equation
  (8.5.42)) and Diggle (2003, page 14). See Baddeley et al (2014).

  \code{mad.test} performs the \sQuote{global} or
  \sQuote{Maximum Absolute Deviation} test described by Ripley (1977, 1981).
  See Baddeley et al (2014).
  
  The type of test depends on the type of argument \code{X}.
  \itemize{
    \item 
    If \code{X} is some kind of point pattern, then a test of Complete
    Spatial Randomness (CSR) will be performed. That is,
    the null hypothesis is that the point pattern is completely random.
    \item
    If \code{X} is a fitted point process model, then a test of
    goodness-of-fit for the fitted model will be performed. The model object
    contains the data point pattern to which it was originally fitted.
    The null hypothesis is that the data point pattern is a realisation
    of the model.
    \item
    If \code{X} is an envelope object generated by \code{\link{envelope}},
    then it should have been generated with \code{savefuns=TRUE} or
    \code{savepatterns=TRUE} so that it contains simulation results.
    These simulations will be treated as realisations from the null
    hypothesis.
    \item
    Alternatively \code{X} could be a previously-performed
    test of the same kind (i.e. the result of calling
    \code{dclf.test} or \code{mad.test}).
    The simulations used to perform the original test
    will be re-used to perform the new test (provided these simulations
    were saved in the original test, by setting \code{savefuns=TRUE} or
    \code{savepatterns=TRUE}).
  }
  In all cases, the algorithm will first call \code{\link{envelope}} to
  generate or extract the simulated summary functions.
  The number of simulations that will be generated or extracted,
  is determined by the argument \code{nsim}, and defaults to 99.
  The summary function that will be computed is determined by the
  argument \code{fun} (or the first unnamed argument in the list
  \code{\dots}) and defaults to \code{\link{Kest}} (except when
  \code{X} is an envelope object generated with \code{savefuns=TRUE},
  when these functions will be taken).

  The choice of summary function \code{fun} affects the power of the
  test. It is normally recommended to apply a variance-stabilising
  transformation (Ripley, 1981). If you are using the \eqn{K} function,
  the normal practice is to replace this by the \eqn{L} function
  (Besag, 1977) computed by \code{\link{Lest}}. If you are using
  the \eqn{F} or \eqn{G} functions, the recommended practice is to apply
  Fisher's variance-stabilising transformation
  \eqn{\sin^{-1}\sqrt x}{asin(sqrt(x))} using the argument
  \code{transform}. See the Examples.
}
\section{Handling Ties}{
  If the observed value of the test statistic is equal to one or more of the
  simulated values (called a \emph{tied value}), then the tied values
  will be assigned a random ordering, and a message will be printed.
}
\value{
  An object of class \code{"htest"}.
  Printing this object gives a report on the result of the test.
  The \eqn{p}-value is contained in the component \code{p.value}.
}
\references{
  Baddeley, A., Diggle, P.J., Hardegen, A., Lawrence, T., Milne,
  R.K. and Nair, G. (2014) On tests of spatial pattern based on
  simulation envelopes. \emph{Ecological Monographs}, to appear.
  
  Besag, J. (1977) 
  Discussion of Dr Ripley's paper.
  \emph{Journal of the Royal Statistical Society, Series B},
  \bold{39}, 193--195.
  
  Cressie, N.A.C. (1991)
  \emph{Statistics for spatial data}.
  John Wiley and Sons, 1991.

  Diggle, P. J. (1986).
  Displaced amacrine cells in the retina of a
  rabbit : analysis of a bivariate spatial point pattern. 
  \emph{J. Neuroscience Methods} \bold{18}, 115--125.
 
  Diggle, P.J. (2003)
  \emph{Statistical analysis of spatial point patterns},
  Second edition. Arnold.

  Loosmore, N.B. and Ford, E.D. (2006)
  Statistical inference using the \emph{G} or \emph{K} point
  pattern spatial statistics. \emph{Ecology} \bold{87}, 1925--1931.

  Ripley, B.D. (1977)
  Modelling spatial patterns (with discussion).
  \emph{Journal of the Royal Statistical Society, Series B},
  \bold{39}, 172 -- 212.

  Ripley, B.D. (1981) 
  \emph{Spatial statistics}.
  John Wiley and Sons.
 }
\author{
  Adrian Baddeley
  \email{Adrian.Baddeley@uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Andrew Hardegen.
}
\seealso{
  \code{\link{envelope}},
  \code{\link{dclf.progress}}
}
\examples{
  dclf.test(cells, Lest, nsim=39)
  m <- mad.test(cells, Lest, verbose=FALSE, rinterval=c(0, 0.1), nsim=19)
  m
  # extract the p-value
  m$p.value
  # variance stabilised G function
  dclf.test(cells, Gest, transform=expression(asin(sqrt(.))),
                   verbose=FALSE, nsim=19)
}
\keyword{spatial}
\keyword{htest}

